/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.meeting.PromoteOrDowngradeItem;
import com.zipow.videobox.fragment.ChangeScreenNameDialog;
import com.zipow.videobox.fragment.ExpelUserAlertDialog;
import com.zipow.videobox.fragment.MakeCoHostAlertDialog;
import com.zipow.videobox.fragment.MakeHostAlertDialog;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.fragment.WebinarRaiseHandFragment;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.DialogUtils;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class PListItemActionDialog
extends ZMDialogFragment {
    private static final String ARG_USERID = "userId";
    private OptionListAdapter mAdapter;
    private long mUserId = 0L;

    public static boolean show(FragmentManager fm, long userId) {
        if (!PListItemActionDialog.hasActionsForUser((Context)VideoBoxApplication.getInstance(), userId)) {
            return false;
        }
        Bundle args = new Bundle();
        args.putLong(ARG_USERID, userId);
        PListItemActionDialog f = new PListItemActionDialog();
        f.setArguments(args);
        f.show(fm, PListItemActionDialog.class.getName());
        return true;
    }

    public static void refreshAction(FragmentManager fm, long userId) {
        PListItemActionDialog dialog = PListItemActionDialog.getActivePListItemActionDialog(fm);
        if (dialog == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isSameUser(userId, dialog.getUserId())) {
            dialog.refresh();
        }
    }

    public static void refreshAction(FragmentManager fm) {
        PListItemActionDialog dialog = PListItemActionDialog.getActivePListItemActionDialog(fm);
        if (dialog == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null) {
            dialog.refresh();
        }
    }

    public PListItemActionDialog() {
        this.setCancelable(true);
    }

    public static PListItemActionDialog getActivePListItemActionDialog(FragmentManager fm) {
        PListItemActionDialog f = (PListItemActionDialog)fm.findFragmentByTag(PListItemActionDialog.class.getName());
        return f;
    }

    public static void dismissPListItemActionDialog(FragmentManager fm) {
        MakeCoHostAlertDialog makeCoHostDialog;
        ExpelUserAlertDialog expelDialog;
        MakeHostAlertDialog makeHostDialog;
        PListItemActionDialog actionDialog = PListItemActionDialog.getActivePListItemActionDialog(fm);
        if (actionDialog != null) {
            actionDialog.dismiss();
        }
        if ((makeHostDialog = MakeHostAlertDialog.getMakeHostAlertDialog(fm)) != null) {
            makeHostDialog.dismiss();
        }
        if ((expelDialog = ExpelUserAlertDialog.getExpelUserAlertDialog(fm)) != null) {
            expelDialog.dismiss();
        }
        if ((makeCoHostDialog = MakeCoHostAlertDialog.getMakeCoHostAlertDialog(fm)) != null) {
            makeCoHostDialog.dismiss();
        }
    }

    public static void dismissPListActionDialogForUserId(FragmentManager fm, long userId) {
        MakeCoHostAlertDialog makeCoHostDialog;
        ExpelUserAlertDialog expelDialog;
        MakeHostAlertDialog makeHostDialog;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        PListItemActionDialog actionDialog = PListItemActionDialog.getActivePListItemActionDialog(fm);
        if (actionDialog != null && confStatus.isSameUser(userId, actionDialog.getUserId())) {
            actionDialog.dismiss();
        }
        if ((makeHostDialog = MakeHostAlertDialog.getMakeHostAlertDialog(fm)) != null && confStatus.isSameUser(userId, makeHostDialog.getUserId())) {
            makeHostDialog.dismiss();
        }
        if ((expelDialog = ExpelUserAlertDialog.getExpelUserAlertDialog(fm)) != null && confStatus.isSameUser(userId, expelDialog.getUserId())) {
            expelDialog.dismiss();
        }
        if ((makeCoHostDialog = MakeCoHostAlertDialog.getMakeCoHostAlertDialog(fm)) != null && confStatus.isSameUser(userId, makeCoHostDialog.getUserId())) {
            makeCoHostDialog.dismiss();
        }
    }

    private static boolean hasActionsForUser(Context context, long userId) {
        return OptionListAdapter.loadActions(new ArrayList(), context, userId) > 0;
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mUserId = args.getLong(ARG_USERID);
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user == null) {
            this.mUserId = 0L;
            return new ZMAlertDialog.Builder((Context)this.getActivity()).create();
        }
        this.mAdapter = new OptionListAdapter((ZMActivity)this.getActivity(), this.mUserId);
        Object avatar = null;
        avatar = user.isPureCallInUser() ? Integer.valueOf(R.drawable.zm_phone_avatar) : (user.isH323User() ? Integer.valueOf(R.drawable.zm_h323_avatar) : user.getSmallPicPath());
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitleView(DialogUtils.createAvatarDialogTitleView((Context)this.getActivity(), user.getScreenName(), avatar)).setAdapter((ListAdapter)this.mAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PListItemActionDialog.this.onClickItem(PListItemActionDialog.this.mAdapter, which);
            }
        }).setListDividerHeight(0).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        if (this.mUserId != 0L) {
            this.refresh();
        } else {
            this.dismiss();
        }
    }

    public long getUserId() {
        return this.mUserId;
    }

    public void refresh() {
        this.mAdapter.reloadAll();
        this.mAdapter.notifyDataSetChanged();
        if (this.mAdapter.getCount() == 0) {
            this.dismiss();
        }
    }

    private void onClickItem(OptionListAdapter adapter, int which) {
        Bundle args = this.getArguments();
        long userId = args.getLong(ARG_USERID);
        PListActionItem item = (PListActionItem)this.mAdapter.getItem(which);
        if (item == null) {
            return;
        }
        switch (item.type) {
            case 0: {
                this.onClickMiChat(userId);
                break;
            }
            case 1: {
                this.onClickMiMute(userId);
                break;
            }
            case 2: {
                this.onClickMiMakeHost(userId);
                break;
            }
            case 15: {
                this.onClickMiAssignCoHost(userId);
                break;
            }
            case 16: {
                this.onClickMiWithdrawCoHost(userId);
                break;
            }
            case 3: {
                this.onClickMiExpel(userId);
                break;
            }
            case 4: {
                this.onClickMiAllowRecord(userId);
                break;
            }
            case 5: {
                this.onClickSpotLightVideo(userId);
                break;
            }
            case 6: {
                this.onClickUnspotLightVideo(userId);
                break;
            }
            case 7: {
                this.onClickEnterSilentMode(userId);
                break;
            }
            case 8: {
                this.onClickLeaveSilentMode(userId);
                break;
            }
            case 9: {
                this.onClickRaiseHand(userId);
                break;
            }
            case 10: {
                this.onClickLowerHand(userId);
                break;
            }
            case 11: {
                this.onClickRename(userId);
                break;
            }
            case 12: {
                this.onClickVideoStop(userId);
                break;
            }
            case 14: {
                this.onClickVideoAskToStart(userId);
                break;
            }
            case 13: {
                this.onClickDowngradeToAttendee(userId);
                break;
            }
            case 17: {
                this.onClickAllowAttendeeChat();
                break;
            }
            case 18: {
                this.onClickFeccRequestCotrolCamera(userId);
                break;
            }
            case 19: {
                this.onClickFeccGiveUpCtrolCamera(userId);
                break;
            }
            case 20: {
                this.onClickAssignCcTyper(userId);
                break;
            }
            case 21: {
                this.onClickWithdrawCcTyper(userId);
                break;
            }
            case 22: {
                this.onClickStopShareAudio();
            }
        }
    }

    private void onClickStopShareAudio() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr != null) {
            shareMgr.requestToStopPureComputerAudioShare(shareMgr.getPureComputerAudioSharingUserID());
        }
    }

    private void onClickAssignCcTyper(long userId) {
        ConfMgr.getInstance().handleUserCmd(33, userId);
    }

    private void onClickWithdrawCcTyper(long userId) {
        ConfMgr.getInstance().handleUserCmd(34, userId);
    }

    private void onClickFeccRequestCotrolCamera(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            videoMgr.handleFECCCmd(11, userId);
        }
    }

    private void onClickFeccGiveUpCtrolCamera(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            videoMgr.handleFECCCmd(14, userId);
        }
    }

    private void onClickAllowAttendeeChat() {
        ConfMgr mgr;
        mgr.handleConfCmd((mgr = ConfMgr.getInstance()).isAllowAttendeeChat() ? 106 : 105);
    }

    private void onClickSpotLightVideo(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            videoMgr.setLeadShipMode(true, userId);
        }
    }

    private void onClickUnspotLightVideo(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            videoMgr.setLeadShipMode(false, userId);
        }
    }

    private void onClickMiMakeHost(long userId) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        MakeHostAlertDialog.showMakeHostAlertDialog((ZMActivity)activity, userId);
    }

    private void onClickMiAssignCoHost(long userId) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        MakeCoHostAlertDialog.showMakeCoHostAlertDialog((ZMActivity)activity, userId);
    }

    private void onClickMiWithdrawCoHost(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (!user.isCoHost()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(44, userId);
    }

    private void onClickMiChat(long userId) {
        this.showChatUI(userId);
    }

    private void onClickMiMute(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (user.getAudioStatusObj().getIsMuted()) {
            ConfMgr.getInstance().handleUserCmd(47, userId);
        } else {
            ConfMgr.getInstance().handleUserCmd(46, userId);
        }
    }

    private void onClickMiExpel(long userId) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ExpelUserAlertDialog.showExpelUserAlertDialog((ZMActivity)activity, userId);
    }

    private void onClickMiAllowRecord(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (user.canRecord()) {
            ConfMgr.getInstance().handleUserCmd(32, userId);
        } else {
            ConfMgr.getInstance().handleUserCmd(31, userId);
        }
    }

    private void onClickEnterSilentMode(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (user.inSilentMode()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(41, userId);
    }

    private void onClickLeaveSilentMode(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (!user.inSilentMode()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(42, userId);
    }

    private void onClickRaiseHand(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (user.getRaiseHandState()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(35, userId);
    }

    private void onClickLowerHand(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (!user.getRaiseHandState()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(36, userId);
    }

    private void onClickRename(long userId) {
        ChangeScreenNameDialog.showDialog(this.getFragmentManager(), userId);
    }

    private void onClickVideoStop(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (!user.videoCanMuteByHost()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(61, userId);
    }

    private void onClickVideoAskToStart(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (!user.videoCanUnmuteByHost()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(62, userId);
    }

    private void onClickDowngradeToAttendee(long userId) {
        PListFragment pListFrag = PListFragment.getPListFragment(this.getFragmentManager());
        WebinarRaiseHandFragment raiseHandFragment = WebinarRaiseHandFragment.getFragment(this.getFragmentManager());
        PromoteOrDowngradeItem promoteOrDowngradeItem = PromoteOrDowngradeItem.getPromoteAttendeeItem(userId, 2);
        if (promoteOrDowngradeItem != null) {
            if (pListFrag != null) {
                pListFrag.promoteOrDowngrade(promoteOrDowngradeItem);
            } else if (raiseHandFragment != null) {
                raiseHandFragment.promoteOrDowngrade(promoteOrDowngradeItem);
            }
        }
    }

    private void showChatUI(long userId) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ConfLocalHelper.showChatUI(activity, userId);
    }

    static class OptionListAdapter
    extends BaseAdapter {
        private ZMActivity mActivity;
        private List<PListActionItem> mList = new ArrayList<PListActionItem>();
        private long mUserId = 0L;

        public OptionListAdapter(ZMActivity activity, long userId) {
            this.mActivity = activity;
            this.mUserId = userId;
        }

        public void reloadAll() {
            this.mList.clear();
            if (this.mActivity != null) {
                OptionListAdapter.loadActions(this.mList, (Context)this.mActivity, this.mUserId);
            }
        }

        private static int loadActions(List<PListActionItem> list, Context context, long userId) {
            int cap;
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return 0;
            }
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus == null) {
                return 0;
            }
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user == null) {
                return 0;
            }
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself == null) {
                return 0;
            }
            boolean supportSilentMode = false;
            boolean inSilentMode = false;
            if (confContext.isMeetingSupportSilentMode() && ((cap = user.getClientCapability()) & 8) != 0) {
                supportSilentMode = true;
                if (user.inSilentMode()) {
                    inSilentMode = true;
                }
            }
            if (confStatus.isMyself(userId)) {
                OptionListAdapter.loadSelfActions(list, context, confContext, user);
            } else if (myself.isHost() || myself.isCoHost() || myself.isBOModerator()) {
                OptionListAdapter.loadAttendeeActionsForHostOrCoHost(list, context, confContext, user, supportSilentMode, inSilentMode);
            } else if (confContext.isWebinar()) {
                OptionListAdapter.loadAttendeeActionsForWebinarPanelist(list, context, confContext, user, supportSilentMode, inSilentMode);
            } else {
                OptionListAdapter.loadAttendeeActions(list, context, confContext, user, supportSilentMode, inSilentMode);
            }
            return list.size();
        }

        private static void loadSelfActions(List<PListActionItem> list, Context context, CmmConfContext confContext, CmmUser user) {
            if (user.getRaiseHandState()) {
                list.add(new PListActionItem(10, context.getResources().getString(R.string.zm_btn_lower_hand)));
            } else if (!(user.isHost() || user.isBOModerator() || confContext.isWebinar())) {
                list.add(new PListActionItem(9, context.getResources().getString(R.string.zm_btn_raise_hand)));
            }
            list.add(new PListActionItem(11, context.getResources().getString(R.string.zm_btn_rename)));
            if ((user.isHost() || user.isCoHost()) && !user.isBOModerator()) {
                VideoSessionMgr videoMgr;
                CmmVideoStatus videoStatus = user.getVideoStatusObj();
                boolean userVideoIsSending = false;
                if (videoStatus != null) {
                    userVideoIsSending = videoStatus.getIsSending();
                }
                if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() > 2 && (videoMgr = ConfMgr.getInstance().getVideoObj()) != null) {
                    if (videoMgr.isLeaderofLeadMode(user.getNodeId())) {
                        list.add(new PListActionItem(6, context.getResources().getString(R.string.zm_mi_unspotlight_video)));
                    } else if (userVideoIsSending) {
                        list.add(new PListActionItem(5, context.getResources().getString(R.string.zm_mi_spotlight_video)));
                    }
                }
            }
        }

        private static void loadAttendeeActions(List<PListActionItem> list, Context context, CmmConfContext confContext, CmmUser user, boolean supportSilentMode, boolean inSilentMode) {
            if (!inSilentMode) {
                if (!(confContext.isPrivateChatOFF() || confContext.isChatOff() || user.isH323User() || user.isPureCallInUser())) {
                    CmmConfStatus confStatus;
                    boolean isAddChat = true;
                    if (!(user.isHost() || user.isCoHost() || user.isBOModerator() || (confStatus = ConfMgr.getInstance().getConfStatusObj()) == null || confStatus.getAttendeeChatPriviledge() != 3)) {
                        isAddChat = false;
                    }
                    if (isAddChat) {
                        list.add(new PListActionItem(0, context.getResources().getString(R.string.zm_mi_chat)));
                    }
                }
                CmmVideoStatus videoStatus = user.getVideoStatusObj();
                boolean userVideoIsSending = false;
                boolean userHasCamera = false;
                int userFeccCamNum = 0;
                if (videoStatus != null) {
                    userVideoIsSending = videoStatus.getIsSending();
                    userHasCamera = videoStatus.getIsSource();
                    userFeccCamNum = videoStatus.getCamFecc();
                }
                boolean canRemoteCtrlCam = false;
                if (confContext.isMeetingSupportCameraControl() && (user.supportSwitchCam() && userVideoIsSending || userFeccCamNum > 0)) {
                    canRemoteCtrlCam = true;
                }
                if (canRemoteCtrlCam && userVideoIsSending && userHasCamera) {
                    VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                    if (videoMgr.canControlltheCam(user.getNodeId())) {
                        list.add(new PListActionItem(19, context.getResources().getString(R.string.zm_fecc_btn_give_up)));
                    } else {
                        list.add(new PListActionItem(18, context.getResources().getString(R.string.zm_fecc_btn_request)));
                    }
                }
            }
        }

        private static void loadAttendeeActionsForHostOrCoHost(List<PListActionItem> list, Context context, CmmConfContext confContext, CmmUser user, boolean supportSilentMode, boolean inSilentMode) {
            if (inSilentMode) {
                list.add(new PListActionItem(3, context.getResources().getString(R.string.zm_mi_expel)));
                list.add(new PListActionItem(8, context.getResources().getString(R.string.zm_mi_leave_silent_mode)));
            } else {
                CmmUser myself;
                VideoSessionMgr videoMgr;
                CmmAudioStatus audioStatus;
                CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
                boolean isCurUserHost = false;
                boolean isCurUserBOModerator = false;
                if (confStatus != null) {
                    isCurUserHost = confStatus.isHost();
                    isCurUserBOModerator = confStatus.isBOModerator();
                }
                if (user.getRaiseHandState()) {
                    list.add(new PListActionItem(10, context.getResources().getString(R.string.zm_btn_lower_hand)));
                }
                if (!user.isH323User() && (audioStatus = user.getAudioStatusObj()) != null && audioStatus.getAudiotype() != 2L) {
                    if (audioStatus.getIsMuted()) {
                        list.add(new PListActionItem(1, context.getResources().getString(R.string.zm_mi_unmute)));
                    } else {
                        list.add(new PListActionItem(1, context.getResources().getString(R.string.zm_mi_mute)));
                    }
                }
                if (!(confContext.isPrivateChatOFF() || confContext.isChatOff() || user.isH323User() || user.isPureCallInUser())) {
                    list.add(new PListActionItem(0, context.getResources().getString(R.string.zm_mi_chat)));
                }
                CmmVideoStatus videoStatus = user.getVideoStatusObj();
                boolean userVideoIsSending = false;
                boolean userHasCamera = false;
                int userFeccCamNum = 0;
                if (videoStatus != null) {
                    userVideoIsSending = videoStatus.getIsSending();
                    userHasCamera = videoStatus.getIsSource();
                    userFeccCamNum = videoStatus.getCamFecc();
                }
                if (!isCurUserBOModerator && ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() > 2 && !user.isPureCallInUser() && (videoMgr = ConfMgr.getInstance().getVideoObj()) != null) {
                    if (videoMgr.isLeaderofLeadMode(user.getNodeId())) {
                        list.add(new PListActionItem(6, context.getResources().getString(R.string.zm_mi_unspotlight_video)));
                    } else if (userVideoIsSending) {
                        list.add(new PListActionItem(5, context.getResources().getString(R.string.zm_mi_spotlight_video)));
                    }
                }
                if (!isCurUserBOModerator && isCurUserHost && !user.isNoHostUser()) {
                    list.add(new PListActionItem(2, context.getResources().getString(R.string.zm_mi_make_host)));
                    if (!user.isCoHost() && user.canActAsCoHost()) {
                        list.add(new PListActionItem(15, context.getResources().getString(R.string.zm_mi_assign_cohost)));
                    }
                }
                if (userVideoIsSending && user.videoCanMuteByHost()) {
                    list.add(new PListActionItem(12, context.getResources().getString(R.string.zm_mi_video_stop)));
                }
                if (!userVideoIsSending && userHasCamera && user.videoCanUnmuteByHost() && confStatus != null && !confStatus.isStartVideoDisabled()) {
                    list.add(new PListActionItem(14, context.getResources().getString(R.string.zm_mi_video_ask_to_start)));
                }
                String zoomId = user.getUserZoomID();
                boolean bOriginalOrAltHost = ConfMgr.getInstance().isUserOriginalorAltHost(zoomId);
                if (!user.isHost() && !user.isCoHost()) {
                    if (!isCurUserBOModerator) {
                        list.add(new PListActionItem(3, context.getResources().getString(R.string.zm_mi_expel)));
                    }
                    if (!confContext.isLocalRecordDisabled()) {
                        if (user.canRecord()) {
                            list.add(new PListActionItem(4, context.getResources().getString(R.string.zm_mi_disallow_record)));
                        } else if (user.clientOSSupportRecord() && !confContext.isRecordDisabled()) {
                            list.add(new PListActionItem(4, context.getResources().getString(R.string.zm_mi_allow_record)));
                        }
                    }
                    if (!isCurUserBOModerator && supportSilentMode) {
                        if (confContext.supportPutUserinWaitingListUponEntryFeature()) {
                            list.add(new PListActionItem(7, context.getResources().getString(R.string.zm_mi_put_on_waiting)));
                        } else {
                            list.add(new PListActionItem(7, context.getResources().getString(R.string.zm_mi_enter_silent_mode)));
                        }
                    }
                    if (confContext.isWebinar() && !user.isH323User() && !user.isPureCallInUser() && !bOriginalOrAltHost) {
                        list.add(new PListActionItem(13, context.getResources().getString(R.string.zm_webinar_mi_downgrade_to_attendee)));
                    }
                }
                if ((myself = ConfMgr.getInstance().getMyself()) != null) {
                    ShareSessionMgr shareMgr;
                    boolean isNormalUser;
                    if (myself.isHost() && confContext.canActAsCCEditor() && user.canActAsCCEditor()) {
                        if (user.canEditCC()) {
                            list.add(new PListActionItem(21, context.getResources().getString(R.string.zm_btn_disassign_cc_typer_16896)));
                        } else {
                            list.add(new PListActionItem(20, context.getResources().getString(R.string.zm_btn_assign_cc_typer_16896)));
                        }
                    }
                    boolean bl = isNormalUser = !ConfUI.getInstance().isDisplayAsHost(user.getNodeId()) && !ConfUI.getInstance().isDisplayAsCohost(user.getNodeId());
                    if (ConfUI.getInstance().isDisplayAsHost(myself.getNodeId()) || isNormalUser) {
                        list.add(new PListActionItem(11, context.getResources().getString(R.string.zm_btn_rename)));
                    }
                    if ((shareMgr = ConfMgr.getInstance().getShareObj()) != null && shareMgr.isViewingPureComputerAudio() && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
                        long shareAdudioId = shareMgr.getPureComputerAudioSharingUserID();
                        if (confStatus != null && confStatus.isSameUser(user.getNodeId(), shareAdudioId)) {
                            list.add(new PListActionItem(22, context.getResources().getString(R.string.zm_mi_host_stop_audio_share_41468)));
                        }
                    }
                }
                if (isCurUserHost && user.isCoHost()) {
                    list.add(new PListActionItem(16, context.getResources().getString(R.string.zm_mi_withdraw_cohost)));
                }
                boolean canRemoteCtrlCam = false;
                if (confContext.isMeetingSupportCameraControl() && (user.supportSwitchCam() && userVideoIsSending || userFeccCamNum > 0)) {
                    canRemoteCtrlCam = true;
                }
                if (canRemoteCtrlCam && userVideoIsSending && userHasCamera) {
                    VideoSessionMgr videoMgr2 = ConfMgr.getInstance().getVideoObj();
                    if (videoMgr2.canControlltheCam(user.getNodeId())) {
                        list.add(new PListActionItem(19, context.getResources().getString(R.string.zm_fecc_btn_give_up)));
                    } else {
                        list.add(new PListActionItem(18, context.getResources().getString(R.string.zm_fecc_btn_request)));
                    }
                }
            }
        }

        private static void loadAttendeeActionsForWebinarPanelist(List<PListActionItem> list, Context context, CmmConfContext confContext, CmmUser user, boolean supportSilentMode, boolean inSilentMode) {
            if (!(inSilentMode || confContext.isChatOff() || confContext.isPrivateChatOFF() || user.isH323User() || user.isPureCallInUser())) {
                list.add(new PListActionItem(0, context.getResources().getString(R.string.zm_mi_chat)));
            }
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_dialog_list_item, null);
            }
            ImageView imgIcon = (ImageView)convertView.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)convertView.findViewById(R.id.txtLabel);
            View check = convertView.findViewById(R.id.check);
            PListActionItem item = (PListActionItem)this.getItem(position);
            txtLabel.setText((CharSequence)item.label);
            if (item.imgIconId == 0) {
                imgIcon.setVisibility(8);
            } else {
                imgIcon.setVisibility(0);
                imgIcon.setImageResource(item.imgIconId);
            }
            check.setVisibility(8);
            return convertView;
        }
    }

    static class PListActionItem {
        public static final int ITEM_CHAT = 0;
        public static final int ITEM_MUTE = 1;
        public static final int ITEM_MAKE_HOST = 2;
        public static final int ITEM_EXPEL = 3;
        public static final int ITEM_ALLOW_RECORD = 4;
        public static final int ITEM_SPOTLIGHT_VIDEO = 5;
        public static final int ITEM_UNSPOTLIGHT_VIDEO = 6;
        public static final int ITEM_ENTER_SILENT_MODE = 7;
        public static final int ITEM_LEAVE_SILENT_MODE = 8;
        public static final int ITEM_RAISE_HAND = 9;
        public static final int ITEM_LOWER_HAND = 10;
        public static final int ITEM_CHANGE_NAME = 11;
        public static final int ITEM_STOP_VIDEO = 12;
        public static final int ITEM_DOWNGRADE_TO_ATTENDEE = 13;
        public static final int ITEM_ASK_TO_START_VIDEO = 14;
        public static final int ITEM_ASSIGN_COHOST = 15;
        public static final int ITEM_WITHDRAW_COHOST = 16;
        public static final int ITEM_ALLOW_ATTENDEE_CHAT = 17;
        public static final int ITEM_FECC_REQUEST_CTRL = 18;
        public static final int ITEM_FECC_GIVE_UP_CTRL = 19;
        public static final int ITEM_ASSIGN_CC_TYPER = 20;
        public static final int ITEM_WITHDRAW_CC_TYPER = 21;
        public static final int ITEM_STOP_AUDIO_SHARE = 22;
        public int type;
        public String label;
        public int imgIconId;

        public PListActionItem(int type, String label) {
            this.type = type;
            this.label = label;
            this.imgIconId = 0;
        }

        public PListActionItem(int type, String label, int iconId) {
            this.type = type;
            this.label = label;
            this.imgIconId = iconId;
        }
    }
}

