/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.meeting.PromoteOrDowngradeItem;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.dialog.ExpelAttendeeAlertDialog;
import com.zipow.videobox.fragment.ConfChatFragment;
import com.zipow.videobox.fragment.PListFragment;
import com.zipow.videobox.fragment.QAWebinarAttendeeListFragment;
import com.zipow.videobox.fragment.WebinarRaiseHandFragment;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.DialogUtils;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class PAttendeeListActionDialog
extends ZMDialogFragment {
    private static final String TAG = PAttendeeListActionDialog.class.getSimpleName();
    private static final String ARG_CONF_ATTENDEE_ITEM = "conf_attendee_item";
    private OptionListAdapter mAdapter;
    private ConfChatAttendeeItem mConfChatAttendeeItem;

    public static boolean show(FragmentManager fm, ConfChatAttendeeItem confChatAttendeeItem) {
        if (!PAttendeeListActionDialog.hasActionsForUser((Context)VideoBoxApplication.getInstance(), confChatAttendeeItem)) {
            return false;
        }
        Bundle args = new Bundle();
        args.putSerializable(ARG_CONF_ATTENDEE_ITEM, (Serializable)confChatAttendeeItem);
        PAttendeeListActionDialog f = new PAttendeeListActionDialog();
        f.setArguments(args);
        f.show(fm, PAttendeeListActionDialog.class.getName());
        return true;
    }

    public PAttendeeListActionDialog() {
        this.setCancelable(true);
    }

    private static PAttendeeListActionDialog getActivePListItemActionDialog(FragmentManager fm) {
        return (PAttendeeListActionDialog)fm.findFragmentByTag(PAttendeeListActionDialog.class.getName());
    }

    public static void dismissPAttendeeListActionDialogForUserId(FragmentManager fm, long userId) {
        ConfChatAttendeeItem confChatAttendeeItem;
        ExpelAttendeeAlertDialog expelDialog;
        ConfChatAttendeeItem confChatAttendeeItem2;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        PAttendeeListActionDialog actionDialog = PAttendeeListActionDialog.getActivePListItemActionDialog(fm);
        if (actionDialog != null && (confChatAttendeeItem2 = actionDialog.getConfChatAttendeeItem()) != null && confStatus.isSameUser(userId, confChatAttendeeItem2.nodeID)) {
            actionDialog.dismiss();
        }
        if ((expelDialog = ExpelAttendeeAlertDialog.getExpelAttendeeAlertDialog(fm)) != null && (confChatAttendeeItem = expelDialog.getConfChatAttendeeItem()) != null && confStatus.isSameUser(userId, confChatAttendeeItem.nodeID)) {
            expelDialog.dismiss();
        }
    }

    public static void refreshAction(FragmentManager fm, long userId) {
        ConfChatAttendeeItem confChatAttendeeItem;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        PAttendeeListActionDialog actionDialog = PAttendeeListActionDialog.getActivePListItemActionDialog(fm);
        if (actionDialog != null && (confChatAttendeeItem = actionDialog.getConfChatAttendeeItem()) != null && confStatus.isSameUser(userId, confChatAttendeeItem.nodeID)) {
            if (ConfLocalHelper.isNeedShowAttendeeActionList()) {
                actionDialog.refresh();
            } else {
                actionDialog.dismiss();
            }
        }
    }

    public static void dismissPAttendeeListActionDialogForUserId(FragmentManager fm, String jid) {
        if (!StringUtil.isEmptyOrNull((String)jid)) {
            ConfChatAttendeeItem confChatAttendeeItem;
            ExpelAttendeeAlertDialog expelDialog;
            ConfChatAttendeeItem confChatAttendeeItem2;
            PAttendeeListActionDialog actionDialog = PAttendeeListActionDialog.getActivePListItemActionDialog(fm);
            if (actionDialog != null && (confChatAttendeeItem2 = actionDialog.getConfChatAttendeeItem()) != null && jid.equals(confChatAttendeeItem2.jid)) {
                actionDialog.dismiss();
            }
            if ((expelDialog = ExpelAttendeeAlertDialog.getExpelAttendeeAlertDialog(fm)) != null && (confChatAttendeeItem = expelDialog.getConfChatAttendeeItem()) != null && jid.equals(confChatAttendeeItem.jid)) {
                expelDialog.dismiss();
            }
        }
    }

    private static boolean hasActionsForUser(Context context, ConfChatAttendeeItem confChatAttendeeItem) {
        return OptionListAdapter.loadActions(new ArrayList(), context, confChatAttendeeItem) > 0;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mConfChatAttendeeItem = (ConfChatAttendeeItem)args.getSerializable(ARG_CONF_ATTENDEE_ITEM);
        if (this.mConfChatAttendeeItem == null) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).create();
        }
        this.mAdapter = new OptionListAdapter((ZMActivity)this.getActivity(), this.mConfChatAttendeeItem);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTheme(R.style.ZMDialog_Material).setListDividerHeight(0).setTitleView(DialogUtils.createAvatarDialogTitleView((Context)this.getActivity(), this.mConfChatAttendeeItem.name, null)).setAdapter((ListAdapter)this.mAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PAttendeeListActionDialog.this.onClickItem(which);
            }
        }).setListDividerHeight(0).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        if (this.mConfChatAttendeeItem != null) {
            this.refresh();
        } else {
            this.dismiss();
        }
    }

    private ConfChatAttendeeItem getConfChatAttendeeItem() {
        return this.mConfChatAttendeeItem;
    }

    private void refresh() {
        ZoomQABuddy buddy;
        ZoomQAComponent zoomQAComponent = ConfMgr.getInstance().getQAComponent();
        if (zoomQAComponent != null && (buddy = zoomQAComponent.getBuddyByNodeID(this.mConfChatAttendeeItem.nodeID)) != null) {
            this.mConfChatAttendeeItem = new ConfChatAttendeeItem(buddy);
            this.mAdapter.setmConfChatAttendeeItem(this.mConfChatAttendeeItem);
        }
        this.mAdapter.reloadAll();
        this.mAdapter.notifyDataSetChanged();
        if (this.mAdapter.getCount() == 0) {
            this.dismiss();
        }
    }

    private void onClickItem(int which) {
        ZMSimpleMenuItem item = this.mAdapter.getItem(which);
        if (this.mConfChatAttendeeItem == null) {
            return;
        }
        int acton = item.getAction();
        if (acton == AttendeeActonMenu.PROMOTE_TO_PANELIST.ordinal()) {
            this.onClickPromotePanelist(this.mConfChatAttendeeItem);
        } else if (acton == AttendeeActonMenu.EXPEL.ordinal()) {
            this.onClickMiExpel(this.mConfChatAttendeeItem);
        } else if (acton == AttendeeActonMenu.LOWERHAND.ordinal()) {
            this.onClickLowerAttendeeHand(this.mConfChatAttendeeItem);
        } else if (acton == AttendeeActonMenu.CHAT.ordinal()) {
            FragmentActivity activity = this.getActivity();
            if (activity instanceof ZMActivity) {
                ConfChatFragment.showAsActivity((ZMActivity)activity, 0, this.mConfChatAttendeeItem);
            }
        } else if (acton == AttendeeActonMenu.TEMPORARILY_TALK.ordinal()) {
            ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.mConfChatAttendeeItem.nodeID);
            if (buddy != null) {
                ConfMgr.getInstance().handleUserCmd(buddy.isAttendeeCanTalk() ? 28 : 27, this.mConfChatAttendeeItem.nodeID);
            }
        } else if (acton == AttendeeActonMenu.MUTE_UNMUTE.ordinal()) {
            this.onClickMiMute(this.mConfChatAttendeeItem.nodeID);
        }
    }

    private void onClickLowerAttendeeHand(ConfChatAttendeeItem attendeeItem) {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null || !raiseHandInWebinar.lowerHand(attendeeItem.jid)) {
            // empty if block
        }
    }

    private void onClickPromotePanelist(ConfChatAttendeeItem confChatAttendeeItem) {
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            QAWebinarAttendeeListFragment f = (QAWebinarAttendeeListFragment)zmActivity.getSupportFragmentManager().findFragmentByTag(QAWebinarAttendeeListFragment.class.getName());
            if (f != null) {
                f.promotePanelist(confChatAttendeeItem);
            } else {
                WebinarRaiseHandFragment webinarRaiseHandFragment = (WebinarRaiseHandFragment)zmActivity.getSupportFragmentManager().findFragmentByTag(WebinarRaiseHandFragment.class.getName());
                PromoteOrDowngradeItem promoteOrDowngradeItem = new PromoteOrDowngradeItem(confChatAttendeeItem, 1);
                if (webinarRaiseHandFragment != null) {
                    webinarRaiseHandFragment.promoteOrDowngrade(promoteOrDowngradeItem);
                } else {
                    PListFragment pListFragment = (PListFragment)zmActivity.getSupportFragmentManager().findFragmentByTag(PListFragment.class.getName());
                    if (pListFragment != null) {
                        pListFragment.promoteOrDowngrade(promoteOrDowngradeItem);
                    }
                }
            }
        }
    }

    private void onClickMiMute(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (user.getAudioStatusObj().getIsMuted()) {
            ConfMgr.getInstance().handleUserCmd(47, userId);
        } else {
            ConfMgr.getInstance().handleUserCmd(46, userId);
        }
    }

    private void onClickMiExpel(ConfChatAttendeeItem confChatAttendeeItem) {
        FragmentActivity activity = this.getActivity();
        if (activity == null || confChatAttendeeItem == null) {
            return;
        }
        ExpelAttendeeAlertDialog.showExpelAttendeeAlertDialog((ZMActivity)activity, confChatAttendeeItem);
    }

    static enum AttendeeActonMenu {
        PROMOTE_TO_PANELIST,
        EXPEL,
        LOWERHAND,
        CHAT,
        TEMPORARILY_TALK,
        MUTE_UNMUTE;

    }

    static class OptionListAdapter
    extends BaseAdapter {
        private ZMActivity mActivity;
        private List<ZMSimpleMenuItem> mList = new ArrayList<ZMSimpleMenuItem>();
        private ConfChatAttendeeItem mConfChatAttendeeItem;

        public OptionListAdapter(ZMActivity activity, ConfChatAttendeeItem confChatAttendeeItem) {
            this.mActivity = activity;
            this.mConfChatAttendeeItem = confChatAttendeeItem;
        }

        public void setmConfChatAttendeeItem(ConfChatAttendeeItem mConfChatAttendeeItem) {
            this.mConfChatAttendeeItem = mConfChatAttendeeItem;
        }

        public void reloadAll() {
            this.mList.clear();
            if (this.mActivity != null) {
                OptionListAdapter.loadActions(this.mList, (Context)this.mActivity, this.mConfChatAttendeeItem);
            }
        }

        private static int loadActions(List<ZMSimpleMenuItem> list, Context context, ConfChatAttendeeItem attendeeItem) {
            ZMSimpleMenuItem item;
            boolean isHostOrCohost;
            if (attendeeItem == null) {
                return 0;
            }
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself == null || ConfMgr.getInstance().isViewOnlyMeeting()) {
                return 0;
            }
            CmmConfContext cmmConfContext = ConfMgr.getInstance().getConfContext();
            if (cmmConfContext == null) {
                return 0;
            }
            boolean bl = isHostOrCohost = myself.isHost() || myself.isCoHost();
            if (isHostOrCohost) {
                MeetingInfo meetingItem = cmmConfContext.getMeetingItem();
                if (cmmConfContext.isWebinar() && cmmConfContext.isMMRSupportViewOnlyClient() && attendeeItem.isSupportTempTalk && meetingItem != null && !meetingItem.getIsSelfTelephonyOn()) {
                    if (attendeeItem.isAllowTalked) {
                        if (attendeeItem.audioType != 2L) {
                            item = new ZMSimpleMenuItem(AttendeeActonMenu.MUTE_UNMUTE.ordinal(), context.getResources().getString(attendeeItem.audioOn ? R.string.zm_mi_mute : R.string.zm_mi_unmute));
                            list.add(item);
                        }
                        item = new ZMSimpleMenuItem(AttendeeActonMenu.TEMPORARILY_TALK.ordinal(), context.getString(R.string.zm_mi_forbid_talk_15294));
                        list.add(item);
                    } else {
                        item = new ZMSimpleMenuItem(AttendeeActonMenu.TEMPORARILY_TALK.ordinal(), context.getString(R.string.zm_mi_allow_talk_15294));
                        list.add(item);
                    }
                }
                if (ConfLocalHelper.isHaisedHand(attendeeItem.jid)) {
                    item = new ZMSimpleMenuItem(AttendeeActonMenu.LOWERHAND.ordinal(), context.getString(R.string.zm_btn_lower_hand));
                    list.add(item);
                }
            }
            if (!cmmConfContext.isChatOff() && !cmmConfContext.isPrivateChatOFF()) {
                item = new ZMSimpleMenuItem(AttendeeActonMenu.CHAT.ordinal(), context.getString(R.string.zm_mi_chat));
                list.add(item);
            }
            if (isHostOrCohost) {
                item = new ZMSimpleMenuItem(AttendeeActonMenu.PROMOTE_TO_PANELIST.ordinal(), context.getString(R.string.zm_webinar_mi_promote_to_panelist));
                list.add(item);
                item = new ZMSimpleMenuItem(AttendeeActonMenu.EXPEL.ordinal(), context.getString(R.string.zm_mi_expel));
                list.add(item);
            }
            return list.size();
        }

        public int getCount() {
            return this.mList.size();
        }

        public ZMSimpleMenuItem getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_menu_item, null);
            }
            ImageView imgIcon = (ImageView)convertView.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)convertView.findViewById(R.id.txtLabel);
            View check = convertView.findViewById(R.id.check);
            txtLabel.setText((CharSequence)this.getItem(position).getLabel());
            imgIcon.setVisibility(8);
            check.setVisibility(8);
            return convertView;
        }
    }
}

