/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.view.NonVerbalFeedbackListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.videomeetings.R;

public class NonVerbalFeedbackListFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private NonVerbalFeedbackListView mListView;
    private Button mBtnClose;
    private Button mBtnClearAll;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void showAsActivity(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        Bundle args = new Bundle();
        NonVerbalFeedbackListFragment f = new NonVerbalFeedbackListFragment();
        f.setArguments(args);
        SimpleInMeetingActivity.show(activity, NonVerbalFeedbackListFragment.class.getName(), args, 0, false);
    }

    public static NonVerbalFeedbackListFragment findFragment(FragmentManager fm) {
        return (NonVerbalFeedbackListFragment)fm.findFragmentByTag(NonVerbalFeedbackListFragment.class.getName());
    }

    public static boolean dismiss(FragmentManager fm) {
        NonVerbalFeedbackListFragment f = NonVerbalFeedbackListFragment.findFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_non_verbal_list, container, false);
        this.mListView = (NonVerbalFeedbackListView)view.findViewById(R.id.listView);
        this.mBtnClose = (Button)view.findViewById(R.id.btnClose);
        this.mBtnClearAll = (Button)view.findViewById(R.id.btnClearAll);
        if (this.mBtnClose != null) {
            this.mBtnClose.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mBtnClearAll != null) {
            this.mBtnClearAll.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    if (cmd == 39) {
                        NonVerbalFeedbackListFragment.this.sinkFeedbackChanged(userId);
                    } else if (cmd == 35) {
                        NonVerbalFeedbackListFragment.this.sinkUserRaiseLowerHand(userId, true);
                    } else if (cmd == 36) {
                        NonVerbalFeedbackListFragment.this.sinkUserRaiseLowerHand(userId, false);
                    }
                    return true;
                }

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 92) {
                        NonVerbalFeedbackListFragment.this.sinkFeedbackAllCleared();
                    }
                    return true;
                }

                @Override
                public boolean onUserEvent(int eventType, long userId, int flag) {
                    NonVerbalFeedbackListFragment.this.sinkUserEvent();
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        return view;
    }

    protected void sinkUserRaiseLowerHand(final long userId, final boolean raise) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackIndicatorTipHand", new EventAction("onRaiseLowerHand"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackListFragment)ui).onRaiseLowerHand(userId, raise);
                }
            });
        }
    }

    protected void onRaiseLowerHand(long userId, boolean b) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        this.mListView.updated(user);
    }

    public void onResume() {
        super.onResume();
        this.refresh();
    }

    protected void sinkFeedbackAllCleared() {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackListFragmentAllCleared", new EventAction("onFeedbackAllCleared"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackListFragment)ui).onFeedbackAllCleared();
                }
            });
        }
    }

    protected void onFeedbackAllCleared() {
        this.refresh();
    }

    protected void sinkFeedbackChanged(final long userId) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackListFragmentChanged", new EventAction("onFeedbackChanged"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackListFragment)ui).onFeedbackChanged(userId);
                }
            });
        }
    }

    protected void onFeedbackChanged(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        this.mListView.updated(user);
    }

    protected void sinkUserEvent() {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("sinkUserEvent", new EventAction("sinkUserEvent"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackListFragment)ui).onUserEvent();
                }
            });
        }
    }

    private void onUserEvent() {
        this.mListView.reloadAllItems();
    }

    public void onDestroy() {
        super.onDestroy();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    private void refresh() {
        this.mListView.reloadAllItems();
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        if (v == this.mBtnClose) {
            this.onClickClose();
        } else if (v == this.mBtnClearAll) {
            this.onClickClearAll();
        }
    }

    private void onClickClose() {
        this.dismiss();
    }

    private void onClickClearAll() {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        if (feedbackMgr == null) {
            return;
        }
        feedbackMgr.clearAllFeedback();
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

