/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.fragment.NonVerbalFeedbackChangeDialog;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class NonVerbalFeedbackIndicatorTip
extends ZMTipFragment
implements View.OnClickListener {
    private ImageView mImage;
    private ConfUI.IConfUIListener mConfUIListener;
    private long mUserId;

    public static void show(FragmentManager fragmentMgr, long userId) {
        NonVerbalFeedbackIndicatorTip.dismiss(fragmentMgr);
        Bundle args = new Bundle();
        args.putLong("feedbackUserId", userId);
        NonVerbalFeedbackIndicatorTip tip = new NonVerbalFeedbackIndicatorTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, NonVerbalFeedbackIndicatorTip.class.getName(), 0L);
    }

    public static NonVerbalFeedbackIndicatorTip getFragment(FragmentManager fm) {
        return (NonVerbalFeedbackIndicatorTip)fm.findFragmentByTag(NonVerbalFeedbackIndicatorTip.class.getName());
    }

    public static boolean dismiss(FragmentManager fm) {
        NonVerbalFeedbackIndicatorTip fragment = NonVerbalFeedbackIndicatorTip.getFragment(fm);
        if (fragment != null) {
            fragment.dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.zm_feedback_indicator, null);
        this.mImage = (ImageView)view.findViewById(R.id.imgContent);
        Bundle args = this.getArguments();
        this.mUserId = args.getLong("feedbackUserId");
        this.refresh();
        this.mImage.setOnClickListener((View.OnClickListener)this);
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    if (cmd == 39) {
                        NonVerbalFeedbackIndicatorTip.this.sinkFeedbackChanged(userId);
                    } else if (cmd == 35) {
                        NonVerbalFeedbackIndicatorTip.this.sinkUserRaiseLowerHand(userId, true);
                    } else if (cmd == 36) {
                        NonVerbalFeedbackIndicatorTip.this.sinkUserRaiseLowerHand(userId, false);
                    }
                    return true;
                }

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 92) {
                        NonVerbalFeedbackIndicatorTip.this.sinkFeedbackAllCleared();
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        tip.setCornerArcSize(UIUtil.dip2px((Context)context, (float)10.0f));
        tip.setLayoutGravity(3, UIUtil.dip2px((Context)context, (float)60.0f));
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_bg_on_dark));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_bg_on_dark));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_bg_on_dark));
        return tip;
    }

    public void onResume() {
        super.onResume();
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user != null) {
            this.updateFeedback(user.getFeedback());
        }
    }

    public void onDestroy() {
        super.onDestroy();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    protected void sinkFeedbackAllCleared() {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackIndicatorTipCleared", new EventAction("onFeedbackAllCleared"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackIndicatorTip)ui).onFeedbackAllCleared();
                }
            });
        }
    }

    protected void sinkFeedbackChanged(long userId) {
        if (userId != this.mUserId) {
            return;
        }
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackIndicatorTipChanged", new EventAction("onFeedbackChanged"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackIndicatorTip)ui).onFeedbackChanged();
                }
            });
        }
    }

    protected void sinkUserRaiseLowerHand(final long userId, final boolean raise) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackIndicatorTipHand", new EventAction("onRaiseLowerHand"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackIndicatorTip)ui).onRaiseLowerHand(userId, raise);
                }
            });
        }
    }

    protected void onRaiseLowerHand(long userId, boolean raise) {
        this.refresh();
    }

    protected void onFeedbackAllCleared() {
        this.dismiss();
    }

    protected void onFeedbackChanged() {
        this.refresh();
    }

    private void refresh() {
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user == null) {
            return;
        }
        if (user.getFeedback() == 0) {
            this.dismiss();
        } else {
            this.updateFeedback(user.getFeedback());
        }
    }

    private void updateFeedback(int feedback) {
        int icon = CmmFeedbackMgr.getIconIdByFeedback(feedback);
        if (icon != 0) {
            this.mImage.setImageResource(icon);
        } else {
            this.dismiss();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.imgContent) {
            NonVerbalFeedbackChangeDialog.showDialogFragment(this.getFragmentManager());
        }
    }
}

