/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.view.NonVerbalFeedbackActionView;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class NonVerbalFeedbackChangeDialog
extends ZMDialogFragment
implements NonVerbalFeedbackActionView.NonVerbalFBListener,
View.OnClickListener {
    private WindowManager.LayoutParams mSaveLayoutParams;
    private NonVerbalFeedbackActionView mFeedbackView;
    private ConfUI.IConfUIListener mConfUIListener;
    private View mBtnClear;

    public static void showDialogFragment(FragmentManager fm) {
        if (fm == null) {
            return;
        }
        Bundle args = new Bundle();
        NonVerbalFeedbackChangeDialog dlg = new NonVerbalFeedbackChangeDialog();
        dlg.setArguments(args);
        dlg.show(fm, NonVerbalFeedbackChangeDialog.class.getName());
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(this.createContent()).setTheme(R.style.ZMDialog_Material_RoundRect).create();
        dialog.setCanceledOnTouchOutside(true);
        Window window = dialog.getWindow();
        if (window != null) {
            WindowManager.LayoutParams lp = window.getAttributes();
            window.setAttributes(lp);
            this.mSaveLayoutParams = lp;
        }
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    if (cmd == 39) {
                        NonVerbalFeedbackChangeDialog.this.sinkFeedbackChanged(userId);
                    } else if (cmd == 35) {
                        NonVerbalFeedbackChangeDialog.this.sinkUserRaiseLowerHand(userId, true);
                    } else if (cmd == 36) {
                        NonVerbalFeedbackChangeDialog.this.sinkUserRaiseLowerHand(userId, false);
                    }
                    return true;
                }

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 92) {
                        NonVerbalFeedbackChangeDialog.this.sinkFeedbackAllCleared();
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        return dialog;
    }

    protected void sinkUserRaiseLowerHand(final long userId, final boolean raise) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackChangeDialogHand", new EventAction("onRaiseLowerHand"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackChangeDialog)ui).onRaiseLowerHand(userId, raise);
                }
            });
        }
    }

    protected void onRaiseLowerHand(long userId, boolean b) {
        this.updateUI();
    }

    private View createContent() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_feedback_change, null);
        this.mFeedbackView = (NonVerbalFeedbackActionView)view.findViewById(R.id.viewFeedback);
        this.mBtnClear = view.findViewById(R.id.txtClearFeedback);
        CmmUser mySelf = ConfMgr.getInstance().getMyself();
        if (mySelf != null) {
            this.mFeedbackView.setFeedbackFocus(mySelf.getFeedback());
        }
        this.mFeedbackView.setLinstener(this);
        this.mBtnClear.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onDestroy() {
        super.onDestroy();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    private void updateUI() {
        CmmUser mySelf = ConfMgr.getInstance().getMyself();
        if (mySelf == null) {
            return;
        }
        if (mySelf.getFeedback() == 0) {
            this.dismiss();
            return;
        }
        this.mFeedbackView.setFeedbackFocus(mySelf.getFeedback());
    }

    protected void sinkFeedbackAllCleared() {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackChangeDialogCleared", new EventAction("onFeedbackAllCleared"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackChangeDialog)ui).onFeedbackAllCleared();
                }
            });
        }
    }

    protected void onFeedbackAllCleared() {
        this.dismiss();
    }

    protected void sinkFeedbackChanged(final long userId) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackChangeDialogChanged", new EventAction("onFeedbackChanged"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackChangeDialog)ui).onFeedbackChanged(userId);
                }
            });
        }
    }

    protected void onFeedbackChanged(long userId) {
        CmmUser mySelf = ConfMgr.getInstance().getMyself();
        if (mySelf == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (!confStatus.isSameUser(userId, mySelf.getNodeId())) {
            return;
        }
        this.updateUI();
    }

    @Override
    public void onSetFeedback(int feedback) {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        if (feedbackMgr == null) {
            return;
        }
        if (feedback == 1) {
            this.onClickHandAction();
        } else {
            feedbackMgr.changeMyFeedback(feedback);
        }
        this.dismiss();
    }

    @Override
    public void onClearFeedback() {
        this.clearMyFeedback();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.txtClearFeedback) {
            this.onClickClearFeedback();
            this.dismiss();
        }
    }

    private void onClickClearFeedback() {
        this.clearMyFeedback();
    }

    private void clearMyFeedback() {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        if (feedbackMgr == null) {
            return;
        }
        feedbackMgr.changeMyFeedback(0);
    }

    private void onClickHandAction() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        if (myself.getRaiseHandState()) {
            ConfMgr.getInstance().handleUserCmd(36, myself.getNodeId());
        } else {
            ConfMgr.getInstance().handleUserCmd(35, myself.getNodeId());
        }
    }

    public void dismiss() {
        Window window;
        Dialog dialog = this.getDialog();
        if (dialog != null && (window = dialog.getWindow()) != null) {
            window.setAttributes(this.mSaveLayoutParams);
        }
        this.finishFragment(true);
    }
}

