/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.upgrade.UpgradeMgr;
import com.zipow.videobox.util.UpgradeUtil;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class NewVersionDialog
extends ZMDialogFragment
implements UpgradeMgr.UpgradeMgrListener {
    private static final String ARG_VERSION = "version";
    private static final String ARG_NOTE = "note";
    private View mContentView = null;
    private ProgressBar mProgress;
    private static NewVersionDialog s_lastInstance = null;
    private Handler mHandler;
    public static final int REQUEST_PERMISSION_BY_UPDATE = 106;
    private RequestPermissionListener mRequestPermissionListener;
    private RetainedFragment mRetainedFragment;
    private DialogInterface.OnClickListener redownloadClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            ZMActivity activity = (ZMActivity)NewVersionDialog.this.getActivity();
            if (activity == null) {
                return;
            }
            UpgradeMgr.getInstance((Context)activity).cancel((Context)activity);
            if (!NetworkUtil.hasDataNetwork((Context)activity)) {
                NewVersionDialog.this.showConnectionError();
                return;
            }
            UpgradeUtil.upgrade(activity);
        }
    };
    private DialogInterface.OnClickListener deleteDownloadClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            FragmentActivity acitvity = NewVersionDialog.this.getActivity();
            if (acitvity == null) {
                return;
            }
            UpgradeMgr.getInstance((Context)acitvity).cancel((Context)acitvity);
        }
    };
    private DialogInterface.OnClickListener hidenDownloadClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
        }
    };

    public static NewVersionDialog newInstance(String version, String note, RequestPermissionListener requestPermissionListener) {
        NewVersionDialog dialog = new NewVersionDialog();
        dialog.setRequestPermissionListener(requestPermissionListener);
        Bundle args = new Bundle();
        args.putString(ARG_VERSION, version);
        args.putString(ARG_NOTE, note);
        dialog.setArguments(args);
        return dialog;
    }

    public static void showDownloading(ZMActivity activity, RequestPermissionListener requestPermissionListener) {
        FragmentManager fm;
        if (activity == null) {
            return;
        }
        if ((UpgradeMgr.getInstance((Context)activity).getStatus() == 2 || UpgradeMgr.getInstance((Context)activity).getStatus() == 3) && (fm = activity.getSupportFragmentManager()) != null) {
            NewVersionDialog dialog = (NewVersionDialog)fm.findFragmentByTag(NewVersionDialog.class.getName());
            if (dialog != null) {
                dialog.dismiss();
            }
            dialog = NewVersionDialog.newInstance("", "", requestPermissionListener);
            dialog.show(fm, NewVersionDialog.class.getName());
        }
    }

    public static NewVersionDialog getLastInstance() {
        return s_lastInstance;
    }

    private static void setLastInstance(NewVersionDialog dlg) {
        s_lastInstance = dlg;
    }

    public NewVersionDialog() {
        this.setCancelable(true);
        NewVersionDialog.setLastInstance(this);
    }

    public void setArguments(String version, String note) {
        Bundle args = this.getArguments();
        if (args != null) {
            args.putString(ARG_VERSION, version);
            args.putString(ARG_NOTE, note);
        }
        if (this.mContentView != null) {
            TextView txtNote = (TextView)this.mContentView.findViewById(R.id.txtNote);
            if (txtNote != null) {
                txtNote.setText((CharSequence)note);
            }
            this.mContentView.setVisibility(StringUtil.isEmptyOrNull((String)note) ? 8 : 0);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initRetainedFragment();
    }

    public void onStart() {
        super.onStart();
        this.mHandler = new Handler();
    }

    public void onDestroy() {
        super.onDestroy();
        NewVersionDialog.setLastInstance(null);
        Object context = this.getActivity();
        if (context == null) {
            context = VideoBoxApplication.getInstance();
        }
        UpgradeMgr.getInstance((Context)context).removeUpgradeMgrListener(this);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog dialog;
        FragmentActivity acitivty = this.getActivity();
        if (acitivty == null) {
            return this.createEmptyDialog();
        }
        if (UpgradeMgr.getInstance((Context)acitivty).getStatus() == 1) {
            View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_new_version, null, false);
            TextView txtNote = (TextView)view.findViewById(R.id.txtNote);
            String note = "";
            Bundle args = this.getArguments();
            if (args != null) {
                note = args.getString(ARG_NOTE);
            }
            if (note == null) {
                note = "";
            }
            txtNote.setText((CharSequence)note);
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)acitivty).setTitle(R.string.zm_title_new_version_ready).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_update, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ZMActivity activity = (ZMActivity)NewVersionDialog.this.getActivity();
                    if (activity == null) {
                        return;
                    }
                    if (!NetworkUtil.hasDataNetwork((Context)activity)) {
                        NewVersionDialog.this.showConnectionError();
                        return;
                    }
                    if (NewVersionDialog.this.checkStoragePermission()) {
                        UpgradeUtil.upgrade(activity);
                    } else if (NewVersionDialog.this.mRequestPermissionListener != null) {
                        NewVersionDialog.this.mRequestPermissionListener.requestPermission();
                    }
                }
            });
            if (StringUtil.isEmptyOrNull((String)note)) {
                view.setVisibility(8);
            }
            this.mContentView = view;
            dialog = builder.create();
        } else {
            View view = LayoutInflater.from((Context)acitivty).inflate(R.layout.zm_version_download, null, false);
            this.mProgress = (ProgressBar)view.findViewById(R.id.down_pre);
            long downloadSize = UpgradeMgr.getInstance((Context)acitivty).getDownloadSize();
            long fileSize = UpgradeMgr.getInstance((Context)acitivty).getFileSize();
            int title = R.string.zm_downloading;
            if (UpgradeMgr.getInstance((Context)acitivty).getStatus() == 2 && fileSize > 0L) {
                this.mProgress.setProgress((int)(downloadSize * 100L / fileSize));
            } else {
                this.mProgress.setProgress(0);
            }
            if (UpgradeMgr.getInstance((Context)this.getActivity()).getStatus() == 3) {
                title = R.string.zm_download_failed;
            }
            this.mProgress.setMax(100);
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setView(view).setNegativeButton(R.string.zm_btn_cancel, this.deleteDownloadClick);
            if (title == R.string.zm_downloading) {
                builder.setPositiveButton(R.string.zm_btn_download_in_background, this.hidenDownloadClick);
            } else if (title == R.string.zm_download_failed) {
                builder.setPositiveButton(R.string.zm_btn_redownload, this.redownloadClick);
            }
            UpgradeMgr.getInstance((Context)this.getActivity()).addUpgradeMgrListener(this);
            dialog = builder.create();
        }
        if (dialog != null) {
            dialog.setCanceledOnTouchOutside(false);
        }
        if (dialog == null) {
            return this.createEmptyDialog();
        }
        return dialog;
    }

    private boolean checkStoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void showNewDialog() {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((NewVersionDialog)ui).dismiss();
                NewVersionDialog dialog = new NewVersionDialog();
                dialog.show(NewVersionDialog.this.getFragmentManager(), NewVersionDialog.class.getName());
            }
        });
    }

    @Override
    public void onUpgradeEvent(final int event, int value, int type) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (event == 1) {
                    NewVersionDialog.this.showNewDialog();
                } else if (event == 4) {
                    if (NewVersionDialog.this.mProgress == null) {
                        NewVersionDialog.this.showNewDialog();
                        return;
                    }
                    FragmentActivity acitvity = NewVersionDialog.this.getActivity();
                    if (acitvity == null) {
                        return;
                    }
                    long downloadSize = UpgradeMgr.getInstance((Context)acitvity).getDownloadSize();
                    long fileSize = UpgradeMgr.getInstance((Context)acitvity).getFileSize();
                    if (downloadSize > 0L && fileSize > 0L) {
                        NewVersionDialog.this.mProgress.setProgress((int)(downloadSize * 100L / fileSize));
                    }
                } else if (event == 5) {
                    NewVersionDialog.this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                        public void run(IUIElement ui) {
                            ((NewVersionDialog)ui).dismiss();
                        }
                    });
                }
            }
        });
    }

    public void setRequestPermissionListener(RequestPermissionListener requestPermissionListener) {
        this.mRequestPermissionListener = requestPermissionListener;
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveRequestPermissionListener(this.mRequestPermissionListener);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            RequestPermissionListener requestPermissionListener = this.mRetainedFragment.restoreRequestPermissionListener();
            if (requestPermissionListener != null) {
                this.mRequestPermissionListener = requestPermissionListener;
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        return (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
    }

    public static interface RequestPermissionListener {
        public void requestPermission();
    }

    public static class RetainedFragment
    extends ZMFragment {
        private RequestPermissionListener mRequestPermissionListener;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveRequestPermissionListener(RequestPermissionListener requestPermissionListener) {
            this.mRequestPermissionListener = requestPermissionListener;
        }

        public RequestPermissionListener restoreRequestPermissionListener() {
            return this.mRequestPermissionListener;
        }
    }
}

