/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class NewGroupChatFragment
extends ZMDialogFragment
implements View.OnClickListener {
    public static final int REQUEST_MM_SELECT_BUDDIES = 100;
    private static final int MAX_NAME_LENGTH = 64;
    public static final String RESULT_ARG_SUBJECT = "group.subject";
    public static final String RESULT_ARG_SELECTED_ITEMS = "selectedItems";
    private View mBtnCancel;
    private EditText mEdtSubject;
    private TextView mTxtCharactersLeft;
    private View mBtnNext;

    public static void showAsActivity(Fragment fragment, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, NewGroupChatFragment.class.getName(), args, requestCode, true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Window window;
        View view = inflater.inflate(R.layout.zm_mm_new_group_chat, null);
        this.mBtnCancel = view.findViewById(R.id.btnCancel);
        this.mEdtSubject = (EditText)view.findViewById(R.id.edtSubject);
        this.mTxtCharactersLeft = (TextView)view.findViewById(R.id.txtCharatersLeft);
        this.mBtnNext = view.findViewById(R.id.btnNext);
        if (Build.VERSION.SDK_INT < 11) {
            this.mEdtSubject.setGravity(3);
        }
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnNext.setOnClickListener((View.OnClickListener)this);
        FragmentActivity activity = this.getActivity();
        if (activity != null && (window = activity.getWindow()) != null) {
            window.setSoftInputMode(16);
        }
        this.checkInput();
        this.mEdtSubject.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                NewGroupChatFragment.this.checkInput();
            }
        });
        return view;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null && !this.getShowsDialog()) {
            data.putExtra(RESULT_ARG_SUBJECT, this.getSubject());
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity != null) {
                activity.setResult(-1, data);
                activity.finish();
                activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
            }
        }
    }

    private void checkInput() {
        String subject = this.getSubject();
        int maxLength = 64;
        Resources res = this.getResources();
        if (res == null) {
            return;
        }
        maxLength = res.getInteger(R.integer.zm_group_chat_topic_max_length);
        int left = maxLength - subject.length();
        if (left < 0) {
            left = 0;
        }
        this.mTxtCharactersLeft.setText((CharSequence)res.getQuantityString(R.plurals.zm_msg_charactors_left, left, new Object[]{left}));
        this.mBtnNext.setEnabled(!StringUtil.isEmptyOrNull((String)subject));
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSubject);
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == this.mBtnCancel) {
            this.onClickBtnCancel();
        } else if (v == this.mBtnNext) {
            this.onClickBtnNext();
        }
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickBtnNext() {
        String subject = this.getSubject();
        if (StringUtil.isEmptyOrNull((String)subject)) {
            if (this.mEdtSubject != null) {
                this.mEdtSubject.requestFocus();
            }
            return;
        }
        Bundle data = new Bundle();
        data.putString(RESULT_ARG_SUBJECT, subject);
        String btnOkText = this.getString(R.string.zm_btn_create);
        String instructionMessage = this.getString(R.string.zm_msg_select_buddies_to_join_group_instructions);
        MMSelectContactsActivity.show((Fragment)this, subject, null, btnOkText, instructionMessage, false, data, false, 100, false, null, false, PTApp.getInstance().getMaxChatGroupBuddyNumber() - 1);
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }

    private String getSubject() {
        if (this.mEdtSubject != null) {
            return this.mEdtSubject.getText().toString();
        }
        return "";
    }
}

