/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.FileProvider;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.cmmlib.AppUtil;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.ChangeCallInCountryFragment;
import com.zipow.videobox.fragment.CustomStatusFragment;
import com.zipow.videobox.fragment.PMIModifyIDFragment;
import com.zipow.videobox.fragment.PasswordEditFragment;
import com.zipow.videobox.fragment.PresenceStatusFragment;
import com.zipow.videobox.fragment.SelectCallInCountryFragment;
import com.zipow.videobox.fragment.VanityURLModifyFragment;
import com.zipow.videobox.ptapp.LogoutHandler;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.DialogUtils;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.AvatarView;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.FingerprintUtil;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MyProfileFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private static final String TAG = MyProfileFragment.class.getSimpleName();
    private static final int REQUEST_CHOOSE_PICTURE = 100;
    private static final int REQUEST_CAPTURE_PHOTO = 101;
    private static final int REQUEST_CROP_PHOTO = 102;
    private static final int REQUEST_ENABLE_ADDRBOOK = 103;
    private static final int REQUEST_SELECT_CALLIN_COUNTRY = 104;
    private static final int REQUEST_PERMISSION_BY_TAKE_PHOTO = 106;
    private static final int REQUEST_PERMISSION_BY_CHOOSE_PHOTO = 107;
    private static final int PROFILE_PHOTO_WIDTH = 400;
    private static final int PROFILE_PHOTO_HEIGHT = 400;
    private static final int AVATAR_COMPRESS_QUALITY = 60;
    private static final int AVATAR_COMPRESS_THRESHOLD = 51200;
    private Uri mCaptureUri;
    private Uri mImageUri;
    private Button mBtnBack;
    private View mOptionProfilePhoto;
    private View mOptionDisplayName;
    private AvatarView mAvatarView;
    private TextView mTxtDisplayName;
    private ImageView mDisplayNameArrow;
    private ImageView mAvatarArrow;
    private View mBtnSignout;
    private View mBtnPMI;
    private TextView mTxtPersonalMeetingId;
    private String mAvatarToUploadOnSignedOn = null;
    private TextView mTxtPhoneNumber;
    private View mBtnPassword;
    private View mBtnCallinCountry;
    private TextView mTxtCallinCountry;
    private View mBtnMeetingRoomName;
    private TextView mTxtMeetingRoomName;
    private TextView mTxtCustomStatus;
    private View mPanelCustomStatus;
    private TextView mTxtCustomSatusDes;
    private View mOptionPresenceStatus;
    private ImageView presenceStatus;
    private TextView txtPresenceStatus;
    private View mOptionFingerprint;
    private CheckedTextView mChkOpenFingerprint;
    private PTUI.IMeetingMgrListener mMeetingMgrListener = null;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerListener;
    private String mSelectedCountryId = null;
    private FingerprintUtil mFingerprintUtil;
    private NotificationSettingUI.INotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnDNDSettingsUpdated() {
            MyProfileFragment.this.updatePresence();
        }

        @Override
        public void OnDNDNowSettingUpdated() {
            MyProfileFragment.this.updatePresence();
        }

        @Override
        public void OnSnoozeSettingsUpdated() {
            MyProfileFragment.this.updatePresence();
        }
    };

    public static void showInActivity(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        MyProfileFragment f = new MyProfileFragment();
        fm.beginTransaction().add(0x1020002, (Fragment)f, MyProfileFragment.class.getName()).commit();
    }

    public static MyProfileFragment findMyProfileFragment(FragmentManager fm) {
        MyProfileFragment f = (MyProfileFragment)fm.findFragmentByTag(MyProfileFragment.class.getName());
        return f;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_my_profile, null);
        if (OsUtil.isAtLeastN()) {
            this.mFingerprintUtil = new FingerprintUtil((ZMActivity)this.getActivity());
        }
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mOptionProfilePhoto = view.findViewById(R.id.optionProfilePhoto);
        this.mOptionDisplayName = view.findViewById(R.id.optionDisplayName);
        this.mAvatarView = (AvatarView)view.findViewById(R.id.avatarView);
        this.mOptionPresenceStatus = view.findViewById(R.id.optionPresenceStatus);
        this.mTxtDisplayName = (TextView)view.findViewById(R.id.txtDisplayName);
        this.mDisplayNameArrow = (ImageView)view.findViewById(R.id.displayNameArrow);
        this.mAvatarArrow = (ImageView)view.findViewById(R.id.avatarArrow);
        this.mBtnSignout = view.findViewById(R.id.btnSignout);
        this.mBtnPMI = view.findViewById(R.id.btnPMI);
        this.mTxtPersonalMeetingId = (TextView)view.findViewById(R.id.txtMeetingId);
        this.mBtnPassword = view.findViewById(R.id.btnPassword);
        this.mTxtPhoneNumber = (TextView)view.findViewById(R.id.txtPhoneNumber);
        this.mBtnCallinCountry = view.findViewById(R.id.btnCallinCountry);
        this.mTxtCallinCountry = (TextView)view.findViewById(R.id.txtCallinCountry);
        this.mBtnMeetingRoomName = view.findViewById(R.id.btnMeetingRoomName);
        this.mTxtMeetingRoomName = (TextView)view.findViewById(R.id.txtMeetingRoomName);
        this.mTxtCustomStatus = (TextView)view.findViewById(R.id.txtCustomStatus);
        this.mTxtCustomSatusDes = (TextView)view.findViewById(R.id.customStatusDes);
        this.mPanelCustomStatus = view.findViewById(R.id.panelCustomStatus);
        this.mOptionFingerprint = view.findViewById(R.id.optionFingerprint);
        this.presenceStatus = (ImageView)view.findViewById(R.id.presenceStatus);
        this.txtPresenceStatus = (TextView)view.findViewById(R.id.txtPresenceStatus);
        this.mChkOpenFingerprint = (CheckedTextView)view.findViewById(R.id.chkOpenFingerprint);
        this.mOptionFingerprint.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        if (PTApp.getInstance().isChangeNamepicEnabled()) {
            this.mOptionProfilePhoto.setOnClickListener((View.OnClickListener)this);
            this.mOptionDisplayName.setOnClickListener((View.OnClickListener)this);
        } else {
            this.mDisplayNameArrow.setVisibility(8);
            this.mAvatarArrow.setVisibility(8);
        }
        this.mBtnSignout.setOnClickListener((View.OnClickListener)this);
        this.mBtnPMI.setOnClickListener((View.OnClickListener)this);
        this.mBtnPassword.setOnClickListener((View.OnClickListener)this);
        this.mBtnCallinCountry.setOnClickListener((View.OnClickListener)this);
        this.mBtnMeetingRoomName.setOnClickListener((View.OnClickListener)this);
        this.mPanelCustomStatus.setOnClickListener((View.OnClickListener)this);
        this.mOptionPresenceStatus.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState != null) {
            String captureUri;
            String imageUri = savedInstanceState.getString("mImageUri");
            if (imageUri != null) {
                this.mImageUri = Uri.parse((String)imageUri);
            }
            if ((captureUri = savedInstanceState.getString("mCaptureUri")) != null) {
                this.mCaptureUri = Uri.parse((String)captureUri);
            }
            this.mAvatarToUploadOnSignedOn = savedInstanceState.getString("mAvatarToUploadOnSignedOn");
        }
        PTUI.getInstance().addPTUIListener(this);
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelCustomStatus.setVisibility(8);
            this.mTxtCustomSatusDes.setVisibility(8);
        }
        this.mSelectedCountryId = PreferenceUtil.readStringValue("callin.selected_country_id", null);
        return view;
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerListener);
        PTUI.getInstance().removeMeetingMgrListener(this.mMeetingMgrListener);
    }

    public void onResume() {
        super.onResume();
        this.updateEnableFingerprintOption();
        int loginType = this.getLoginType();
        if (loginType == 97 || loginType == 102) {
            this.dismiss();
            return;
        }
        if (this.mMeetingMgrListener == null) {
            this.mMeetingMgrListener = new PTUI.SimpleMeetingMgrListener(){

                @Override
                public void onListMeetingResult(int result) {
                    MyProfileFragment.this.updatePMI();
                }
            };
        }
        PTUI.getInstance().addMeetingMgrListener(this.mMeetingMgrListener);
        if (this.mZoomMessengerListener == null) {
            this.mZoomMessengerListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void Indicate_VCardInfoReady(String jid) {
                    MyProfileFragment.this.Indicate_VCardInfoReady(jid);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerListener);
        this.updateUI();
    }

    public void onStart() {
        super.onStart();
        NotificationSettingUI.getInstance().addListener(this.mListener);
    }

    public void onStop() {
        NotificationSettingUI.getInstance().removeListener(this.mListener);
        super.onStop();
    }

    private void Indicate_VCardInfoReady(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null || !StringUtil.isSameString((String)jid, (String)myself.getJid())) {
            return;
        }
        this.updateCustomMessage();
    }

    public void updateUI() {
        this.updateDisplayName();
        this.updateAvatar();
        this.updatePMI();
        this.updateEnableAddrBook();
        this.updateVanityURL();
        this.updateCallinCountry();
        this.updateCustomMessage();
        this.updatePresence();
    }

    private void updatePresence() {
        int presence = this.getPresence();
        this.updatePresence(presence);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.getNonNullEventTaskManagerOrThrowException().pushLater("MyProfileFragment", new EventAction("MyProfileFragmentPermissionResult"){

            public void run(IUIElement ui) {
                ((MyProfileFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        if (requestCode == 106 && this.checkCameraAndExternalSoragePermission()) {
            this.takePhoto();
        } else if (requestCode == 107 && this.checkExternalSoragePermission()) {
            this.doChoosePhoteGromGallery();
        }
    }

    private boolean checkExternalSoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private boolean checkCameraAndExternalSoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.CAMERA") == 0 && this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void onSelectCamera() {
        if (this.checkCameraAndExternalSoragePermission()) {
            this.takePhoto();
        } else {
            ArrayList<String> list = new ArrayList<String>();
            if (this.checkSelfPermission("android.permission.CAMERA") != 0) {
                list.add("android.permission.CAMERA");
            }
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                list.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            String[] permissions = list.toArray(new String[list.size()]);
            this.zm_requestPermissions(permissions, 106);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
    }

    private int getLoginType() {
        PTAppProtos.ZoomAccount account;
        int loginType = PTApp.getInstance().getPTLoginType();
        if (loginType == 100 && (account = PTApp.getInstance().getSavedZoomAccount()) == null) {
            loginType = 102;
        }
        return loginType;
    }

    @Override
    public void onPTAppEvent(int event, final long result) {
        if (event == 47) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("PT_EVENT_ON_UPDATE_PROFILE"){

                public void run(IUIElement ui) {
                    MyProfileFragment f = (MyProfileFragment)ui;
                    if (f != null) {
                        f.handleOnUpdateProfile(result);
                    }
                }
            });
        } else if (event == 46) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("PT_EVENT_ON_UPLOAD_PICTURE"){

                public void run(IUIElement ui) {
                    MyProfileFragment f = (MyProfileFragment)ui;
                    if (f != null) {
                        f.handleOnUploadPicture(result);
                    }
                }
            });
        } else if (event == 9 || event == 12) {
            if (this.isResumed()) {
                this.updateDisplayName();
                this.updateAvatar();
            }
        } else if (event == 1 && this.isResumed()) {
            this.dismiss();
        }
    }

    private void handleOnUpdateProfile(long result) {
        this.dismissWaitingDialog();
        if (result == 0L) {
            this.updateDisplayName();
        } else {
            this.showChangeUserNameFailureMessage();
        }
    }

    private void handleOnUploadPicture(long result) {
        this.dismissWaitingDialog();
        if (result == 0L) {
            this.updateAvatar();
        } else {
            this.showUploadProfilePhotoFailureMessage();
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            if (this.mImageUri != null) {
                outState.putString("mImageUri", this.mImageUri.toString());
            }
            if (this.mCaptureUri != null) {
                outState.putString("mCaptureUri", this.mCaptureUri.toString());
            }
            outState.putString("mAvatarToUploadOnSignedOn", this.mAvatarToUploadOnSignedOn);
        }
    }

    private void updateDisplayName() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String name = PTApp.getInstance().getMyName();
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = context.getString(R.string.zm_mm_lbl_not_set);
        }
        this.mTxtDisplayName.setText((CharSequence)name);
    }

    private void updateAvatar() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String avatar = null;
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            avatar = profile.getPictureLocalPath();
        }
        if (!StringUtil.isEmptyOrNull(avatar) && !ImageUtil.isValidImageFile(avatar)) {
            File file = new File(avatar);
            if (file.exists()) {
                file.delete();
            }
            avatar = null;
        }
        this.mAvatarView.setAvatar(avatar);
        this.mAvatarView.setBgColorSeedString(this.getMyJid());
        this.mAvatarView.setName(PTApp.getInstance().getMyName());
    }

    private String getMyJid() {
        ZoomBuddy buddy;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (buddy = messenger.getMyself()) != null) {
            return buddy.getJid();
        }
        return null;
    }

    private void updateCustomMessage() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String text = myself.getSignature();
        if (text != null) {
            text = text.trim();
        }
        if (StringUtil.isEmptyOrNull((String)text)) {
            this.mTxtCustomStatus.setText(R.string.zm_hintl_not_set);
        } else {
            this.mTxtCustomStatus.setText((CharSequence)text);
        }
    }

    private void updatePMI() {
        int loginType = this.getLoginType();
        switch (loginType) {
            case 0: 
            case 2: 
            case 100: 
            case 101: {
                this.mBtnPMI.setVisibility(0);
                break;
            }
            default: {
                this.mBtnPMI.setVisibility(8);
                return;
            }
        }
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            this.mTxtPersonalMeetingId.setText((CharSequence)"");
            return;
        }
        MeetingInfo meetingInfo = meetingHelper.getPmiMeetingItem();
        if (meetingInfo == null) {
            this.mTxtPersonalMeetingId.setText((CharSequence)"");
            return;
        }
        this.mTxtPersonalMeetingId.setText((CharSequence)StringUtil.formatConfNumber((long)meetingInfo.getMeetingNumber()));
    }

    private void updateEnableFingerprintOption() {
        this.mOptionFingerprint.setVisibility(this.mFingerprintUtil != null && this.mFingerprintUtil.isSupportFingerprint() ? 0 : 8);
        FingerprintOption fingerprintOption = FingerprintOption.readFromPreference();
        this.mChkOpenFingerprint.setChecked(fingerprintOption != null && fingerprintOption.ismEnableFingerprint());
    }

    private void updateEnableAddrBook() {
        if (this.mTxtPhoneNumber != null) {
            String phoneNumber = PTApp.getInstance().getRegisteredPhoneNumber();
            if (StringUtil.isEmptyOrNull((String)phoneNumber)) {
                this.mTxtPhoneNumber.setText(R.string.zm_lbl_not_registered);
            } else {
                this.mTxtPhoneNumber.setText((CharSequence)phoneNumber);
            }
        }
    }

    private void updateVanityURL() {
        if (this.mTxtMeetingRoomName == null) {
            return;
        }
        boolean enable = PTApp.getInstance().isPremiumFeatureEnabled();
        if (enable) {
            this.mBtnMeetingRoomName.setVisibility(0);
            this.mTxtMeetingRoomName.setText((CharSequence)this.getVanityURLMeetingName());
        } else {
            this.mBtnMeetingRoomName.setVisibility(8);
        }
    }

    private void updateCallinCountry() {
        String name;
        if (this.mTxtCallinCountry == null) {
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        PTAppProtos.CountryCodelistProto proto = profile.getCallinCountryCodes();
        if (proto == null) {
            return;
        }
        String defaultCountryID = "";
        defaultCountryID = profile.getDefaultCallinTollCountry();
        if (StringUtil.isEmptyOrNull((String)defaultCountryID)) {
            this.mTxtCallinCountry.setText((CharSequence)this.getString(R.string.zm_lbl_callin_country_not_set));
            return;
        }
        PTAppProtos.CountryCodePT countryCode = null;
        List<PTAppProtos.CountryCodePT> lists = proto.getCallinCountryCodesList();
        if (lists != null) {
            for (PTAppProtos.CountryCodePT item : lists) {
                if (!defaultCountryID.equals(item.getId())) continue;
                countryCode = item;
                break;
            }
        }
        if (countryCode == null) {
            name = new Locale("", defaultCountryID).getDisplayCountry();
        } else {
            name = new Locale("", countryCode.getId()).getDisplayCountry();
            String code = countryCode.getCode();
            if (!StringUtil.isEmptyOrNull((String)code)) {
                name = name + "(" + code + ")";
            }
        }
        this.mTxtCallinCountry.setText((CharSequence)name);
    }

    private String getVanityURLMeetingName() {
        String vanityURL = null;
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            vanityURL = profile.getPMIVanityURL();
        }
        if (StringUtil.isEmptyOrNull(vanityURL)) {
            return "";
        }
        if (vanityURL.endsWith("/")) {
            return "";
        }
        int start = vanityURL.lastIndexOf(47);
        String name = vanityURL.substring(start + 1);
        return name;
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mOptionProfilePhoto) {
            this.onClickOptProfilePhoto();
        } else if (v == this.mOptionDisplayName) {
            this.onClickOptDisplayName();
        } else if (v == this.mOptionPresenceStatus) {
            this.onClickOptPresenceStatus();
        } else if (v == this.mBtnSignout) {
            this.onClickBtnSignout();
        } else if (v == this.mBtnPMI) {
            this.onClickBtnPMI();
        } else if (v == this.mBtnPassword) {
            this.onClickBtnPassword();
        } else if (v == this.mBtnMeetingRoomName) {
            this.onClickVanityURL();
        } else if (v == this.mBtnCallinCountry) {
            this.onClickCallinCountry();
        } else if (v == this.mPanelCustomStatus) {
            this.onClickPanelCustomStatus();
        } else if (v == this.mOptionFingerprint) {
            this.onClickFingerprint();
        }
    }

    private void updateTxtPresenceStatus() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        long[] snoozeSettings = mgr.getSnoozeSettings();
        if (snoozeSettings != null) {
            if (snoozeSettings[2] > CmmTime.getMMNow()) {
                String start = TimeUtil.formatTime((Context)this.getActivity(), (long)snoozeSettings[1]);
                String end = TimeUtil.formatTime((Context)this.getActivity(), (long)snoozeSettings[2]);
                this.txtPresenceStatus.setText((CharSequence)this.getString(R.string.zm_lbl_notification_dnd_19898, new Object[]{start, end}));
            } else {
                this.txtPresenceStatus.setText((CharSequence)"");
            }
        }
    }

    public void updatePresence(int presence) {
        this.updateTxtPresenceStatus();
        switch (presence) {
            case 3: {
                this.presenceStatus.setImageResource(R.drawable.zm_status_available);
                this.presenceStatus.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_mm_presence_available));
                break;
            }
            case 2: {
                this.presenceStatus.setImageResource(R.drawable.zm_status_idle);
                this.presenceStatus.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                break;
            }
            case 4: {
                this.presenceStatus.setImageResource(R.drawable.zm_status_dnd);
                this.presenceStatus.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                break;
            }
            case 1: {
                this.presenceStatus.setImageResource(R.drawable.zm_away);
                this.presenceStatus.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_mm_presence_away_40739));
                break;
            }
            default: {
                this.presenceStatus.setImageResource(R.drawable.zm_offline);
                this.presenceStatus.setContentDescription((CharSequence)this.getResources().getString(R.string.zm_description_mm_presence_offline));
            }
        }
    }

    public int getPresence() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return 0;
        }
        return messenger.getMyPresence();
    }

    private void onClickPanelCustomStatus() {
        CustomStatusFragment.showAsActivity((Fragment)this, 0);
    }

    private void onClickFingerprint() {
        FingerprintOption fingerprintOption = FingerprintOption.readFromPreference();
        if (!this.mChkOpenFingerprint.isChecked()) {
            if (fingerprintOption == null || StringUtil.isEmptyOrNull((String)fingerprintOption.getmUserName()) && StringUtil.isEmptyOrNull((String)fingerprintOption.getmPassword())) {
                DialogUtils.showAlertDialog((ZMActivity)this.getActivity(), R.string.zm_title_confirm_logout_enable_fingerprint_22438, R.string.zm_btn_ok, R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        FingerprintOption fingerprintOption = new FingerprintOption();
                        fingerprintOption.setmEnableFingerprint(true);
                        fingerprintOption.savePreference();
                        MyProfileFragment.this.signOut();
                    }
                });
            } else {
                fingerprintOption.setmEnableFingerprint(true);
                fingerprintOption.savePreference();
                this.mChkOpenFingerprint.setChecked(true);
            }
        } else if (fingerprintOption != null) {
            fingerprintOption.setmEnableFingerprint(false);
            fingerprintOption.savePreference();
            this.mChkOpenFingerprint.setChecked(false);
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void onClickOptProfilePhoto() {
        if (AndroidAppUtil.hasCameraApp((Context)this.getActivity())) {
            FragmentManager fm = this.getFragmentManager();
            if (fm == null) {
                return;
            }
            GetPhotoMenuFragment.show(fm);
        } else {
            this.choosePhoto();
        }
    }

    private void doChoosePhoteGromGallery() {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        try {
            this.startActivityForResult(intent, 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void choosePhoto() {
        if (this.checkExternalSoragePermission()) {
            this.doChoosePhoteGromGallery();
        } else {
            ArrayList<String> list = new ArrayList<String>();
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                list.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            String[] permissions = list.toArray(new String[list.size()]);
            this.zm_requestPermissions(permissions, 107);
        }
    }

    public void takePhoto() {
        Uri uri;
        String path = ImageUtil.getNewFilePathForTakingPhoto();
        if (path == null) {
            return;
        }
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.mCaptureUri = Uri.parse((String)("file://" + path));
        if (OsUtil.isAtLeastN()) {
            uri = FileProvider.getUriForFile((Context)this.getActivity(), (String)"us.zoom.videomeetings.fileprovider", (File)new File(path));
            intent.addFlags(3);
        } else {
            uri = this.mCaptureUri;
        }
        intent.putExtra("output", (Parcelable)uri);
        try {
            this.startActivityForResult(intent, 101);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cropImageUri(Uri uri, Uri uriOutput, int outputX, int outputY) {
        if (uri == null) {
            return;
        }
        try {
            Intent intent = new Intent("com.android.camera.action.CROP");
            if (OsUtil.isAtLeastN() && !DocumentsContract.isDocumentUri((Context)this.getActivity(), (Uri)uri)) {
                File tmp = new File(uri.getPath());
                uri = FileProvider.getUriForFile((Context)this.getActivity(), (String)"us.zoom.videomeetings.fileprovider", (File)tmp);
                intent.addFlags(3);
            }
            intent.setDataAndType(uri, "image/*");
            intent.putExtra("crop", "true");
            intent.putExtra("aspectX", 1);
            intent.putExtra("aspectY", 1);
            intent.putExtra("outputX", outputX);
            intent.putExtra("outputY", outputY);
            intent.putExtra("scale", true);
            intent.putExtra("output", (Parcelable)uriOutput);
            intent.putExtra("return-data", false);
            intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
            intent.putExtra("noFaceDetection", true);
            this.startActivityForResult(intent, 102);
        }
        catch (Exception e) {
            try {
                boolean res = ImageUtil.translateImageAsSmallJpeg((Context)this.getActivity(), uri, 400, true, uriOutput.getPath());
                Intent resIntent = new Intent();
                this.onActivityResult(102, res ? -1 : 0, resIntent);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 101: {
                    if (this.mCaptureUri == null) break;
                    AndroidAppUtil.addImageToGallery((Context)this.getActivity(), (String)this.mCaptureUri.getPath());
                    String path = "file://" + AppUtil.getTempPath() + "/my-avatar.jpg";
                    this.mImageUri = Uri.parse((String)path);
                    this.cropImageUri(this.mCaptureUri, this.mImageUri, 400, 400);
                    break;
                }
                case 102: {
                    if (this.mImageUri == null) break;
                    this.onSelectedPhoto(this.mImageUri);
                    break;
                }
                case 100: {
                    if (data == null) {
                        return;
                    }
                    String path = "file://" + AppUtil.getTempPath() + "/my-avatar.jpg";
                    this.mImageUri = Uri.parse((String)path);
                    Uri uri = data.getData();
                    path = ImageUtil.getPathFromUri((Context)this.getActivity(), uri);
                    if (!StringUtil.isEmptyOrNull((String)path)) {
                        path = "file://" + path;
                        uri = Uri.parse((String)path);
                    }
                    if (uri == null) break;
                    this.cropImageUri(uri, this.mImageUri, 400, 400);
                    break;
                }
                case 103: {
                    break;
                }
                case 104: {
                    SelectCallInCountryFragment.CallInNumberItem number = (SelectCallInCountryFragment.CallInNumberItem)data.getSerializableExtra("phoneNumber");
                    if (number == null) break;
                    this.mSelectedCountryId = number.countryId;
                    PreferenceUtil.saveStringValue("callin.selected_country_id", this.mSelectedCountryId);
                    this.updateUI();
                }
            }
        }
    }

    private void onSelectedPhoto(Uri uri) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String filePath = ImageUtil.getPathFromUri((Context)context, uri);
        if (filePath == null) {
            return;
        }
        this.onSelectedPhoto(filePath);
    }

    public void onSelectedPhoto(String filePath) {
        if (!PTApp.getInstance().isWebSignedOn()) {
            if (!PTApp.getInstance().isAuthenticating()) {
                return;
            }
            this.uploadAvatarOnSignedOn(filePath);
            return;
        }
        this.uploadAvatar(filePath);
    }

    private void uploadAvatar(String filePath) {
        if (filePath != null) {
            boolean res;
            if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
                this.showConnectionError();
                return;
            }
            File file = new File(filePath);
            if (file.length() > 51200L) {
                String srcFile = filePath + ".bak";
                File fTmp = new File(srcFile);
                if (fTmp.exists()) {
                    fTmp.delete();
                }
                if (file.renameTo(new File(srcFile))) {
                    String destFile = filePath;
                    if (ImageUtil.compressImageFile(srcFile, destFile, 60)) {
                        File oldFile = new File(srcFile);
                        oldFile.delete();
                    } else {
                        File oldFile = new File(srcFile);
                        oldFile.renameTo(new File(filePath));
                    }
                }
            }
            if (res = PTApp.getInstance().user_UploadMyPicture(filePath)) {
                this.showWaitingDialog();
            } else {
                this.showUploadProfilePhotoFailureMessage();
            }
        }
    }

    private void uploadAvatarOnSignedOn(String filePath) {
        this.mAvatarToUploadOnSignedOn = filePath;
        this.showWaitingDialog();
    }

    private void onClickOptDisplayName() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        String firstName = "";
        String lastName = "";
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            firstName = profile.getFirstName();
            lastName = profile.getLastName();
        }
        SetNameDialog.showSetNameDialog(fm, firstName, lastName);
    }

    private void onClickOptPresenceStatus() {
        PresenceStatusFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnPMI() {
        if (!PTApp.getInstance().isPaidUser()) {
            this.showMessageOnlyPaidUserCanModifyId();
            return;
        }
        if (this.mTxtPersonalMeetingId.getText().length() == 0) {
            return;
        }
        SimpleActivity.show((Fragment)this, PMIModifyIDFragment.class.getName(), null, 0, false);
    }

    private void onClickBtnPassword() {
        PasswordEditFragment.showAsActivity((Fragment)this);
    }

    private void onClickVanityURL() {
        String name = "";
        if (this.mTxtMeetingRoomName != null) {
            name = this.mTxtMeetingRoomName.getText().toString();
        }
        VanityURLModifyFragment.showAsActivity((Fragment)this, name);
    }

    private void onClickCallinCountry() {
        ChangeCallInCountryFragment.showAsActivity((Fragment)this, 104);
    }

    private void onClickBtnSignout() {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(R.string.zm_alert_logout).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MyProfileFragment.this.signOut();
            }
        }).create();
        dialog.show();
    }

    private void signOut() {
        LogoutHandler.getInstance().startLogout();
        this.showWaitingDialog(false);
    }

    private void showMessageOnlyPaidUserCanModifyId() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_msg_only_paid_user_can_modify_pmi).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    private void setDisplayName(String firstName, String lastName) {
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        boolean res = PTApp.getInstance().user_UpdateMyName(firstName, lastName);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showChangeUserNameFailureMessage();
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)0).show();
    }

    private void showWaitingDialog() {
        this.showWaitingDialog(true);
    }

    private void showWaitingDialog(boolean cancelable) {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(cancelable);
        waitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    private void showChangeUserNameFailureMessage() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_mm_msg_change_user_name_failed, (int)0).show();
    }

    private void showUploadProfilePhotoFailureMessage() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_mm_msg_upload_profile_photo_failed, (int)0).show();
    }

    public void onWebLogin() {
        this.updateUI();
        if (this.mAvatarToUploadOnSignedOn != null) {
            this.dismissWaitingDialog();
            this.uploadAvatar(this.mAvatarToUploadOnSignedOn);
        }
    }

    public static class FingerprintOption
    implements Parcelable {
        private static final String KEY = "FingerprintOption";
        private boolean mEnableFingerprint;
        private String mUserName;
        private String mPassword;
        public static final Parcelable.Creator<FingerprintOption> CREATOR = new Parcelable.Creator<FingerprintOption>(){

            public FingerprintOption createFromParcel(Parcel source) {
                return new FingerprintOption(source);
            }

            public FingerprintOption[] newArray(int size) {
                return new FingerprintOption[size];
            }
        };

        public boolean ismEnableFingerprint() {
            return this.mEnableFingerprint;
        }

        public String getmUserName() {
            return this.mUserName;
        }

        public String getmPassword() {
            return this.mPassword;
        }

        public void setmEnableFingerprint(boolean mEnableFingerprint) {
            this.mEnableFingerprint = mEnableFingerprint;
        }

        public void setmUserName(String mUserName) {
            this.mUserName = mUserName;
        }

        public void setmPassword(String mPassword) {
            this.mPassword = mPassword;
        }

        public boolean isEnableFingerprintWithUserInfo() {
            return this.mEnableFingerprint && !StringUtil.isEmptyOrNull((String)this.mUserName) && !StringUtil.isEmptyOrNull((String)this.mPassword);
        }

        public boolean isDisableFingerprintWithUserInfo() {
            return !this.mEnableFingerprint && !StringUtil.isEmptyOrNull((String)this.mUserName) && !StringUtil.isEmptyOrNull((String)this.mPassword);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte(this.mEnableFingerprint ? (byte)1 : 0);
            dest.writeString(this.mUserName);
            dest.writeString(this.mPassword);
        }

        public FingerprintOption() {
        }

        public void savePreference() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("FingerprintOptionmUserName", this.mUserName);
            values.put("FingerprintOptionmPassword", this.mPassword);
            values.put("FingerprintOptionmEnableFingerprint", String.valueOf(this.mEnableFingerprint));
            PreferenceUtil.saveMapStringValues(values);
        }

        public static FingerprintOption readFromPreference() {
            HashSet<String> keys = new HashSet<String>();
            keys.add("FingerprintOptionmUserName");
            keys.add("FingerprintOptionmPassword");
            keys.add("FingerprintOptionmEnableFingerprint");
            HashMap<String, String> values = PreferenceUtil.readMapStringValues(keys, null);
            if (values != null) {
                FingerprintOption fingerprintOption = new FingerprintOption();
                String enableFingerprint = values.get("FingerprintOptionmEnableFingerprint");
                fingerprintOption.mEnableFingerprint = StringUtil.isEmptyOrNull((String)enableFingerprint) ? false : Boolean.parseBoolean(enableFingerprint);
                fingerprintOption.mUserName = values.get("FingerprintOptionmUserName");
                fingerprintOption.mPassword = values.get("FingerprintOptionmPassword");
                return fingerprintOption;
            }
            return null;
        }

        protected FingerprintOption(Parcel in) {
            this.mEnableFingerprint = in.readByte() != 0;
            this.mUserName = in.readString();
            this.mPassword = in.readString();
        }
    }

    public static class SetNameDialog
    extends ZMDialogFragment
    implements TextWatcher,
    TextView.OnEditorActionListener {
        private static final String ARG_FIRST_NAME = "firstName";
        private static final String ARG_LAST_NAME = "lastName";
        private EditText mEdtFirstName = null;
        private EditText mEdtLastName = null;
        private Button mBtnOK = null;

        public static void showSetNameDialog(FragmentManager fm, String defFirstName, String defLastName) {
            SetNameDialog dialog = new SetNameDialog();
            Bundle args = new Bundle();
            args.putString(ARG_FIRST_NAME, defFirstName);
            args.putString(ARG_LAST_NAME, defLastName);
            dialog.setArguments(args);
            dialog.show(fm, SetNameDialog.class.getName());
        }

        public SetNameDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            String firstName = "";
            String lastName = "";
            Bundle args = this.getArguments();
            if (args != null) {
                firstName = args.getString(ARG_FIRST_NAME);
                lastName = args.getString(ARG_LAST_NAME);
            }
            View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_set_name, null, false);
            this.mEdtFirstName = (EditText)view.findViewById(R.id.edtFirstName);
            this.mEdtLastName = (EditText)view.findViewById(R.id.edtLastName);
            if (firstName != null) {
                this.mEdtFirstName.setText((CharSequence)firstName);
            }
            if (lastName != null) {
                this.mEdtLastName.setText((CharSequence)lastName);
            }
            this.mEdtLastName.setImeOptions(2);
            this.mEdtLastName.setOnEditorActionListener((TextView.OnEditorActionListener)this);
            this.mEdtFirstName.addTextChangedListener((TextWatcher)this);
            this.mEdtLastName.addTextChangedListener((TextWatcher)this);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            return dialog;
        }

        public void onResume() {
            super.onResume();
            this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
            this.mBtnOK.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!SetNameDialog.this.checkInput()) {
                        return;
                    }
                    SetNameDialog.this.onClickBtnOK();
                }
            });
            this.updateButtons();
        }

        public void onCancel(DialogInterface dialog) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
        }

        private void onClickBtnOK() {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
            String firstName = this.mEdtFirstName.getText().toString().trim();
            String lastName = this.mEdtLastName.getText().toString().trim();
            if (firstName.length() == 0) {
                this.mEdtFirstName.requestFocus();
                return;
            }
            if (lastName.length() == 0) {
                this.mEdtLastName.requestFocus();
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            MyProfileFragment f = MyProfileFragment.findMyProfileFragment(fm);
            if (f == null) {
                return;
            }
            f.setDisplayName(firstName, lastName);
            this.dismissAllowingStateLoss();
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            this.updateButtons();
        }

        private void updateButtons() {
            if (this.mBtnOK != null) {
                this.mBtnOK.setEnabled(this.checkInput());
            }
        }

        private boolean checkInput() {
            String firstName = this.mEdtFirstName.getText().toString().trim();
            String lastName = this.mEdtLastName.getText().toString().trim();
            return !StringUtil.isEmptyOrNull((String)firstName) && !StringUtil.isEmptyOrNull((String)lastName);
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            switch (actionId) {
                case 2: {
                    this.onClickBtnOK();
                    return true;
                }
            }
            return false;
        }
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        public ContextMenuItem(String label, int id2) {
            super(id2, label);
        }
    }

    public static class GetPhotoMenuFragment
    extends ZMDialogFragment {
        private static final int ACTION_TAKE_PHOTO = 0;
        private static final int ACTION_CHOOSE_PHOTO = 1;
        private ZMMenuAdapter<ContextMenuItem> mAdapter;

        public static void show(@NonNull FragmentManager fm) {
            Bundle args = new Bundle();
            GetPhotoMenuFragment f = new GetPhotoMenuFragment();
            f.setArguments(args);
            f.show(fm, GetPhotoMenuFragment.class.getName());
        }

        public GetPhotoMenuFragment() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            FragmentActivity activity = this.getActivity();
            this.mAdapter = this.createUpdateAdapter((Context)activity);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_title_change_profile_photo).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    GetPhotoMenuFragment.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMMenuAdapter<ContextMenuItem> createUpdateAdapter(Context context) {
            ContextMenuItem[] items = new ContextMenuItem[]{new ContextMenuItem(context.getString(R.string.zm_lbl_take_photo), 0), new ContextMenuItem(context.getString(R.string.zm_lbl_choose_photo), 1)};
            if (this.mAdapter == null) {
                this.mAdapter = new ZMMenuAdapter((Context)((ZMActivity)this.getActivity()), false);
            } else {
                this.mAdapter.clear();
            }
            this.mAdapter.addAll((IZMMenuItem[])items);
            return this.mAdapter;
        }

        private void onSelectItem(int which) {
            ContextMenuItem menuItem = (ContextMenuItem)((Object)this.mAdapter.getItem(which));
            if (menuItem == null) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            MyProfileFragment f = MyProfileFragment.findMyProfileFragment(fm);
            if (f == null) {
                return;
            }
            switch (menuItem.getAction()) {
                case 0: {
                    f.onSelectCamera();
                    break;
                }
                case 1: {
                    f.choosePhoto();
                }
            }
        }
    }
}

