/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.cmmlib.AppContext;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.SelectCallInNumberFragment;
import com.zipow.videobox.ptapp.CountryCode;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZMWebUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class MeetingRunningInfoFragment
extends ZMTipFragment
implements View.OnClickListener {
    public static final int REQUEST_SELECT_CALLIN_NUMBER = 100;
    public static final String ARG_ANCHOR_ID = "anchorId";
    public static final String ARG_DISPLAY_FLAG = "displayFlag";
    public static final int FLAG_SHOW_ALL = 255;
    public static final int FLAG_SHOW_BASIC_INFO = 1;
    public static final int FLAG_SHOW_TELE_INFO = 2;
    public static final int FLAG_SHOW_H323_INFO = 4;
    private int mAnchorId = 0;
    private View mPanelMeetingTopic;
    private View mPanelMeetingId;
    private TextView mTxtMeetingTopic;
    private TextView mTxtMeetingId;
    private View mPanelBasicInfo;
    private View mPanelTeleConfInfo;
    private View mPanelH323Info;
    private ViewGroup mPanelCallinNumbers;
    private ViewGroup mPanelTollFreeNumbers;
    private TextView mTxtAccessCode;
    private TextView mTxtAttendeeId;
    private TextView mTxtOtherNumbers;
    private TextView mTxtH323Info;
    private TextView mTxtH323MeetingId;
    private ImageView mImgCountryFlag;
    private ImageView mImgNextArrow;
    private View mPanelTollFree;
    private View mPanelH323MeetingPassword;
    private TextView mTxtH323MeetingPassword;
    private Button mBtnBack;
    private boolean mShowBasicInfo = true;
    private boolean mShowTeleInfo = true;
    private boolean mShowH323Info = true;
    private String mSelectedCountryId = null;
    private String mSelectedNumber = null;

    public static void showInActivity(ZMActivity activity, int displayFlag) {
        MeetingRunningInfoFragment f = new MeetingRunningInfoFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_DISPLAY_FLAG, displayFlag);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, MeetingRunningInfoFragment.class.getName()).commit();
    }

    public static void show(FragmentManager fm, int anchorId, int displayFlag) {
        MeetingRunningInfoFragment f = MeetingRunningInfoFragment.getMeetingRunningInfoFragment(fm);
        if (f == null) {
            f = new MeetingRunningInfoFragment();
            Bundle args = new Bundle();
            args.putInt(ARG_ANCHOR_ID, anchorId);
            args.putInt(ARG_DISPLAY_FLAG, displayFlag);
            f.setArguments(args);
            f.show(fm, MeetingRunningInfoFragment.class.getName());
        } else {
            f.setTipVisible(true);
        }
    }

    public static MeetingRunningInfoFragment getMeetingRunningInfoFragment(FragmentManager fm) {
        return (MeetingRunningInfoFragment)fm.findFragmentByTag(MeetingRunningInfoFragment.class.getName());
    }

    public static boolean hide(FragmentManager fm) {
        MeetingRunningInfoFragment f = MeetingRunningInfoFragment.getMeetingRunningInfoFragment(fm);
        if (f != null) {
            if (!f.getShowsTip()) {
                f.dismiss();
                return true;
            }
            if (f.isTipVisible()) {
                f.setTipVisible(false);
                return true;
            }
        }
        return false;
    }

    public static boolean dismiss(FragmentManager fm) {
        MeetingRunningInfoFragment f = MeetingRunningInfoFragment.getMeetingRunningInfoFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        this.refresh();
    }

    public void refresh() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        if (this.mShowBasicInfo) {
            this.mPanelBasicInfo.setVisibility(8);
            MeetingInfo meetingInfo = confContext.getMeetingItem();
            if (meetingInfo == null) {
                return;
            }
            String topic = meetingInfo.getTopic();
            if (StringUtil.isEmptyOrNull((String)topic)) {
                this.mPanelMeetingTopic.setVisibility(8);
            } else {
                this.mPanelMeetingTopic.setVisibility(0);
            }
            this.mTxtMeetingTopic.setText((CharSequence)topic);
            this.mTxtMeetingId.setText((CharSequence)StringUtil.formatConfNumber((long)meetingInfo.getMeetingNumber()));
        } else {
            this.mPanelBasicInfo.setVisibility(8);
        }
        long confNumber = confContext.getConfNumber();
        String accessCode = StringUtil.formatConfNumber((long)confNumber, (char)' ');
        if (this.mShowTeleInfo && this.isTelephonyEnabled()) {
            int flagId;
            String phoneCallInNumber = confContext.getPhoneCallInNumber();
            String countryId = this.mSelectedCountryId;
            if (!StringUtil.isEmptyOrNull((String)this.mSelectedCountryId) && this.isInCallInNumbers(this.mSelectedNumber)) {
                phoneCallInNumber = this.mSelectedNumber;
            } else {
                phoneCallInNumber = confContext.getPhoneCallInNumber();
                if (phoneCallInNumber != null) {
                    String isoCountry = CountryCodeUtil.getIsoCountryCode((Context)activity);
                    String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountry);
                    String formatedNumber = PhoneNumberUtil.formatNumber((String)phoneCallInNumber, (String)phoneCountryCode);
                    String code = PhoneNumberUtil.getCountryCodeFromFormatedPhoneNumber((String)formatedNumber);
                    countryId = CountryCodeUtil.phoneCountryCodeToIsoCountryCode((String)code);
                } else {
                    countryId = "us";
                }
            }
            if (countryId != null) {
                countryId = countryId.toLowerCase(Locale.US);
            }
            if ((flagId = this.getResources().getIdentifier("zm_flag_" + countryId, "drawable", VideoBoxApplication.getInstance().getPackageName())) != 0) {
                this.mImgCountryFlag.setImageResource(flagId);
            }
            String tollFreeNumber = confContext.getTollFreeCallInNumber();
            long attendeeId = myself.getAttendeeID();
            if (StringUtil.isEmptyOrNull((String)phoneCallInNumber) && StringUtil.isEmptyOrNull((String)tollFreeNumber)) {
                this.mPanelTeleConfInfo.setVisibility(8);
            } else {
                this.mPanelTeleConfInfo.setVisibility(0);
                boolean bPSTNNeedConfirm = false;
                MeetingInfo meetingInfo = confContext.getMeetingItem();
                if (meetingInfo != null) {
                    bPSTNNeedConfirm = meetingInfo.getPSTNNeedConfirm1();
                }
                if (StringUtil.isEmptyOrNull((String)phoneCallInNumber)) {
                    this.mPanelCallinNumbers.setVisibility(8);
                } else {
                    this.createNumbersLinks((Activity)activity, this.mPanelCallinNumbers, phoneCallInNumber, confNumber, attendeeId, bPSTNNeedConfirm);
                }
                if (StringUtil.isEmptyOrNull((String)tollFreeNumber)) {
                    this.mPanelTollFree.setVisibility(8);
                } else {
                    this.mPanelTollFree.setVisibility(0);
                    this.createNumbersLinks((Activity)activity, this.mPanelTollFreeNumbers, tollFreeNumber, confNumber, attendeeId, bPSTNNeedConfirm);
                }
                this.mTxtAccessCode.setText((CharSequence)accessCode);
                this.mTxtAttendeeId.setText((CharSequence)String.valueOf(attendeeId));
                if (meetingInfo != null) {
                    ArrayList<CountryCode> countryCodeArrayList = meetingInfo.getCallinCountryCodesList();
                    if (ResourcesUtil.getBoolean((Context)this.getActivity(), (int)R.bool.zm_config_no_global_callin_numbers, (boolean)false) || countryCodeArrayList == null || countryCodeArrayList.size() == 0) {
                        this.mImgCountryFlag.setVisibility(8);
                        this.mImgNextArrow.setVisibility(8);
                    } else {
                        if (flagId != 0) {
                            this.mImgCountryFlag.setVisibility(0);
                        } else {
                            this.mImgCountryFlag.setVisibility(8);
                        }
                        this.mImgNextArrow.setVisibility(0);
                    }
                }
            }
            View.OnClickListener onClickOtherNumberListener = new View.OnClickListener(){

                public void onClick(View v) {
                    MeetingRunningInfoFragment.this.onClickOtherNumbers();
                }
            };
            this.mImgCountryFlag.setOnClickListener(onClickOtherNumberListener);
            this.mImgNextArrow.setOnClickListener(onClickOtherNumberListener);
            if (this.mTxtOtherNumbers != null) {
                this.mTxtOtherNumbers.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MeetingRunningInfoFragment.this.onClickOtherNumbersLink();
                    }
                });
            }
        } else {
            this.mPanelTeleConfInfo.setVisibility(8);
        }
        if (this.mShowH323Info) {
            String h323ConfInfo = confContext.getH323ConfInfo();
            String h323Password = confContext.getH323Password();
            if (StringUtil.isEmptyOrNull((String)h323ConfInfo)) {
                this.mPanelH323Info.setVisibility(8);
            } else {
                this.mPanelH323Info.setVisibility(0);
                String[] items = h323ConfInfo.split(";");
                if (items.length > 1) {
                    StringBuilder builder = new StringBuilder();
                    boolean first = true;
                    for (String item : items) {
                        if (!first) {
                            builder.append("\n");
                        }
                        builder.append(item.trim());
                        first = false;
                    }
                    this.mTxtH323Info.setText((CharSequence)builder.toString());
                } else {
                    this.mTxtH323Info.setText((CharSequence)h323ConfInfo);
                }
                this.mTxtH323MeetingId.setText((CharSequence)accessCode);
                if (StringUtil.isEmptyOrNull((String)h323Password)) {
                    this.mPanelH323MeetingPassword.setVisibility(8);
                } else {
                    this.mPanelH323MeetingPassword.setVisibility(0);
                    this.mTxtH323MeetingPassword.setText((CharSequence)h323Password);
                }
            }
        } else {
            this.mPanelH323Info.setVisibility(8);
        }
    }

    private boolean isInCallInNumbers(String strNumber) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return false;
        }
        ArrayList<CountryCode> numbersList = meetingInfo.getCallinCountryCodesList();
        if (numbersList == null) {
            return false;
        }
        for (CountryCode number : numbersList) {
            if (number == null || !StringUtil.isSameString((String)this.mSelectedNumber, (String)number.getNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean isTelephonyEnabled() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return !meetingItem.getTelephonyOff();
        }
        return true;
    }

    private void createNumbersLinks(Activity activity, ViewGroup parent, String strNumbers, long confNumber, long attendeeId, boolean bPSTNNeedConfirm) {
        strNumbers = strNumbers.trim();
        String[] numbers = strNumbers.split("\\s*;\\s*");
        parent.removeAllViews();
        LayoutInflater inflater = LayoutInflater.from((Context)activity);
        for (String number : numbers) {
            if ((number = number.trim()).length() == 0) continue;
            View view = inflater.inflate(R.layout.zm_callin_number, parent, false);
            TextView txtCallinNumber = (TextView)view.findViewById(R.id.txtCallinNumber);
            this.decorateCallinNumberTextView(activity, txtCallinNumber, number, confNumber, attendeeId, bPSTNNeedConfirm);
            parent.addView(view);
        }
    }

    private void decorateCallinNumberTextView(Activity activity, TextView textView, final String number, long accessCode, long attendeeId, boolean needConfirm) {
        if (ResourcesUtil.getBoolean((Context)activity, (int)R.bool.zm_config_no_auto_dial_in, (boolean)false) || !VoiceEngineCompat.isFeatureTelephonySupported((Context)activity)) {
            textView.setText((CharSequence)number);
            return;
        }
        final String fullNumberStr = this.buildFullCallInNumberString(activity, number, accessCode, attendeeId, needConfirm);
        UIUtil.buildLinkTextView((TextView)textView, (String)number, (View.OnClickListener)new View.OnClickListener(){

            public void onClick(View v) {
                ZMActivity activity = (ZMActivity)MeetingRunningInfoFragment.this.getActivity();
                if (activity == null) {
                    return;
                }
                if (number != null) {
                    PhoneCallConfirmDialog.showPhoneCallConfirmDialog(activity, number, fullNumberStr);
                }
            }
        });
    }

    private String buildFullCallInNumberString(Activity activity, String number, long accessCode, long attendeeId, boolean needConfirm) {
        String formatedNumber = PhoneNumberUtil.formatNumber((String)number, null);
        StringBuilder builder = new StringBuilder();
        builder.append(formatedNumber);
        builder.append(",,,");
        builder.append(accessCode);
        builder.append("#,,");
        if (needConfirm) {
            builder.append("1,");
        }
        builder.append(attendeeId);
        builder.append("#");
        return builder.toString();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isTipVisible", this.isTipVisible());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_meeting_running_info, null);
        this.mPanelMeetingTopic = view.findViewById(R.id.panelMeetingTopic);
        this.mPanelMeetingId = view.findViewById(R.id.panelMeetingId);
        this.mTxtMeetingTopic = (TextView)view.findViewById(R.id.txtMeetingTopic);
        this.mTxtMeetingId = (TextView)view.findViewById(R.id.txtMeetingId);
        this.mPanelBasicInfo = view.findViewById(R.id.panelBasicInfo);
        this.mPanelTeleConfInfo = view.findViewById(R.id.panelTeleConfInfo);
        this.mPanelH323Info = view.findViewById(R.id.panelH323Info);
        this.mPanelCallinNumbers = (ViewGroup)view.findViewById(R.id.panelCallInNumbers);
        this.mPanelTollFreeNumbers = (ViewGroup)view.findViewById(R.id.panelTollFreeNumbers);
        this.mTxtAccessCode = (TextView)view.findViewById(R.id.txtAccessCode);
        this.mTxtAttendeeId = (TextView)view.findViewById(R.id.txtAttendeeId);
        this.mTxtOtherNumbers = (TextView)view.findViewById(R.id.txtOtherNumbers);
        this.mTxtH323Info = (TextView)view.findViewById(R.id.txtH323Info);
        this.mTxtH323MeetingId = (TextView)view.findViewById(R.id.txtH323MeetingId);
        this.mImgCountryFlag = (ImageView)view.findViewById(R.id.imgCountryFlag);
        this.mImgNextArrow = (ImageView)view.findViewById(R.id.imgNextArrow);
        this.mPanelTollFree = view.findViewById(R.id.panelTollFree);
        this.mPanelH323MeetingPassword = view.findViewById(R.id.panelH323MeetingPassword);
        this.mTxtH323MeetingPassword = (TextView)view.findViewById(R.id.txtH323MeetingPassword);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
        Bundle args = this.getArguments();
        if (args != null) {
            int displayFlag = args.getInt(ARG_DISPLAY_FLAG);
            this.mShowBasicInfo = (displayFlag & 1) != 0;
            this.mShowTeleInfo = (displayFlag & 2) != 0;
            boolean bl = this.mShowH323Info = (displayFlag & 4) != 0;
            if (this.mShowBasicInfo) {
                txtTitle.setText(R.string.zm_title_meeting_information);
            } else {
                txtTitle.setText(R.string.zm_btn_dial_in);
            }
        }
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        if (ResourcesUtil.getBoolean((Context)this.getActivity(), (int)R.bool.zm_config_no_global_callin_numbers, (boolean)false)) {
            this.mImgCountryFlag.setVisibility(8);
            this.mImgNextArrow.setVisibility(8);
        }
        if (ResourcesUtil.getBoolean((Context)this.getActivity(), (int)R.bool.zm_config_no_global_callin_link, (boolean)true)) {
            this.mTxtOtherNumbers.setVisibility(8);
        }
        this.mSelectedCountryId = PreferenceUtil.readStringValue("callin.selected_country_id", null);
        this.mSelectedNumber = PreferenceUtil.readStringValue("callin.selected_number", null);
        return view;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        SelectCallInNumberFragment.CallInNumberItem number;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null && (number = (SelectCallInNumberFragment.CallInNumberItem)data.getSerializableExtra("phoneNumber")) != null) {
            this.mSelectedCountryId = number.countryId;
            this.mSelectedNumber = number.phoneNumber;
            if ("us".equalsIgnoreCase(number.countryId)) {
                PreferenceUtil.removeValue("callin.selected_country_id");
                PreferenceUtil.removeValue("callin.selected_number");
            } else {
                PreferenceUtil.saveStringValue("callin.selected_country_id", this.mSelectedCountryId);
                PreferenceUtil.saveStringValue("callin.selected_number", this.mSelectedNumber);
            }
            this.refresh();
        }
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = this.getView();
        if (view == null) {
            return null;
        }
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        Bundle args = this.getArguments();
        this.mAnchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (this.mAnchorId > 0 && (anchor = this.getActivity().findViewById(this.mAnchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode(context) ? 1 : 3);
        }
        if (savedInstanceState != null) {
            boolean visible = savedInstanceState.getBoolean("isTipVisible", true);
            tip.setVisibility(visible ? 0 : 4);
        }
        return tip;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    protected void onClickOtherNumbersLink() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        String url = null;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            url = confContext.getTeleConfURL();
        }
        if (StringUtil.isEmptyOrNull(url)) {
            AppContext appContext = new AppContext("config");
            String webServer = appContext.queryWithKey("conf.webserver", AppContext.APP_NAME_CHAT);
            if (StringUtil.isEmptyOrNull((String)webServer)) {
                webServer = ZMWebUtil.getWebDomainWithHttps();
            }
            url = webServer + "/teleconference";
        }
        UIUtil.openURL((Context)activity, (String)url);
    }

    protected void onClickOtherNumbers() {
        SelectCallInNumberFragment.showAsActivity((Fragment)this, 100);
    }

    public void dismiss() {
        if (this.getShowsTip()) {
            super.dismiss();
        } else {
            this.getActivity().finish();
        }
    }

    private boolean isTipVisible() {
        ZMTip tip = this.getTip();
        if (tip != null) {
            return tip.getVisibility() == 0;
        }
        return false;
    }

    private void setTipVisible(boolean visible) {
        ZMTip tip = this.getTip();
        if (tip != null && tip.getVisibility() == 0 != visible) {
            tip.setVisibility(visible ? 0 : 4);
            if (visible) {
                Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.zm_tip_fadein);
                tip.startAnimation(fadeIn);
            }
        }
    }

    public static class PhoneCallConfirmDialog
    extends ZMDialogFragment {
        private static final String TAG = PhoneCallConfirmDialog.class.getSimpleName();
        private static final String ARG_NUMBER = "number";
        private static final String ARG_DIAL_STRING = "dialString";

        public static void showPhoneCallConfirmDialog(ZMActivity activity, @NonNull String number, @NonNull String dialString) {
            PhoneCallConfirmDialog dlg = new PhoneCallConfirmDialog();
            Bundle args = new Bundle();
            args.putString(ARG_NUMBER, number);
            args.putString(ARG_DIAL_STRING, dialString);
            dlg.setArguments(args);
            dlg.show(activity.getSupportFragmentManager(), PhoneCallConfirmDialog.class.getName());
        }

        public PhoneCallConfirmDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            String number = args.getString(ARG_NUMBER);
            final String dialString = args.getString(ARG_DIAL_STRING);
            String message = this.getString(R.string.zm_alert_dial_into_meeting);
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(number).setMessage(message).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_call, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PhoneCallConfirmDialog.this.callNumber(dialString);
                }
            }).create();
        }

        private void callNumber(String dialString) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Uri uri = Uri.parse((String)("tel:" + URLEncoder.encode(dialString)));
            Intent intent = new Intent("android.intent.action.CALL", uri);
            try {
                activity.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

