/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.ScheduleActivity;
import com.zipow.videobox.fragment.ScheduleFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.util.MeetingInvitationUtil;
import com.zipow.videobox.util.TimeFormatUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.template.Template;
import us.zoom.videomeetings.R;

public class MeetingInfoFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IMeetingMgrListener,
PTUI.IPTUIListener {
    private static final String ARG_MEETING_ITEM = "meetingItem";
    private static final String ARG_PARENT_SCREEN_TITLE = "parentScreenTitle";
    private static final String ARG_AUTO_ADD_INVITEE = "autoAddInvitee";
    private static final int REQUEST_DELETE_MEETING = 3001;
    private static final int REQUEST_ADD_TO_CALENDAR = 3002;
    private Button mBtnBack;
    private Button mBtnStartMeeting;
    private Button mBtnSendInvitation;
    private Button mBtnAddToCalendar;
    private Button mBtnDeleteMeeting;
    private Button mBtnEdit;
    private TextView mTxtTopic;
    private TextView mTxtMeetingId;
    private TextView mTxtDuration;
    private TextView mTxtWhen;
    private TextView mTxtPassword;
    private View mPanelDuration;
    private View mPanelPassword;
    private View mPanelMeetingId;
    private ScheduledMeetingItem mMeetingItem;
    private boolean mHasSendInvitation = false;

    public static void showInActivity(ZMActivity activity, ScheduledMeetingItem mi, int parentScreenTitle, boolean autoAddInvitee) {
        MeetingInfoFragment f = new MeetingInfoFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_MEETING_ITEM, (Serializable)mi);
        args.putInt(ARG_PARENT_SCREEN_TITLE, parentScreenTitle);
        args.putBoolean(ARG_AUTO_ADD_INVITEE, autoAddInvitee);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, MeetingInfoFragment.class.getName()).commit();
    }

    public static void showDialog(FragmentManager fm, ScheduledMeetingItem mi, int parentScreen, boolean autoAddInvitee) {
        if (MeetingInfoFragment.getMeetingInfoFragment(fm) != null) {
            return;
        }
        MeetingInfoFragment f = new MeetingInfoFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_MEETING_ITEM, (Serializable)mi);
        args.putInt(ARG_PARENT_SCREEN_TITLE, parentScreen);
        args.putBoolean(ARG_AUTO_ADD_INVITEE, autoAddInvitee);
        f.setArguments(args);
        f.show(fm, MeetingInfoFragment.class.getName());
    }

    public static MeetingInfoFragment getMeetingInfoFragment(FragmentManager fm) {
        return (MeetingInfoFragment)fm.findFragmentByTag(MeetingInfoFragment.class.getName());
    }

    public MeetingInfoFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_meeting_info, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnStartMeeting = (Button)view.findViewById(R.id.btnStartMeeting);
        this.mBtnSendInvitation = (Button)view.findViewById(R.id.btnSendInvitation);
        this.mBtnAddToCalendar = (Button)view.findViewById(R.id.btnAddToCalendar);
        this.mBtnDeleteMeeting = (Button)view.findViewById(R.id.btnDeleteMeeting);
        this.mBtnEdit = (Button)view.findViewById(R.id.btnEdit);
        this.mTxtTopic = (TextView)view.findViewById(R.id.txtTopic);
        this.mTxtMeetingId = (TextView)view.findViewById(R.id.txtMeetingId);
        this.mTxtDuration = (TextView)view.findViewById(R.id.txtDuration);
        this.mTxtWhen = (TextView)view.findViewById(R.id.txtWhen);
        this.mTxtPassword = (TextView)view.findViewById(R.id.txtPassword);
        this.mPanelDuration = view.findViewById(R.id.panelDuration);
        this.mPanelPassword = view.findViewById(R.id.panelPassword);
        this.mPanelMeetingId = view.findViewById(R.id.panelMeetingId);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnStartMeeting.setOnClickListener((View.OnClickListener)this);
        this.mBtnSendInvitation.setOnClickListener((View.OnClickListener)this);
        this.mBtnAddToCalendar.setOnClickListener((View.OnClickListener)this);
        this.mBtnDeleteMeeting.setOnClickListener((View.OnClickListener)this);
        this.mBtnEdit.setOnClickListener((View.OnClickListener)this);
        this.mBtnAddToCalendar.setVisibility(AndroidAppUtil.hasCalendarApp((Context)this.getActivity()) ? 0 : 8);
        Bundle args = this.getArguments();
        int parentScreenTitle = args.getInt(ARG_PARENT_SCREEN_TITLE);
        if (parentScreenTitle != 0) {
            this.mBtnBack.setText(parentScreenTitle);
        }
        if (savedInstanceState != null) {
            this.mHasSendInvitation = savedInstanceState.getBoolean("mHasSendInvitation", false);
        }
        return view;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnEdit) {
            this.onClickBtnEdit();
        } else if (id2 == R.id.btnStartMeeting) {
            this.onClickBtnStartMeeting();
        } else if (id2 == R.id.btnSendInvitation) {
            this.onClickBtnSendInvitation();
        } else if (id2 == R.id.btnAddToCalendar) {
            this.onClickBtnAddToCalendar();
        } else if (id2 == R.id.btnDeleteMeeting) {
            this.onClickBtnDeleteMeeting();
        }
    }

    private void onClickBtnDeleteMeeting() {
        DeleteMeetingConfirmDialog.showDialog(this.getChildFragmentManager());
    }

    private void onClickBtnSendInvitation() {
        this.sendInvitations(-1);
    }

    private void sendInvitations(int appTypes) {
        String content = MeetingInvitationUtil.buildEmailInvitationContent((Context)this.getActivity(), this.mMeetingItem, true);
        String topic = this.getActivity().getString(R.string.zm_title_meeting_invitation_email_topic, new Object[]{this.mMeetingItem.getTopic()});
        String chooserTitle = this.getActivity().getString(R.string.zm_lbl_add_invitees);
        String stream = null;
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper != null) {
            String[] filePath;
            String calendarContent = MeetingInvitationUtil.buildEmailInvitationContent((Context)this.getActivity(), this.mMeetingItem, true);
            this.mMeetingItem.setInvitationEmailContentWithTime(calendarContent);
            MeetingInfo meetingInfo = this.mMeetingItem.toMeetingInfo();
            AndroidAppUtil.EventRepeatType repeatType = ScheduledMeetingItem.zoomRepeatTypeToNativeRepeatType(this.mMeetingItem.getRepeatType());
            if ((!this.mMeetingItem.isRecurring() || repeatType != AndroidAppUtil.EventRepeatType.NONE) && helper.createIcsFileFromMeeting(meetingInfo, filePath = new String[]{this.getActivity().getString(R.string.zm_meeting_invitation_ics_name)}, TimeZone.getDefault().getID())) {
                stream = "file://" + filePath[0];
            }
        }
        String url = this.mMeetingItem.getJoinMeetingUrl();
        long meetingId = this.mMeetingItem.getMeetingNo();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("joinMeetingUrl", url);
        config.put("meetingId", String.valueOf(meetingId));
        Template template = new Template(this.getString(R.string.zm_msg_sms_invite_scheduled_meeting));
        String smsContent = template.format(config);
        ZMSendMessageFragment.show((Context)this.getActivity(), (FragmentManager)this.getFragmentManager(), null, null, (String)topic, (String)content, (String)smsContent, stream, (String)chooserTitle, (int)appTypes);
    }

    private void onClickBtnAddToCalendar() {
        if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_CALENDAR") == 0) {
            this.handleAddToCalendar();
        } else {
            this.zm_requestPermissions(new String[]{"android.permission.WRITE_CALENDAR"}, 3002);
        }
    }

    private void handleAddToCalendar() {
        if (this.mMeetingItem == null) {
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        String content = MeetingInvitationUtil.buildEmailInvitationContent((Context)this.getActivity(), this.mMeetingItem, false);
        String topic = this.getActivity().getString(R.string.zm_title_meeting_invitation_email_topic, new Object[]{this.mMeetingItem.getTopic()});
        String location = this.mMeetingItem.getJoinMeetingUrl();
        long beginTime = 0L;
        long endTime = 0L;
        beginTime = this.mMeetingItem.getStartTime();
        endTime = beginTime + (long)(this.mMeetingItem.getDuration() * 60000);
        long eventID = -1L;
        long[] eventIDs = AndroidAppUtil.queryCalendarEventsForMeeting((Context)this.getActivity(), (long)this.mMeetingItem.getMeetingNo(), (String)location);
        if (eventIDs != null && eventIDs.length > 0) {
            eventID = eventIDs[0];
        }
        String rrule = null;
        if (this.mMeetingItem.isRecurring()) {
            rrule = AndroidAppUtil.buildCalendarRrule((Date)new Date(beginTime), (AndroidAppUtil.EventRepeatType)ScheduledMeetingItem.zoomRepeatTypeToNativeRepeatType(this.mMeetingItem.getRepeatType()), (Date)new Date(this.mMeetingItem.getRepeatEndTime()));
        }
        if (eventID < 0L) {
            String myEmail = profile.getEmail();
            eventID = AndroidAppUtil.addNewCalendarEvent((Context)this.getActivity(), (String)myEmail, (long)beginTime, (long)endTime, (String)topic, (String)content, (String)location, (String)rrule);
        } else {
            AndroidAppUtil.updateCalendarEvent((Context)this.getActivity(), (long)eventID, (long)beginTime, (long)endTime, (String)topic, (String)content, (String)location, rrule);
        }
        if (eventID >= 0L) {
            AndroidAppUtil.viewCalendarEvent((Context)this.getActivity(), (long)eventID, (long)beginTime, (long)endTime);
        } else {
            AndroidAppUtil.createCalendarEvent((Context)this.getActivity(), (long)beginTime, (long)endTime, (String)topic, (String)content, (String)location);
        }
    }

    private void onClickBtnEdit() {
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            ScheduleFragment.showEditMeetingDialog(this.getFragmentManager(), this.mMeetingItem);
        } else {
            ScheduleActivity.showEditMeeting((ZMActivity)this.getActivity(), 103, this.mMeetingItem);
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final @NonNull String[] permissions, final @NonNull int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("MeetingInfoPermissionResult", new EventAction("MeetingInfoPermissionResult"){

            public void run(IUIElement ui) {
                ((MeetingInfoFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    public void handleRequestPermissionResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.WRITE_CALENDAR".equals(permissions[i]) || grantResults[i] != 0) continue;
            if (requestCode == 3001) {
                this.handleDeleteMeetingResult();
                this.dismiss();
                continue;
            }
            if (requestCode != 3002) continue;
            this.handleAddToCalendar();
        }
    }

    private void onClickBtnStartMeeting() {
        if (this.mMeetingItem == null) {
            return;
        }
        if (this.mMeetingItem.ismIsCanStartMeetingForMySelf()) {
            ConfActivity.startMeeting((ZMActivity)this.getActivity(), this.mMeetingItem.getMeetingNo(), this.mMeetingItem.getId());
        } else {
            ConfActivity.joinByUrl((Context)this.getActivity(), this.mMeetingItem.getJoinMeetingUrl());
        }
    }

    public void deleteThisMeeting() {
        if (this.mMeetingItem == null) {
            return;
        }
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper != null) {
            long delNo = this.mMeetingItem.getMeetingNo();
            long origNo = this.mMeetingItem.getOriginalMeetingNo();
            if (origNo > 0L) {
                delNo = origNo;
            }
            meetingHelper.deleteMeeting(delNo);
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public void onResume() {
        super.onResume();
        this.loadData();
        PTUI.getInstance().addMeetingMgrListener(this);
        PTUI.getInstance().addPTUIListener(this);
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (this.mMeetingItem == null || meetingHelper == null || this.mMeetingItem.ismIsCanStartMeetingForMySelf() && meetingHelper.getMeetingItemByNumber(this.mMeetingItem.getMeetingNo()) == null) {
            this.dismiss();
            return;
        }
        this.updateUIForCallStatus(PTApp.getInstance().getCallStatus());
        Bundle args = this.getArguments();
        boolean autoAddInvitee = args.getBoolean(ARG_AUTO_ADD_INVITEE);
        if (!this.mHasSendInvitation && autoAddInvitee) {
            this.sendInvitations(1);
            this.mHasSendInvitation = true;
        }
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeMeetingMgrListener(this);
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("mHasSendInvitation", this.mHasSendInvitation);
    }

    @Override
    public void onScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
    }

    @Override
    public void onListMeetingResult(int result) {
    }

    @Override
    public void onListCalendarEventsResult(int result) {
    }

    @Override
    public void onUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.updateUIForCallStatus(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public void onDeleteMeetingResult(int result) {
        this.processDeleteMeetingResult(result);
    }

    @Override
    public void onStartFailBeforeLaunch(int result) {
    }

    @Override
    public void onPMIEvent(int event, int result, MeetingInfo item) {
    }

    public void onEditSuccess(ScheduledMeetingItem item) {
        this.mMeetingItem = item;
        Bundle args = this.getArguments();
        args.putSerializable(ARG_MEETING_ITEM, (Serializable)item);
        this.sendInvitations(1);
        this.mHasSendInvitation = true;
        this.loadData();
    }

    private void updateUIForCallStatus(long result) {
        if (this.mMeetingItem == null) {
            return;
        }
        switch ((int)result) {
            case 1: {
                this.mBtnStartMeeting.setText(this.mMeetingItem != null && this.mMeetingItem.ismIsCanStartMeetingForMySelf() ? R.string.zm_btn_start_meeting : R.string.zm_btn_join_meeting);
                this.mBtnStartMeeting.setEnabled(false);
                this.mBtnDeleteMeeting.setEnabled(false);
                break;
            }
            case 2: {
                long activeMeetingNo = PTApp.getInstance().getActiveMeetingNo();
                String activeCallId = PTApp.getInstance().getActiveCallId();
                if (activeMeetingNo == this.mMeetingItem.getMeetingNo() || activeCallId != null && activeCallId.equals(this.mMeetingItem.getId())) {
                    this.mBtnStartMeeting.setText(R.string.zm_btn_return_to_conf);
                    this.mBtnDeleteMeeting.setEnabled(false);
                } else {
                    this.mBtnStartMeeting.setText(this.mMeetingItem != null && this.mMeetingItem.ismIsCanStartMeetingForMySelf() ? R.string.zm_btn_start_meeting : R.string.zm_btn_join_meeting);
                }
                this.mBtnStartMeeting.setEnabled(true);
                break;
            }
            default: {
                this.mBtnStartMeeting.setText(this.mMeetingItem != null && this.mMeetingItem.ismIsCanStartMeetingForMySelf() ? R.string.zm_btn_start_meeting : R.string.zm_btn_join_meeting);
                this.mBtnStartMeeting.setEnabled(true);
                this.mBtnDeleteMeeting.setEnabled(true);
            }
        }
    }

    private void processDeleteMeetingResult(int result) {
        if (result == 0) {
            if (this.mMeetingItem == null) {
                return;
            }
            if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_CALENDAR") == 0) {
                this.handleDeleteMeetingResult();
                this.dismiss();
            } else {
                this.zm_requestPermissions(new String[]{"android.permission.WRITE_CALENDAR"}, 3001);
            }
        } else {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_alert_delete_meeting_failed);
            dialog.show(this.getChildFragmentManager(), SimpleMessageDialog.class.getName());
        }
    }

    private void handleDeleteMeetingResult() {
        if (this.mMeetingItem == null) {
            return;
        }
        String location = this.mMeetingItem.getJoinMeetingUrl();
        long[] eventIDs = AndroidAppUtil.queryCalendarEventsForMeeting((Context)this.getActivity(), (long)this.mMeetingItem.getMeetingNo(), (String)location);
        if (eventIDs != null) {
            for (long id2 : eventIDs) {
                AndroidAppUtil.deleteCalendarEvent((Context)this.getActivity(), (long)id2);
            }
        }
    }

    private void loadData() {
        Bundle args = this.getArguments();
        this.mMeetingItem = (ScheduledMeetingItem)args.getSerializable(ARG_MEETING_ITEM);
        if (this.mMeetingItem == null) {
            return;
        }
        this.mTxtTopic.setText((CharSequence)this.mMeetingItem.getTopic());
        this.mTxtMeetingId.setText((CharSequence)StringUtil.formatConfNumber((long)this.mMeetingItem.getMeetingNo()));
        if (this.mMeetingItem.isRecurring()) {
            this.mPanelDuration.setVisibility(8);
            this.mTxtWhen.setText(R.string.zm_lbl_time_recurring);
        } else {
            this.mPanelDuration.setVisibility(0);
            this.mTxtDuration.setText((CharSequence)this.getActivity().getString(R.string.zm_lbl_xxx_minutes, new Object[]{this.mMeetingItem.getDuration()}));
            this.mTxtWhen.setText((CharSequence)TimeFormatUtil.formatDateTime((Context)this.getActivity(), this.mMeetingItem.getStartTime(), true));
        }
        if (this.mMeetingItem.hasPassword()) {
            this.mPanelPassword.setVisibility(0);
            this.mTxtPassword.setText((CharSequence)this.mMeetingItem.getPassword());
        } else {
            this.mPanelPassword.setVisibility(8);
        }
        if (this.mMeetingItem.getExtendMeetingType() == 2 || !this.mMeetingItem.ismIsCanStartMeetingForMySelf()) {
            this.mBtnEdit.setVisibility(8);
            this.mBtnDeleteMeeting.setVisibility(8);
            if (!this.mMeetingItem.ismIsCanStartMeetingForMySelf()) {
                this.mBtnAddToCalendar.setVisibility(8);
                this.mBtnSendInvitation.setVisibility(8);
            }
        }
    }

    public static class DeleteMeetingConfirmDialog
    extends ZMDialogFragment {
        public static void showDialog(FragmentManager fm) {
            DeleteMeetingConfirmDialog dialog = new DeleteMeetingConfirmDialog();
            dialog.show(fm, DeleteMeetingConfirmDialog.class.getName());
        }

        public DeleteMeetingConfirmDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_delete_meeting_confirm).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DeleteMeetingConfirmDialog.this.onClickYes();
                }
            }).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }

        private void onClickYes() {
            MeetingInfoFragment f = (MeetingInfoFragment)this.getParentFragment();
            if (f != null) {
                f.deleteThisMeeting();
            }
        }
    }
}

