/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.AutoStreamConflictChecker;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.MMSelectSessionAndBuddyListView;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.videomeetings.R;

public class MMSelectSessionAndBuddyFragment
extends ZMFragment
implements View.OnClickListener,
TextView.OnEditorActionListener,
ABContactsCache.IABContactsCacheListener,
SimpleActivity.ExtListener {
    private final String TAG = MMSelectSessionAndBuddyFragment.class.getSimpleName();
    public static final String RESULT_ARG_SELECTED_ITEM = "selectedItem";
    public static final String RESULT_ARG_SELECTED_ITEM_IS_GROUP = "isgroup";
    public static final String ARG_CONTAINS_E2E_GROUP = "containE2E";
    public static final String ARG_RESULT_DATA = "resultData";
    public static final String ARG_CONTAINS_BLOCK = "containBlock";
    private MMSelectSessionAndBuddyListView mSessionsListView;
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private Button mBtnClearSearchView;
    private View mPanelConnectionAlert;
    private TextView mTxtNetworkAlert;
    private TextView mTxtTitle;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private View mPanelSearchBar;
    private Button mBtnClose;
    private View mTxtEmptyView;
    private WaitingDialog mWaitingDialog;
    private boolean isKeyboardOpen = false;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private BroadcastReceiver mNetworkStateReceiver;
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = MMSelectSessionAndBuddyFragment.this.mEdtSearch.getText().toString();
            MMSelectSessionAndBuddyFragment.this.mSessionsListView.filter(key);
            if (key.length() > 0 && MMSelectSessionAndBuddyFragment.this.mSessionsListView.getCount() > 0 || MMSelectSessionAndBuddyFragment.this.mPanelTitleBar.getVisibility() == 0) {
                MMSelectSessionAndBuddyFragment.this.mListContainer.setForeground(null);
            } else {
                MMSelectSessionAndBuddyFragment.this.mListContainer.setForeground(MMSelectSessionAndBuddyFragment.this.mDimmedForground);
            }
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onBeginConnect() {
            MMSelectSessionAndBuddyFragment.this.onBeginConnect();
        }

        @Override
        public void onConnectReturn(int errorCode) {
            MMSelectSessionAndBuddyFragment.this.onConnectReturn(errorCode);
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMSelectSessionAndBuddyFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
        }

        @Override
        public void onIndicateBuddyListUpdated() {
            MMSelectSessionAndBuddyFragment.this.onIndicateBuddyListUpdated();
        }

        @Override
        public void onGroupAction(int result, GroupAction action, String msgId) {
            MMSelectSessionAndBuddyFragment.this.onGroupAction(result, action, msgId);
        }

        @Override
        public void onNotify_ChatSessionListUpdate() {
            MMSelectSessionAndBuddyFragment.this.onNotify_ChatSessionListUpdate();
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            MMSelectSessionAndBuddyFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }

        @Override
        public void onSearchBuddyByKey(String key, int result) {
            MMSelectSessionAndBuddyFragment.this.onSearchBuddyByKey(key, result);
        }
    };

    public static void showAsFragment(Fragment fragment, Bundle resultData, boolean containsE2E, boolean containsBlock, int requestCode) {
        Bundle args = new Bundle();
        if (resultData != null) {
            args.putBundle(ARG_RESULT_DATA, resultData);
        }
        args.putBoolean(ARG_CONTAINS_E2E_GROUP, containsE2E);
        args.putBoolean(ARG_CONTAINS_BLOCK, containsBlock);
        SimpleActivity.show(fragment, MMSelectSessionAndBuddyFragment.class.getName(), args, requestCode, false, 1);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args;
        View view = inflater.inflate(R.layout.zm_mm_share_session_buddy_list, container, false);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mSessionsListView = (MMSelectSessionAndBuddyListView)view.findViewById(R.id.sessionsListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelConnectionAlert = view.findViewById(R.id.panelConnectionAlert);
        this.mTxtNetworkAlert = (TextView)view.findViewById(R.id.txtNetworkAlert);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mBtnClose = (Button)view.findViewById(R.id.btnClose);
        this.mTxtEmptyView = view.findViewById(R.id.txtEmptyView);
        this.mSessionsListView.setParentFragment(this);
        this.mSessionsListView.setEmptyView(this.mTxtEmptyView);
        this.mBtnClose.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mPanelConnectionAlert.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MMSelectSessionAndBuddyFragment.this.mHandler.removeCallbacks(MMSelectSessionAndBuddyFragment.this.mRunnableFilter);
                MMSelectSessionAndBuddyFragment.this.mHandler.postDelayed(MMSelectSessionAndBuddyFragment.this.mRunnableFilter, s == null || s.length() == 0 ? 0L : 300L);
                MMSelectSessionAndBuddyFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.onKeyboardClosed();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mEdtSearchDummy.setVisibility(8);
        }
        if ((args = this.getArguments()) != null) {
            this.mSessionsListView.setContainsE2E(args.getBoolean(ARG_CONTAINS_E2E_GROUP));
            this.mSessionsListView.setContainsBlock(args.getBoolean(ARG_CONTAINS_BLOCK));
        }
        this.compatPCModeForSearch();
        return view;
    }

    private void compatPCModeForSearch() {
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(final View v, boolean hasFocus) {
                if (hasFocus) {
                    MMSelectSessionAndBuddyFragment.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!MMSelectSessionAndBuddyFragment.this.isAdded() || !MMSelectSessionAndBuddyFragment.this.isResumed()) {
                                return;
                            }
                            EditText editText = (EditText)v;
                            if (editText.hasFocus()) {
                                MMSelectSessionAndBuddyFragment.this.onKeyboardOpen();
                            }
                        }
                    }, 500L);
                }
            }
        };
        this.mEdtSearchDummy.setOnFocusChangeListener(onFocusChangeListener);
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void updatePanelConnectionAlert() {
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelConnectionAlert.setVisibility(8);
            return;
        }
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
                case -1: 
                case 1: 
                case 2: {
                    this.mPanelConnectionAlert.setVisibility(8);
                    break;
                }
                case 0: {
                    this.mPanelConnectionAlert.setVisibility(0);
                    if (this.mTxtNetworkAlert == null) break;
                    this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_stream_conflict);
                }
            }
        } else {
            this.mPanelConnectionAlert.setVisibility(0);
            if (this.mTxtNetworkAlert != null) {
                this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_network_unavailable);
            }
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.isKeyboardOpen) {
            return;
        }
        this.isKeyboardOpen = true;
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.isKeyboardOpen = false;
        int keyLen = this.mEdtSearch.getText().length();
        if (keyLen == 0 || this.mSessionsListView.getCount() == 0) {
            this.mEdtSearchDummy.setVisibility(0);
            this.mPanelSearchBar.setVisibility(4);
            this.mListContainer.setForeground(null);
            this.mPanelTitleBar.setVisibility(0);
            this.mEdtSearch.setText((CharSequence)"");
        }
        this.mSessionsListView.post(new Runnable(){

            @Override
            public void run() {
                MMSelectSessionAndBuddyFragment.this.mSessionsListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        if (this.mPanelSearchBar.getVisibility() == 0) {
            this.mEdtSearchDummy.setVisibility(0);
            this.mPanelSearchBar.setVisibility(4);
            this.mListContainer.setForeground(null);
            this.mPanelTitleBar.setVisibility(0);
            this.mEdtSearch.setText((CharSequence)"");
            this.isKeyboardOpen = false;
            return true;
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        if (this.mSessionsListView != null) {
            this.mSessionsListView.onParentFragmentResume();
        }
        this.updateTitle();
        this.updateBtnClearSearchView();
        this.updatePanelConnectionAlert();
        this.startToListenNetworkEvent();
        ABContactsCache.getInstance().addListener(this);
        if (ABContactsCache.getInstance().needReloadAll()) {
            ABContactsCache.getInstance().reloadAllContacts();
        }
    }

    public void onStart() {
        super.onStart();
        if (this.mSessionsListView != null) {
            this.mSessionsListView.onParentFragmentStart();
        }
    }

    private void updateTitle() {
        switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
            case -1: 
            case 0: 
            case 1: {
                if (this.mTxtTitle == null) break;
                this.mTxtTitle.setText(R.string.zm_mm_title_share_to);
                break;
            }
            case 2: {
                if (this.mTxtTitle == null) break;
                this.mTxtTitle.setText(R.string.zm_mm_title_chats_connecting);
            }
        }
        if (this.mTxtTitle != null) {
            this.mTxtTitle.getParent().requestLayout();
        }
    }

    private void startToListenNetworkEvent() {
        if (this.mNetworkStateReceiver == null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    MMSelectSessionAndBuddyFragment.this.updatePanelConnectionAlert();
                }
            };
            context.registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopToListenNetworkEvent() {
        if (this.mNetworkStateReceiver != null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            context.unregisterReceiver(this.mNetworkStateReceiver);
            this.mNetworkStateReceiver = null;
        }
    }

    @Override
    public void onContactsCacheUpdated() {
        if (this.mSessionsListView != null) {
            this.mSessionsListView.loadData();
            this.mSessionsListView.notifyDataSetChanged();
        }
    }

    public void onPause() {
        super.onPause();
        this.stopToListenNetworkEvent();
        ABContactsCache.getInstance().removeListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void dismiss() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
        }
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void onSelect(String jid, boolean isGroup) {
        FragmentActivity activity;
        Bundle resultData;
        Intent intent = new Intent();
        intent.putExtra(RESULT_ARG_SELECTED_ITEM, jid);
        intent.putExtra(RESULT_ARG_SELECTED_ITEM_IS_GROUP, isGroup);
        Bundle args = this.getArguments();
        if (args != null && (resultData = args.getBundle(ARG_RESULT_DATA)) != null) {
            intent.putExtras(resultData);
        }
        if ((activity = this.getActivity()) != null) {
            activity.setResult(-1, intent);
        }
        this.dismiss();
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        this.mWaitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        } else if (this.mWaitingDialog != null) {
            try {
                this.mWaitingDialog.dismissAllowingStateLoss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mWaitingDialog = null;
    }

    public void onClickViewMore() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String filter = this.mEdtSearch.getText().toString().trim().toLowerCase(CompatUtils.getLocalDefault());
        if (messenger.searchBuddyByKey(filter)) {
            this.mSessionsListView.setIsWebSearchMode(true);
            this.showWaitingDialog();
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (v == this.mPanelConnectionAlert) {
            this.onClickPanelConnectionAlert();
        } else if (v == this.mBtnClose) {
            this.onClickBtnClose();
        }
    }

    private void onClickBtnClose() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.dismiss();
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickPanelConnectionAlert() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)activity)) {
            Toast.makeText((Context)activity, (int)R.string.zm_alert_network_disconnected, (int)1).show();
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isStreamConflict()) {
            AutoStreamConflictChecker.getInstance().showStreamConflictMessage(this.getActivity());
        } else {
            messenger.trySignon();
        }
    }

    private void onBeginConnect() {
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity()) && this.isResumed()) {
            this.updateTitle();
            this.updatePanelConnectionAlert();
        }
    }

    private void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && this.isResumed()) {
            this.updateTitle();
            this.updatePanelConnectionAlert();
            if (this.mSessionsListView != null) {
                this.mSessionsListView.notifyDataSetChanged();
            }
        }
    }

    private void onIndicateBuddyInfoUpdatedWithJID(String jid) {
        if (this.mSessionsListView != null) {
            this.mSessionsListView.onIndicateBuddyInfoUpdatedWithJID(jid);
        }
    }

    private void onGroupAction(int result, GroupAction action, String msgId) {
        if (action == null) {
            return;
        }
        this.mSessionsListView.onGroupAction(result, action, msgId);
    }

    private void onNotify_ChatSessionListUpdate() {
        if (this.mSessionsListView != null && this.isResumed()) {
            this.mSessionsListView.loadData();
            this.mSessionsListView.notifyDataSetChanged();
        }
    }

    private void onIndicateBuddyListUpdated() {
        if (this.mSessionsListView != null && this.isResumed()) {
            this.mSessionsListView.loadData();
            this.mSessionsListView.notifyDataSetChanged();
        }
    }

    private void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        if (this.mSessionsListView != null) {
            this.mSessionsListView.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }
    }

    private void onSearchBuddyByKey(String key, int result) {
        String filter = this.mEdtSearch.getText().toString().trim().toLowerCase(CompatUtils.getLocalDefault());
        if (StringUtil.isSameString((String)filter, (String)key)) {
            this.dismissWaitingDialog();
        }
        if (this.mSessionsListView != null) {
            this.mSessionsListView.onSearchBuddyByKey(key, result);
        }
    }
}

