/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.MMSelectContactsFragment;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.view.MMSelectGroupListItemSpan;
import com.zipow.videobox.view.ZMReplaceSpanMovementMethod;
import com.zipow.videobox.view.mm.MMSelectGroupListView;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMEditText;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.videomeetings.R;

public class MMSelectGroupFragment
extends ZMDialogFragment
implements AdapterView.OnItemClickListener,
View.OnClickListener,
ZMKeyboardDetector.KeyboardListener {
    public static final String RESULT_SELECT_GROUPS = "selectGroups";
    private static final String ARGS_IS_MULT_SELECT = "isMultSelect";
    private static final String ARGS_PRE_SEELECTS = "preSelects";
    private static final String ARGS_TITLE = "title";
    private MMSelectGroupListView mSelectGroupListView;
    private ZMEditText mEdtSearch;
    private boolean mIsMultSelect = false;
    private Button mBtnOK;
    private Handler mHandler = new Handler();
    private GestureDetector mGestureDetector;
    private TextView mTxtTitle;
    private SearchFilterRunnable mRunnableFilter = new SearchFilterRunnable();
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMSelectGroupFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMSelectGroupFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }
    };

    public static void showAsActivity(Fragment fragment, boolean isMultSelect, ArrayList<String> preSelects, String title, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        if (preSelects != null) {
            args.putStringArrayList(ARGS_PRE_SEELECTS, preSelects);
        }
        args.putBoolean(ARGS_IS_MULT_SELECT, isMultSelect);
        args.putString(ARGS_TITLE, title);
        SimpleActivity.show(fragment, MMSelectGroupFragment.class.getName(), args, requestCode, true);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mIsMultSelect = args.getBoolean(ARGS_IS_MULT_SELECT);
            ArrayList preSelects = args.getStringArrayList(ARGS_PRE_SEELECTS);
            this.mSelectGroupListView.setIsMultSelect(this.mIsMultSelect);
            this.mSelectGroupListView.setPreSelects(preSelects);
            String title = args.getString(ARGS_TITLE);
            if (!StringUtil.isEmptyOrNull((String)title)) {
                this.mTxtTitle.setText((CharSequence)title);
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_select_groups, container, false);
        this.mSelectGroupListView = (MMSelectGroupListView)view.findViewById(R.id.listView);
        this.mEdtSearch = (ZMEditText)view.findViewById(R.id.edtSearch);
        this.mBtnOK = (Button)view.findViewById(R.id.btnOK);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mSelectGroupListView.setOnItemClickListener(this);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mBtnOK.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setSelected(true);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (after < count) {
                    Editable editable = MMSelectGroupFragment.this.mEdtSearch.getText();
                    final MMSelectGroupListItemSpan[] spans = (MMSelectGroupListItemSpan[])editable.getSpans(start + after, start + count, MMSelectGroupListItemSpan.class);
                    if (spans.length <= 0) {
                        return;
                    }
                    MMSelectGroupFragment.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!MMSelectGroupFragment.this.isResumed()) {
                                return;
                            }
                            for (MMSelectGroupListItemSpan span : spans) {
                                MMZoomGroup item = span.getItem();
                                if (item == null) continue;
                                MMSelectGroupFragment.this.mSelectGroupListView.unselectBuddy(item.getGroupId());
                            }
                        }
                    });
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MMSelectGroupFragment.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!MMSelectGroupFragment.this.isResumed()) {
                            return;
                        }
                        MMSelectGroupFragment.this.formatSearchEditText();
                        String key = MMSelectGroupFragment.this.getFilter();
                        MMSelectGroupFragment.this.startFilter(key);
                    }
                });
            }
        });
        this.mEdtSearch.setMovementMethod((MovementMethod)ZMReplaceSpanMovementMethod.getInstance());
        this.mEdtSearch.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                return actionId == 6 || event.getKeyCode() == 66 && event.getAction() == 0;
            }
        });
        this.mGestureDetector = new GestureDetector((Context)this.getActivity(), (GestureDetector.OnGestureListener)new MMSelectContactsFragment.GuestureListener((View)this.mSelectGroupListView, (View)this.mEdtSearch));
        this.mSelectGroupListView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return MMSelectGroupFragment.this.mGestureDetector.onTouchEvent(event);
            }
        });
        return view;
    }

    private void updateUI() {
        this.mSelectGroupListView.updateUI();
        this.updateButtonOK();
    }

    public void onKeyboardOpen() {
        this.mEdtSearch.setCursorVisible(true);
    }

    public void onKeyboardClosed() {
        this.mEdtSearch.setCursorVisible(false);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MMSelectGroupFragment.this.mEdtSearch.requestLayout();
            }
        });
    }

    public void onResume() {
        super.onResume();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.updateUI();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (MMSelectGroupFragment.this.isResumed()) {
                    MMSelectGroupFragment.this.mEdtSearch.requestFocus();
                    UIUtil.openSoftKeyboard((Context)MMSelectGroupFragment.this.getActivity(), (View)MMSelectGroupFragment.this.mEdtSearch);
                }
            }
        }, 100L);
    }

    public void onPause() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onPause();
    }

    private void formatSearchEditText() {
        Editable editable = this.mEdtSearch.getEditableText();
        MMSelectGroupListItemSpan[] spans = (MMSelectGroupListItemSpan[])StringUtil.getSortedSpans((Spanned)editable, MMSelectGroupListItemSpan.class);
        if (spans.length <= 0) {
            return;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)editable);
        boolean hasNormalCharInMiddle = false;
        for (int i = 0; i < spans.length; ++i) {
            int preEnd;
            int start = builder.getSpanStart((Object)spans[i]);
            int n = preEnd = i == 0 ? 0 : builder.getSpanEnd((Object)spans[i - 1]);
            if (start == preEnd) continue;
            CharSequence str = builder.subSequence(preEnd, start);
            builder.replace(preEnd, start, (CharSequence)"");
            int end = builder.getSpanEnd((Object)spans[spans.length - 1]);
            builder.replace(end, end, str);
            hasNormalCharInMiddle = true;
        }
        if (hasNormalCharInMiddle) {
            this.mEdtSearch.setText((CharSequence)builder);
            this.mEdtSearch.setSelection(builder.length());
        }
    }

    private String getFilter() {
        String key = "";
        Editable editable = this.mEdtSearch.getText();
        MMSelectGroupListItemSpan[] spans = (MMSelectGroupListItemSpan[])editable.getSpans(0, editable.length(), MMSelectGroupListItemSpan.class);
        if (spans.length <= 0) {
            key = editable.toString();
        } else {
            int length;
            MMSelectGroupListItemSpan lastSpan = spans[spans.length - 1];
            int pos = editable.getSpanEnd((Object)lastSpan);
            if (pos < (length = editable.length())) {
                key = editable.subSequence(pos, length).toString();
            }
        }
        return key;
    }

    private void startFilter(String key) {
        String oldKey;
        if (key == null) {
            key = "";
        }
        if (key.equals(oldKey = this.mRunnableFilter.getKey())) {
            return;
        }
        this.mRunnableFilter.setKey(key);
        this.mHandler.removeCallbacks((Runnable)this.mRunnableFilter);
        this.mHandler.postDelayed((Runnable)this.mRunnableFilter, 300L);
    }

    private void onGroupAction(int result, GroupAction action, String messageId) {
        if (action == null) {
            return;
        }
        this.mSelectGroupListView.updateGroup(action.getGroupId());
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        this.mSelectGroupListView.removeGroup(groupID);
    }

    private void updateButtonOK() {
        if (this.mIsMultSelect) {
            this.mBtnOK.setEnabled(this.getSelectedBuddiesCount() > 0);
        } else {
            this.mBtnOK.setVisibility(8);
        }
    }

    private int getSelectedBuddiesCount() {
        ArrayList<String> items = this.mSelectGroupListView.getSelectedBuddies();
        return items.size();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MMZoomGroup group = this.mSelectGroupListView.getItem(position);
        if (group == null) {
            return;
        }
        if (this.mIsMultSelect) {
            this.mSelectGroupListView.onItemClicked(group.getGroupId());
            this.onSelected(this.mSelectGroupListView.isGroupSelected(group.getGroupId()), group);
            this.updateButtonOK();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                ArrayList<String> items = new ArrayList<String>();
                Intent intent = new Intent();
                items.add(group.getGroupId());
                intent.putStringArrayListExtra(RESULT_SELECT_GROUPS, items);
                activity.setResult(-1, intent);
            }
            this.dismiss();
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnOK) {
            this.onClickBtnOK();
        }
    }

    private void onClickBtnOK() {
        this.onSelectionConfirmed();
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.dismiss();
    }

    private void onSelectionConfirmed() {
        ArrayList<String> items = this.mSelectGroupListView.getSelectedBuddies();
        if (items == null || items.size() == 0) {
            this.onClickBtnBack();
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.getView());
        Intent intent = new Intent();
        intent.putStringArrayListExtra(RESULT_SELECT_GROUPS, items);
        activity.setResult(-1, intent);
        this.dismiss();
    }

    private void onSelected(boolean selected, MMZoomGroup group) {
        if (group == null) {
            return;
        }
        Editable editable = this.mEdtSearch.getText();
        MMSelectGroupListItemSpan[] spans = (MMSelectGroupListItemSpan[])editable.getSpans(0, editable.length(), MMSelectGroupListItemSpan.class);
        MMSelectGroupListItemSpan itemSpan = null;
        for (MMSelectGroupListItemSpan span : spans) {
            if (!StringUtil.isSameString((String)group.getGroupId(), (String)span.getItem().getGroupId())) continue;
            itemSpan = span;
            break;
        }
        if (selected) {
            if (itemSpan != null) {
                itemSpan.setItem(group);
                return;
            }
            int count = spans.length;
            if (count > 0) {
                int length;
                MMSelectGroupListItemSpan lastSpan = spans[count - 1];
                int lastSpanEnd = editable.getSpanEnd((Object)lastSpan);
                if (lastSpanEnd < (length = editable.length())) {
                    editable.delete(lastSpanEnd, length);
                }
            } else {
                editable.clear();
            }
            itemSpan = new MMSelectGroupListItemSpan((Context)this.getActivity(), group);
            itemSpan.setInterval(UIUtil.dip2px((Context)this.getActivity(), (float)2.0f));
            String name = group.getGroupName();
            int start = editable.length();
            int end = start + name.length();
            editable.append((CharSequence)group.getGroupName());
            editable.setSpan((Object)itemSpan, start, end, 33);
            this.mEdtSearch.setSelection(end);
            this.mEdtSearch.setCursorVisible(true);
        } else {
            if (itemSpan == null) {
                return;
            }
            int start = editable.getSpanStart((Object)itemSpan);
            int end = editable.getSpanEnd((Object)itemSpan);
            if (start >= 0 && end >= 0 && end >= start) {
                editable.delete(start, end);
                editable.removeSpan((Object)itemSpan);
            }
        }
    }

    public class SearchFilterRunnable
    implements Runnable {
        private String mKey = "";

        public void setKey(String key) {
            this.mKey = key == null ? "" : key;
        }

        public String getKey() {
            return this.mKey;
        }

        @Override
        public void run() {
            MMSelectGroupFragment.this.mSelectGroupListView.setFilter(this.mKey);
        }
    }
}

