/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.ZMWebUtil;
import com.zipow.videobox.view.LoginView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMSSOLoginFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final int UI_MODE_DOMAIN = 1;
    private static final int UI_MODE_EMAIL = 2;
    private View mLayoutInputDomain;
    private View mViewLineDomainError;
    private View mViewLineDomainNormal;
    private View mViewHintDomainNormal;
    private View mLayoutInputEmail;
    private View mViewLineEmailError;
    private View mViewLineEmailNormal;
    private View mViewHintEmailNormal;
    private EditText mEdtDomail;
    private EditText mEdtEmail;
    private TextView mViewHintEmailError;
    private TextView mViewHintDomainError;
    private Button mBtnContinue;
    private int mUIMode = 1;
    private TextView.OnEditorActionListener mOnEditorActionListener = new TextView.OnEditorActionListener(){

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            UIUtil.closeSoftKeyboard((Context)MMSSOLoginFragment.this.getActivity(), (View)v);
            MMSSOLoginFragment.this.onBtnContinueClick();
            return true;
        }
    };

    public static void showAsDialog(FragmentManager fm) {
        MMSSOLoginFragment f = new MMSSOLoginFragment();
        Bundle args = new Bundle();
        f.setArguments(args);
        f.show(fm, MMSSOLoginFragment.class.getName());
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setView(this.createContent(savedInstanceState)).setTheme(R.style.ZMDialog_Material_Transparent).create();
        Window window = dialog.getWindow();
        if (window != null) {
            window.clearFlags(131080);
            window.setSoftInputMode(4);
        }
        return dialog;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putInt("uiMode", this.mUIMode);
        }
    }

    private View createContent(Bundle savedInstanceState) {
        String siteUrl;
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_mm_login_sso, null);
        this.mLayoutInputDomain = view.findViewById(R.id.layoutInputDomain);
        this.mViewLineDomainError = view.findViewById(R.id.viewLineDomainError);
        this.mViewLineDomainNormal = view.findViewById(R.id.viewLineDomainNormal);
        this.mViewHintDomainError = (TextView)view.findViewById(R.id.viewHintDomainError);
        this.mViewHintDomainNormal = view.findViewById(R.id.viewHintDomainNormal);
        this.mLayoutInputEmail = view.findViewById(R.id.layoutInputEmail);
        this.mViewLineEmailError = view.findViewById(R.id.viewLineEmailError);
        this.mViewHintEmailError = (TextView)view.findViewById(R.id.viewHintEmailError);
        this.mViewLineEmailNormal = view.findViewById(R.id.viewLineEmailNormal);
        this.mViewHintEmailNormal = view.findViewById(R.id.viewHintEmailNormal);
        this.mEdtDomail = (EditText)view.findViewById(R.id.edtDomail);
        this.mEdtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mBtnContinue = (Button)view.findViewById(R.id.btnContinue);
        TextView txtSsoDomain = (TextView)view.findViewById(R.id.txtSsoDomain);
        txtSsoDomain.setText((CharSequence)ZMWebUtil.getZmUrlSSOPostfix());
        Bundle args = this.getArguments();
        if (args != null && !TextUtils.isEmpty((CharSequence)(siteUrl = PTApp.getInstance().getSSOURL()))) {
            String domain = null;
            if (siteUrl.startsWith("http://")) {
                domain = siteUrl.substring(7);
            } else if (siteUrl.startsWith("https://")) {
                domain = siteUrl.substring(8);
            }
            if (!StringUtil.isEmptyOrNull((String)domain) && domain.endsWith(ZMWebUtil.getZmUrlSSOPostfix())) {
                domain = domain.substring(0, domain.length() - ZMWebUtil.getZmUrlSSOPostfix().length());
                this.mEdtDomail.setText((CharSequence)domain);
                this.mEdtDomail.setSelection(domain.length());
            }
        }
        if (savedInstanceState != null) {
            this.mUIMode = savedInstanceState.getInt("uiMode");
        }
        view.findViewById(R.id.btnUnknowCompanyDomain).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnManualyEnterDomain).setOnClickListener((View.OnClickListener)this);
        this.mBtnContinue.setOnClickListener((View.OnClickListener)this);
        this.mEdtDomail.setOnEditorActionListener(this.mOnEditorActionListener);
        this.mEdtEmail.setOnEditorActionListener(this.mOnEditorActionListener);
        this.mEdtDomail.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MMSSOLoginFragment.this.showDomainInputHint(true, 0);
                if (MMSSOLoginFragment.this.mUIMode == 1) {
                    MMSSOLoginFragment.this.mBtnContinue.setEnabled(s.length() > 0);
                }
            }
        });
        this.mEdtEmail.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MMSSOLoginFragment.this.showEmailInputHint(true, 0);
                if (MMSSOLoginFragment.this.mUIMode == 2) {
                    MMSSOLoginFragment.this.mBtnContinue.setEnabled(StringUtil.isValidEmailAddress((String)s.toString()));
                }
            }
        });
        return view;
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnUnknowCompanyDomain) {
            this.onBtnUnknowCompanyDomainClick();
        } else if (id2 == R.id.btnManualyEnterDomain) {
            this.onBtnManualyEnterDomainClick();
        } else if (id2 == R.id.btnContinue) {
            this.onBtnContinueClick();
        }
    }

    public void onSSOSuccess() {
        this.dismiss();
    }

    public void onSSOError(int errCode) {
        if (this.mUIMode == 1) {
            this.showDomainInputHint(false, errCode);
        } else {
            this.showEmailInputHint(false, errCode);
        }
        this.mBtnContinue.setEnabled(false);
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void showEmailInputHint(boolean isCorrect, int errCode) {
        this.mViewLineEmailError.setVisibility(!isCorrect ? 0 : 8);
        this.mViewHintEmailError.setVisibility(!isCorrect ? 0 : 8);
        this.mViewLineEmailNormal.setVisibility(isCorrect ? 0 : 8);
        this.mViewHintEmailNormal.setVisibility(isCorrect ? 0 : 8);
        if (!isCorrect) {
            if (errCode == 2014) {
                this.mViewHintEmailError.setText(R.string.zm_mm_lbl_no_match_domain);
            } else {
                this.mViewHintEmailError.setText(R.string.zm_mm_lbl_net_error_try_again);
            }
        }
    }

    private void showDomainInputHint(boolean isCorrect, int errCode) {
        this.mViewLineDomainError.setVisibility(!isCorrect ? 0 : 8);
        this.mViewHintDomainError.setVisibility(!isCorrect ? 0 : 8);
        this.mViewLineDomainNormal.setVisibility(isCorrect ? 0 : 8);
        this.mViewHintDomainNormal.setVisibility(isCorrect ? 0 : 8);
    }

    private void onBtnContinueClick() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getActivity();
            LoginView.AuthFailedDialog.show(activity, message);
            return;
        }
        if (this.mUIMode == 1) {
            String siteUrl = "https://";
            String str = this.mEdtDomail.getText().toString();
            if (str.trim().length() == 0) {
                return;
            }
            siteUrl = siteUrl + str.toLowerCase() + ZMWebUtil.getZmUrlSSOPostfix();
            PTApp.getInstance().setSSOURL(siteUrl);
            FragmentActivity activity = this.getActivity();
            if (activity != null && activity instanceof LoginActivity) {
                ((LoginActivity)activity).loginSSOSite(siteUrl);
            }
        } else if (this.mUIMode == 2) {
            String email = this.mEdtEmail.getText().toString();
            if (StringUtil.isValidEmailAddress((String)email)) {
                FragmentActivity activity = this.getActivity();
                if (activity != null && activity instanceof LoginActivity) {
                    ((LoginActivity)activity).querySSODomainByEmail(email);
                }
                return;
            }
        } else {
            return;
        }
    }

    private void onBtnManualyEnterDomainClick() {
        this.mUIMode = 1;
        this.mLayoutInputDomain.setVisibility(0);
        this.mLayoutInputEmail.setVisibility(8);
        this.mEdtDomail.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtDomail);
        this.mBtnContinue.setEnabled(this.mEdtDomail.getText().toString().trim().length() > 0);
    }

    private void onBtnUnknowCompanyDomainClick() {
        this.mUIMode = 2;
        this.mLayoutInputDomain.setVisibility(8);
        this.mLayoutInputEmail.setVisibility(0);
        this.mEdtEmail.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtEmail);
        this.mBtnContinue.setEnabled(StringUtil.isValidEmailAddress((String)this.mEdtEmail.getText().toString()));
    }
}

