/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.MMNotificationGroupSettingsFragment;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.view.mm.MMNotificationExceptionGroupSettingsListView;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.videomeetings.R;

public class MMNotificationExceptionGroupsSettingsFragment
extends ZMDialogFragment
implements AdapterView.OnItemClickListener,
View.OnClickListener,
ZMKeyboardDetector.KeyboardListener,
AbsListView.OnScrollListener,
SimpleActivity.ExtListener {
    private MMNotificationExceptionGroupSettingsListView mListView;
    private EditText mEdtSearch;
    private View mPanelTitleBar;
    private FrameLayout mPanelListView;
    private Drawable mDimmedForground = null;
    private View mPanelSearchBarReal;
    private View mPanelSearch;
    private EditText mEdtSearchReal;
    private Button mBtnClearSearchView;
    private SearchFilterRunnable mRunnableFilter = new SearchFilterRunnable();
    private Handler mHandler = new Handler();
    private HashMap<String, Integer> mSettings = new HashMap();
    private View btnRight;
    private boolean isKeyboardOpen;
    private final int REQUEST_MUC_SETTINGS = 1;
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMNotificationExceptionGroupsSettingsFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMNotificationExceptionGroupsSettingsFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }
    };
    private NotificationSettingUI.INotificationSettingUIListener mNotificationListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnMUCSettingUpdated() {
            MMNotificationExceptionGroupsSettingsFragment.this.OnMUCSettingUpdated();
        }

        @Override
        public void OnDNDSettingsUpdated() {
            MMNotificationExceptionGroupsSettingsFragment.this.OnDNDSettingsUpdated();
        }
    };

    public static void showAsActivity(Fragment fragment, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMNotificationExceptionGroupsSettingsFragment.class.getName(), args, requestCode, true);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Serializable s;
        View view = inflater.inflate(R.layout.zm_notification_exception_groups_settings, container, false);
        this.mListView = (MMNotificationExceptionGroupSettingsListView)view.findViewById(R.id.listView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mPanelListView = (FrameLayout)view.findViewById(R.id.panelListView);
        this.mPanelSearchBarReal = view.findViewById(R.id.panelSearchBarReal);
        this.mEdtSearchReal = (EditText)view.findViewById(R.id.edtSearchReal);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        this.btnRight = view.findViewById(R.id.btnRight);
        this.mListView.setOnItemClickListener(this);
        this.mListView.setOnScrollListener(this);
        this.mEdtSearch.setCursorVisible(false);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.btnRight.setOnClickListener((View.OnClickListener)this);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        if (savedInstanceState != null && (s = savedInstanceState.getSerializable("mSettings")) != null) {
            this.mSettings = (HashMap)s;
        }
        this.mEdtSearchReal.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(final Editable s) {
                MMNotificationExceptionGroupsSettingsFragment.this.mBtnClearSearchView.setVisibility(s.length() > 0 ? 0 : 8);
                MMNotificationExceptionGroupsSettingsFragment.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!MMNotificationExceptionGroupsSettingsFragment.this.isResumed()) {
                            return;
                        }
                        MMNotificationExceptionGroupsSettingsFragment.this.startFilter(s.toString());
                    }
                });
            }
        });
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mSettings", this.mSettings);
    }

    private void updateUI() {
        this.mListView.updateData(this.mSettings);
        this.btnRight.setEnabled(this.mSettings != null && !this.mSettings.isEmpty());
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        this.isKeyboardOpen = true;
        if (this.mEdtSearch.hasFocus()) {
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelListView.setForeground(this.mDimmedForground);
            this.mPanelSearchBarReal.setVisibility(0);
            this.mPanelSearch.setVisibility(8);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mEdtSearchReal.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        this.isKeyboardOpen = false;
        if (this.mEdtSearchReal.length() == 0 || this.mListView.getCount() == 0) {
            this.mPanelListView.setForeground(null);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MMNotificationExceptionGroupsSettingsFragment.this.mListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return this.handleBackPressed();
    }

    public void onStop() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        NotificationSettingUI.getInstance().removeListener(this.mNotificationListener);
        super.onStop();
    }

    public void onStart() {
        super.onStart();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        NotificationSettingUI.getInstance().addListener(this.mNotificationListener);
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    private void startFilter(String key) {
        String oldKey;
        if (key == null) {
            key = "";
        }
        if (key.equals(oldKey = this.mRunnableFilter.getKey())) {
            return;
        }
        this.mRunnableFilter.setKey(key);
        this.mHandler.removeCallbacks((Runnable)this.mRunnableFilter);
        this.mHandler.postDelayed((Runnable)this.mRunnableFilter, 300L);
    }

    private void onGroupAction(int result, GroupAction action, String messageId) {
        if (action == null) {
            return;
        }
        this.mListView.updateGroup(action.getGroupId());
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        this.mListView.removeGroup(groupID);
    }

    public void OnMUCSettingUpdated() {
        this.mListView.updateData(this.mSettings);
    }

    public void OnDNDSettingsUpdated() {
        this.mListView.updateData(this.mSettings);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MMZoomGroup group = this.mListView.getItem(position);
        if (group == null) {
            return;
        }
        Integer integer2 = this.mSettings.get(group.getGroupId());
        int mucType = 0;
        mucType = integer2 != null ? integer2.intValue() : group.getNotifyType();
        if (mucType == 0) {
            mucType = this.getDefaultSettings();
        }
        MMNotificationGroupSettingsFragment.showAsActivity((Fragment)this, group.getGroupId(), mucType, 1);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                if (resultCode != -1 || data == null) {
                    return;
                }
                String sessionId = data.getStringExtra("sessionId");
                int type = data.getIntExtra("mucType", 1);
                this.onGroupNotificationSettings(sessionId, type);
            }
        }
    }

    private void onGroupNotificationSettings(String sessionId, int type) {
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        PTAppProtos.MUCNotifySettings settings = mgr.getMUCDiffFromGeneralSetting();
        if (settings == null) {
            return;
        }
        int mucType = 0;
        for (PTAppProtos.MUCNotifySettingItem item : settings.getItemsList()) {
            if (!StringUtil.isSameString((String)item.getSessionId(), (String)sessionId)) continue;
            mucType = item.getType();
        }
        if (type == mucType) {
            this.mSettings.remove(sessionId);
        } else if (mucType == 0 && type == this.getDefaultSettings()) {
            this.mSettings.remove(sessionId);
        } else {
            this.mSettings.put(sessionId, type);
        }
        this.updateUI();
    }

    private int getDefaultSettings() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return 1;
        }
        int[] allSettings = mgr.getBlockAllSettings();
        if (allSettings == null) {
            return 1;
        }
        int action = allSettings[0];
        int type = allSettings[1];
        if (action == 1 && type == 1) {
            return 1;
        }
        if (action == 2) {
            return 3;
        }
        if (action == 1 && type == 4) {
            return 2;
        }
        return 1;
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnRight) {
            this.onClickBtnRight();
        }
    }

    private void onClickBtnRight() {
        if (this.mSettings == null || this.mSettings.isEmpty()) {
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        ArrayList<String> allJids = new ArrayList<String>();
        ArrayList<String> privateJids = new ArrayList<String>();
        ArrayList<String> noJids = new ArrayList<String>();
        ArrayList<String> resetJids = new ArrayList<String>();
        block5: for (Map.Entry<String, Integer> item : this.mSettings.entrySet()) {
            Integer type = item.getValue();
            if (type == null) continue;
            switch (type) {
                case 1: {
                    allJids.add(item.getKey());
                    continue block5;
                }
                case 2: {
                    privateJids.add(item.getKey());
                    continue block5;
                }
                case 3: {
                    noJids.add(item.getKey());
                    continue block5;
                }
            }
            resetJids.add(item.getKey());
        }
        if (!CollectionsUtil.isListEmpty(allJids)) {
            mgr.applyMUCSettings(allJids, 1);
        }
        if (!CollectionsUtil.isListEmpty(privateJids)) {
            mgr.applyMUCSettings(privateJids, 2);
        }
        if (!CollectionsUtil.isListEmpty(noJids)) {
            mgr.applyMUCSettings(noJids, 3);
        }
        if (!CollectionsUtil.isListEmpty(resetJids)) {
            mgr.resetMUCSettings(resetJids);
        }
        this.mSettings.clear();
        this.dismiss();
    }

    public boolean handleBackPressed() {
        if (this.mPanelSearchBarReal.getVisibility() == 0) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
            this.mEdtSearchReal.setText((CharSequence)"");
            return true;
        }
        return false;
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearchReal.setText((CharSequence)"");
        if (!this.isKeyboardOpen) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearch.setVisibility(0);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MMNotificationExceptionGroupsSettingsFragment.this.mListView.requestLayout();
                }
            });
        }
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.dismiss();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 2) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    public class SearchFilterRunnable
    implements Runnable {
        private String mKey = "";

        public void setKey(String key) {
            this.mKey = key == null ? "" : key;
        }

        public String getKey() {
            return this.mKey;
        }

        @Override
        public void run() {
            String key = this.getKey();
            MMNotificationExceptionGroupsSettingsFragment.this.mListView.setFilter(this.mKey);
            if (key.length() > 0 && MMNotificationExceptionGroupsSettingsFragment.this.mListView.getCount() > 0 || MMNotificationExceptionGroupsSettingsFragment.this.mPanelTitleBar.getVisibility() == 0) {
                MMNotificationExceptionGroupsSettingsFragment.this.mPanelListView.setForeground(null);
            } else {
                MMNotificationExceptionGroupsSettingsFragment.this.mPanelListView.setForeground(MMNotificationExceptionGroupsSettingsFragment.this.mDimmedForground);
            }
        }
    }
}

