/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.MMNotificationGroupSettingsFragment;
import com.zipow.videobox.fragment.MMSelectGroupFragment;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.view.mm.MMNotificationExceptionGroupListView;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.videomeetings.R;

public class MMNotificationExceptionGroupFragment
extends ZMDialogFragment
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private static final int REQUEST_ADD_GROUP = 1;
    private MMNotificationExceptionGroupListView mListView;
    private NotificationSettingUI.INotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnMUCSettingUpdated() {
            MMNotificationExceptionGroupFragment.this.OnMUCSettingUpdated();
        }
    };
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMNotificationExceptionGroupFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMNotificationExceptionGroupFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }
    };

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMNotificationExceptionGroupFragment.class.getName(), args, 0);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_notification_exception_group, container, false);
        this.mListView = (MMNotificationExceptionGroupListView)view.findViewById(R.id.listView);
        this.mListView.setParentFragment(this);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mListView.setOnItemClickListener(this);
        return view;
    }

    public void onResume() {
        super.onResume();
        NotificationSettingUI.getInstance().addListener(this.mListener);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.updateUI();
    }

    public void onPause() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        NotificationSettingUI.getInstance().removeListener(this.mListener);
        super.onPause();
    }

    private void onGroupAction(int result, GroupAction action, String messageId) {
        this.updateUI();
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        this.updateUI();
    }

    private void OnMUCSettingUpdated() {
        this.updateUI();
    }

    private void updateUI() {
        if (this.mListView != null) {
            this.mListView.updateData();
        }
    }

    public void addExceptionGroup() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        ArrayList<String> selects = new ArrayList<String>();
        PTAppProtos.MUCNotifySettings settings = mgr.getMUCDiffFromGeneralSetting();
        if (settings != null) {
            for (PTAppProtos.MUCNotifySettingItem item : settings.getItemsList()) {
                selects.add(item.getSessionId());
            }
        }
        MMSelectGroupFragment.showAsActivity((Fragment)this, true, selects, this.getString(R.string.zm_lbl_notification_add_exception_group_19898), 1);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                ArrayList groupIds;
                if (data == null || resultCode != -1 || CollectionsUtil.isListEmpty((List)(groupIds = data.getStringArrayListExtra("selectGroups")))) break;
                this.setExceptionForGroup(groupIds);
            }
        }
    }

    private void setExceptionForGroup(List<String> groupIds) {
        if (CollectionsUtil.isListEmpty(groupIds)) {
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] allSettings = mgr.getBlockAllSettings();
        if (allSettings == null) {
            return;
        }
        int action = allSettings[0];
        int type = allSettings[1];
        int notifyType = 1;
        if (action == 1 && type == 1) {
            notifyType = 1;
        } else if (action == 2) {
            notifyType = 3;
        } else if (action == 1 && type == 4) {
            notifyType = 2;
        }
        mgr.applyMUCSettings(groupIds, notifyType);
        this.mListView.updateData();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        MMZoomGroup group = this.mListView.getItem(position);
        if (group == null) {
            return;
        }
        MMNotificationGroupSettingsFragment.showAsActivity((Fragment)this, group.getGroupId());
    }
}

