/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.TimePicker;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import java.util.ArrayList;
import java.util.Calendar;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.androidlib.widget.ZMTimePickerDialog;
import us.zoom.videomeetings.R;

public class MMNotificationDndSettingsFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private CheckedTextView mChkDndScheduled;
    private TextView mTxtTimeFrom;
    private TextView mTxtTimeTo;
    private ZMTimePickerDialog mTimePickerDialog;
    private TextView mTxtSnoozed;
    private View mPanelDndFrom;
    private View mPanelDndTo;
    private NotificationSettingUI.INotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnDNDSettingsUpdated() {
            MMNotificationDndSettingsFragment.this.onDNDSettingsUpdated();
        }

        @Override
        public void OnDNDNowSettingUpdated() {
            MMNotificationDndSettingsFragment.this.onDNDNowSettingUpdated();
        }

        @Override
        public void OnSnoozeSettingsUpdated() {
            MMNotificationDndSettingsFragment.this.onSnoozeSettingsUpdated();
        }
    };

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMNotificationDndSettingsFragment.class.getName(), args, 0);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_notification_dnd, container, false);
        this.mChkDndScheduled = (CheckedTextView)view.findViewById(R.id.chkDndScheduled);
        this.mTxtTimeFrom = (TextView)view.findViewById(R.id.txtTimeFrom);
        this.mTxtTimeTo = (TextView)view.findViewById(R.id.txtTimeTo);
        this.mTxtSnoozed = (TextView)view.findViewById(R.id.txtSnoozed);
        this.mPanelDndFrom = view.findViewById(R.id.panelDndFrom);
        this.mPanelDndTo = view.findViewById(R.id.panelDndTo);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mPanelDndFrom.setOnClickListener((View.OnClickListener)this);
        this.mPanelDndTo.setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelSnoozed).setOnClickListener((View.OnClickListener)this);
        this.mChkDndScheduled.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
        NotificationSettingUI.getInstance().addListener(this.mListener);
    }

    public void onPause() {
        NotificationSettingUI.getInstance().removeListener(this.mListener);
        super.onPause();
    }

    private void updateUI() {
        long[] snoozeSettings;
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
        if (dndSettings != null) {
            if (dndSettings.isEnable()) {
                this.mChkDndScheduled.setChecked(true);
                this.mPanelDndTo.setVisibility(0);
                this.mPanelDndFrom.setVisibility(0);
            } else {
                this.mChkDndScheduled.setChecked(false);
                this.mPanelDndTo.setVisibility(8);
                this.mPanelDndFrom.setVisibility(8);
            }
            String start = dndSettings.isEnable() ? TimeUtil.formatTime((Context)this.getActivity(), (Calendar)dndSettings.getStart()) : "";
            String end = dndSettings.isEnable() ? TimeUtil.formatTime((Context)this.getActivity(), (Calendar)dndSettings.getEnd()) : "";
            this.mTxtTimeFrom.setText((CharSequence)start);
            this.mTxtTimeTo.setText((CharSequence)end);
        }
        if ((snoozeSettings = mgr.getSnoozeSettings()) != null) {
            if (snoozeSettings[2] > CmmTime.getMMNow()) {
                String start = TimeUtil.formatTime((Context)this.getActivity(), (long)snoozeSettings[1]);
                String end = TimeUtil.formatTime((Context)this.getActivity(), (long)snoozeSettings[2]);
                this.mTxtSnoozed.setText((CharSequence)this.getString(R.string.zm_lbl_notification_dnd_19898, new Object[]{start, end}));
            } else {
                this.mTxtSnoozed.setText((CharSequence)"");
            }
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void onDNDSettingsUpdated() {
        this.updateUI();
    }

    private void onDNDNowSettingUpdated() {
        this.updateUI();
    }

    public void onSnoozeSettingsUpdated() {
        this.updateUI();
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.panelDndFrom) {
            this.onClickPanelDndFrom();
        } else if (id2 == R.id.panelDndTo) {
            this.onClickPanelDndTo();
        } else if (id2 == R.id.chkDndScheduled) {
            this.onClickChkDndScheduled();
        } else if (id2 == R.id.panelSnoozed) {
            this.onClickPanelSnoozed();
        }
    }

    private void onClickPanelSnoozed() {
        String title = this.getString(R.string.zm_lbl_notification_snoozed_19898);
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        long[] snoozedSetting = mgr.getSnoozeSettings();
        if (snoozedSetting == null) {
            return;
        }
        long time = snoozedSetting[2] - snoozedSetting[1];
        if (time > 0L) {
            int t;
            long now = CmmTime.getMMNow();
            if (snoozedSetting[2] - now >= 0L && now - snoozedSetting[1] >= 0L) {
                time = snoozedSetting[2] - now;
            }
            if ((t = (int)(time / 60000L)) == 0) {
                t = 1;
            }
            String hour = t / 60 > 0 ? this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, t / 60, new Object[]{t / 60}) : "";
            String min = t % 60 > 0 ? this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_min_19898, t % 60, new Object[]{t % 60}) : "";
            title = this.getString(R.string.zm_lbl_notification_snoozed_resume_in_19898, new Object[]{hour, min});
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        ArrayList<SnoozedContextMenuItem> items = new ArrayList<SnoozedContextMenuItem>();
        if (time > 0L) {
            items.add(new SnoozedContextMenuItem(this.getString(R.string.zm_lbl_notification_snoozed_turn_off_19898), 0));
        }
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_min_19898, 20, new Object[]{20}), 1));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 1, new Object[]{1}), 2));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 2, new Object[]{2}), 3));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 4, new Object[]{4}), 4));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 8, new Object[]{8}), 5));
        TextView titleView = new TextView((Context)this.getActivity());
        if (Build.VERSION.SDK_INT < 23) {
            titleView.setTextAppearance((Context)this.getActivity(), R.style.ZMTextView_Small);
        } else {
            titleView.setTextAppearance(R.style.ZMTextView_Small);
        }
        int padding = UIUtil.dip2px((Context)this.getActivity(), (float)20.0f);
        titleView.setPadding(padding, padding, padding, padding / 2);
        titleView.setText((CharSequence)title);
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitleView((View)titleView).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SnoozedContextMenuItem mi = (SnoozedContextMenuItem)((Object)menuAdapter.getItem(which));
                MMNotificationDndSettingsFragment.this.onSelectContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectContextMenuItem(SnoozedContextMenuItem item) {
        if (item == null) {
            return;
        }
        int duration = 0;
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        switch (item.getAction()) {
            case 2: {
                duration = 60;
                break;
            }
            case 3: {
                duration = 120;
                break;
            }
            case 4: {
                duration = 240;
                break;
            }
            case 5: {
                duration = 480;
                break;
            }
            case 6: {
                duration = 1440;
                break;
            }
            case 1: {
                duration = 20;
                break;
            }
            case 0: {
                duration = 0;
                break;
            }
            default: {
                duration = 0;
            }
        }
        long now = CmmTime.getMMNow();
        mgr.applySnoozeSettings(duration, now, now + (long)(duration * 60000));
        this.updateUI();
    }

    private void onClickChkDndScheduled() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
        if (dndSettings == null) {
            return;
        }
        if (dndSettings.isEnable()) {
            dndSettings.setEnable(false);
        } else {
            dndSettings.setEnable(true);
            NotificationSettingMgr.DndSetting historySettings = mgr.getHistoryDNDSetting();
            int startHour = 17;
            int startMin = 0;
            int endHour = 9;
            int endMin = 0;
            if (historySettings != null) {
                startHour = historySettings.getStart().get(11);
                startMin = historySettings.getStart().get(12);
                endHour = historySettings.getEnd().get(11);
                endMin = historySettings.getEnd().get(12);
            }
            Calendar start = Calendar.getInstance();
            start.set(11, startHour);
            start.set(12, startMin);
            Calendar end = Calendar.getInstance();
            end.set(11, endHour);
            end.set(12, endMin);
            dndSettings.setEnd(end);
            dndSettings.setStart(start);
        }
        mgr.applyDndSettings(dndSettings);
        this.updateUI();
    }

    private void onClickPanelDndFrom() {
        if (this.mTimePickerDialog != null) {
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
        if (dndSettings == null) {
            return;
        }
        Calendar start = dndSettings.getStart();
        if (start == null) {
            start = Calendar.getInstance();
        }
        this.mTimePickerDialog = new ZMTimePickerDialog((Context)this.getActivity(), new ZMTimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                MMNotificationDndSettingsFragment.this.mTimePickerDialog = null;
                NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
                if (mgr == null) {
                    return;
                }
                NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
                if (dndSettings == null) {
                    return;
                }
                Calendar time = Calendar.getInstance();
                time.set(11, hourOfDay);
                time.set(12, minute);
                dndSettings.setStart(time);
                mgr.applyDndSettings(dndSettings);
                MMNotificationDndSettingsFragment.this.updateUI();
            }
        }, start.get(11), start.get(12), DateFormat.is24HourFormat((Context)this.getActivity()));
        this.mTimePickerDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                MMNotificationDndSettingsFragment.this.mTimePickerDialog = null;
            }
        });
        this.mTimePickerDialog.show();
    }

    private void onClickPanelDndTo() {
        if (this.mTimePickerDialog != null) {
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
        if (dndSettings == null) {
            return;
        }
        Calendar end = dndSettings.getEnd();
        if (end == null) {
            end = Calendar.getInstance();
        }
        this.mTimePickerDialog = new ZMTimePickerDialog((Context)this.getActivity(), new ZMTimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                MMNotificationDndSettingsFragment.this.mTimePickerDialog = null;
                NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
                if (mgr == null) {
                    return;
                }
                NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
                if (dndSettings == null) {
                    return;
                }
                Calendar time = Calendar.getInstance();
                time.set(11, hourOfDay);
                time.set(12, minute);
                dndSettings.setEnd(time);
                mgr.applyDndSettings(dndSettings);
                MMNotificationDndSettingsFragment.this.updateUI();
            }
        }, end.get(11), end.get(12), DateFormat.is24HourFormat((Context)this.getActivity()));
        this.mTimePickerDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                MMNotificationDndSettingsFragment.this.mTimePickerDialog = null;
            }
        });
        this.mTimePickerDialog.show();
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public static class SnoozedContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_TURN_OFF = 0;
        public static final int ACTION_20_MINUTE = 1;
        public static final int ACTION_1_HOUR = 2;
        public static final int ACTION_2_HOUR = 3;
        public static final int ACTION_4_HOUR = 4;
        public static final int ACTION_8_HOUR = 5;
        public static final int ACTION_24_HOUR = 6;

        public SnoozedContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

