/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.FileInfoChecker;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.ZMGifView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMAsyncTask;
import us.zoom.androidlib.widget.TouchImageView;
import us.zoom.videomeetings.R;

public class MMImageSendConfirmFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = MMImageSendConfirmFragment.class.getSimpleName();
    public static final String RESULT_IMAGE_PATH = "imagePath";
    public static final String ARG_IMAGE_URI = "imageUri";
    public static final String ARG_TRANS_PATH = "transPath";
    private static final int MAX_IMAGE_SIZE_TO_SEND_IN_AREA = 921600;
    private static final int MAX_IMAGE_FILE_SIZE = 0x100000;
    private Button mBtnBack;
    private View mBtnSend;
    private TouchImageView mViewImage;
    private ZMGifView mViewGif;
    private View mProgressBar;
    private View mViewPlaceHolder;
    private Uri mImageUri;
    private String mTransPath;
    private String mImagePath;
    private boolean mSendConfirmed = false;
    private ZMAsyncTask<Void, Void, String> mTaskTransPhoto = null;

    public static void showAsActivity(ZMActivity activity, String imageUri, String transPath, int requestCode) {
        Bundle args = new Bundle();
        args.putString(ARG_IMAGE_URI, imageUri);
        args.putString(ARG_TRANS_PATH, transPath);
        SimpleActivity.show(activity, MMImageSendConfirmFragment.class.getName(), args, requestCode);
    }

    public static void showAsActivity(Fragment fragment, String imageUri, String transPath, int requestCode) {
        Bundle args = new Bundle();
        args.putString(ARG_IMAGE_URI, imageUri);
        args.putString(ARG_TRANS_PATH, transPath);
        SimpleActivity.show(fragment, MMImageSendConfirmFragment.class.getName(), args, requestCode);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_image_send_confirm, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSend = view.findViewById(R.id.btnSend);
        this.mViewImage = (TouchImageView)view.findViewById(R.id.viewImage);
        this.mProgressBar = view.findViewById(R.id.progressBar1);
        this.mViewPlaceHolder = view.findViewById(R.id.viewPlaceHolder);
        this.mViewGif = (ZMGifView)view.findViewById(R.id.viewGif);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState != null) {
            this.mImagePath = savedInstanceState.getString("mImagePath");
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString("mImagePath", this.mImagePath);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        FragmentActivity activity;
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            String sUri = args.getString(ARG_IMAGE_URI);
            if (sUri != null) {
                this.mImageUri = Uri.parse((String)sUri);
            }
            this.mTransPath = args.getString(ARG_TRANS_PATH);
        }
        if ((activity = this.getActivity()) != null) {
            activity.setRequestedOrientation(4);
        }
        if (this.needExternalStoragePermission()) {
            this.zm_requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 0);
        }
    }

    private void loadImage() {
        if (!StringUtil.isEmptyOrNull((String)this.mImagePath)) {
            this.updateUIForLoadSuccess();
            return;
        }
        this.mTaskTransPhoto = new ZMAsyncTask<Void, Void, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doInBackground(Void ... params) {
                if (MMImageSendConfirmFragment.this.mImageUri == null) {
                    return null;
                }
                String origFile = ImageUtil.getPathFromUri((Context)VideoBoxApplication.getInstance(), MMImageSendConfirmFragment.this.mImageUri);
                boolean isLocalFile = origFile != null && origFile.startsWith(File.separator);
                String ext = origFile != null && (origFile.endsWith(".png") || origFile.endsWith(".PNG")) ? "png" : "jpg";
                String filePath = AppUtil.createTempFile("pic", MMImageSendConfirmFragment.this.mTransPath, ext);
                String scheme = MMImageSendConfirmFragment.this.mImageUri.getScheme();
                if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                    String file = null;
                    try {
                        file = FileUtils.downloadFile((Context)MMImageSendConfirmFragment.this.getActivity(), (URL)new URL(MMImageSendConfirmFragment.this.mImageUri.toString()));
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                    if (file == null) {
                        return null;
                    }
                    if (ImageUtil.getImageMimeType(file).equals("image/gif") && FileUtils.copyFile((String)file, (String)(filePath = AppUtil.createTempFile("pic", MMImageSendConfirmFragment.this.mTransPath, "gif")))) {
                        return filePath;
                    }
                    filePath = file;
                } else if (isLocalFile) {
                    String imageType = ImageUtil.getImageMimeType(origFile);
                    if ("image/gif".equals(imageType) && FileUtils.copyFile((String)origFile, (String)(filePath = AppUtil.createTempFile("pic", MMImageSendConfirmFragment.this.mTransPath, "gif")))) {
                        return filePath;
                    }
                    if (!FileUtils.copyFile((String)origFile, (String)filePath)) {
                        return null;
                    }
                } else {
                    File file = new File(filePath);
                    if (!file.exists()) {
                        boolean res = false;
                        try {
                            res = file.createNewFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!res) {
                            return null;
                        }
                    }
                    FileOutputStream os = null;
                    InputStream is = null;
                    try {
                        os = new FileOutputStream(file);
                        is = MMImageSendConfirmFragment.this.getActivity().getContentResolver().openInputStream(MMImageSendConfirmFragment.this.mImageUri);
                        if (is != null) {
                            byte[] buff = new byte[8192];
                            int count = -1;
                            while ((count = is.read(buff)) > 0) {
                                ((OutputStream)os).write(buff, 0, count);
                            }
                        }
                    }
                    catch (Exception e) {
                        String string2 = null;
                        return string2;
                    }
                    finally {
                        if (os != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (ImageUtil.getImageMimeType(filePath).equals("image/png")) {
                    return filePath;
                }
                if (!ImageUtil.compressImage(filePath, 0x100000)) {
                    return null;
                }
                return filePath;
            }

            protected void onPostExecute(String filePath) {
                MMImageSendConfirmFragment.this.mTaskTransPhoto = null;
                if (!MMImageSendConfirmFragment.this.isResumed() || this.isCancelled()) {
                    return;
                }
                if (filePath == null) {
                    MMImageSendConfirmFragment.this.onLoadFailed();
                } else {
                    MMImageSendConfirmFragment.this.onLoadSuccess(filePath);
                }
            }
        };
        this.mViewPlaceHolder.setVisibility(8);
        this.mProgressBar.setVisibility(0);
        this.mBtnSend.setEnabled(false);
        this.mTaskTransPhoto.execute((Object[])new Void[0]);
    }

    private void onLoadFailed() {
        this.mViewPlaceHolder.setVisibility(0);
        this.mProgressBar.setVisibility(8);
    }

    private void onLoadSuccess(String filePath) {
        this.mImagePath = filePath;
        this.updateUIForLoadSuccess();
    }

    private void updateUIForLoadSuccess() {
        this.mViewPlaceHolder.setVisibility(8);
        this.mProgressBar.setVisibility(8);
        File file = new File(this.mImagePath);
        if (file.length() >= 0x800000L) {
            SimpleMessageDialog.newInstance(R.string.zm_msg_img_too_large, true).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
        }
        if ("image/gif".equals(ImageUtil.getImageMimeType(this.mImagePath))) {
            this.mViewGif.setVisibility(0);
            this.mViewImage.setVisibility(8);
            this.mViewGif.setGifResourse(this.mImagePath);
            FileInfoChecker checker = PTApp.getInstance().getZoomFileInfoChecker();
            if (!checker.isLegalGif(this.mImagePath)) {
                SimpleMessageDialog.newInstance(R.string.zm_msg_illegal_image, true).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
                return;
            }
        } else {
            Bitmap bmp;
            this.mViewGif.setVisibility(8);
            this.mViewImage.setVisibility(0);
            if (!this.mViewImage.hasImage() && (bmp = ZMBitmapFactory.decodeFile(this.mImagePath)) != null) {
                this.mViewImage.setImageBitmap(bmp);
            }
        }
        this.mBtnSend.setEnabled(true);
    }

    public void onPause() {
        super.onPause();
        if (this.mTaskTransPhoto != null && this.mTaskTransPhoto.getStatus() == ZMAsyncTask.Status.RUNNING) {
            this.mTaskTransPhoto.cancel(true);
            this.mTaskTransPhoto = null;
        }
    }

    public void onResume() {
        super.onResume();
        if (!this.needExternalStoragePermission()) {
            this.loadImage();
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("MMImageSendConfirmForPermission"){

            public void run(IUIElement ui) {
                ((MMImageSendConfirmFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        this.loadImage();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (!StringUtil.isEmptyOrNull((String)this.mImagePath)) {
            try {
                new File(this.mImagePath).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (!this.getShowsDialog()) {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            if (activity.isFinishing() && !this.mSendConfirmed && !StringUtil.isEmptyOrNull((String)this.mImagePath)) {
                try {
                    new File(this.mImagePath).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mBtnSend) {
            this.onClickBtnSend();
        }
    }

    private boolean needExternalStoragePermission() {
        boolean isLocalFile;
        String appDataPath = AppUtil.getDataPath();
        String origFile = ImageUtil.getPathFromUri((Context)VideoBoxApplication.getInstance(), this.mImageUri);
        boolean bl = isLocalFile = origFile != null && origFile.startsWith(File.separator);
        if (!StringUtil.isEmptyOrNull((String)origFile) && !StringUtil.isEmptyOrNull((String)appDataPath) && isLocalFile && origFile.startsWith(appDataPath)) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0;
    }

    private void onClickBtnBack() {
        this.dimiss();
    }

    private void dimiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    private void onClickBtnSend() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        if (this.getShowsDialog()) {
            super.dismiss();
        } else {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity != null) {
                this.mSendConfirmed = true;
                Intent intent = new Intent();
                intent.putExtra(RESULT_IMAGE_PATH, this.mImagePath);
                activity.setResult(-1, intent);
                activity.finish();
            }
        }
    }
}

