/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessageTemplateUI;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessageTemplate;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.tempbean.IMessageTemplateFieldItem;
import com.zipow.videobox.tempbean.IMessageTemplateMessage;
import com.zipow.videobox.tempbean.IZoomMessageTemplate;
import com.zipow.videobox.util.ZMActionMsgUtil;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.util.Map;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMEditTemplateFragment
extends ZMDialogFragment
implements View.OnClickListener,
SimpleActivity.ExtListener {
    private static final String ARGS_SESSION_ID = "session_id";
    public static final String ARGS_GUID = "guid";
    public static final String ARGS_EVENT_ID = "event_id";
    private TextView mBtnCancel;
    private TextView mBtnDone;
    private TextView mTitle;
    private EditText mContent;
    private String mSessionId;
    private String mGuid;
    private String mEventID;
    private MMMessageItem mMessageItem;
    private IZoomMessageTemplate mMessageTemplate;
    private Object editItem;
    private String reqID;
    private ZoomMessageTemplateUI.SimpleZoomMessageTemplateUIListener mZoomMessageTemplateUIListener;

    public static void showAsFragment(Fragment fragment, String sessionId, String guid, String eventID) {
        MMEditTemplateFragment.showAsFragment(fragment, sessionId, guid, eventID, -1);
    }

    public static void showAsFragment(Fragment fragment, String sessionId, String guid, String eventID, int requestCode) {
        Bundle args = new Bundle();
        args.putString(ARGS_SESSION_ID, sessionId == null ? "" : sessionId);
        args.putString(ARGS_GUID, guid == null ? "" : guid);
        args.putString(ARGS_EVENT_ID, eventID == null ? "" : eventID);
        SimpleActivity.show(fragment, MMEditTemplateFragment.class.getName(), args, requestCode, 2);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.zm_mm_edit_template, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mBtnCancel = (TextView)view.findViewById(R.id.btn_cancel);
        this.mBtnDone = (TextView)view.findViewById(R.id.btn_done);
        this.mTitle = (TextView)view.findViewById(R.id.title);
        this.mContent = (EditText)view.findViewById(R.id.ext_content);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        ZoomMessenger messenger;
        super.onActivityCreated(savedInstanceState);
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnDone.setOnClickListener((View.OnClickListener)this);
        this.mContent.setOnClickListener((View.OnClickListener)this);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mSessionId = bundle.getString(ARGS_SESSION_ID);
            this.mGuid = bundle.getString(ARGS_GUID);
            this.mEventID = bundle.getString(ARGS_EVENT_ID);
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        ZoomMessage mZoomMessage = session.getMessageByXMPPGuid(this.mGuid);
        if (mZoomMessage == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getMyself();
        if (buddy == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        boolean isOutMessage = StringUtil.isSameString((String)mZoomMessage.getSenderID(), (String)buddy.getJid());
        this.mMessageItem = MMMessageItem.initWithZoomMessage(mZoomMessage, this.mSessionId, messenger, session.isGroup(), isOutMessage, (Context)this.getActivity(), IMAddrBookItem.fromZoomBuddy(session.getSessionBuddy()), mgr);
        if (this.mMessageItem == null) {
            return;
        }
        this.mMessageTemplate = this.mMessageItem.template;
        if (this.mMessageTemplate == null) {
            return;
        }
        this.editItem = this.mMessageTemplate.findEditItem(this.mEventID);
        if (this.editItem == null) {
            return;
        }
        if (this.editItem instanceof IMessageTemplateMessage) {
            IMessageTemplateMessage item = (IMessageTemplateMessage)this.editItem;
            this.mContent.setText((CharSequence)item.getText());
        } else if (this.editItem instanceof IMessageTemplateFieldItem) {
            IMessageTemplateFieldItem item = (IMessageTemplateFieldItem)this.editItem;
            this.mContent.setText((CharSequence)item.getValue());
        }
        this.mContent.setSelection(this.mContent.getText().length());
        this.mContent.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (TextUtils.isEmpty((CharSequence)editable)) {
                    MMEditTemplateFragment.this.mBtnDone.setEnabled(false);
                } else {
                    MMEditTemplateFragment.this.mBtnDone.setEnabled(true);
                }
            }
        });
        this.mZoomMessageTemplateUIListener = new ZoomMessageTemplateUI.SimpleZoomMessageTemplateUIListener(){

            @Override
            public void Notify_SendPostHttpMessageDone(String reqID, int result) {
                MMEditTemplateFragment.this.handleResult(reqID, result);
                super.Notify_SendPostHttpMessageDone(reqID, result);
            }

            @Override
            public void Notify_SendGetHttpMessageDone(String reqID, int result) {
                MMEditTemplateFragment.this.handleResult(reqID, result);
                super.Notify_SendGetHttpMessageDone(reqID, result);
            }
        };
        ZoomMessageTemplateUI.getInstance().addListener(this.mZoomMessageTemplateUIListener);
    }

    private void handleResult(String reqID, int result) {
        if (!TextUtils.isEmpty((CharSequence)reqID) && TextUtils.equals((CharSequence)reqID, (CharSequence)this.reqID)) {
            if (result == 0) {
                if (this.getActivity() != null) {
                    if (this.mMessageTemplate == null) {
                        return;
                    }
                    ZoomMessageTemplate messageTemplate = PTApp.getInstance().getZoomMessageTemplate();
                    if (messageTemplate == null) {
                        return;
                    }
                    messageTemplate.updateMessageBodyByJson(this.mSessionId, this.mGuid, this.mMessageTemplate.toJSONString());
                    Intent intent = new Intent();
                    intent.putExtra(ARGS_GUID, this.mGuid);
                    this.getActivity().setResult(-1, intent);
                    this.getActivity().finish();
                }
            } else {
                this.mBtnCancel.setEnabled(true);
                this.mBtnDone.setEnabled(true);
                this.mTitle.setText((CharSequence)this.getResources().getString(R.string.zm_mm_edit_message_19884));
            }
        }
    }

    public void onDestroy() {
        ZoomMessageTemplateUI.getInstance().removeListener(this.mZoomMessageTemplateUIListener);
        super.onDestroy();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_cancel) {
            this.dismiss();
        } else if (id2 == R.id.btn_done) {
            this.onClickDone();
        }
    }

    private void onClickDone() {
        Object item;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (this.mMessageItem == null) {
            return;
        }
        ZoomMessageTemplate messageTemplate = PTApp.getInstance().getZoomMessageTemplate();
        if (messageTemplate == null) {
            return;
        }
        if (this.editItem == null) {
            return;
        }
        String event = "";
        String event_id = "";
        String oldStr = "";
        if (this.editItem instanceof IMessageTemplateMessage) {
            item = (IMessageTemplateMessage)this.editItem;
            event = ((IMessageTemplateMessage)item).getEvent();
            event_id = ((IMessageTemplateMessage)item).getEvent_id();
            oldStr = ((IMessageTemplateMessage)item).getText();
        } else if (this.editItem instanceof IMessageTemplateFieldItem) {
            item = (IMessageTemplateFieldItem)this.editItem;
            event = ((IMessageTemplateFieldItem)item).getEvent();
            event_id = ((IMessageTemplateFieldItem)item).getEvent_id();
            oldStr = ((IMessageTemplateFieldItem)item).getValue();
        }
        if (TextUtils.isEmpty((CharSequence)event) || TextUtils.isEmpty((CharSequence)event_id)) {
            return;
        }
        if (TextUtils.equals((CharSequence)oldStr, (CharSequence)this.mContent.getText())) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mContent.getText())) {
            return;
        }
        if (this.editItem instanceof IMessageTemplateMessage) {
            item = (IMessageTemplateMessage)this.editItem;
            ((IMessageTemplateMessage)item).setText(this.mContent.getText().toString());
        } else if (this.editItem instanceof IMessageTemplateFieldItem) {
            item = (IMessageTemplateFieldItem)this.editItem;
            ((IMessageTemplateFieldItem)item).setValue(this.mContent.getText().toString());
        }
        Map<String, String> params = ZMActionMsgUtil.parseActionMsgParams(event);
        if (params != null) {
            params.put("eventid", event_id);
            params.put("text", this.mContent.getText().toString());
            this.reqID = ZMActionMsgUtil.sendHttpMsg(params, true);
            if (this.reqID != null && this.getActivity() != null) {
                this.mBtnDone.setEnabled(false);
                this.mBtnCancel.setEnabled(false);
                this.mTitle.setText((CharSequence)this.getResources().getString(R.string.zm_mm_edit_message_saving_19884));
                UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mContent);
            }
        }
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (!this.mContent.hasFocus()) {
            this.mContent.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }
}

