/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.TextCommandHelper;
import com.zipow.videobox.view.CommandEditText;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerInputView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.videomeetings.R;

public class MMEditMessageFragment
extends ZMDialogFragment
implements View.OnClickListener,
SimpleActivity.ExtListener,
StickerInputView.OnPrivateStickerSelectListener,
CommandEditText.OnCommandActionListener {
    private static final int MODE_KEYBOARD = 0;
    private static final int MODE_EMOJI = 1;
    private static final int REQUEST_SELECT_CONTACT = 105;
    private static final String ARGS_SESSION_ID = "session_id";
    public static final String ARGS_GUID = "guid";
    public static final String ARGS_SERVER_TIME = "server_time";
    private TextView mBtnCancel;
    private TextView mBtnDone;
    private TextView mTitle;
    private CommandEditText mContent;
    private ImageButton mBtnKeyBoard;
    private ImageButton mBtnEmojis;
    private StickerInputView mPanelEmojis;
    private String mSessionId;
    private String mGuid;
    private ZoomMessage mZoomMessage;
    private int mMode = 0;
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener;

    public static void showAsFragment(Fragment fragment, String sessionId, String guid) {
        MMEditMessageFragment.showAsFragment(fragment, sessionId, guid, -1);
    }

    public static void showAsFragment(Fragment fragment, String sessionId, String guid, int requestCode) {
        Bundle args = new Bundle();
        args.putString(ARGS_SESSION_ID, sessionId == null ? "" : sessionId);
        args.putString(ARGS_GUID, guid == null ? "" : guid);
        SimpleActivity.show(fragment, MMEditMessageFragment.class.getName(), args, requestCode, 2);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putInt("mMode", this.mMode);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.zm_mm_edit_message, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mBtnCancel = (TextView)view.findViewById(R.id.btn_cancel);
        this.mBtnDone = (TextView)view.findViewById(R.id.btn_done);
        this.mTitle = (TextView)view.findViewById(R.id.title);
        this.mContent = (CommandEditText)view.findViewById(R.id.ext_content);
        this.mContent.setEnableLine(false);
        this.mBtnKeyBoard = (ImageButton)view.findViewById(R.id.btnSetModeKeyboard);
        this.mPanelEmojis = (StickerInputView)view.findViewById(R.id.panelEmojis);
        this.mPanelEmojis.disableCustomSticker();
        this.mPanelEmojis.disableGiphy();
        this.mBtnEmojis = (ImageButton)view.findViewById(R.id.btnEmoji);
        if (savedInstanceState != null) {
            this.mMode = savedInstanceState.getInt("mMode", 0);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        ZoomMessenger messenger;
        super.onActivityCreated(savedInstanceState);
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnDone.setOnClickListener((View.OnClickListener)this);
        this.mBtnEmojis.setOnClickListener((View.OnClickListener)this);
        this.mBtnKeyBoard.setOnClickListener((View.OnClickListener)this);
        this.mPanelEmojis.setEmojiInputEditText((EditText)this.mContent);
        this.mPanelEmojis.setOnPrivateStickerSelectListener(this);
        this.mContent.setOnClickListener(this);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mSessionId = bundle.getString(ARGS_SESSION_ID);
            this.mGuid = bundle.getString(ARGS_GUID);
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        this.mZoomMessage = session.getMessageByXMPPGuid(this.mGuid);
        if (this.mZoomMessage == null) {
            return;
        }
        this.mContent.setText(this.mZoomMessage.getBody());
        List<String> atList = this.mZoomMessage.getMsgAtList();
        if (this.mZoomMessage.isMessageAtEveryone()) {
            if (atList == null) {
                atList = new ArrayList<String>();
            }
            atList.add("jid_select_everyone");
        }
        if (atList != null && !atList.isEmpty()) {
            for (String jid : atList) {
                this.mContent.addAtCommandByJid(jid);
            }
        }
        this.mContent.setSelection(this.mContent.getText().length());
        this.mContent.setOnCommandActionListener(this);
        this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

            @Override
            public void Indicate_EditMessageResultIml(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
                if (TextUtils.isEmpty((CharSequence)guid) || !TextUtils.equals((CharSequence)guid, (CharSequence)MMEditMessageFragment.this.mGuid)) {
                    return;
                }
                if (result) {
                    if (MMEditMessageFragment.this.getActivity() != null) {
                        Intent intent = new Intent();
                        intent.putExtra(MMEditMessageFragment.ARGS_GUID, guid);
                        intent.putExtra(MMEditMessageFragment.ARGS_SERVER_TIME, serverTime);
                        MMEditMessageFragment.this.getActivity().setResult(-1, intent);
                        MMEditMessageFragment.this.getActivity().finish();
                    }
                } else {
                    MMEditMessageFragment.this.mBtnCancel.setEnabled(true);
                    MMEditMessageFragment.this.mBtnDone.setEnabled(true);
                    MMEditMessageFragment.this.mTitle.setText((CharSequence)MMEditMessageFragment.this.getResources().getString(R.string.zm_mm_edit_message_19884));
                }
            }
        };
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
    }

    public void onDestroy() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroy();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_cancel) {
            this.dismiss();
        } else if (id2 == R.id.btn_done) {
            this.onClickDone();
        } else if (id2 == R.id.btnSetModeKeyboard) {
            this.onClickSetModeKeyboard();
        } else if (id2 == R.id.btnEmoji) {
            this.onClickBtnEmoji();
        } else if (id2 == R.id.ext_content) {
            this.mMode = 0;
            this.updateUIMode(this.mMode);
        }
    }

    private void onClickDone() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (this.mZoomMessage == null) {
            return;
        }
        ArrayList<String> atList = new ArrayList<String>();
        boolean hasAtAll = false;
        List<TextCommandHelper.SpanBean> list = this.mContent.getTextCommand(2);
        if (list != null && !list.isEmpty()) {
            for (TextCommandHelper.SpanBean spanBean : list) {
                String label = this.mContent.getText().subSequence(spanBean.getStart(), spanBean.getEnd()).toString();
                if (!StringUtil.isSameString((String)label, (String)spanBean.getLabel()) || spanBean.getEnd() >= 4096 || atList.contains(spanBean.getJid())) continue;
                if (StringUtil.isSameString((String)spanBean.getJid(), (String)"jid_select_everyone")) {
                    hasAtAll = true;
                    continue;
                }
                atList.add(spanBean.getJid());
            }
        }
        if (session.editMessageByXMPPGuid(this.mContent.getText().toString(), this.mGuid, this.mSessionId, atList, hasAtAll)) {
            this.mBtnDone.setEnabled(false);
            this.mBtnCancel.setEnabled(false);
            this.mTitle.setText((CharSequence)this.getResources().getString(R.string.zm_mm_edit_message_saving_19884));
        }
        if (this.getActivity() != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mContent);
        }
    }

    private void onClickSetModeKeyboard() {
        this.mMode = 0;
        this.updateUIMode(this.mMode);
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mContent);
    }

    private void onClickBtnEmoji() {
        this.mMode = 1;
        this.updateUIMode(this.mMode);
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        SimpleActivity simpleActivity;
        ZMKeyboardDetector keyboardDetector;
        if (!this.mContent.hasFocus()) {
            this.mContent.requestFocus();
        }
        this.mMode = 0;
        this.updateUIMode(this.mMode);
        if (this.getActivity() instanceof SimpleActivity && (keyboardDetector = (simpleActivity = (SimpleActivity)this.getActivity()).getKeyboardDetector()) != null) {
            this.mPanelEmojis.setKeyboardHeight(keyboardDetector.getKeyboardHeight());
        }
    }

    private void updateUIMode(int mode) {
        switch (mode) {
            case 1: {
                this.mPanelEmojis.setVisibility(0);
                this.mBtnEmojis.setVisibility(8);
                this.mBtnKeyBoard.setVisibility(0);
                UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mContent);
                break;
            }
            default: {
                this.mPanelEmojis.setVisibility(8);
                this.mBtnEmojis.setVisibility(0);
                this.mBtnKeyBoard.setVisibility(8);
            }
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mMode == 1) {
            this.mPanelEmojis.setVisibility(0);
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.mMode == 1) {
            this.mMode = 0;
            this.updateUIMode(this.mMode);
            return true;
        }
        return false;
    }

    @Override
    public void onPrivateStickerSelect(StickerEvent sticker) {
        if (sticker == null || StringUtil.isEmptyOrNull((String)sticker.getStickerId())) {
            return;
        }
        MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (mgr == null) {
            return;
        }
        PTAppProtos.StickerInfo.Builder builder = PTAppProtos.StickerInfo.newBuilder();
        builder.setFileId(sticker.getStickerId());
        builder.setStatus(sticker.getStatus());
        if (sticker.getStickerPath() != null) {
            builder.setUploadingPath(sticker.getStickerPath());
        }
        if (mgr.sendSticker(builder.build(), this.mSessionId) != 1) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.zm_hint_sticker_send_failed, (int)1).show();
        }
    }

    @Override
    public void onCommandAction(int type) {
        if (type == 2) {
            this.selectATBuddy();
        }
    }

    private void onATBuddySelect(IMAddrBookItem item) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getMyself();
        if (buddy == null) {
            return;
        }
        if (item == null || TextUtils.isEmpty((CharSequence)buddy.getJid()) || TextUtils.isEmpty((CharSequence)item.getJid()) || buddy.getJid().equals(item.getJid())) {
            return;
        }
        String input = '@' + item.getScreenName() + " ";
        int startCursor = this.mContent.getSelectionStart();
        if (startCursor > 0 && this.mContent.getEditableText().charAt(startCursor - 1) == '@') {
            this.mContent.getEditableText().delete(startCursor - 1, startCursor);
            --startCursor;
        }
        this.mContent.addTextCommand(2, input, item.getJid(), startCursor);
        if (this.mMode != 0) {
            this.mMode = 0;
            this.updateUIMode(this.mMode);
            this.mContent.requestFocus();
            UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mContent);
        }
    }

    private void selectATBuddy() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (!session.isGroup()) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        String title = activity.getString(R.string.zm_mm_title_select_a_contact);
        String btnOkText = activity.getString(R.string.zm_btn_ok);
        MMSelectContactsActivity.show((Fragment)this, title, null, btnOkText, null, false, null, true, 105, true, session.getSessionId());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList abItems;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 105 && resultCode == -1 && data != null && (abItems = (ArrayList)data.getSerializableExtra("selectedItems")) != null && abItems.size() == 1) {
            IMAddrBookItem item = (IMAddrBookItem)abItems.get(0);
            this.onATBuddySelect(item);
        }
    }
}

