/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.IMSearchFragment;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.AutoStreamConflictChecker;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.MeetingToolbar;
import com.zipow.videobox.view.mm.MMChatsListView;
import com.zipow.videobox.view.mm.MMContactSearchFragment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMTextViewWithImages;
import us.zoom.videomeetings.R;

public class MMChatsListFragment
extends ZMFragment
implements View.OnClickListener,
TextView.OnEditorActionListener,
ABContactsCache.IABContactsCacheListener,
PTUI.IPTUIListener,
PTUI.IMeetingMgrListener,
View.OnLongClickListener,
VideoBoxApplication.IConfProcessListener {
    private final String TAG = MMChatsListFragment.class.getSimpleName();
    public static final int REQUEST_MM_NEW_CHAT = 100;
    private MMChatsListView mChatsListView;
    private EditText mEdtSearch;
    private Button mBtnClearSearchView;
    private View mBtnNewChat;
    private View mBtnSettings;
    private View mPanelConnectionAlert;
    private TextView mTxtNetworkAlert;
    private TextView mTxtTitle;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private View mPanelSearch;
    private ImageButton mBtnSearch;
    private View mEmptyView;
    private ZMTextViewWithImages mZMTextViewWithImages;
    private MeetingToolbar mMeetingToolbar;
    private View mLlContent;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private BroadcastReceiver mNetworkStateReceiver;
    private Runnable mRunnableUpdateSessionList;
    private ArrayList<String> mUpdatedBuddyJids = new ArrayList();
    private Runnable mRunnableHandleBuddyUpdate = new Runnable(){

        @Override
        public void run() {
            if (MMChatsListFragment.this.mUpdatedBuddyJids.size() > 10) {
                MMChatsListFragment.this.mChatsListView.refresh();
            } else if (MMChatsListFragment.this.mChatsListView != null) {
                for (String jid : MMChatsListFragment.this.mUpdatedBuddyJids) {
                    MMChatsListFragment.this.handleIndicateBuddyInfoUpdatedWithJID(jid);
                }
            }
            MMChatsListFragment.this.updatePanelNoItemMsg();
            MMChatsListFragment.this.mUpdatedBuddyJids.clear();
            MMChatsListFragment.this.mHandler.postDelayed(MMChatsListFragment.this.mRunnableHandleBuddyUpdate, 2000L);
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onBeginConnect() {
            MMChatsListFragment.this.onBeginConnect();
        }

        @Override
        public void onConnectReturn(int errorCode) {
            MMChatsListFragment.this.onConnectReturn(errorCode);
        }

        @Override
        public void onIndicateBuddyInfoUpdated(String phoneNumber) {
            MMChatsListFragment.this.onIndicateBuddyInfoUpdated(phoneNumber);
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMChatsListFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
        }

        @Override
        public void onIndicateBuddyListUpdated() {
            MMChatsListFragment.this.onIndicateBuddyListUpdated();
        }

        @Override
        public void onGroupAction(int result, GroupAction action, String msgId) {
            MMChatsListFragment.this.onGroupAction(result, action, msgId);
        }

        @Override
        public void onNotify_ChatSessionListUpdate() {
            MMChatsListFragment.this.onNotify_ChatSessionListUpdate();
        }

        @Override
        public void Indicate_OnlineBuddies(List<String> jidList) {
            if (jidList != null) {
                for (String jid : jidList) {
                    MMChatsListFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
                }
            }
        }

        @Override
        public void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
            if (onLines != null) {
                for (String jid : onLines) {
                    MMChatsListFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
                }
            }
            if (offlines != null) {
                for (String jid : offlines) {
                    MMChatsListFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
                }
            }
        }

        @Override
        public void Indicate_BuddyPresenceChanged(String jid) {
            MMChatsListFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
        }

        @Override
        public void onConfirm_MessageSent(String sessionId, String messageId, int result) {
            MMChatsListFragment.this.onConfirm_MessageSent(sessionId, messageId, result);
        }

        @Override
        public boolean onIndicateMessageReceived(String sessionId, String senderJid, String messageId) {
            return MMChatsListFragment.this.onIndicateMessageReceived(sessionId, senderJid, messageId);
        }

        @Override
        public boolean onNotifySubscribeRequest(String jid, String msg) {
            return MMChatsListFragment.this.onNotifySubscribeRequest();
        }

        @Override
        public boolean onNotifySubscriptionAccepted(String jid) {
            return MMChatsListFragment.this.onNotifySubscribeRequest();
        }

        @Override
        public boolean onNotifySubscriptionDenied(String jid) {
            return MMChatsListFragment.this.onNotifySubscribeRequest();
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            MMChatsListFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }

        @Override
        public void onNotifySubscribeRequestUpdated(String jid) {
            MMChatsListFragment.this.refreshSubcribeRequest();
        }

        @Override
        public void On_DestroyGroup(int result, String actionOwner, String groupID, String groupName, long tm) {
            MMChatsListFragment.this.On_DestroyGroup(result, actionOwner, groupID, groupName, tm);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMChatsListFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }

        @Override
        public void Indicate_RevokeMessageResult(String actionOwner, String sessionId, String guid, String recallMsgId, boolean result) {
            MMChatsListFragment.this.Indicate_RevokeMessageResult(actionOwner, sessionId, guid, recallMsgId, result);
        }

        @Override
        public void Indicate_EditMessageResultIml(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
            MMChatsListFragment.this.Indicate_EditMessageResultIml(actionOwner, sessionId, guid, msgTime, serverTime, result);
        }

        @Override
        public void onNotify_ChatSessionUnreadUpdate() {
            MMChatsListFragment.this.refreshChatSessionUnread();
        }

        @Override
        public void onNotify_ChatSessionUpdate(String sessionId) {
            MMChatsListFragment.this.onNotify_ChatSessionUpdate(sessionId);
        }

        @Override
        public void Notify_DBLoadSessionLastMessagesDone() {
            MMChatsListFragment.this.notify_DBLoadSessionLastMessagesDone();
        }
    };

    private void pushBuddyUpdateEventToQueue(String jid) {
        if (jid != null) {
            this.mUpdatedBuddyJids.add(jid);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        boolean isE2E;
        ZoomMessenger messenger;
        View view = inflater.inflate(R.layout.zm_mm_chats_list, container, false);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mChatsListView = (MMChatsListView)view.findViewById(R.id.chatsListView);
        this.mEmptyView = view.findViewById(R.id.rlEmptyView);
        this.mZMTextViewWithImages = (ZMTextViewWithImages)this.mEmptyView.findViewById(R.id.zmTvi);
        this.mBtnNewChat = view.findViewById(R.id.btnNewChat);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelConnectionAlert = view.findViewById(R.id.panelConnectionAlert);
        this.mTxtNetworkAlert = (TextView)view.findViewById(R.id.txtNetworkAlert);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        this.mBtnSearch = (ImageButton)view.findViewById(R.id.btnSearch);
        this.mBtnSettings = view.findViewById(R.id.btnSettings);
        this.mMeetingToolbar = (MeetingToolbar)view.findViewById(R.id.meetingToolbar);
        this.mLlContent = view.findViewById(R.id.llContent);
        this.mChatsListView.setParentFragment(this);
        this.mMeetingToolbar.setParentFragment(this);
        this.mBtnNewChat.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mPanelConnectionAlert.setOnClickListener((View.OnClickListener)this);
        this.mBtnSearch.setOnClickListener((View.OnClickListener)this);
        this.mBtnSettings.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnClickListener((View.OnClickListener)this);
        if (this.getActivity() instanceof IMActivity && !((IMActivity)this.getActivity()).isKeyboardOpen()) {
            this.onKeyboardClosed();
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        boolean isImDisable = (messenger = PTApp.getInstance().getZoomMessenger()) == null || messenger.imChatGetOption() == 2;
        boolean bl = isE2E = messenger == null || messenger.e2eGetMyOption() == 2;
        if (!PTApp.getInstance().hasZoomMessenger() || isImDisable) {
            this.mPanelSearch.setVisibility(8);
            this.mBtnSearch.setVisibility(8);
        } else if (isE2E) {
            this.mBtnSearch.setVisibility(8);
        }
        return view;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void updatePanelConnectionAlert() {
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelConnectionAlert.setVisibility(8);
            return;
        }
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
                case -1: 
                case 1: 
                case 2: {
                    this.mPanelConnectionAlert.setVisibility(8);
                    break;
                }
                case 0: {
                    this.mPanelConnectionAlert.setVisibility(0);
                    if (this.mTxtNetworkAlert == null) break;
                    this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_stream_conflict);
                }
            }
        } else {
            this.mPanelConnectionAlert.setVisibility(0);
            if (this.mTxtNetworkAlert != null) {
                this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_network_unavailable);
            }
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearch.hasFocus()) {
            this.mEdtSearch.setCursorVisible(true);
            this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
            this.mPanelTitleBar.setVisibility(8);
            this.mListContainer.setForeground(this.mDimmedForground);
        }
    }

    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
        this.mListContainer.setForeground(null);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MMChatsListFragment.this.isResumed()) {
                    MMChatsListFragment.this.mPanelTitleBar.setVisibility(0);
                }
            }
        });
    }

    public void onResume() {
        super.onResume();
        if (ZmPtUtils.isEnableIM()) {
            this.mLlContent.setVisibility(0);
            this.mMeetingToolbar.setVisibility(8);
            this.mBtnNewChat.setVisibility(0);
            this.mZMTextViewWithImages.setVisibility(0);
        } else {
            this.mLlContent.setVisibility(8);
            this.mMeetingToolbar.setVisibility(0);
            this.mBtnNewChat.setVisibility(4);
            this.mZMTextViewWithImages.setVisibility(8);
            this.mMeetingToolbar.refresh();
        }
        if (this.mChatsListView != null) {
            this.mChatsListView.onParentFragmentResume();
        }
        NotificationMgr.removeMessageNotificationMM((Context)this.getActivity());
        this.updateTitle();
        this.updateBtnClearSearchView();
        this.updatePanelConnectionAlert();
        this.startToListenNetworkEvent();
        VideoBoxApplication.getInstance().addConfProcessListener(this);
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addMeetingMgrListener(this);
        this.mHandler.post(this.mRunnableHandleBuddyUpdate);
        PTApp.getInstance().getCalendarIntegrationConfig();
    }

    public void onStart() {
        super.onStart();
        if (this.mChatsListView != null) {
            this.mChatsListView.onParentFragmentStart();
            this.mMeetingToolbar.refresh();
        }
    }

    private void updateTitle() {
        if (!PTApp.getInstance().hasZoomMessenger()) {
            if (this.mTxtTitle != null) {
                this.mTxtTitle.setText(R.string.zm_tab_chats_no_messenger);
            }
            return;
        }
        switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
            case -1: 
            case 0: 
            case 1: {
                boolean isImDisable;
                if (this.mTxtTitle == null) break;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                boolean bl = isImDisable = messenger == null || messenger.imChatGetOption() == 2;
                if (isImDisable) {
                    this.mTxtTitle.setText(R.string.zm_app_full_name);
                    break;
                }
                this.mTxtTitle.setText(R.string.zm_mm_title_chats);
                break;
            }
            case 2: {
                if (this.mTxtTitle == null) break;
                this.mTxtTitle.setText(R.string.zm_mm_title_chats_connecting);
            }
        }
        if (this.mTxtTitle != null) {
            this.mTxtTitle.getParent().requestLayout();
        }
    }

    private void updatePanelNoItemMsg() {
        boolean isShowEmptyView;
        boolean bl = isShowEmptyView = this.mChatsListView.getCount() <= this.mChatsListView.getHeaderViewsCount();
        if (this.mEmptyView.getVisibility() != 0 && isShowEmptyView) {
            ViewGroup.LayoutParams layoutParams = this.mChatsListView.getLayoutParams();
            layoutParams.height = -2;
            this.mChatsListView.setLayoutParams(layoutParams);
            this.mEmptyView.setVisibility(0);
        } else if (this.mEmptyView.getVisibility() == 0 && !isShowEmptyView) {
            ViewGroup.LayoutParams layoutParams = this.mChatsListView.getLayoutParams();
            layoutParams.height = -1;
            this.mChatsListView.setLayoutParams(layoutParams);
            this.mEmptyView.setVisibility(8);
        }
    }

    private void startToListenNetworkEvent() {
        if (this.mNetworkStateReceiver == null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    MMChatsListFragment.this.updatePanelConnectionAlert();
                }
            };
            context.registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopToListenNetworkEvent() {
        if (this.mNetworkStateReceiver != null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            context.unregisterReceiver(this.mNetworkStateReceiver);
            this.mNetworkStateReceiver = null;
        }
    }

    @Override
    public void onContactsCacheUpdated() {
        if (this.mChatsListView != null) {
            this.mChatsListView.loadData(false, true);
            this.mChatsListView.notifyDataSetChanged(true);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mChatsListView != null) {
            this.mChatsListView.onParentFragmentPause();
        }
        this.stopToListenNetworkEvent();
        VideoBoxApplication.getInstance().removeConfProcessListener(this);
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeMeetingMgrListener(this);
        this.mHandler.removeCallbacks(this.mRunnableHandleBuddyUpdate);
    }

    public void onDestroy() {
        super.onDestroy();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mChatsListView != null) {
            this.mChatsListView.onActivityResult(requestCode, resultCode, data);
        }
        if (requestCode == 100 && resultCode == -1 && data != null) {
            ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
            if (abItems == null || abItems.size() == 0) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (abItems.size() == 1) {
                IMAddrBookItem item = (IMAddrBookItem)abItems.get(0);
                ZoomBuddy buddy = messenger.getBuddyWithJID(item.getJid());
                if (buddy == null) {
                    return;
                }
                MMChatsListFragment.startOneToOneChat(activity, buddy);
            } else {
                this.makeGroup(messenger, abItems, "");
            }
        }
    }

    public void makeGroup(ZoomMessenger messenger, ArrayList<IMAddrBookItem> abItems, String groupName) {
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (StringUtil.isEmptyOrNull((String)myJid)) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (int i = 0; i < abItems.size(); ++i) {
            IMAddrBookItem item = abItems.get(i);
            String jid = item.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) continue;
            buddies.add(jid);
        }
        if (!buddies.contains(myJid)) {
            buddies.add(myJid);
        }
        if (buddies.size() == 0) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        PTAppProtos.MakeGroupResult result = messenger.makeGroup(buddies, groupName, 80L);
        if (result != null && result.getResult()) {
            if (result.getValid()) {
                String groupId = result.getReusableGroupId();
                ZMActivity activity = (ZMActivity)this.getActivity();
                if (activity == null || StringUtil.isEmptyOrNull((String)groupId)) {
                    return;
                }
                MMChatsListFragment.startGroupChat(activity, groupId);
            } else {
                this.showWaitingMakeGroupDialog();
            }
        } else {
            this.showMakeGroupFailureMessage(1);
        }
    }

    private static void startOneToOneChat(ZMActivity activity, ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat(activity, buddy);
    }

    private static void startGroupChat(ZMActivity activity, String groupId) {
        MMChatActivity.showAsGroupChat(activity, groupId);
    }

    public void onClick(View v) {
        if (v == this.mBtnNewChat) {
            this.startNewChat();
        } else if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (v == this.mPanelConnectionAlert) {
            this.onClickPanelConnectionAlert();
        } else if (v == this.mEdtSearch) {
            this.onClickEdtSearch();
        } else if (v == this.mBtnSearch) {
            this.onClickBtnSearch();
        } else if (v == this.mBtnSettings) {
            this.onClickBtnSettings();
        }
    }

    private void onClickBtnSettings() {
        SettingFragment.showAsActivity((ZMActivity)this.getActivity(), 0, true);
    }

    private void onClickBtnSearch() {
        IMSearchFragment.showAsFragment((Fragment)this, 0);
    }

    private void onClickEdtSearch() {
        MMContactSearchFragment.showAsFragment(this);
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickPanelConnectionAlert() {
        IMActivity activity = (IMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)activity)) {
            Toast.makeText((Context)activity, (int)R.string.zm_alert_network_disconnected, (int)1).show();
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isStreamConflict()) {
            AutoStreamConflictChecker.getInstance().showStreamConflictMessage(this.getActivity());
        } else {
            messenger.trySignon();
        }
    }

    private void startNewChat() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        String title = activity.getString(R.string.zm_mm_title_new_chat);
        String btnOkText = activity.getString(R.string.zm_mm_btn_start_chat);
        String instructionMessage = activity.getString(R.string.zm_msg_select_buddies_to_chat_instructions);
        MMSelectContactsActivity.SelectContactsParamter paramter = new MMSelectContactsActivity.SelectContactsParamter();
        paramter.title = title;
        paramter.btnOkText = btnOkText;
        paramter.instructionMessage = instructionMessage;
        paramter.isAnimBottomTop = true;
        paramter.isOnlySameOrganization = false;
        paramter.maxSelectCount = PTApp.getInstance().getMaxChatGroupBuddyNumber() - 1;
        paramter.isContainsAllInGroup = false;
        paramter.includeRobot = false;
        MMSelectContactsActivity.show((Fragment)this, paramter, 100, null);
    }

    private void showWaitingMakeGroupDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingMakeGroupDialog");
    }

    private boolean dismissWaitingMakeGroupDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return false;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingMakeGroupDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
            return true;
        }
        return false;
    }

    private void showMakeGroupFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 8) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_make_group_failed_too_many_buddies, (int)1).show();
        } else {
            String msg = context.getString(R.string.zm_mm_msg_make_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void onBeginConnect() {
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity()) && this.isResumed()) {
            this.updateTitle();
            this.updatePanelConnectionAlert();
        }
    }

    private void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            if (this.mChatsListView != null) {
                this.mChatsListView.getChatsPresence();
                this.mChatsListView.onConnectReturn(errorCode);
            }
            if (this.isResumed()) {
                this.updateTitle();
                this.updatePanelConnectionAlert();
                if (this.mChatsListView != null) {
                    this.mChatsListView.notifyDataSetChanged(true);
                }
            }
        }
    }

    private void onIndicateBuddyInfoUpdated(String phoneNumber) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onIndicateBuddyInfoUpdated(phoneNumber);
        }
    }

    private void onIndicateBuddyInfoUpdatedWithJID(String jid) {
        this.pushBuddyUpdateEventToQueue(jid);
    }

    private void handleIndicateBuddyInfoUpdatedWithJID(String jid) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onIndicateBuddyInfoUpdatedWithJID(jid);
        }
    }

    private void onGroupAction(final int result, final GroupAction action, String msgId) {
        if (action == null) {
            return;
        }
        this.mChatsListView.onGroupAction(result, action, msgId);
        if (this.isResumed()) {
            this.updatePanelNoItemMsg();
        }
        if (action.getActionType() == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    MMChatsListFragment f = (MMChatsListFragment)ui;
                    if (f != null) {
                        f.handleGroupActionMakeGroup(result, action);
                    }
                }
            });
        } else if (action.getActionType() == 4) {
            if (action.isMeInBuddies()) {
                this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                    public void run(IUIElement ui) {
                        MMChatsListFragment f = (MMChatsListFragment)ui;
                        if (f != null) {
                            f.handleGroupActionDeleteGroup(result, action);
                        }
                    }
                });
            }
        } else if (action.getActionType() == 5) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    MMChatsListFragment f = (MMChatsListFragment)ui;
                    if (f != null) {
                        f.handleGroupActionDeleteGroup(result, action);
                    }
                }
            });
        }
    }

    private void handleGroupActionDeleteGroup(int result, GroupAction action) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        messenger.deleteSession(action.getGroupId());
        this.mChatsListView.refresh();
    }

    private void handleGroupActionMakeGroup(int result, GroupAction action) {
        if (!this.dismissWaitingMakeGroupDialog()) {
            return;
        }
        if (result == 0) {
            String groupId = action.getGroupId();
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null || StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            MMChatsListFragment.startGroupChat(activity, groupId);
        } else {
            this.showMakeGroupFailureMessage(result);
        }
    }

    private void onNotify_ChatSessionListUpdate() {
        if (this.mRunnableUpdateSessionList == null) {
            this.mRunnableUpdateSessionList = new Runnable(){

                @Override
                public void run() {
                    if (MMChatsListFragment.this.mChatsListView != null) {
                        ZMLog.i((String)MMChatsListFragment.this.TAG, (String)"onNotify_ChatSessionListUpdate", (Object[])new Object[0]);
                        MMChatsListFragment.this.mChatsListView.loadData(false, true);
                        MMChatsListFragment.this.mChatsListView.subscribeChatsPresence();
                        if (MMChatsListFragment.this.isResumed()) {
                            MMChatsListFragment.this.mChatsListView.notifyDataSetChanged(true);
                            MMChatsListFragment.this.updatePanelNoItemMsg();
                        }
                    }
                    MMChatsListFragment.this.mRunnableUpdateSessionList = null;
                }
            };
            this.mHandler.postDelayed(this.mRunnableUpdateSessionList, 1000L);
        }
    }

    private void onIndicateBuddyListUpdated() {
        if (this.mChatsListView != null) {
            this.mChatsListView.loadData(false, false);
            if (this.isResumed()) {
                this.mChatsListView.notifyDataSetChanged(true);
            }
        }
    }

    public void onChatItemDelete(String itemId) {
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity instanceof IMActivity) {
            ((IMActivity)activity).onMMSessionDeleted(itemId);
        }
    }

    public void onSessionDeleted(String sessionId) {
        if (this.isResumed()) {
            this.mChatsListView.refresh();
            this.updatePanelNoItemMsg();
        }
    }

    private void onConfirm_MessageSent(String sessionId, String messageId, int result) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onConfirm_MessageSent(sessionId, messageId, result);
        }
        if (this.isResumed()) {
            this.updatePanelNoItemMsg();
        }
    }

    private boolean onIndicateMessageReceived(String sessionId, String senderJid, String messageId) {
        return false;
    }

    private void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }
        if (this.isResumed()) {
            this.updatePanelNoItemMsg();
        }
    }

    private void refreshSubcribeRequest() {
        if (this.mChatsListView != null) {
            this.mChatsListView.onNotifySubscribeRequest();
        }
        if (this.isResumed()) {
            this.updatePanelNoItemMsg();
        }
    }

    private void refreshChatSessionUnread() {
        if (this.mChatsListView != null) {
            this.mChatsListView.refreshChatSessionUnread();
        }
    }

    private void notify_DBLoadSessionLastMessagesDone() {
        if (this.mChatsListView != null) {
            this.mChatsListView.notify_DBLoadSessionLastMessagesDone();
        }
    }

    private void onNotify_ChatSessionUpdate(String sessionId) {
        this.onNotify_ChatSessionListUpdate();
    }

    private void On_DestroyGroup(int result, String actionOwner, String groupID, String groupName, long tm) {
        if (result == 0) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("DestroyGroup"){

                public void run(IUIElement ui) {
                    if (MMChatsListFragment.this.mChatsListView != null) {
                        MMChatsListFragment.this.mChatsListView.refresh();
                    }
                }
            });
        }
    }

    private void Indicate_EditMessageResultIml(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
        this.mChatsListView.Indicate_EditMessageResultIml(actionOwner, sessionId, guid, msgTime, serverTime, result);
    }

    private void Indicate_RevokeMessageResult(String actionOwner, String sessionId, String guid, String recallMsgId, boolean result) {
        if (result) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("RevokeMessageResult"){

                public void run(IUIElement ui) {
                    if (MMChatsListFragment.this.mChatsListView != null) {
                        MMChatsListFragment.this.mChatsListView.refresh();
                    }
                }
            });
        }
    }

    private void On_NotifyGroupDestroy(String groupID, final String groupName, long tm) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("NotifyGroupDestroy"){

            public void run(IUIElement ui) {
                FragmentActivity activity;
                if (MMChatsListFragment.this.mChatsListView != null) {
                    MMChatsListFragment.this.mChatsListView.refresh();
                }
                if ((activity = MMChatsListFragment.this.getActivity()) == null) {
                    return;
                }
                SimpleMessageDialog.newInstance(activity.getString(R.string.zm_mm_msg_group_disbanded_by_admin, new Object[]{groupName}), false).show(MMChatsListFragment.this.getFragmentManager(), SimpleMessageDialog.class.getName());
            }
        });
    }

    private boolean onNotifySubscribeRequest() {
        PreferenceUtil.saveBooleanValue("system_notification_delete_flag", false);
        this.refreshSubcribeRequest();
        return false;
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.onCallStatusChanged(result);
                break;
            }
            case 0: {
                this.onWebLogin(result);
                break;
            }
            case 65: {
                this.onCalendarConfigReady(result);
            }
        }
    }

    private void onWebLogin(long result) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onWebLogin(result);
            this.mMeetingToolbar.refresh();
        }
    }

    private void onCallStatusChanged(long result) {
        if (this.mChatsListView != null) {
            this.mChatsListView.refresh();
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    public boolean onLongClick(View v) {
        if (v == this.mTxtTitle) {
            return this.onLongClickTxtTitle();
        }
        return false;
    }

    private boolean onLongClickTxtTitle() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String sourcePath, String destPath) {
        File source = new File(sourcePath);
        File dest = new File(destPath);
        if (!source.exists()) {
            return;
        }
        if (dest.exists()) {
            this.deleteFile(destPath);
        }
        if (source.isDirectory()) {
            File[] files;
            if (!dest.mkdirs()) {
                return;
            }
            for (File file : files = source.listFiles()) {
                String sPath = file.getAbsolutePath();
                String dPath = new File(destPath, file.getName()).getAbsolutePath();
                this.copyFile(sPath, dPath);
            }
        } else {
            AbstractInterruptibleChannel inputChannel = null;
            AbstractInterruptibleChannel outputChannel = null;
            try {
                if (!dest.createNewFile()) {
                    return;
                }
                inputChannel = new FileInputStream(source).getChannel();
                outputChannel = new FileOutputStream(dest).getChannel();
                ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (inputChannel != null) {
                        inputChannel.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (outputChannel != null) {
                        outputChannel.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void deleteFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] files;
            for (String subFile : files = file.list()) {
                this.deleteFile(subFile);
            }
        }
        file.delete();
    }

    @Override
    public void onScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
    }

    @Override
    public void onListMeetingResult(int result) {
        if (ZmPtUtils.isCalendarServiceReady()) {
            MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
            if (meetingHelper != null) {
                meetingHelper.listCalendarEvents();
            }
        } else if (this.mChatsListView != null && ZmPtUtils.isEnableIM()) {
            this.mChatsListView.onCallStatusChanged();
        }
    }

    @Override
    public void onListCalendarEventsResult(int result) {
        if (this.mChatsListView != null && ZmPtUtils.isEnableIM()) {
            this.mChatsListView.onCallStatusChanged();
        }
    }

    @Override
    public void onDeleteMeetingResult(int result) {
    }

    @Override
    public void onUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
    }

    @Override
    public void onStartFailBeforeLaunch(int result) {
    }

    @Override
    public void onPMIEvent(int event, int result, MeetingInfo item) {
    }

    private void onCalendarConfigReady(long result) {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper != null) {
            meetingHelper.listMeetingUpcoming();
        }
    }

    @Override
    public void onConfProcessStarted() {
        if (this.mMeetingToolbar != null && this.mMeetingToolbar.getVisibility() == 0) {
            this.mMeetingToolbar.refresh();
        } else if (this.mChatsListView != null) {
            this.mChatsListView.refresh();
        }
    }

    @Override
    public void onConfProcessStopped() {
        if (this.mMeetingToolbar != null && this.mMeetingToolbar.getVisibility() == 0) {
            this.mMeetingToolbar.refresh();
        } else if (this.mChatsListView != null) {
            this.mChatsListView.refresh();
        }
    }
}

