/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.AddrBookItemDetailsActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.MMChatInfoActivity;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.fragment.AddrBookItemDetailsFragment;
import com.zipow.videobox.fragment.MMGroupBuddiesFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMBuddyItem;
import com.zipow.videobox.view.mm.MMChatBuddiesGridView;
import com.zipow.videobox.view.mm.MMSessionContentsFragment;
import com.zipow.videobox.view.mm.MMSetGroupInformationFragment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMChatInfoFragment
extends ZMDialogFragment
implements View.OnClickListener,
ABContactsCache.IABContactsCacheListener,
MMChatBuddiesGridView.BuddyOperationListener {
    private static final String TAG = MMChatInfoFragment.class.getSimpleName();
    private static final String ARG_CONTACT = "contact";
    private static final String ARG_IS_GROUP = "isGroup";
    private static final String ARG_GROUP_ID = "groupId";
    private static final String ARG_BUDDY_ID = "buddyId";
    private static final int REQUEST_ONE_ON_ONE_BUDDY_DETAILS = 100;
    private static final int REQUEST_SELECT_ADMIN_AND_LEAVE = 101;
    private static final int REQUEST_SELECT_ADMIN = 103;
    private static final int REQUEST_CHAT_INFO = 102;
    public static int MAX = 45;
    private boolean mIsGroup = false;
    private IMAddrBookItem mIMAddrBookItem;
    private String mGroupId;
    private String mBuddyId;
    private Button mBtnBack;
    private MMChatBuddiesGridView mGvBuddies;
    private TextView mTxtTitle;
    private View mOptionTopic;
    private TextView mTxtTopic;
    private View mBtnQuitGroup;
    private View mBtnTransferAdmin;
    private View mPanelQuitGroup;
    private View mPanelTransferAdmin;
    private View mBtnClearHistory;
    private String mSessionId;
    private ZMDialogFragment mWaitingDialog;
    private CheckedTextView mChkNotification;
    private View mOptionSaveSession;
    private View mOptionNotification;
    private View mOptionShareImages;
    private View mOptionShareFiles;
    private View mPanelShareFiles;
    private CheckedTextView mChkSaveSession;
    private TextView mTxtQuitGroup;
    private ImageView mImgTopicArrow;
    private View mTxtGroupNotificationDes;
    private View mPanelGroupNotification;
    private View mPanelAllMsg;
    private ImageView mImgAllMsg;
    private View mPanelPrivateMsg;
    private ImageView mImgNotificationPrivate;
    private View mPanelNoMsg;
    private ImageView mImgNotificationNo;
    private View mOptionBlockUser;
    private CheckedTextView mChkBlockUser;
    private RelativeLayout mViewMore;
    private boolean mOnlyTransfer = false;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMChatInfoFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMChatInfoFragment.this.onIndicateInfoUpdatedWithJID(jid);
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            MMChatInfoFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }

        @Override
        public void On_DestroyGroup(int result, String actionOwner, String groupID, String groupName, long tm) {
            MMChatInfoFragment.this.On_DestroyGroup(result, actionOwner, groupID, groupName, tm);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMChatInfoFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }

        @Override
        public void On_AssignGroupAdmins(int result, String actionOwner, String groupID, List<String> buddies, long tm) {
            MMChatInfoFragment.this.On_AssignGroupAdmins(result, actionOwner, groupID, buddies, tm);
        }

        @Override
        public void Indicate_BlockedUsersUpdated() {
            MMChatInfoFragment.this.Indicate_BlockedUsersUpdated();
        }

        @Override
        public void Indicate_BlockedUsersAdded(List<String> users) {
            MMChatInfoFragment.this.Indicate_BlockedUsersUpdated();
        }

        @Override
        public void Indicate_BlockedUsersRemoved(List<String> users) {
            MMChatInfoFragment.this.Indicate_BlockedUsersUpdated();
        }
    };
    private NotificationSettingUI.INotificationSettingUIListener mNotificationSettingUI = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnMUCSettingUpdated() {
            MMChatInfoFragment.this.updateData();
        }
    };

    public static void showAsOneToOneInActivity(ZMActivity activity, IMAddrBookItem contact, String buddyId) {
        if (activity == null || buddyId == null) {
            return;
        }
        MMChatInfoFragment f = new MMChatInfoFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_CONTACT, (Serializable)contact);
        args.putString(ARG_BUDDY_ID, buddyId);
        args.putBoolean(ARG_IS_GROUP, false);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, MMChatInfoFragment.class.getName()).commit();
    }

    public static void showAsGroupChatInActivity(ZMActivity activity, String groupId) {
        if (activity == null || groupId == null) {
            return;
        }
        MMChatInfoFragment f = new MMChatInfoFragment();
        Bundle args = new Bundle();
        args.putString(ARG_GROUP_ID, groupId);
        args.putBoolean(ARG_IS_GROUP, true);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, MMChatInfoFragment.class.getName()).commit();
    }

    public static MMChatInfoFragment findMMChatInfoFragment(FragmentManager fm) {
        if (fm == null) {
            return null;
        }
        MMChatInfoFragment f = (MMChatInfoFragment)fm.findFragmentByTag(MMChatInfoFragment.class.getName());
        return f;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        this.mIsGroup = args.getBoolean(ARG_IS_GROUP);
        this.mIMAddrBookItem = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
        this.mBuddyId = args.getString(ARG_BUDDY_ID);
        this.mGroupId = args.getString(ARG_GROUP_ID);
        this.mSessionId = this.mIsGroup ? this.mGroupId : this.mBuddyId;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_chat_info, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mGvBuddies = (MMChatBuddiesGridView)view.findViewById(R.id.gvBuddies);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mOptionTopic = view.findViewById(R.id.optionTopic);
        this.mTxtTopic = (TextView)view.findViewById(R.id.txtTopic);
        this.mBtnQuitGroup = view.findViewById(R.id.btnQuitGroup);
        this.mBtnTransferAdmin = view.findViewById(R.id.btnTransferAdmin);
        this.mBtnClearHistory = view.findViewById(R.id.btnClearHistory);
        this.mChkNotification = (CheckedTextView)view.findViewById(R.id.chkNotification);
        this.mOptionNotification = view.findViewById(R.id.optionNotification);
        this.mPanelQuitGroup = view.findViewById(R.id.panelQuitGroup);
        this.mPanelTransferAdmin = view.findViewById(R.id.panelTransferAdmin);
        this.mOptionSaveSession = view.findViewById(R.id.optionSaveSession);
        this.mChkSaveSession = (CheckedTextView)view.findViewById(R.id.chkSaveSession);
        this.mOptionShareImages = view.findViewById(R.id.optionShareImages);
        this.mOptionShareFiles = view.findViewById(R.id.optionShareFiles);
        this.mPanelShareFiles = view.findViewById(R.id.panelShareFiles);
        this.mTxtQuitGroup = (TextView)view.findViewById(R.id.txtQuitGroup);
        this.mImgTopicArrow = (ImageView)view.findViewById(R.id.imgTopicArrow);
        this.mPanelGroupNotification = view.findViewById(R.id.panelGroupNotification);
        this.mTxtGroupNotificationDes = view.findViewById(R.id.txtGroupNotificationDes);
        this.mOptionBlockUser = view.findViewById(R.id.optionBlockUser);
        this.mChkBlockUser = (CheckedTextView)view.findViewById(R.id.chkBlockUser);
        this.mViewMore = (RelativeLayout)view.findViewById(R.id.viewMore);
        this.mPanelAllMsg = view.findViewById(R.id.panelAllMsg);
        this.mImgAllMsg = (ImageView)view.findViewById(R.id.imgAllMsg);
        this.mPanelPrivateMsg = view.findViewById(R.id.panelPrivateMsg);
        this.mImgNotificationPrivate = (ImageView)view.findViewById(R.id.imgNotificationPrivate);
        this.mPanelNoMsg = view.findViewById(R.id.panelNoMsg);
        this.mImgNotificationNo = (ImageView)view.findViewById(R.id.imgNotificationNo);
        this.mGvBuddies.setMax(MAX);
        this.mGvBuddies.setBuddyOperationListener(this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mOptionTopic.setOnClickListener((View.OnClickListener)this);
        this.mBtnQuitGroup.setOnClickListener((View.OnClickListener)this);
        this.mBtnTransferAdmin.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearHistory.setOnClickListener((View.OnClickListener)this);
        this.mOptionNotification.setOnClickListener((View.OnClickListener)this);
        this.mOptionSaveSession.setOnClickListener((View.OnClickListener)this);
        this.mOptionShareImages.setOnClickListener((View.OnClickListener)this);
        this.mOptionShareFiles.setOnClickListener((View.OnClickListener)this);
        this.mPanelAllMsg.setOnClickListener((View.OnClickListener)this);
        this.mPanelPrivateMsg.setOnClickListener((View.OnClickListener)this);
        this.mPanelNoMsg.setOnClickListener((View.OnClickListener)this);
        this.mOptionBlockUser.setOnClickListener((View.OnClickListener)this);
        this.mViewMore.setOnClickListener((View.OnClickListener)this);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            boolean backToChat;
            if (data != null && (backToChat = data.getBooleanExtra("backToChat", false))) {
                this.onClickBtnBack();
            }
        } else if ((requestCode == 101 || requestCode == 103) && resultCode == -1 && data != null) {
            ArrayList selectItems = (ArrayList)data.getSerializableExtra("selectedItems");
            if (CollectionsUtil.isListEmpty((List)selectItems)) {
                return;
            }
            ArrayList<String> items = new ArrayList<String>();
            for (IMAddrBookItem item : selectItems) {
                items.add(item.getJid());
            }
            this.transferAdmin(items, requestCode == 101);
        }
    }

    public void onResume() {
        ZoomGroup group;
        ZoomMessenger messenger;
        super.onResume();
        this.updateData();
        ABContactsCache.getInstance().addListener(this);
        if (ABContactsCache.getInstance().needReloadAll()) {
            ABContactsCache.getInstance().reloadAllContacts();
        }
        if (this.mIsGroup && (messenger = PTApp.getInstance().getZoomMessenger()) != null && (group = messenger.getGroupById(this.mGroupId)) != null && !group.amIInGroup()) {
            this.onClickBtnBack();
        }
        NotificationSettingUI.getInstance().addListener(this.mNotificationSettingUI);
    }

    private void updateData() {
        this.updateContact();
        if (this.mGvBuddies != null) {
            this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
            this.mGvBuddies.notifyDataSetChanged();
        }
        this.updateTitle();
        this.updateTopic();
        this.updateOptions();
    }

    private void updateContact() {
        if (!this.mIsGroup && this.mIMAddrBookItem != null && this.mIMAddrBookItem.getPhoneNumberCount() > 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(this.mIMAddrBookItem.getJid());
            if (buddy == null) {
                return;
            }
            this.mIMAddrBookItem = IMAddrBookItem.fromZoomBuddy(buddy);
        }
    }

    private void updateTopic() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (this.mIsGroup) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            ZoomGroup group = messenger.getGroupById(this.mGroupId);
            if (group == null) {
                return;
            }
            String name = group.getGroupName();
            if (StringUtil.isEmptyOrNull((String)name)) {
                this.mTxtTopic.setText(R.string.zm_mm_lbl_not_set);
            } else {
                String topic = name;
                if (group.isPublicRoom()) {
                    topic = topic + String.format("(%s)", this.getString(R.string.zm_mm_lbl_public));
                } else if (group.isRoom()) {
                    topic = topic + String.format("(%s)", this.getString(R.string.zm_mm_lbl_privte));
                }
                this.mTxtTopic.setText((CharSequence)topic);
            }
            if (group.isRoom()) {
                if (group.isGroupOperatorable()) {
                    this.mImgTopicArrow.setVisibility(0);
                } else {
                    this.mImgTopicArrow.setVisibility(4);
                }
            }
        }
    }

    private void updateTitle() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (this.mIsGroup) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            ZoomGroup group = messenger.getGroupById(this.mGroupId);
            if (group == null) {
                return;
            }
            int count = group.getBuddyCount();
            String title = context.getString(R.string.zm_mm_title_chat_options_group, new Object[]{count});
            this.mTxtTitle.setText((CharSequence)title);
            if (group.isRoom()) {
                if (group.isGroupOperatorable() && count + 2 > MAX || !group.isGroupOperatorable() && count + 1 > MAX) {
                    this.mViewMore.setVisibility(0);
                } else {
                    this.mViewMore.setVisibility(8);
                }
            } else if (count + 1 > MAX) {
                this.mViewMore.setVisibility(0);
            } else {
                this.mViewMore.setVisibility(8);
            }
        } else {
            this.mTxtTitle.setText(R.string.zm_mm_title_chat_options);
            this.mViewMore.setVisibility(8);
        }
    }

    private void updateOptions() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            boolean isSaved = messenger.savedSessionIsSaved(this.mSessionId);
            this.mChkSaveSession.setChecked(isSaved);
            boolean isE2E = this.checkE2EStatus();
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            boolean isContentEnable = mgr != null && mgr.getFileContentMgmtOption() == 1;
            NotificationSettingMgr notificationSettingMgr = PTApp.getInstance().getNotificationSettingMgr();
            if (notificationSettingMgr == null) {
                return;
            }
            List<String> disableJIds = notificationSettingMgr.getDisableMUCSettings();
            List<String> hlJids = notificationSettingMgr.getHLMUCSettings();
            List<String> receiveAllMUCSettingsJids = notificationSettingMgr.getReceiveAllMUCSettings();
            if (this.mIsGroup) {
                this.mOptionBlockUser.setVisibility(8);
                this.mTxtGroupNotificationDes.setVisibility(0);
                this.mPanelGroupNotification.setVisibility(0);
                this.mOptionTopic.setVisibility(0);
                this.mOptionNotification.setVisibility(8);
                ZoomGroup group = messenger.getGroupById(this.mSessionId);
                if (group == null) {
                    return;
                }
                if (!group.isGroupOperatorable()) {
                    this.mPanelTransferAdmin.setVisibility(8);
                } else {
                    this.mPanelTransferAdmin.setVisibility(0);
                }
                if (group.isRoom()) {
                    this.mBtnQuitGroup.setContentDescription((CharSequence)this.getString(R.string.zm_mm_btn_delete_and_quit_group_chat));
                    this.mTxtQuitGroup.setText(R.string.zm_mm_btn_delete_and_quit_group_chat);
                } else {
                    this.mBtnQuitGroup.setContentDescription((CharSequence)this.getString(R.string.zm_mm_btn_quit_muc_chat));
                    this.mTxtQuitGroup.setText(R.string.zm_mm_btn_quit_muc_chat);
                }
                this.mPanelPrivateMsg.setVisibility(0);
                if (disableJIds != null && disableJIds.contains(this.mSessionId)) {
                    this.mImgNotificationNo.setVisibility(0);
                    this.mImgAllMsg.setVisibility(8);
                    this.mImgNotificationPrivate.setVisibility(8);
                } else if (hlJids != null && hlJids.contains(this.mSessionId)) {
                    this.mImgNotificationNo.setVisibility(8);
                    this.mImgAllMsg.setVisibility(8);
                    this.mImgNotificationPrivate.setVisibility(0);
                } else if (receiveAllMUCSettingsJids != null && receiveAllMUCSettingsJids.contains(this.mSessionId)) {
                    this.mImgNotificationNo.setVisibility(8);
                    this.mImgAllMsg.setVisibility(0);
                    this.mImgNotificationPrivate.setVisibility(8);
                } else {
                    int[] allSettings = notificationSettingMgr.getBlockAllSettings();
                    if (allSettings == null) {
                        this.mImgNotificationNo.setVisibility(8);
                        this.mImgAllMsg.setVisibility(0);
                        this.mImgNotificationPrivate.setVisibility(8);
                        return;
                    }
                    int action = allSettings[0];
                    int type = allSettings[1];
                    this.mImgAllMsg.setVisibility(action == 1 && type == 1 ? 0 : 8);
                    this.mImgNotificationNo.setVisibility(action == 2 ? 0 : 8);
                    this.mImgNotificationPrivate.setVisibility(action == 1 && type == 4 ? 0 : 8);
                }
            } else {
                this.mOptionBlockUser.setVisibility(0);
                if (disableJIds != null && disableJIds.contains(this.mSessionId)) {
                    this.mChkNotification.setChecked(false);
                    this.mOptionNotification.setVisibility(0);
                } else {
                    this.mOptionNotification.setVisibility(8);
                }
                this.mChkBlockUser.setChecked(messenger.blockUserIsBlocked(this.mBuddyId));
                this.mTxtGroupNotificationDes.setVisibility(8);
                this.mPanelGroupNotification.setVisibility(8);
                this.mOptionTopic.setVisibility(8);
                this.mPanelQuitGroup.setVisibility(8);
                this.mPanelTransferAdmin.setVisibility(8);
                this.mPanelPrivateMsg.setVisibility(8);
            }
            if (isE2E || !isContentEnable || PTApp.getInstance().isFileTransferDisabled()) {
                this.mPanelShareFiles.setVisibility(8);
            } else {
                this.mPanelShareFiles.setVisibility(0);
            }
        }
    }

    private boolean checkE2EStatus() {
        boolean mIsE2EChat = false;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        int myOption = messenger.e2eGetMyOption();
        if (myOption == 2) {
            return true;
        }
        if (this.mIsGroup) {
            ZoomGroup group = messenger.getGroupById(this.mGroupId);
            if (group != null) {
                mIsE2EChat = group.isForceE2EGroup();
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithJID(this.mBuddyId);
            if (buddy != null) {
                mIsE2EChat = buddy.getE2EAbility(myOption) == 2;
            }
        }
        return mIsE2EChat;
    }

    @Override
    public void onContactsCacheUpdated() {
        this.updateContact();
        if (this.mGvBuddies != null) {
            this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
            this.mGvBuddies.notifyDataSetChanged();
        }
    }

    public void onPause() {
        super.onPause();
        ABContactsCache.getInstance().removeListener(this);
        NotificationSettingUI.getInstance().removeListener(this.mNotificationSettingUI);
    }

    public void onDestroy() {
        super.onDestroy();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private void onGroupAction(final int result, final GroupAction action, String messageId) {
        if (action.getActionType() == 1) {
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.updateTopic();
                }
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("GroupAction.ACTION_MODIFY_NAME"){

                public void run(IUIElement ui) {
                    MMChatInfoFragment f = (MMChatInfoFragment)ui;
                    if (f != null) {
                        f.handleGroupActionModifyName(result, action);
                    }
                }
            });
        } else if (action.getActionType() == 3) {
            ZoomMessenger messenger;
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            if (this.isResumed()) {
                this.updateTitle();
            }
            if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
                    this.mGvBuddies.notifyDataSetChanged();
                }
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_ADD_BUDDIES"){

                public void run(IUIElement ui) {
                    MMChatInfoFragment f = (MMChatInfoFragment)ui;
                    if (f != null) {
                        f.handleGroupActionAddBuddies(result, action);
                    }
                }
            });
        } else if (action.getActionType() == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_MAKE_GROUP"){

                public void run(IUIElement ui) {
                    MMChatInfoFragment f = (MMChatInfoFragment)ui;
                    if (f != null) {
                        f.handleGroupActionMakeGroup(result, action);
                    }
                }
            });
        } else if (action.getActionType() == 2 || action.getActionType() == 5) {
            ZoomMessenger messenger;
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            if (this.isResumed()) {
                this.updateTitle();
            }
            if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
                    this.mGvBuddies.notifyDataSetChanged();
                }
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_DELETE_GROUP"){

                public void run(IUIElement ui) {
                    MMChatInfoFragment f = (MMChatInfoFragment)ui;
                    if (f != null) {
                        f.handleGroupActionDeleteGroup(result, action);
                    }
                }
            });
        } else if (action.getActionType() == 4) {
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            if (this.isResumed()) {
                this.updateTitle();
            }
            if (this.isResumed() && action.isMeInBuddies()) {
                this.onClickBtnBack();
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
                    this.mGvBuddies.notifyDataSetChanged();
                }
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_REMOVE_BUDDY"){

                public void run(IUIElement ui) {
                    MMChatInfoFragment f = (MMChatInfoFragment)ui;
                    if (f != null) {
                        f.handleGroupActionRemoveBuddy(result, action);
                    }
                }
            });
        }
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        if (!this.mIsGroup && StringUtil.isSameString((String)jid, (String)this.mBuddyId)) {
            this.updateData();
        }
    }

    private void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        if (this.mIsGroup && StringUtil.isSameString((String)groupID, (String)this.mGroupId)) {
            this.updateData();
        }
    }

    private void On_DestroyGroup(final int result, String actionOwner, String groupID, String groupName, long tm) {
        if (!StringUtil.isSameString((String)groupID, (String)this.mGroupId)) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("DestroyGroup"){

            public void run(IUIElement ui) {
                MMChatInfoFragment.this.dismissWaitingDialog();
                ZMActivity activity = (ZMActivity)MMChatInfoFragment.this.getActivity();
                if (result == 0) {
                    if (activity instanceof MMChatInfoActivity) {
                        ((MMChatInfoActivity)activity).onQuitGroup();
                    }
                } else {
                    if (activity == null) {
                        return;
                    }
                    String msg = activity.getString(R.string.zm_mm_msg_destory_group_failed, new Object[]{result});
                    Toast.makeText((Context)activity, (CharSequence)msg, (int)1).show();
                }
            }
        });
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        if (!StringUtil.isSameString((String)groupID, (String)this.mGroupId)) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("NotifyGroupDestroy"){

            public void run(IUIElement ui) {
                ZMActivity activity = (ZMActivity)MMChatInfoFragment.this.getActivity();
                if (activity instanceof MMChatInfoActivity) {
                    ((MMChatInfoActivity)activity).onQuitGroup();
                }
            }
        });
    }

    private void Indicate_BlockedUsersUpdated() {
        this.updateData();
    }

    private void On_AssignGroupAdmins(final int result, String actionOwner, String groupID, List<String> buddies, long tm) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getMyself();
        if (buddy == null) {
            return;
        }
        this.dismissWaitingDialog();
        if (StringUtil.isSameString((String)actionOwner, (String)buddy.getJid()) && result == 0 && !this.mOnlyTransfer) {
            this.quitGroup();
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAdminTransfer"){

            public void run(IUIElement ui) {
                ZMActivity activity = (ZMActivity)MMChatInfoFragment.this.getActivity();
                if (result == 0) {
                    MMChatInfoFragment.this.updateData();
                } else {
                    if (activity == null) {
                        return;
                    }
                    Toast.makeText((Context)activity, (CharSequence)activity.getString(R.string.zm_mm_msg_assign_admin_failed, new Object[]{result}), (int)1).show();
                }
            }
        });
    }

    private void handleGroupActionModifyName(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.updateTopic();
        } else {
            this.showChangeTopicFailureMessage(result);
        }
    }

    private void handleGroupActionAddBuddies(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
            this.mGvBuddies.notifyDataSetChanged();
            List<String> buddies = action.getNotAllowBuddies();
            if (buddies != null) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < buddies.size(); ++i) {
                    if (StringUtil.isEmptyOrNull((String)buddies.get(i))) continue;
                    buffer.append(buddies.get(i));
                    buffer.append(",");
                }
                if (buffer.length() > 0) {
                    String buddiesName = buffer.substring(0, buffer.length() - 1);
                    Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.zm_mm_msg_add_buddies_not_allowed, new Object[]{buddiesName}), (int)1).show();
                }
            }
        } else {
            this.showAddBuddiesFailureMessage(result);
        }
    }

    private void handleGroupActionMakeGroup(int result, GroupAction action) {
        this.dismissWaitingDialog();
        String groupId = action.getGroupId();
        if (result == 0) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null || StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            MMChatInfoFragment.startGroupChat(activity, groupId);
        } else {
            this.showMakeGroupFailureMessage(result);
        }
    }

    private void handleGroupActionDeleteGroup(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity instanceof MMChatInfoActivity) {
                ((MMChatInfoActivity)activity).onQuitGroup();
            }
        } else {
            this.showQuitGroupFailureMessage(result);
        }
    }

    private void handleGroupActionRemoveBuddy(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.mGvBuddies.loadAllBuddies(this.mIMAddrBookItem, this.mBuddyId, this.mGroupId);
            this.mGvBuddies.setIsRemoveMode(false);
            this.mGvBuddies.notifyDataSetChanged();
        } else {
            this.showRemoveBuddyFailureMessage(result);
        }
    }

    private static void startGroupChat(ZMActivity activity, String groupId) {
        activity.finish();
        MMChatActivity.showAsGroupChat(activity, groupId);
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mOptionTopic) {
            this.onClickOptionTopic();
        } else if (v == this.mBtnTransferAdmin) {
            this.onClickBtnTransferAdmin(103);
        } else if (v == this.mBtnQuitGroup) {
            this.onClickBtnQuitGroup();
        } else if (v == this.mBtnClearHistory) {
            this.onClickBtnClearHistory();
        } else if (v == this.mOptionNotification) {
            this.onClickChkNotification();
        } else if (v == this.mOptionSaveSession) {
            this.onClickChkSaveSession();
        } else if (v == this.mOptionShareFiles) {
            this.onClickOptionShareFiles();
        } else if (v == this.mOptionShareImages) {
            this.onClickOptionShareImages();
        } else if (v == this.mPanelAllMsg) {
            this.onClickPanelAllMsg();
        } else if (v == this.mPanelNoMsg) {
            this.onClickPanelNoMsg();
        } else if (v == this.mPanelPrivateMsg) {
            this.onClickPanelPrivateMsg();
        } else if (v == this.mOptionBlockUser) {
            this.onClickOptionBlockUser();
        } else if (v == this.mViewMore) {
            this.onClickViewMore();
        }
    }

    private void onClickViewMore() {
        MMGroupBuddiesFragment.show((ZMActivity)this.getActivity(), this.mGroupId, 102);
    }

    private void onClickOptionBlockUser() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        FragmentActivity context = this.getActivity();
        if (context == null || StringUtil.isEmptyOrNull((String)this.mBuddyId)) {
            return;
        }
        boolean isConnectionGood = messenger.isConnectionGood();
        if (messenger.blockUserIsBlocked(this.mBuddyId)) {
            if (!isConnectionGood) {
                Toast.makeText((Context)context, (int)R.string.zm_mm_msg_cannot_unblock_buddy_no_connection, (int)1).show();
                return;
            }
            ArrayList<String> users = new ArrayList<String>();
            users.add(this.mBuddyId);
            messenger.blockUserUnBlockUsers(users);
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithJID(this.mBuddyId);
            if (buddy == null) {
                return;
            }
            AddrBookItemDetailsFragment.BlockFragment.show(this.getFragmentManager(), IMAddrBookItem.fromZoomBuddy(buddy));
        }
    }

    private void onClickPanelAllMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (!(messenger == null || messenger.isConnectionGood() && NetworkUtil.hasDataNetwork((Context)this.getActivity()))) {
            this.showConnectionError();
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        List<String> jids = mgr.getReceiveAllMUCSettings();
        if (jids != null && jids.contains(this.mSessionId)) {
            return;
        }
        mgr.applyMUCSettings(this.mSessionId, 1);
        this.updateData();
    }

    private void onClickPanelNoMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (!(messenger == null || messenger.isConnectionGood() && NetworkUtil.hasDataNetwork((Context)this.getActivity()))) {
            this.showConnectionError();
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        List<String> disableJIds = mgr.getDisableMUCSettings();
        if (disableJIds != null && disableJIds.contains(this.mSessionId)) {
            return;
        }
        mgr.applyMUCSettings(this.mSessionId, 3);
        this.updateData();
    }

    private void onClickPanelPrivateMsg() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (!(messenger == null || messenger.isConnectionGood() && NetworkUtil.hasDataNetwork((Context)this.getActivity()))) {
            this.showConnectionError();
            return;
        }
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        List<String> hlJids = mgr.getHLMUCSettings();
        if (hlJids != null && hlJids.contains(this.mSessionId)) {
            return;
        }
        mgr.applyMUCSettings(this.mSessionId, 2);
        this.updateData();
    }

    private void onClickOptionShareFiles() {
        MMSessionContentsFragment.showAsActivity((Fragment)this, this.mSessionId, 0, 0);
    }

    private void onClickOptionShareImages() {
        MMSessionContentsFragment.showAsActivity((Fragment)this, this.mSessionId, 1, 0);
    }

    private void onClickChkSaveSession() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        boolean res = messenger.savedSessionSet(this.mSessionId, !this.mChkSaveSession.isChecked());
        if (res) {
            this.mChkSaveSession.setChecked(!this.mChkSaveSession.isChecked());
        }
    }

    private void onClickOptionTopic() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        if (!group.isGroupOperatorable()) {
            return;
        }
        MMSetGroupInformationFragment.showAsActivity((Fragment)this, this.mGroupId, 0);
    }

    private void onClickBtnBack() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (this.getShowsDialog()) {
            this.dismiss();
        } else if (activity != null) {
            activity.setResult(0);
            activity.finish();
        }
    }

    private void onClickBtnQuitGroup() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        if (group.isGroupOperatorable()) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_msg_delete_by_admin).setCancelable(true).setPositiveButton(R.string.zm_mm_lbl_transfer_admin_42597, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MMChatInfoFragment.this.onClickBtnTransferAdmin(101);
                }
            }).setNeutralButton(R.string.zm_btn_disband, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MMChatInfoFragment.this.confirmDestoryGroup();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null).create();
            dialog.show();
        } else {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_mm_msg_quit_group_confirm).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MMChatInfoFragment.this.quitGroup();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            dialog.show();
        }
    }

    private void confirmDestoryGroup() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_msg_confirm_disband).setCancelable(true).setPositiveButton(R.string.zm_btn_continue_disband, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMChatInfoFragment.this.destroyGroup();
            }
        }).setNegativeButton(R.string.zm_btn_cancel, null).create();
        dialog.show();
    }

    private void destroyGroup() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        messenger.destroyGroup(this.mGroupId);
    }

    private void transferAdmin(List<String> selectItems, boolean transferAndLeave) {
        if (!this.mIsGroup) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        if (transferAndLeave) {
            messenger.assignGroupAdmins(this.mGroupId, selectItems);
        } else {
            messenger.assignGroupAdminsV2(this.mGroupId, selectItems);
        }
        this.showWaitingDialog();
    }

    private void onClickBtnTransferAdmin(int assignAdminType) {
        if (!this.mIsGroup) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        this.mOnlyTransfer = assignAdminType == 103;
        MMSelectContactsActivity.SelectContactsParamter paramter = new MMSelectContactsActivity.SelectContactsParamter();
        paramter.title = activity.getString(R.string.zm_mm_title_select_a_contact);
        paramter.btnOkText = activity.getString(R.string.zm_btn_ok);
        paramter.groupId = this.mGroupId;
        paramter.isContainsAllInGroup = false;
        paramter.includeRobot = false;
        paramter.isSingleChoice = true;
        MMSelectContactsActivity.show((Fragment)this, paramter, assignAdminType, null);
    }

    private void onClickBtnClearHistory() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        int titleRes = this.mIsGroup ? R.string.zm_mm_msg_delete_group_chat_history_confirm : R.string.zm_mm_msg_delete_p2p_chat_history_confirm;
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(titleRes).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMChatInfoFragment.this.clearHistory();
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    private void onClickChkNotification() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            if (!messenger.isConnectionGood() || !NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
                this.showConnectionError();
                return;
            }
            NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
            if (mgr == null) {
                return;
            }
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.mSessionId);
            if (this.mChkNotification.isChecked()) {
                mgr.applyMUCSettings(this.mSessionId, 3);
            } else {
                mgr.applyMUCSettings(this.mSessionId, 1);
            }
            this.updateData();
        }
    }

    private void clearHistory() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (session.clearAllMessages()) {
            ZMActivity activity;
            if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
                AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnClearHistory, (int)R.string.zm_accessibility_history_clear_22864);
            }
            if ((activity = (ZMActivity)this.getActivity()) instanceof MMChatInfoActivity) {
                ((MMChatInfoActivity)activity).onHistoryCleared();
            }
        }
    }

    private void quitGroup() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        boolean res = messenger.deleteGroup(this.mGroupId);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showQuitGroupFailureMessage(1);
        }
    }

    @Override
    public void onClickAddBtn() {
        List<MMBuddyItem> items;
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ArrayList<String> preSelectedItems = null;
        if (this.mGvBuddies != null && (items = this.mGvBuddies.getAllItems()) != null) {
            preSelectedItems = new ArrayList<String>();
            for (MMBuddyItem item : items) {
                preSelectedItems.add(item.getBuddyJid());
            }
        }
        String title = this.mIsGroup ? activity.getString(R.string.zm_mm_title_add_contacts) : activity.getString(R.string.zm_mm_title_select_contacts);
        String btnOkText = activity.getString(R.string.zm_btn_ok);
        String instructionMessage = this.getString(R.string.zm_msg_select_buddies_to_join_group_instructions);
        boolean onlySameOrganization = false;
        if (this.mIsGroup) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomGroup group = messenger.getGroupById(this.mGroupId);
            onlySameOrganization = (group.getMucType() & 4) != 0;
        }
        MMSelectContactsActivity.SelectContactsParamter paramters = new MMSelectContactsActivity.SelectContactsParamter();
        paramters.title = title;
        paramters.preSelectedItems = preSelectedItems;
        paramters.btnOkText = btnOkText;
        paramters.instructionMessage = instructionMessage;
        paramters.isAnimBottomTop = true;
        paramters.isOnlySameOrganization = onlySameOrganization;
        paramters.maxSelectCount = PTApp.getInstance().getMaxChatGroupBuddyNumber();
        paramters.includeRobot = false;
        paramters.isContainsAllInGroup = false;
        MMSelectContactsActivity.show((Activity)activity, paramters, 100, null);
    }

    @Override
    public void onRemoveBuddy(MMBuddyItem item) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        if (StringUtil.isSameString((String)myself.getJid(), (String)item.getBuddyJid())) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        boolean res = messenger.removeBuddyFromGroup(this.mGroupId, item.getBuddyJid());
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showRemoveBuddyFailureMessage(1);
        }
    }

    @Override
    public void onClickBuddyItem(MMBuddyItem item) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(item.getBuddyJid());
        if (buddy == null) {
            return;
        }
        if (StringUtil.isSameString((String)buddy.getJid(), (String)myself.getJid())) {
            return;
        }
        IMAddrBookItem contact = item.getLocalContact();
        if (contact == null) {
            contact = IMAddrBookItem.fromZoomBuddy(buddy);
        }
        if (contact != null) {
            contact.setIsZoomUser(true);
        }
        AddrBookItemDetailsActivity.show((Fragment)this, contact, !this.mIsGroup, 100);
    }

    public void onContactsSelected(ArrayList<IMAddrBookItem> abItems) {
        if (abItems == null || abItems.size() == 0) {
            return;
        }
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
            String title = this.mIsGroup ? this.getString(R.string.zm_mm_title_add_contacts) : this.getString(R.string.zm_mm_title_select_contacts);
            AccessibilityUtil.announceForAccessibilityCompat((View)this.mGvBuddies, (CharSequence)this.getString(R.string.zm_accessibility_select_contacts_success_22861, new Object[]{title}));
        }
        if (this.mIsGroup) {
            this.addBuddiesToGroup(abItems);
        } else {
            this.makeGroupWithNewBuddies(abItems);
        }
    }

    private void addBuddiesToGroup(ArrayList<IMAddrBookItem> abItems) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (IMAddrBookItem item : abItems) {
            String jid = item.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) continue;
            buddies.add(item.getJid());
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        boolean res = messenger.addBuddyToGroup(this.mGroupId, buddies);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showAddBuddiesFailureMessage(1);
        }
    }

    private void makeGroupWithNewBuddies(ArrayList<IMAddrBookItem> abItems) {
        ZoomBuddy myself;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (IMAddrBookItem item : abItems) {
            String jid = item.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) continue;
            buddies.add(item.getJid());
        }
        if (!StringUtil.isEmptyOrNull((String)this.mBuddyId)) {
            buddies.add(this.mBuddyId);
        }
        if ((myself = messenger.getMyself()) == null) {
            return;
        }
        String myJid = myself.getJid();
        if (StringUtil.isEmptyOrNull((String)myJid)) {
            return;
        }
        if (!buddies.contains(myJid)) {
            buddies.add(myJid);
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        PTAppProtos.MakeGroupResult result = messenger.makeGroup(buddies, "", 80L);
        if (result != null && result.getResult()) {
            if (result.getValid()) {
                String groupId = result.getReusableGroupId();
                ZMActivity activity = (ZMActivity)this.getActivity();
                if (activity == null || StringUtil.isEmptyOrNull((String)groupId)) {
                    return;
                }
                MMChatInfoFragment.startGroupChat(activity, groupId);
            } else {
                this.showWaitingDialog();
            }
        } else {
            this.showMakeGroupFailureMessage(1);
        }
    }

    public void setGroupTopic(String topic) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        String name = group.getGroupName();
        if (StringUtil.isSameString((String)name, (String)topic)) {
            return;
        }
        boolean res = messenger.modifyGroupName(this.mGroupId, topic);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showChangeTopicFailureMessage(1);
        }
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        this.mWaitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        } else if (this.mWaitingDialog != null) {
            try {
                this.mWaitingDialog.dismissAllowingStateLoss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mWaitingDialog = null;
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void showChangeTopicFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_change_group_topic_failed);
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }

    private void showAddBuddiesFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
        } else if (result == 8) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_add_buddies_to_group_failed_too_many_buddies, (int)1).show();
        } else {
            String msg = context.getString(R.string.zm_mm_msg_add_buddies_to_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void showMakeGroupFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
        } else if (result == 8) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_make_group_failed_too_many_buddies, (int)1).show();
        } else {
            String msg = context.getString(R.string.zm_mm_msg_make_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void showQuitGroupFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_quit_group_failed, new Object[]{result});
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }

    private void showRemoveBuddyFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_remove_buddy_from_group_failed, new Object[]{result});
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }
}

