/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.File;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMAddBuddyFragment
extends ZMDialogFragment
implements View.OnClickListener,
TextView.OnEditorActionListener,
TextWatcher {
    private EditText mEdtEmail;
    private View mLayoutInput;
    private View mLayoutResult;
    private ProgressDialog mWaitDialog;
    private TextView mTxtResultDescription;
    private Button mBtnResultAction;
    private AvatarView mAvatarView;
    private IMAddrBookItem mAddrBookItem;
    private int mResult = -1;
    private static final int RESULT_NOFINISH = -1;
    private static final int RESULT_SUCCESS = 1;
    private static final int RESULT_EXITED = 2;
    private static final int RESULT_NO_MATCH = 3;
    private static final int RESULT_NETERROR = 4;
    private static final String EXTRA_RESULT = "result_code";
    private static final String EXTRA_SEARCH_EMAIL = "result_email";
    private static final String EXTRA_SEARCH_BUDDY = "search_buddy";
    private ZoomMessengerUI.IZoomMessengerUIListener mMessengerUI = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onSearchBuddy(String email, int result) {
            MMAddBuddyFragment.this.onSearchBuddy(email, result);
        }

        @Override
        public void onSearchBuddyByKey(String key, int result) {
            MMAddBuddyFragment.this.onSearchBuddyByKey(key, result);
        }

        @Override
        public void onSearchBuddyPicDownloaded(String jid) {
            MMAddBuddyFragment.this.onSearchBuddyPicDownloaded(jid);
        }
    };

    public static void showAsDialog(FragmentManager fm) {
        MMAddBuddyFragment f = new MMAddBuddyFragment();
        Bundle args = new Bundle();
        f.setArguments(args);
        f.show(fm, MMAddBuddyFragment.class.getName());
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ZoomMessengerUI.getInstance().addListener(this.mMessengerUI);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setView(this.createContent(savedInstanceState)).setTheme(R.style.ZMDialog_Material_Transparent).create();
        Window window = dialog.getWindow();
        if (window != null) {
            window.clearFlags(131080);
            window.setSoftInputMode(4);
        }
        return dialog;
    }

    private View createContent(Bundle savedInstanceState) {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_mm_add_buddy, null);
        this.mEdtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mEdtEmail.addTextChangedListener((TextWatcher)this);
        this.mEdtEmail.requestFocus();
        this.mAvatarView = (AvatarView)view.findViewById(R.id.avatarView);
        this.mAvatarView.setBorderSize(0);
        this.mLayoutInput = view.findViewById(R.id.layoutInput);
        this.mLayoutResult = view.findViewById(R.id.layoutResult);
        this.mTxtResultDescription = (TextView)view.findViewById(R.id.txtResultDescription);
        this.mBtnResultAction = (Button)view.findViewById(R.id.btnResultAction);
        this.mBtnResultAction.setEnabled(false);
        this.mBtnResultAction.setOnClickListener((View.OnClickListener)this);
        this.mEdtEmail.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        if (savedInstanceState != null) {
            this.mResult = savedInstanceState.getInt(EXTRA_RESULT, -1);
            String jid = savedInstanceState.getString(EXTRA_SEARCH_BUDDY);
            String email = savedInstanceState.getString(EXTRA_SEARCH_EMAIL);
            this.mEdtEmail.setText((CharSequence)email);
            ZoomBuddy item = this.getSearchBuddy();
            if (!StringUtil.isEmptyOrNull((String)jid) && item != null && StringUtil.isSameString((String)jid, (String)item.getJid())) {
                this.mAddrBookItem = IMAddrBookItem.fromZoomBuddy(item);
            }
            if (this.mResult != -1) {
                this.showAddBuddyFinish(this.mResult, this.mAddrBookItem);
            }
        }
        return view;
    }

    private void closeProgressDialog() {
        if (this.mWaitDialog != null && this.mWaitDialog.isShowing()) {
            this.mWaitDialog.dismiss();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putInt(EXTRA_RESULT, this.mResult);
            outState.putString(EXTRA_SEARCH_EMAIL, this.mEdtEmail.getText().toString());
            if (this.mAddrBookItem != null) {
                outState.putString(EXTRA_SEARCH_BUDDY, this.mAddrBookItem.getJid());
            }
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        ZoomMessengerUI.getInstance().removeListener(this.mMessengerUI);
        this.closeProgressDialog();
        super.onDestroy();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void sendEmail(String email) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        String subject = messenger.getAddBuddySubject();
        String content = messenger.getAddBuddyEmail();
        AndroidAppUtil.sendEmail((Context)activity, (String[])new String[]{email}, (String)subject, (String)content, null);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnResultAction) {
            if (this.mLayoutInput.isShown()) {
                this.onClickSearchBuddy();
            } else {
                this.onClickBtnResultAction();
            }
        }
    }

    private void onClickBtnResultAction() {
        switch (this.mResult) {
            case 3: {
                this.sendEmail(this.mEdtEmail.getText().toString());
                break;
            }
            case 2: {
                ZoomBuddy buddy;
                ZoomMessenger messenger;
                FragmentActivity context = this.getActivity();
                if (!(context instanceof ZMActivity) || this.mAddrBookItem == null || (messenger = PTApp.getInstance().getZoomMessenger()) == null || messenger.imChatGetOption() == 2 || (buddy = messenger.getBuddyWithJID(this.mAddrBookItem.getJid())) == null || buddy.isPending()) break;
                MMChatActivity.showAsOneToOneChat((ZMActivity)context, buddy);
                break;
            }
        }
        this.dismiss();
    }

    private boolean validateInput(String input) {
        if (StringUtil.isValidEmailAddress((String)input)) {
            ZoomBuddy buddy;
            String myEmail;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            return messenger == null || (myEmail = (buddy = messenger.getMyself()).getEmail()) == null || !StringUtil.isSameString((String)input, (String)(myEmail = myEmail.toLowerCase(Locale.US)));
        }
        return false;
    }

    private void onClickSearchBuddy() {
        String input = this.mEdtEmail.getText().toString().trim().toLowerCase(Locale.US);
        if (!this.validateInput(input)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood() || !NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        if (messenger.searchBuddyByKey(input)) {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            this.closeProgressDialog();
            this.mWaitDialog = UIUtil.showSimpleWaitingDialog((Activity)activity, (int)R.string.zm_msg_waiting);
            this.mWaitDialog.setCancelable(false);
        } else {
            this.showAddBuddyFinish(3);
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void showAddBuddyFinish(int code) {
        this.showAddBuddyFinish(code, null);
    }

    private void showAddBuddyFinish(int code, IMAddrBookItem item) {
        int start;
        if (!this.isAdded()) {
            return;
        }
        this.closeProgressDialog();
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtEmail);
        String input = this.mEdtEmail.getText().toString().trim().toLowerCase(Locale.US);
        String resultAction = null;
        String resultDescription = null;
        switch (code) {
            case 2: {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                boolean isPending = false;
                if (item != null) {
                    ZoomBuddy buddy = messenger.getBuddyWithJID(item.getJid());
                    boolean bl = isPending = buddy == null || buddy.isPending();
                    if (!isPending && !StringUtil.isEmptyOrNull((String)buddy.getScreenName())) {
                        input = buddy.getScreenName();
                    }
                } else {
                    isPending = true;
                }
                resultAction = this.getString(messenger.imChatGetOption() == 2 || isPending ? R.string.zm_system_notification_done : R.string.zm_description_contact_request_chat);
                if (item != null) {
                    this.loadAvatar(item, this.mAvatarView);
                } else {
                    this.mAvatarView.setAvatar(R.drawable.zm_emailnotmatch);
                }
                resultDescription = this.getString(R.string.zm_mm_msg_search_contact_result_is_buddy, new Object[]{input});
                break;
            }
            case 3: {
                resultDescription = this.getString(R.string.zm_mm_msg_search_contact_result_empty, new Object[]{input});
                resultAction = this.getString(R.string.zm_mm_msg_search_contact_invite_to_zoom);
                this.mAvatarView.setAvatar(R.drawable.zm_emailnotmatch);
                break;
            }
            case 1: {
                resultDescription = this.getString(R.string.zm_lbl_contact_request_sent, new Object[]{input});
                resultAction = this.getString(R.string.zm_system_notification_done);
                if (item != null) {
                    this.loadAvatar(item, this.mAvatarView);
                    break;
                }
                this.mAvatarView.setAvatar(R.drawable.zm_emailnotmatch);
                break;
            }
            case 4: {
                resultDescription = this.getString(R.string.zm_msg_disconnected_try_again);
                resultAction = this.getString(R.string.zm_system_notification_done);
                this.mAvatarView.setAvatar(R.drawable.zm_emailnotmatch);
                break;
            }
            default: {
                return;
            }
        }
        this.mResult = code;
        String description = resultDescription;
        if (resultDescription != null && (start = resultDescription.indexOf(input)) != -1) {
            SpannableString instruction = new SpannableString((CharSequence)resultDescription);
            ForegroundColorSpan span = new ForegroundColorSpan(this.getResources().getColor(R.color.zm_addbuddy_name));
            instruction.setSpan((Object)span, start, start + input.length(), 33);
            description = instruction;
        }
        this.mTxtResultDescription.setText((CharSequence)description);
        this.mLayoutInput.setVisibility(8);
        this.mLayoutResult.setVisibility(0);
        this.mBtnResultAction.setText((CharSequence)resultAction);
    }

    private void loadAvatar(IMAddrBookItem item, AvatarView avatarView) {
        if (avatarView != null && !avatarView.isInEditMode()) {
            String fromJid = item.getJid();
            avatarView.setName(item.getScreenName());
            avatarView.setBgColorSeedString(item.getJid());
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                File file;
                ZoomBuddy buddy = null;
                ZoomBuddy myself = messenger.getMyself();
                buddy = myself != null && fromJid != null && fromJid.equals(myself.getJid()) ? myself : messenger.getBuddyWithJID(fromJid);
                String avatarPath = null;
                if (buddy != null) {
                    avatarPath = buddy.getLocalPicturePath();
                }
                boolean hasAvatarFile = false;
                if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                    avatarView.setAvatar(avatarPath);
                    hasAvatarFile = true;
                }
                if (!hasAvatarFile) {
                    avatarView.setAvatar(item.getAvatarBitmap((Context)this.getActivity()));
                }
            }
        }
    }

    private ZoomBuddy getSearchBuddy() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomBuddySearchData data = messenger.getBuddySearchData();
        if (data == null) {
            return null;
        }
        ZoomBuddy buddy = null;
        int count = data.getBuddyCount();
        if (count > 0) {
            buddy = data.getBuddyAt(0);
        }
        return buddy;
    }

    private void onSearchBuddy(String email, int result) {
        if (result == 0) {
            this.mAddrBookItem = IMAddrBookItem.fromZoomBuddy(this.getSearchBuddy());
            if (this.mAddrBookItem != null) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null && messenger.isMyContact(this.mAddrBookItem.getJid())) {
                    this.showAddBuddyFinish(2, this.mAddrBookItem);
                } else {
                    this.inviteByEmail(this.mAddrBookItem.getJid());
                }
            }
        }
        if (result != 0 || this.mAddrBookItem == null) {
            this.showAddBuddyFinish(3);
        }
    }

    private void inviteByEmail(String jid) {
        String buddyEmail;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || TextUtils.isEmpty((CharSequence)jid)) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String buddyName = this.mAddrBookItem == null ? "" : this.mAddrBookItem.getScreenName();
        String string2 = buddyEmail = this.mAddrBookItem == null ? "" : this.mAddrBookItem.getAccountEmail();
        if (messenger.addBuddyByJID(jid, myself.getScreenName(), null, buddyName, buddyEmail)) {
            this.showAddBuddyFinish(1, this.mAddrBookItem);
            ZMBuddySyncInstance.getInsatance().onAddBuddyByJid(jid);
        } else {
            this.showAddBuddyFinish(4);
        }
    }

    private void onSearchBuddyPicDownloaded(String jid) {
        if (this.isAdded() && this.mAddrBookItem != null && this.mLayoutResult.isShown() && StringUtil.isSameString((String)jid, (String)this.mAddrBookItem.getJid())) {
            this.loadAvatar(this.mAddrBookItem, this.mAvatarView);
        }
    }

    private void onSearchBuddyByKey(String key, int result) {
        String input = this.mEdtEmail.getText().toString().trim().toLowerCase(Locale.US);
        if (!StringUtil.isSameString((String)key, (String)input)) {
            return;
        }
        this.mAddrBookItem = IMAddrBookItem.fromZoomBuddy(this.getSearchBuddy());
        if (this.mAddrBookItem == null) {
            if (!this.validateInput(input)) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            messenger.searchBuddy(key);
        } else {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            this.showAddBuddyFinish(2, this.mAddrBookItem);
            if (!messenger.isMyContact(this.mAddrBookItem.getJid())) {
                messenger.addSameOrgBuddyByJID(this.mAddrBookItem.getJid());
            }
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 6: {
                this.onClickSearchBuddy();
                return true;
            }
        }
        return false;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String input = this.mEdtEmail.getText().toString().trim().toLowerCase(Locale.US);
        this.mBtnResultAction.setEnabled(this.validateInput(input));
    }
}

