/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TabHost;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.RoomSystemCallInView;
import com.zipow.videobox.view.RoomSystemCallOutView;
import com.zipow.videobox.view.RoomSystemCallViewListener;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class InviteRoomSystemFragment
extends ZMDialogFragment
implements TabHost.TabContentFactory,
RoomSystemCallViewListener,
View.OnClickListener,
SimpleActivity.ExtListener {
    private RoomSystemCallInView mCallInView;
    private RoomSystemCallOutView mCallOutView;
    private TabHost mTabHost;
    private View mBtnClose;
    private Bundle mCallInSaveState;
    private Bundle mCallOutSaveState;
    private boolean mDisableBackPress = false;
    private boolean mStarted = false;
    private static final String TAB_CALL_IN = "call_in";
    private static final String TAB_CALL_OUT = "call_out";
    private static final String CURRENT_TAB = "current_tab";
    private static final String CALL_IN_INFO = "call_in_info";
    private static final String CALL_OUT_INFO = "call_out_info";

    public static void showAsActivity(ZMActivity activity, Bundle args, int requestCode) {
        if (activity == null) {
            return;
        }
        if (args == null) {
            args = new Bundle();
        }
        SimpleActivity.show(activity, InviteRoomSystemFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_invite_room_system_view, container, false);
        this.mTabHost = (TabHost)view.findViewById(0x1020012);
        this.mBtnClose = view.findViewById(R.id.btnClose);
        this.mBtnClose.setOnClickListener((View.OnClickListener)this);
        String tab = null;
        if (savedInstanceState != null) {
            tab = savedInstanceState.getString(CURRENT_TAB);
            this.mCallInSaveState = savedInstanceState.getBundle(CALL_IN_INFO);
            this.mCallOutSaveState = savedInstanceState.getBundle(CALL_OUT_INFO);
        }
        this.setupTabHost(this.mTabHost, inflater);
        if (!StringUtil.isEmptyOrNull((String)tab)) {
            this.mTabHost.setCurrentTabByTag(tab);
        }
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.mCallInView != null) {
            this.mCallInView.initialUIListener();
        }
        if (this.mCallOutView != null) {
            this.mCallOutView.initialUIListener();
        }
        this.mStarted = true;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        String currentTab = "";
        if (this.mTabHost != null) {
            currentTab = this.mTabHost.getCurrentTabTag();
        }
        if (StringUtil.isEmptyOrNull((String)currentTab)) {
            return;
        }
        outState.putString(CURRENT_TAB, currentTab);
        if (this.mCallInView != null) {
            outState.putBundle(CALL_IN_INFO, this.mCallInView.getSaveInstanceState());
        }
        if (this.mCallOutView != null) {
            outState.putBundle(CALL_OUT_INFO, this.mCallOutView.getSaveInstanceState());
        }
    }

    private void setupTabHost(TabHost tabHost, LayoutInflater inflater) {
        tabHost.setup();
        if (!PreferenceUtil.readBooleanValue("sdk_no_invite_room_call_out", false)) {
            tabHost.addTab(this.mTabHost.newTabSpec(TAB_CALL_IN).setIndicator(this.createCallInTabView(inflater)).setContent((TabHost.TabContentFactory)this));
            tabHost.addTab(this.mTabHost.newTabSpec(TAB_CALL_OUT).setIndicator(this.createCallOutTabView(inflater)).setContent((TabHost.TabContentFactory)this));
        } else {
            tabHost.addTab(this.mTabHost.newTabSpec(TAB_CALL_IN).setIndicator(this.createSingleCallInTabView(inflater)).setContent((TabHost.TabContentFactory)this));
        }
    }

    private View createCallInTabView(LayoutInflater inflater) {
        View view = inflater.inflate(R.layout.zm_tab_indicator_top, null);
        View icon = view.findViewById(R.id.icon);
        TextView title = (TextView)view.findViewById(R.id.title);
        icon.setVisibility(8);
        title.setText(R.string.zm_room_system_title_call_in);
        view.setBackgroundResource(R.drawable.zm_tab_indicator_top_first);
        view.setMinimumWidth(UIUtil.dip2px((Context)this.getActivity(), (float)100.0f));
        return view;
    }

    private View createCallOutTabView(LayoutInflater inflater) {
        View view = inflater.inflate(R.layout.zm_tab_indicator_top, null);
        View icon = view.findViewById(R.id.icon);
        TextView title = (TextView)view.findViewById(R.id.title);
        icon.setVisibility(8);
        title.setText(R.string.zm_room_system_title_call_out);
        view.setBackgroundResource(R.drawable.zm_tab_indicator_top_last);
        view.setMinimumWidth(UIUtil.dip2px((Context)this.getActivity(), (float)100.0f));
        return view;
    }

    private View createSingleCallInTabView(LayoutInflater inflater) {
        View view = inflater.inflate(R.layout.zm_tab_indicator_single, null);
        TextView title = (TextView)view.findViewById(R.id.title);
        title.setText(R.string.zm_room_system_title_call_in);
        return view;
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mCallInView != null) {
            this.mCallInView.destroy();
        }
        if (this.mCallOutView != null) {
            this.mCallOutView.destroy();
        }
    }

    public View createTabContent(String tag) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return null;
        }
        if (TAB_CALL_IN.equals(tag)) {
            this.mCallInView = new RoomSystemCallInView((Context)context, this.mCallInSaveState);
            this.mCallInView.setListener(this);
            if (this.mStarted) {
                this.mCallInView.initialUIListener();
            }
            return this.mCallInView;
        }
        if (TAB_CALL_OUT.equals(tag)) {
            this.mCallOutView = new RoomSystemCallOutView((Context)context, this.mCallOutSaveState);
            this.mCallOutView.setListener(this);
            if (this.mStarted) {
                this.mCallOutView.initialUIListener();
            }
            return this.mCallOutView;
        }
        return null;
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        if (v == this.mBtnClose) {
            this.dismiss();
        }
    }

    @Override
    public void onConnected(final boolean isCallOut) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                InviteRoomSystemFragment fragment = (InviteRoomSystemFragment)ui;
                if (isCallOut) {
                    fragment.enableClose(true);
                }
                fragment.dismiss();
            }
        });
    }

    @Override
    public void onConnecting(final boolean isCallOut) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                InviteRoomSystemFragment fragment = (InviteRoomSystemFragment)ui;
                if (isCallOut) {
                    fragment.enableClose(false);
                }
            }
        });
    }

    @Override
    public void onFailed(final boolean isCallOut) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                InviteRoomSystemFragment fragment = (InviteRoomSystemFragment)ui;
                if (isCallOut) {
                    fragment.enableClose(true);
                }
            }
        });
    }

    @Override
    public void onCancel(final boolean isCallOut) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                InviteRoomSystemFragment fragment = (InviteRoomSystemFragment)ui;
                if (isCallOut) {
                    fragment.enableClose(true);
                }
            }
        });
    }

    private void enableClose(boolean enable) {
        this.mBtnClose.setEnabled(enable);
        this.mDisableBackPress = !enable;
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
    }

    @Override
    public void onKeyboardClosed() {
    }

    @Override
    public boolean onBackPressed() {
        return this.mDisableBackPress;
    }
}

