/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.SelectCountryCodeFragment;
import com.zipow.videobox.fragment.SelectPhoneNumberFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class InviteByPhoneFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final int UPDATE_STATUS_DELAY_MILLIS = 3000;
    private static final int REQUEST_SELECT_COUTRY_CODE = 100;
    private static final int REQUEST_SELECT_PHONE_NUMBER = 101;
    private static final String ARG_SUPPORT_CALLOUT_TYPE = "supportCalloutType";
    private static final String ARG_SUPPORT_COUNTRY_CODES = "supportCountryCodes";
    private Button mBtnCall = null;
    private Button mBtnHangup = null;
    private Button mBtnBack = null;
    private EditText mEdtNumber = null;
    private EditText mEdtName = null;
    private View mBtnSelectCountryCode = null;
    private TextView mTxtCountryCode;
    private TextView mTxtMessage = null;
    private View mBtnSelectPhoneNumber = null;
    private SelectCountryCodeFragment.CountryCodeItem mSelectedCountryCode;
    private PTUI.IInviteByCallOutListener mInviteByCallOutListener;
    private PTUI.IPTUIListener mPTUIListener;
    private Handler mHandler = new Handler();
    private int mSupportCalloutType = 2;
    private ArrayList<SelectCountryCodeFragment.CountryCodeItem> mSupportCountryCodes;
    private static String s_lastCalloutNumber = null;
    private static String s_lastCalloutName = null;
    private boolean mIsInitCallStatus = true;

    public static void showAsActivity(ZMActivity activity, int supportCallOutType, ArrayList<SelectCountryCodeFragment.CountryCodeItem> supportCountryCodes, int requestCode) {
        Bundle args = new Bundle();
        args.putInt(ARG_SUPPORT_CALLOUT_TYPE, supportCallOutType);
        args.putSerializable(ARG_SUPPORT_COUNTRY_CODES, supportCountryCodes);
        SimpleActivity.show(activity, InviteByPhoneFragment.class.getName(), args, requestCode, true, 1);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_invite_by_phone, container, false);
        this.mBtnCall = (Button)view.findViewById(R.id.btnCall);
        this.mBtnHangup = (Button)view.findViewById(R.id.btnHangup);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mEdtNumber = (EditText)view.findViewById(R.id.edtNumber);
        this.mEdtName = (EditText)view.findViewById(R.id.edtName);
        this.mBtnSelectCountryCode = view.findViewById(R.id.btnSelectCountryCode);
        this.mTxtCountryCode = (TextView)view.findViewById(R.id.txtCountryCode);
        this.mTxtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mBtnSelectPhoneNumber = view.findViewById(R.id.btnSelectPhoneNumber);
        this.mBtnCall.setOnClickListener((View.OnClickListener)this);
        this.mBtnHangup.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSelectCountryCode.setOnClickListener((View.OnClickListener)this);
        this.mBtnSelectPhoneNumber.setOnClickListener((View.OnClickListener)this);
        this.installNumberChangeListener();
        this.installNameChangeListener();
        Bundle args = this.getArguments();
        if (args != null) {
            this.mSupportCalloutType = args.getInt(ARG_SUPPORT_CALLOUT_TYPE, this.mSupportCalloutType);
            this.mSupportCountryCodes = (ArrayList)args.getSerializable(ARG_SUPPORT_COUNTRY_CODES);
        }
        if (savedInstanceState == null) {
            this.loadDefaultNumber();
        } else {
            this.mSelectedCountryCode = (SelectCountryCodeFragment.CountryCodeItem)savedInstanceState.get("mSelectedCountryCode");
            this.mIsInitCallStatus = savedInstanceState.getBoolean("mIsInitCallStatus");
            this.updateSelectedCountry();
        }
        this.updateCallButton();
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mSelectedCountryCode", (Serializable)this.mSelectedCountryCode);
        outState.putBoolean("mIsInitCallStatus", this.mIsInitCallStatus);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        SelectPhoneNumberFragment.PhoneNumberItem item;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null) {
            SelectCountryCodeFragment.CountryCodeItem item2 = (SelectCountryCodeFragment.CountryCodeItem)data.getSerializableExtra("countryCode");
            if (item2 != null) {
                this.mSelectedCountryCode = item2;
                this.updateSelectedCountry();
            }
        } else if (requestCode == 101 && resultCode == -1 && data != null && (item = (SelectPhoneNumberFragment.PhoneNumberItem)data.getSerializableExtra("phoneNumber")) != null) {
            this.updateSelectedPhoneNumber(item);
        }
    }

    private String getCountryDisplayName(String isoCountryCode, String phoneCountryCode) {
        String countryName = null;
        for (SelectCountryCodeFragment.CountryCodeItem item : this.mSupportCountryCodes) {
            if (item == null || !StringUtil.isSameString((String)item.countryCode, (String)phoneCountryCode)) continue;
            countryName = item.countryName;
        }
        if (StringUtil.isEmptyOrNull(countryName)) {
            Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
            countryName = locale.getDisplayCountry();
        }
        return countryName;
    }

    private void updateSelectedCountry() {
        if (this.mSelectedCountryCode == null) {
            return;
        }
        this.mTxtCountryCode.setText((CharSequence)(this.mSelectedCountryCode.countryName + "(+" + this.mSelectedCountryCode.countryCode + ")"));
    }

    private void updateSelectedPhoneNumber(SelectPhoneNumberFragment.PhoneNumberItem item) {
        this.mEdtName.setText((CharSequence)item.contactName);
        String countryCode = item.countryCode;
        if (this.mSelectedCountryCode == null || !StringUtil.isSameString((String)this.mSelectedCountryCode.countryCode, (String)countryCode)) {
            String isoCountryCode = CountryCodeUtil.phoneCountryCodeToIsoCountryCode((String)countryCode);
            String countryName = this.getCountryDisplayName(isoCountryCode, countryCode);
            this.mSelectedCountryCode = new SelectCountryCodeFragment.CountryCodeItem(countryCode, isoCountryCode, countryName);
            this.updateSelectedCountry();
        }
        String number = item.normalizedNumber;
        number = this.truncateCountryCode(number, countryCode);
        this.mEdtNumber.setText((CharSequence)number);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeInviteByCallOutListener(this.mInviteByCallOutListener);
        PTUI.getInstance().removePTUIListener(this.mPTUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mInviteByCallOutListener == null) {
            this.mInviteByCallOutListener = new PTUI.IInviteByCallOutListener(){

                @Override
                public void onCallOutStatusChanged(int status) {
                    InviteByPhoneFragment.this.onCallOutStatusChanged(status);
                }
            };
        }
        PTUI.getInstance().addInviteByCallOutListener(this.mInviteByCallOutListener);
        if (this.mPTUIListener == null) {
            this.mPTUIListener = new PTUI.SimplePTUIListener(){

                @Override
                public void onPTAppEvent(int event, long result) {
                    InviteByPhoneFragment.this.onPTAppEvent(event, result);
                }
            };
        }
        PTUI.getInstance().addPTUIListener(this.mPTUIListener);
        this.updateUIForCallOutStatus(PTApp.getInstance().getCallOutStatus());
        this.updateUIForConfCallStatus(PTApp.getInstance().getCallStatus());
        this.updateUIForSupportCalloutType(this.mSupportCalloutType);
    }

    public void onDestroy() {
        super.onDestroy();
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null && activity.isFinishing()) {
            this.finishActivity(100);
            this.finishActivity(101);
        }
    }

    private void updateCallButton() {
        String countryCode = this.getSelectedCountryCode();
        String number = this.getPhoneNumber();
        String name = this.getUserName();
        boolean enabled = !StringUtil.isEmptyOrNull((String)countryCode) && !StringUtil.isEmptyOrNull((String)number) && number.length() > 4 && !StringUtil.isEmptyOrNull((String)name);
        this.mBtnCall.setEnabled(enabled);
    }

    private void installNumberChangeListener() {
        this.mEdtNumber.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                InviteByPhoneFragment.this.updateCallButton();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
    }

    private void installNameChangeListener() {
        this.mEdtName.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                InviteByPhoneFragment.this.updateCallButton();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
    }

    private void loadDefaultNumber() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mSelectedCountryCode = SelectCountryCodeFragment.CountryCodeItem.readFromPreference("callout_invite.select_country");
        if (this.mSelectedCountryCode == null || StringUtil.isEmptyOrNull((String)this.mSelectedCountryCode.isoCountryCode)) {
            String isoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)activity);
            if (isoCountryCode == null) {
                return;
            }
            String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountryCode);
            Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
            String countryName = locale.getDisplayCountry();
            this.mSelectedCountryCode = new SelectCountryCodeFragment.CountryCodeItem(phoneCountryCode, isoCountryCode, countryName);
        }
        if (s_lastCalloutNumber != null && PTApp.getInstance().getCallOutStatus() != 0) {
            this.mEdtNumber.setText((CharSequence)s_lastCalloutNumber);
            if (s_lastCalloutName != null) {
                this.mEdtName.setText((CharSequence)s_lastCalloutName);
            }
        }
        this.updateSelectedCountry();
    }

    private String truncateCountryCode(String phoneNumber, String countryCode) {
        int idx;
        if (StringUtil.isEmptyOrNull((String)phoneNumber) || StringUtil.isEmptyOrNull((String)countryCode)) {
            return phoneNumber;
        }
        String savedPhoneNumber = phoneNumber = PhoneNumberUtil.formatNumber((String)phoneNumber, (String)countryCode);
        int idxPlus = phoneNumber.indexOf(43);
        if (idxPlus >= 0) {
            phoneNumber = phoneNumber.substring(idxPlus + 1);
        }
        if ((idx = phoneNumber.indexOf(countryCode)) != 0) {
            return savedPhoneNumber;
        }
        return phoneNumber.substring(countryCode.length());
    }

    private void onCallOutStatusChanged(int status) {
        this.updateUIForCallOutStatus(status);
    }

    private void onPTAppEvent(int event, long result) {
        if (event == 22) {
            this.updateUIForConfCallStatus((int)result);
        }
    }

    private void updateUIForConfCallStatus(int status) {
        switch (status) {
            case 0: 
            case 1: {
                this.dismiss();
            }
        }
    }

    private void updateUIForCallOutStatus(int status) {
        if (status != 0) {
            this.mIsInitCallStatus = false;
        }
        switch (status) {
            case 0: {
                if (!this.mIsInitCallStatus) break;
                this.mTxtMessage.setText(R.string.zm_callout_msg_invite_indication);
                break;
            }
            case 1: {
                this.mTxtMessage.setText((CharSequence)this.getString(R.string.zm_callout_msg_calling, new Object[]{this.getFullPhoneNumber()}));
                break;
            }
            case 2: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_ringing);
                break;
            }
            case 3: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_call_accepted);
                break;
            }
            case 4: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_busy);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 5: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_not_available);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 6: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_user_hangup);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 7: 
            case 9: {
                this.mTxtMessage.setText((CharSequence)this.getString(R.string.zm_callout_msg_fail_to_call, new Object[]{this.getFullPhoneNumber()}));
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 8: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_success);
                this.dismissDelayed(3000L);
                break;
            }
            case 10: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_cancel_call);
                break;
            }
            case 12: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_cancel_call_fail);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 11: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_call_canceled);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 14: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_block_no_host);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 15: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_block_high_rate);
                this.updateCallStatusDelayed(3000L);
                break;
            }
            case 16: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_block_too_frequent);
                this.updateCallStatusDelayed(3000L);
            }
        }
        this.updateButtonsForCallOutStatus(status);
    }

    private void updateButtonsForCallOutStatus(int status) {
        switch (status) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                this.mBtnCall.setVisibility(0);
                this.mBtnHangup.setVisibility(8);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                this.mBtnCall.setVisibility(8);
                this.mBtnHangup.setVisibility(0);
                this.mBtnHangup.setEnabled(true);
                break;
            }
            case 10: {
                this.mBtnCall.setVisibility(8);
                this.mBtnHangup.setVisibility(0);
                this.mBtnHangup.setEnabled(false);
            }
        }
    }

    private void updateCallStatusDelayed(long delayMillis) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                InviteByPhoneFragment.this.updateUIForCallOutStatus(PTApp.getInstance().getCallOutStatus());
            }
        }, delayMillis);
    }

    private void dismissDelayed(long delayMillis) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                InviteByPhoneFragment.this.dismiss();
            }
        }, delayMillis);
    }

    private void updateUIForSupportCalloutType(int supportCalloutType) {
        if (1 == supportCalloutType) {
            this.mBtnSelectCountryCode.setEnabled(false);
            this.mSelectedCountryCode = new SelectCountryCodeFragment.CountryCodeItem("1", "US", Locale.US.getDisplayCountry());
            this.updateSelectedCountry();
        } else {
            this.mBtnSelectCountryCode.setEnabled(true);
            if (this.mSupportCountryCodes != null && this.mSupportCountryCodes.size() > 0) {
                boolean find = false;
                if (this.mSelectedCountryCode != null && this.mSelectedCountryCode.countryCode != null) {
                    for (SelectCountryCodeFragment.CountryCodeItem item : this.mSupportCountryCodes) {
                        if (!this.mSelectedCountryCode.countryCode.equalsIgnoreCase(item.countryCode)) continue;
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    this.mSelectedCountryCode = SelectCountryCodeFragment.CountryCodeItem.from(this.mSupportCountryCodes.get(0));
                    PreferenceUtil.saveStringValue("callout_invite.select_country", null);
                    s_lastCalloutNumber = null;
                    this.mEdtNumber.setText(null);
                    s_lastCalloutName = null;
                    this.mEdtName.setText(null);
                }
            }
            this.updateSelectedCountry();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnCall) {
            this.onClickBtnCall();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSelectCountryCode) {
            this.onClickBtnSelectCountryCode();
        } else if (id2 == R.id.btnHangup) {
            this.onClickBtnHangup();
        } else if (id2 == R.id.btnSelectPhoneNumber) {
            this.onClickBtnSelectPhoneNumber();
        }
    }

    private void onClickBtnSelectCountryCode() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        ArrayList<SelectCountryCodeFragment.CountryCodeItem> filterCountryCodes = null;
        if (this.mSupportCalloutType == 1) {
            filterCountryCodes = new ArrayList<SelectCountryCodeFragment.CountryCodeItem>();
            filterCountryCodes.add(new SelectCountryCodeFragment.CountryCodeItem("1", "US", Locale.US.getDisplayCountry()));
        } else if (this.mSupportCalloutType == 2) {
            filterCountryCodes = this.mSupportCountryCodes;
        }
        SelectCountryCodeFragment.showAsActivity((Fragment)this, filterCountryCodes, true, 100);
    }

    private void onClickBtnSelectPhoneNumber() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        ArrayList<SelectCountryCodeFragment.CountryCodeItem> filterCountryCodes = null;
        if (this.mSupportCalloutType == 1) {
            filterCountryCodes = new ArrayList<SelectCountryCodeFragment.CountryCodeItem>();
            filterCountryCodes.add(new SelectCountryCodeFragment.CountryCodeItem("1", "US", Locale.US.getDisplayCountry()));
        } else if (this.mSupportCalloutType == 2) {
            filterCountryCodes = this.mSupportCountryCodes;
        }
        SelectPhoneNumberFragment.showAsActivity((Fragment)this, filterCountryCodes, 101);
    }

    private void onClickBtnCall() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        String userName = this.getUserName();
        String number = this.getFullPhoneNumber();
        if (StringUtil.isEmptyOrNull((String)number) || StringUtil.isEmptyOrNull((String)userName)) {
            return;
        }
        PTApp.getInstance().inviteCallOutUser(number, userName);
        this.saveDataAsDefault();
    }

    private void saveDataAsDefault() {
        if (this.mSelectedCountryCode != null) {
            this.mSelectedCountryCode.savePreference("callout_invite.select_country");
        }
        s_lastCalloutNumber = this.getPhoneNumber();
        s_lastCalloutName = this.getUserName();
    }

    private void onClickBtnHangup() {
        PTApp.getInstance().cancelCallOut();
    }

    private String getSelectedCountryCode() {
        if (this.mSelectedCountryCode == null) {
            return null;
        }
        return this.mSelectedCountryCode.countryCode;
    }

    private String getUserName() {
        String str = this.mEdtName.getText().toString().trim();
        return str;
    }

    private String getPhoneNumber() {
        String phoneNumber = this.mEdtNumber.getText().toString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (c == '+' && builder.length() == 0) {
                builder.append(c);
                continue;
            }
            if (c == ',' || c == ';') break;
        }
        return builder.toString();
    }

    private String getFullPhoneNumber() {
        return "+" + this.getSelectedCountryCode() + this.getPhoneNumber();
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        this.finishFragment(0);
    }
}

