/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.fragment.MMSelectSessionAndBuddyFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.view.mm.MMContentFileViewerFragment;
import com.zipow.videobox.view.mm.MMContentSearchFilesListView;
import com.zipow.videobox.view.mm.MMContentSearchMessagesListView;
import com.zipow.videobox.view.mm.MMShareZoomFileDialogFragment;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class IMSessionSearchFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
OnContentFileOperatorListener {
    public static final String TAG = IMSessionSearchFragment.class.getSimpleName();
    private static String ARG_CONTENT_MODE = "content_mode";
    private static String ARG_MESSAGE_FIRST = "message_first";
    private static String ARG_SESSION_ID = "session_id";
    private static final int UI_MODE_FILES = 1;
    private static final int UI_MODE_MESSAGES = 2;
    public static final int REQUEST_VIEW_FILE_DETAIL = 3001;
    public static final int REQUEST_GET_SHAREER = 2014;
    public static final int REQUEST_DO_SHAREER = 2015;
    private static final String ARGS_SHARE_FILE_ID = "shareFileId";
    private String mContextMsgReqId;
    private String mContextAnchorMsgGUID;
    private WaitingDialog mWaitingDialog;
    private String mUnshareReqId;
    private String mShareReqId;
    private TextView mTxtLoadingError;
    private View mTxtContentLoading;
    private View mPanelEmptyView;
    private View mTxtEmptyView;
    private View mPanelTitleBar;
    private EditText mEdtSearch;
    private Button mBtnClearSearchView;
    private MMContentSearchFilesListView mFilesListView;
    private MMContentSearchMessagesListView mMessagesListView;
    private View mPanelFiles;
    private View mPanelMessages;
    private boolean mIsOwnerMode = false;
    private boolean mIsMessageFirst = false;
    private TextView mTxtTabFilesLabel;
    private TextView mTxtTabMessagesLabel;
    private int mUIMode = 1;
    private boolean mbKeyboardOpen = false;
    private boolean mbIgnoreKeyboardCloseEvent = false;
    private String sessionId = null;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_FileContentSearchResult(String reqID, int result, PTAppProtos.FileFilterSearchResults response) {
            IMSessionSearchFragment.this.Indicate_FileContentSearchResult(reqID, result, response);
        }

        @Override
        public void Indicate_MessageContentSearchResult(String reqID, int result, PTAppProtos.MessageContentSearchResponse response) {
            IMSessionSearchFragment.this.Indicate_MessageContentSearchResult(reqID, result, response);
        }

        @Override
        public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
            IMSessionSearchFragment.this.Indicate_PreviewDownloaded(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileDeleted(String reqId, String webFileID, int result) {
            IMSessionSearchFragment.this.Indicate_FileDeleted(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
            IMSessionSearchFragment.this.Indicate_FileShared(reqId, webFileID, sharee, newSession, newMsgXmppID, result);
        }

        @Override
        public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
            IMSessionSearchFragment.this.Indicate_FileUnshared(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
            IMSessionSearchFragment.this.Indicate_FileActionStatus(actionType, fileId, actionOwner, fileName, sessionId, msgId);
        }
    };

    public static void showAsFragment(Fragment fragment, String sessionId, int requestCode, boolean isOwnerMode, boolean bMessageFirst) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_CONTENT_MODE, isOwnerMode);
        args.putBoolean(ARG_MESSAGE_FIRST, bMessageFirst);
        args.putString(ARG_SESSION_ID, sessionId);
        SimpleActivity.show(fragment, IMSessionSearchFragment.class.getName(), args, requestCode, 2);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            this.mIsOwnerMode = args.getBoolean(ARG_CONTENT_MODE, false);
            this.mIsMessageFirst = args.getBoolean(ARG_MESSAGE_FIRST, false);
            this.sessionId = args.getString(ARG_SESSION_ID);
        }
        View view = inflater.inflate(R.layout.zm_im_session_search_fragment, container, false);
        final Button btnSearch = (Button)view.findViewById(R.id.btnSearch);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mFilesListView = (MMContentSearchFilesListView)view.findViewById(R.id.listViewContentFiles);
        this.mMessagesListView = (MMContentSearchMessagesListView)view.findViewById(R.id.listViewContentMessages);
        if (this.mIsMessageFirst) {
            this.mPanelFiles = view.findViewById(R.id.panelMessages);
            this.mPanelMessages = view.findViewById(R.id.panelFiles);
            this.mTxtTabFilesLabel = (TextView)view.findViewById(R.id.txtTabMessagesLabel);
            this.mTxtTabMessagesLabel = (TextView)view.findViewById(R.id.txtTabFilesLabel);
            this.mEdtSearch.setHint(R.string.zm_hint_search_messages_18680);
            this.mUIMode = 2;
        } else {
            this.mPanelFiles = view.findViewById(R.id.panelFiles);
            this.mPanelMessages = view.findViewById(R.id.panelMessages);
            this.mTxtTabFilesLabel = (TextView)view.findViewById(R.id.txtTabFilesLabel);
            this.mTxtTabMessagesLabel = (TextView)view.findViewById(R.id.txtTabMessagesLabel);
            this.mEdtSearch.setHint(R.string.zm_hint_search_content_18680);
            this.mUIMode = 1;
        }
        this.mTxtLoadingError = (TextView)view.findViewById(R.id.txtLoadingError);
        this.mTxtContentLoading = view.findViewById(R.id.txtContentLoading);
        this.mPanelEmptyView = view.findViewById(R.id.panelEmptyView);
        this.mTxtEmptyView = view.findViewById(R.id.txtEmptyView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        btnSearch.setVisibility(8);
        btnSearch.setOnClickListener((View.OnClickListener)this);
        this.mFilesListView.setListener(this);
        this.mMessagesListView.setParentFragment(this);
        this.mFilesListView.setPullDownRefreshEnabled(false);
        this.mEdtSearch.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    IMSessionSearchFragment.this.startSearch();
                }
                return false;
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                IMSessionSearchFragment.this.mBtnClearSearchView.setVisibility(s.length() != 0 ? 0 : 8);
                btnSearch.setVisibility(s.length() != 0 ? 0 : 8);
            }
        });
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mPanelFiles.setOnClickListener((View.OnClickListener)this);
        this.mPanelMessages.setOnClickListener((View.OnClickListener)this);
        this.mTxtLoadingError.setOnClickListener((View.OnClickListener)this);
        this.mTxtLoadingError.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.zm_lbl_content_load_error)));
        this.mFilesListView.setIsOwnerMode(this.mIsOwnerMode);
        if (savedInstanceState != null) {
            this.mUIMode = savedInstanceState.getInt("uiMode", 1);
            this.mIsOwnerMode = savedInstanceState.getBoolean("mIsOwnerMode", false);
            this.mContextMsgReqId = savedInstanceState.getString("mContextMsgReqId");
            this.mContextAnchorMsgGUID = savedInstanceState.getString("mContextAnchorMsgGUID");
            this.mUnshareReqId = savedInstanceState.getString("mUnshareReqId");
            this.mShareReqId = savedInstanceState.getString("mShareReqId");
            this.mbIgnoreKeyboardCloseEvent = savedInstanceState.getBoolean("mbIgnoreKeyboardCloseEvent");
            int visibility = savedInstanceState.getInt("mPanelTitleBar", -1);
            if (visibility != -1) {
                this.mPanelTitleBar.setVisibility(visibility);
            }
        }
        this.updateUIMode();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 3001: {
                if (resultCode != -1 || data == null) break;
                int action = data.getIntExtra("action", 0);
                String fileWebId = data.getStringExtra("zoomFileWebId");
                String reqId = data.getStringExtra("reqId");
                this.dealResultForZoomFileViewer(action, fileWebId, reqId);
                break;
            }
            case 2014: {
                if (resultCode != -1 || data == null) break;
                Bundle bundle = data.getExtras();
                if (bundle == null) {
                    return;
                }
                String messageId = bundle.getString(ARGS_SHARE_FILE_ID);
                if (StringUtil.isEmptyOrNull((String)messageId)) {
                    return;
                }
                String jid = data.getStringExtra("selectedItem");
                if (StringUtil.isEmptyOrNull((String)jid)) {
                    return;
                }
                ArrayList<String> sharees = new ArrayList<String>();
                sharees.add(jid);
                if (sharees.size() <= 0) break;
                this.doShareFile(sharees, messageId);
                break;
            }
            case 2015: {
                if (resultCode != -1 || data == null) break;
                this.mShareReqId = data.getStringExtra("reqId");
            }
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            this.getActivity().getWindow().setSoftInputMode(21);
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        this.mbKeyboardOpen = true;
        this.mbIgnoreKeyboardCloseEvent = false;
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mbKeyboardOpen) {
            this.mbKeyboardOpen = false;
            if (!this.mbIgnoreKeyboardCloseEvent && this.isResultEmpty()) {
                this.dismiss();
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private boolean isResultEmpty() {
        boolean empty = true;
        if (this.mFilesListView != null) {
            empty = this.mFilesListView.isResultEmpty();
        }
        if (this.mMessagesListView != null) {
            empty &= this.mMessagesListView.isResultEmpty();
        }
        return empty;
    }

    private void checkContentFileIsEmpty() {
        if (!(this.mMessagesListView.isLoading() || this.mFilesListView.isLoading() || this.mFilesListView.isLoadSuccess() && !this.mFilesListView.isEmpty() || !this.mMessagesListView.isLoadSuccess() || this.mMessagesListView.isEmpty())) {
            this.mUIMode = 2;
            this.updateUIMode();
            this.updateEmptyViewStatus();
        }
    }

    private void updateEmptyViewStatus() {
        boolean isEmpty = false;
        boolean isLoading = false;
        boolean isLoadSuccess = false;
        if (this.mUIMode == 1) {
            isEmpty = this.mFilesListView.isEmpty();
            isLoading = this.mFilesListView.isLoading();
            isLoadSuccess = this.mFilesListView.isLoadSuccess();
        } else {
            isEmpty = this.mMessagesListView.isEmpty();
            isLoading = this.mMessagesListView.isLoading();
            isLoadSuccess = this.mMessagesListView.isLoadSuccess();
        }
        this.mPanelEmptyView.setVisibility((isEmpty &= this.mEdtSearch.getText().toString().trim().length() != 0) ? 0 : 8);
        if (isLoading) {
            this.mTxtContentLoading.setVisibility(0);
            this.mTxtEmptyView.setVisibility(8);
            this.mTxtLoadingError.setVisibility(8);
        } else {
            this.mTxtContentLoading.setVisibility(8);
            this.mTxtEmptyView.setVisibility(isLoadSuccess ? 0 : 8);
            this.mTxtLoadingError.setVisibility(!isLoadSuccess ? 0 : 8);
        }
    }

    private void doShareFile(ArrayList<String> sharees, String fileID) {
        MMShareZoomFileDialogFragment.showShareFileDialog(this.getFragmentManager(), sharees, fileID, (Fragment)this, 2015);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putInt("uiMode", this.mUIMode);
            outState.putBoolean("mIsOwnerMode", this.mIsOwnerMode);
            outState.putString("mContextMsgReqId", this.mContextMsgReqId);
            outState.putString("mContextAnchorMsgGUID", this.mContextAnchorMsgGUID);
            outState.putString("mUnshareReqId", this.mUnshareReqId);
            outState.putString("mShareReqId", this.mShareReqId);
            outState.putInt("mPanelTitleBar", this.mPanelTitleBar.getVisibility());
            outState.putBoolean("mbIgnoreKeyboardCloseEvent", this.mbIgnoreKeyboardCloseEvent);
        }
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    private void dealResultForZoomFileViewer(int action, String fileWebId, String reqId) {
        if (StringUtil.isEmptyOrNull((String)fileWebId)) {
            return;
        }
        switch (action) {
            case 1: {
                this.Indicate_FileDeleted(reqId, fileWebId, 0);
                break;
            }
        }
    }

    private void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        if (StringUtil.isSameString((String)reqId, (String)this.mShareReqId)) {
            this.mFilesListView.Indicate_FileShared(reqId, webFileID, sharee, newSession, newMsgXmppID, result);
        }
    }

    private void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        if (StringUtil.isSameString((String)reqId, (String)this.mUnshareReqId)) {
            this.mFilesListView.Indicate_FileUnshared(reqId, webFileID, result);
        }
    }

    public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        if (actionType == 1) {
            this.mFilesListView.Indicate_FileDeleted(null, fileId, 0);
        } else if (actionType == 2) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithWebFileID(fileId);
            if (file == null) {
                this.mFilesListView.Indicate_FileDeleted(null, fileId, 0);
            } else {
                MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
                if (mmFile == null) {
                    return;
                }
                if (mmFile.getShareAction() == null || mmFile.getShareAction().size() == 0) {
                    this.mFilesListView.Indicate_FileDeleted(null, fileId, 0);
                }
            }
        }
    }

    private void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        this.mFilesListView.Indicate_FileDeleted(reqID, webFileID, result);
    }

    public void Indicate_FileContentSearchResult(String reqID, int result, PTAppProtos.FileFilterSearchResults response) {
        this.mFilesListView.Indicate_FileContentSearchResult(reqID, result, response);
        this.updateEmptyViewStatus();
        this.checkContentFileIsEmpty();
        if (result == 0 && response != null) {
            this.mTxtTabFilesLabel.setText((CharSequence)String.format("%s(%d)", this.getString(R.string.zm_tab_content_search_contents), response.getSearchResultCount()));
        }
    }

    public void Indicate_MessageContentSearchResult(String reqID, int result, PTAppProtos.MessageContentSearchResponse response) {
        this.mMessagesListView.Indicate_MessageContentSearchResult(reqID, result, response);
        this.updateEmptyViewStatus();
        this.checkContentFileIsEmpty();
        if (result == 0 && response != null) {
            this.mTxtTabMessagesLabel.setText((CharSequence)String.format("%s(%d)", this.getString(R.string.zm_tab_content_search_messages), response.getSearchResponseCount()));
        }
    }

    public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        this.mFilesListView.Indicate_PreviewDownloaded(reqId, webFileID, result);
    }

    private void showWaitDialog() {
        this.mWaitingDialog = new WaitingDialog(this.getString(R.string.zm_msg_waiting));
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(this.getFragmentManager(), "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog == null) {
            FragmentManager fm = this.getFragmentManager();
            if (fm == null) {
                return;
            }
            this.mWaitingDialog = (WaitingDialog)fm.findFragmentByTag("WaitingDialog");
        }
        if (this.mWaitingDialog != null) {
            this.mWaitingDialog.dismissAllowingStateLoss();
        }
        this.mWaitingDialog = null;
    }

    private void updateUIMode() {
        switch (this.mUIMode) {
            case 1: {
                this.mPanelMessages.setSelected(false);
                this.mPanelFiles.setSelected(true);
                this.mMessagesListView.setVisibility(8);
                this.mFilesListView.setVisibility(0);
                break;
            }
            case 2: {
                this.mPanelMessages.setSelected(true);
                this.mPanelFiles.setSelected(false);
                this.mMessagesListView.setVisibility(0);
                this.mFilesListView.setVisibility(8);
                break;
            }
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnSearch) {
            this.onClickBtnSearch();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.txtLoadingError) {
            this.onClickTxtLoadingError();
        }
        if (v == this.mPanelFiles) {
            this.onClickPanelContents();
        } else if (v == this.mPanelMessages) {
            this.onClickPanelMessages();
        }
    }

    private void onClickTxtLoadingError() {
        if (!this.mFilesListView.isLoadSuccess()) {
            this.mFilesListView.searchContent(this.sessionId);
        }
        if (!this.mMessagesListView.isLoadSuccess()) {
            this.mMessagesListView.searchMessage(this.sessionId);
        }
        this.updateEmptyViewStatus();
    }

    private void onClickPanelMessages() {
        this.mUIMode = 2;
        this.updateUIMode();
        this.updateEmptyViewStatus();
    }

    private void onClickPanelContents() {
        this.mUIMode = 1;
        this.updateUIMode();
        this.updateEmptyViewStatus();
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
    }

    private void onClickBtnSearch() {
        this.startSearch();
    }

    @Override
    public void onZoomFileClick(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMContentFileViewerFragment.showAsActivity((Fragment)this, fileId, 3001);
    }

    @Override
    public void onZoomFileShared(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString(ARGS_SHARE_FILE_ID, fileId);
        MMSelectSessionAndBuddyFragment.showAsFragment((Fragment)this, bundle, false, false, 2014);
    }

    @Override
    public void onZoomFileCancelTransfer(String fileId) {
        boolean res;
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        PendingFileDataHelper.PendingFileInfo info = PendingFileDataHelper.getInstance().getDownloadPendingInfoByWebFileId(fileId);
        if (info == null) {
            return;
        }
        String reqId = info.getReqId();
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr != null && (res = mgr.cancelFileTransfer(reqId, fileId))) {
            this.mFilesListView.endFileTransfer(fileId);
            PendingFileDataHelper.getInstance().removeDownloadPendingFile(fileId);
        }
    }

    @Override
    public void onZoomFileSharerAction(String fileId, MMZoomShareAction action) {
        if (StringUtil.isEmptyOrNull((String)fileId) || action == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        ArrayList<SharerActionContextMenuItem> items = new ArrayList<SharerActionContextMenuItem>();
        items.add(new SharerActionContextMenuItem(this.getString(R.string.zm_btn_jump_group), 0, fileId, action));
        items.add(new SharerActionContextMenuItem(this.getString(R.string.zm_btn_unshare_group), 1, fileId, action));
        menuAdapter.addAll(items);
        TextView titleView = new TextView((Context)this.getActivity());
        if (Build.VERSION.SDK_INT < 23) {
            titleView.setTextAppearance((Context)this.getActivity(), R.style.ZMTextView_Medium);
        } else {
            titleView.setTextAppearance(R.style.ZMTextView_Medium);
        }
        int padding = UIUtil.dip2px((Context)this.getActivity(), (float)20.0f);
        titleView.setPadding(padding, padding, padding, padding / 2);
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileId);
        if (file == null) {
            return;
        }
        String name = file.getFileName();
        mgr.destroyFileObject(file);
        titleView.setText((CharSequence)this.getString(R.string.zm_title_sharer_action, new Object[]{name, action.getShareeName((Context)this.getActivity())}));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitleView((View)titleView).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SharerActionContextMenuItem mi = (SharerActionContextMenuItem)((Object)menuAdapter.getItem(which));
                IMSessionSearchFragment.this.onSelectSharerActionContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectSharerActionContextMenuItem(SharerActionContextMenuItem mi) {
        if (mi == null) {
            return;
        }
        switch (mi.getAction()) {
            case 0: {
                MMChatActivity.showAsGroupChat((ZMActivity)this.getActivity(), mi.mShareAction.getSharee());
                break;
            }
            case 1: {
                UnshareAlertDialog.showUnshareAlertDialog(this.getFragmentManager(), mi.mFileId, mi.mShareAction);
                break;
            }
        }
    }

    private void unshareZoomFile(String fileId, MMZoomShareAction action) {
        if (StringUtil.isEmptyOrNull((String)fileId) || action == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ArrayList<String> sharees = new ArrayList<String>();
        sharees.add(action.getSharee());
        this.mUnshareReqId = mgr.unshareFile(fileId, sharees);
        if (StringUtil.isEmptyOrNull((String)this.mUnshareReqId)) {
            this.handelFileUnsharedErrorCode(-1);
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)0).show();
    }

    private void handelFileUnsharedErrorCode(int code) {
        if (code == 0) {
            return;
        }
        String msg = this.getString(R.string.zm_alert_unshare_file_failed);
        ErrorMsgDialog.newInstance(msg, -1).show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
    }

    private void startSearch() {
        String filter = this.mEdtSearch.getText().toString().trim();
        if (StringUtil.isEmptyOrNull((String)filter)) {
            return;
        }
        this.mPanelTitleBar.setVisibility(0);
        this.mFilesListView.setFilter(filter, this.sessionId);
        this.mMessagesListView.setFilter(filter, this.sessionId);
        this.updateEmptyViewStatus();
        this.mbIgnoreKeyboardCloseEvent = true;
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.mTxtTabFilesLabel.setText(R.string.zm_tab_content_search_contents);
        this.mTxtTabMessagesLabel.setText(R.string.zm_tab_content_search_messages);
    }

    public static class UnshareAlertDialog
    extends ZMDialogFragment {
        static final String ARG_FILE_ID = "fileId";
        static final String ARG_SHARE_ACTION = "shareAction";
        private String mFileId;
        private MMZoomShareAction mAction;

        public static void showUnshareAlertDialog(FragmentManager fm, String fileId, MMZoomShareAction action) {
            if (StringUtil.isEmptyOrNull((String)fileId) || action == null) {
                return;
            }
            UnshareAlertDialog dialog = new UnshareAlertDialog();
            Bundle args = new Bundle();
            args.putString(ARG_FILE_ID, fileId);
            args.putSerializable(ARG_SHARE_ACTION, (Serializable)action);
            dialog.setArguments(args);
            dialog.show(fm, UnshareAlertDialog.class.getName());
        }

        public UnshareAlertDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            if (args != null) {
                this.mFileId = args.getString(ARG_FILE_ID);
                this.mAction = (MMZoomShareAction)args.getSerializable(ARG_SHARE_ACTION);
            }
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_alert_unshare_msg).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    IMSessionSearchFragment fragment = (IMSessionSearchFragment)UnshareAlertDialog.this.getFragmentManager().findFragmentByTag(IMSessionSearchFragment.class.getName());
                    if (fragment != null) {
                        fragment.unshareZoomFile(UnshareAlertDialog.this.mFileId, UnshareAlertDialog.this.mAction);
                    }
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null).create();
        }
    }

    public static class SharerActionContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_JUMP = 0;
        public static final int ACTION_UNSHARE = 1;
        private String mFileId;
        private MMZoomShareAction mShareAction;

        public SharerActionContextMenuItem(String label, int action, String fileId, MMZoomShareAction shareAction) {
            super(action, label);
            this.mFileId = fileId;
            this.mShareAction = shareAction;
        }
    }
}

