/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.JoinConfActivity;
import com.zipow.videobox.MeetingInfoActivity;
import com.zipow.videobox.ScheduleActivity;
import com.zipow.videobox.SettingActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.IMMyMeetingsFragment;
import com.zipow.videobox.fragment.JoinConfFragment;
import com.zipow.videobox.fragment.ScheduleFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.ScheduledMeetingItem;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class IMMeetingFragment
extends ZMFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private final String TAG = IMMeetingFragment.class.getSimpleName();
    private Button mBtnStartConf;
    private Button mBtnReturnToConf;
    private Button mBtnJoinConf;
    private Button mBtnSchedule;
    private Button mBtnMyMeetings;
    private View mBtnSetting;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutId = R.layout.zm_imview_meeting;
        if (!UIMgr.isLargeMode((Context)this.getActivity()) && UIUtil.getDisplayMinWidthInDip((Context)this.getActivity()) < 500.0f && UIUtil.isLandscapeMode((Context)this.getActivity())) {
            layoutId = R.layout.zm_imview_meeting_line;
        }
        View view = inflater.inflate(layoutId, container, false);
        this.mBtnStartConf = (Button)view.findViewById(R.id.btnStartConf);
        this.mBtnReturnToConf = (Button)view.findViewById(R.id.btnReturnToConf);
        this.mBtnJoinConf = (Button)view.findViewById(R.id.btnJoinConf);
        this.mBtnSchedule = (Button)view.findViewById(R.id.btnSchedule);
        this.mBtnMyMeetings = (Button)view.findViewById(R.id.btnMyMeetings);
        ViewGroup toolbar = (ViewGroup)view.findViewById(R.id.toolbar);
        this.mBtnSetting = toolbar.findViewById(R.id.btnSetting);
        TextView txtTitle = (TextView)toolbar.findViewById(R.id.txtTitle);
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            txtTitle.setVisibility(8);
        } else {
            txtTitle.setVisibility(0);
        }
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            toolbar.setVisibility(8);
        }
        this.mBtnStartConf.setOnClickListener((View.OnClickListener)this);
        this.mBtnReturnToConf.setOnClickListener((View.OnClickListener)this);
        this.mBtnJoinConf.setOnClickListener((View.OnClickListener)this);
        this.mBtnSchedule.setOnClickListener((View.OnClickListener)this);
        this.mBtnMyMeetings.setOnClickListener((View.OnClickListener)this);
        this.mBtnSetting.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnJoinConf) {
            this.onClickBtnJoinById();
        } else if (id2 == R.id.btnStartConf) {
            this.onClickBtnStartConf();
        } else if (id2 == R.id.btnReturnToConf) {
            this.onClickBtnReturnToConf();
        } else if (id2 == R.id.btnSchedule) {
            this.onClickBtnSchedule();
        } else if (id2 == R.id.btnMyMeetings) {
            this.onClickBtnMyMeetings();
        } else if (id2 == R.id.btnSetting) {
            this.onClickBtnSetting();
        }
    }

    private void updateButtons() {
        if (this.getView() == null) {
            return;
        }
        if (PTApp.getInstance().hasActiveCall() && VideoBoxApplication.getInstance().isConfProcessRunning()) {
            this.mBtnJoinConf.setEnabled(false);
            this.mBtnStartConf.setVisibility(8);
            this.mBtnReturnToConf.setVisibility(0);
        } else {
            this.mBtnJoinConf.setEnabled(true);
            this.mBtnStartConf.setVisibility(0);
            this.mBtnStartConf.setEnabled(this.checkStartButtonEnabled());
            this.mBtnReturnToConf.setVisibility(8);
        }
        this.mBtnSchedule.setEnabled(this.checkScheduleButtonEnabled());
    }

    private boolean checkStartButtonEnabled() {
        PTApp ptApp = PTApp.getInstance();
        return ptApp.hasPrescheduleMeeting() || ptApp.canAccessZoomWebservice();
    }

    private boolean checkScheduleButtonEnabled() {
        PTApp ptApp = PTApp.getInstance();
        return ptApp.canAccessZoomWebservice();
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        this.updateButtons();
        this.showMyInfo();
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onStart() {
        super.onStart();
        this.updateButtons();
        this.showMyInfo();
    }

    public void onWebLogin() {
        this.updateButtons();
    }

    public void onMyInfoReady() {
        this.showMyInfo();
    }

    public void onMyPictureReady() {
        this.showMyInfo();
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.onCallStatusChanged(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onCallStatusChanged(long result) {
        if (this.getView() == null) {
            return;
        }
        switch ((int)result) {
            case 1: 
            case 2: {
                this.mBtnJoinConf.setEnabled(false);
                this.mBtnStartConf.setVisibility(8);
                this.mBtnReturnToConf.setVisibility(0);
                break;
            }
            default: {
                this.mBtnJoinConf.setEnabled(true);
                this.mBtnStartConf.setVisibility(0);
                this.mBtnStartConf.setEnabled(true);
                this.mBtnReturnToConf.setVisibility(8);
            }
        }
    }

    public void onScheduleSuccess(final ScheduledMeetingItem item) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            activity.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onScheduleSuccess"){

                public void run(IUIElement ui) {
                    MeetingInfoActivity.show((ZMActivity)ui, item, R.string.zm_tab_meeting, true, 104);
                }
            });
        }
    }

    private void onClickBtnStartConf() {
        if (this.getView() == null) {
            return;
        }
        int ret = ConfActivity.startConference((Context)this.getActivity());
        if (ret == 0) {
            this.mBtnStartConf.setEnabled(false);
        } else {
            IMView.StartHangoutFailedDialog.show(((ZMActivity)this.getActivity()).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    private void onClickBtnReturnToConf() {
        if (!PTApp.getInstance().hasActiveCall()) {
            this.updateButtons();
            return;
        }
        ConfActivity.returnToConf((Context)this.getActivity());
    }

    private void onClickBtnJoinById() {
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            JoinConfFragment.showJoinByNumber(this.getFragmentManager(), null, null);
        } else {
            JoinConfActivity.showJoinByNumber((Context)this.getActivity(), null, null);
        }
    }

    private void onClickBtnSchedule() {
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            ScheduleFragment.showDialog(this.getFragmentManager());
        } else {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity != null) {
                ScheduleActivity.show(activity, 103);
            }
        }
    }

    private void onClickBtnMyMeetings() {
        IMMyMeetingsFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnSetting() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            SettingActivity.show(activity, 0);
        }
        PTApp.getInstance().checkForUpdates(false);
    }

    private void showMyInfo() {
    }
}

