/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.videobox.BuddyInviteActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.BuddyInviteFragment;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSubscription;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMBuddyListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.videomeetings.R;

public class IMBuddyListFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener,
PTUI.IPTUIListener,
PTUI.IIMListener {
    private final String TAG = IMBuddyListFragment.class.getSimpleName();
    public static final String ARG_SHOW_BACK_BUTTON = "showBackButton";
    private IMBuddyListView mBuddyListView;
    private EditText mEdtSearch;
    private View mPanelNoItemMsg;
    private View mPanelConnecting;
    private View mPanelReconnect;
    private Button mBtnReconnect;
    private TextView mTxtLocalStatus;
    private Button mBtnClearSearchView;
    private TextView mTxtScreenName;
    private TextView mTxtInvitationsCount;
    private Button mBtnInviteBuddy;
    private AvatarView mAvatar;
    private View mBtnBack;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = IMBuddyListFragment.this.mEdtSearch.getText().toString();
            IMBuddyListFragment.this.mBuddyListView.filter(key);
            if (key.length() > 0 && IMBuddyListFragment.this.mBuddyListView.getCount() > 0 || IMBuddyListFragment.this.mPanelTitleBar.getVisibility() == 0) {
                IMBuddyListFragment.this.mListContainer.setForeground(null);
            } else {
                IMBuddyListFragment.this.mListContainer.setForeground(IMBuddyListFragment.this.mDimmedForground);
            }
            IMBuddyListFragment.this.checkToShowNoBuddyMessage();
        }
    };
    private Runnable mRunnableCheckToShowNoBuddyMessage = new Runnable(){

        @Override
        public void run() {
            boolean isSignedOn = true;
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper != null) {
                isSignedOn = imHelper.isIMSignedOn();
            }
            if (isSignedOn && StringUtil.isEmptyOrNull((String)IMBuddyListFragment.this.mBuddyListView.getFilter()) && IMBuddyListFragment.this.mBuddyListView.getCount() == 0) {
                IMBuddyListFragment.this.mPanelNoItemMsg.setVisibility(0);
                IMBuddyListFragment.this.mPanelConnecting.setVisibility(8);
            } else {
                IMBuddyListFragment.this.mPanelNoItemMsg.setVisibility(8);
                if (isSignedOn) {
                    IMBuddyListFragment.this.mPanelReconnect.setVisibility(8);
                }
            }
        }
    };

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_BACK_BUTTON, true);
        SimpleActivity.show(activity, IMBuddyListFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_BACK_BUTTON, true);
        SimpleActivity.show(fragment, IMBuddyListFragment.class.getName(), args, 0);
    }

    private void checkToShowNoBuddyMessage() {
        this.mHandler.removeCallbacks(this.mRunnableCheckToShowNoBuddyMessage);
        this.mHandler.postDelayed(this.mRunnableCheckToShowNoBuddyMessage, 1000L);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ZMActivity activity;
        View view = inflater.inflate(R.layout.zm_imview_buddylist, container, false);
        this.mBuddyListView = (IMBuddyListView)view.findViewById(R.id.buddyListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mPanelConnecting = view.findViewById(R.id.panelConnecting);
        this.mPanelReconnect = view.findViewById(R.id.panelReconnect);
        this.mBtnReconnect = (Button)view.findViewById(R.id.btnReconnect);
        this.mTxtLocalStatus = (TextView)view.findViewById(R.id.txtLocalStatus);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        TextView txtNoBuddiesMsg = (TextView)view.findViewById(R.id.txtNoBuddiesMsg);
        if (PTApp.getInstance().getPTLoginType() == 2) {
            txtNoBuddiesMsg.setText(R.string.zm_msg_no_buddies_google);
        } else if (PTApp.getInstance().getPTLoginType() == 0) {
            txtNoBuddiesMsg.setText(R.string.zm_msg_no_buddies_fb);
        }
        this.mPanelTitleBar = (ViewGroup)view.findViewById(R.id.toolbar);
        this.mTxtScreenName = (TextView)this.mPanelTitleBar.findViewById(R.id.txtScreenName);
        TextView txtTitle = (TextView)this.mPanelTitleBar.findViewById(R.id.txtTitle);
        this.mBtnBack = this.mPanelTitleBar.findViewById(R.id.btnBack);
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            this.mTxtScreenName.setVisibility(0);
        } else {
            this.mTxtScreenName.setVisibility(8);
            txtTitle.setVisibility(0);
            switch (PTApp.getInstance().getPTLoginType()) {
                case 2: {
                    txtTitle.setText(R.string.zm_tab_buddylist_google);
                    break;
                }
                case 0: {
                    txtTitle.setText(R.string.zm_tab_buddylist_facebook);
                }
            }
        }
        this.mBtnInviteBuddy = (Button)this.mPanelTitleBar.findViewById(R.id.btnInviteBuddy);
        this.mAvatar = (AvatarView)this.mPanelTitleBar.findViewById(R.id.avatarView);
        this.mTxtInvitationsCount = (TextView)this.mPanelTitleBar.findViewById(R.id.txtInvitationsCount);
        this.mBtnInviteBuddy.setVisibility(this.isInviteBuddySupported() ? 0 : 8);
        this.mPanelNoItemMsg.setVisibility(8);
        this.mBtnReconnect.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mAvatar.setOnClickListener(this);
        this.mBtnInviteBuddy.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                IMBuddyListFragment.this.mHandler.removeCallbacks(IMBuddyListFragment.this.mRunnableFilter);
                IMBuddyListFragment.this.mHandler.postDelayed(IMBuddyListFragment.this.mRunnableFilter, 300L);
                IMBuddyListFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            this.updateLocalStatus(imHelper.getIMLocalStatus());
        }
        if ((activity = (ZMActivity)this.getActivity()) instanceof IMActivity && !((IMActivity)activity).isKeyboardOpen() || activity instanceof SimpleActivity && !((SimpleActivity)activity).isKeyboardOpen()) {
            this.onKeyboardClosed();
        }
        boolean showBackButton = false;
        Bundle args = this.getArguments();
        if (args != null) {
            showBackButton = args.getBoolean(ARG_SHOW_BACK_BUTTON, false);
        }
        if (showBackButton) {
            this.mBtnBack.setVisibility(0);
            this.mAvatar.setVisibility(8);
        } else {
            this.mBtnBack.setVisibility(8);
            this.mAvatar.setVisibility(8);
        }
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    private boolean isInviteBuddySupported() {
        return PTApp.getInstance().getPTLoginType() == 2;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void showMyInfo() {
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnReconnect) {
            this.reconnect();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnInviteBuddy) {
            this.onClickBtnInviteBuddy();
        } else if (id2 == R.id.avatarView) {
            this.onClickAvatarView(v.getId());
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickBtnInviteBuddy() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        if (UIMgr.isLargeMode((Context)activity)) {
            FragmentManager fm = ((ZMActivity)this.getActivity()).getSupportFragmentManager();
            BuddyInviteFragment.showDialog(fm, null);
        } else {
            BuddyInviteActivity.show((ZMActivity)this.getActivity(), activity instanceof IMActivity ? 102 : 0, null);
        }
    }

    private void onClickAvatarView(int viewId) {
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            FragmentManager fm = ((ZMActivity)this.getActivity()).getSupportFragmentManager();
            SettingFragment.show(fm, viewId);
        }
    }

    public boolean isFocusedOnSearchField() {
        if (this.getView() == null) {
            return false;
        }
        return this.mEdtSearch.hasFocus();
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearch.hasFocus()) {
            this.mEdtSearch.setCursorVisible(true);
            this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
            this.mPanelTitleBar.setVisibility(8);
            this.mListContainer.setForeground(this.mDimmedForground);
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
        this.mPanelTitleBar.setVisibility(0);
        this.mListContainer.setForeground(null);
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public void updateLocalStatus() {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper != null) {
            this.updateLocalStatus(imHelper.getIMLocalStatus());
        }
    }

    public void updateLocalStatus(int status) {
        if (this.getView() == null) {
            return;
        }
        switch (status) {
            case 4: {
                this.mPanelReconnect.setVisibility(8);
                this.checkToShowNoBuddyMessage();
                break;
            }
            case 0: 
            case 5: {
                this.mPanelNoItemMsg.setVisibility(8);
                this.mPanelReconnect.setVisibility(0);
                this.mPanelConnecting.setVisibility(8);
                this.mBtnReconnect.setVisibility(0);
                break;
            }
            case 1: {
                this.mTxtLocalStatus.setText(R.string.zm_login_step_connecting);
                this.mPanelNoItemMsg.setVisibility(8);
                this.mPanelReconnect.setVisibility(0);
                this.mPanelConnecting.setVisibility(0);
                this.mBtnReconnect.setVisibility(8);
                break;
            }
            case 3: {
                this.mTxtLocalStatus.setText(R.string.zm_login_step_authenticating);
                this.mPanelNoItemMsg.setVisibility(8);
                this.mPanelReconnect.setVisibility(0);
                this.mPanelConnecting.setVisibility(0);
                this.mBtnReconnect.setVisibility(8);
                break;
            }
            case 2: {
                this.mTxtLocalStatus.setText(R.string.zm_login_step_negotiating);
                this.mPanelNoItemMsg.setVisibility(8);
                this.mPanelReconnect.setVisibility(0);
                this.mPanelConnecting.setVisibility(0);
                this.mBtnReconnect.setVisibility(8);
            }
        }
    }

    public void onResume() {
        super.onResume();
        this.refreshAll();
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addIMListener(this);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeIMListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mHandler.removeCallbacks(this.mRunnableFilter);
        this.mHandler.removeCallbacks(this.mRunnableCheckToShowNoBuddyMessage);
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
        if (!this.isResumed()) {
            return;
        }
        if (this.getView() == null) {
            return;
        }
        this.mBuddyListView.updateBuddyItem(message.getFromScreenName());
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        if (!this.isResumed()) {
            return;
        }
        if (this.getView() == null) {
            return;
        }
        this.mBuddyListView.updateBuddyItem(item);
        this.mRunnableCheckToShowNoBuddyMessage.run();
        this.mPanelReconnect.setVisibility(8);
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        if (!this.isResumed()) {
            return;
        }
        if (this.getView() == null) {
            return;
        }
        this.mBuddyListView.updateBuddyItem(item);
    }

    @Override
    public void onIMBuddySort() {
        if (!this.isResumed()) {
            return;
        }
        if (this.getView() == null) {
            return;
        }
        this.mBuddyListView.reloadAllBuddyItems();
        this.mRunnableCheckToShowNoBuddyMessage.run();
    }

    public void reloadAllBuddyItems() {
        if (this.getView() == null) {
            return;
        }
        this.mBuddyListView.reloadAllBuddyItems();
        this.mRunnableCheckToShowNoBuddyMessage.run();
    }

    @Override
    public void onSubscriptionRequest() {
        if (!this.isResumed()) {
            return;
        }
        this.updateBuddyInvitationsMessage();
    }

    @Override
    public void onSubscriptionUpdate() {
        if (!this.isResumed()) {
            return;
        }
        this.updateBuddyInvitationsMessage();
    }

    public void onCallPlistChanged() {
        if (this.mBuddyListView != null) {
            this.mBuddyListView.refreshContextMenu();
        }
    }

    public void onCallStatusChanged(long result) {
        if (this.mBuddyListView != null) {
            this.mBuddyListView.refreshContextMenu();
        }
    }

    public void onWebLogin(long result) {
        if (this.mBuddyListView != null) {
            this.mBuddyListView.refreshContextMenu();
        }
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void onMyInfoReady() {
        this.showMyInfo();
    }

    public void onMyPictureReady() {
        this.showMyInfo();
    }

    private void reconnect() {
        AuthToken authToken = FBSessionStore.getSession((Context)this.getContext(), (String)"facebook-session");
        if (PTApp.getInstance().getPTLoginType() == 0 && (authToken.shouldExtendAccessToken() || !authToken.isSessionValid())) {
            this.showLoginUI(true);
        } else if (NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            PTUI.getInstance().reconnectIM();
        }
    }

    private void showLoginUI(boolean autoLogin) {
        LoginActivity.show((Context)this.getActivity(), autoLogin);
        this.getActivity().finish();
    }

    private void refreshAll() {
        if (this.getView() == null) {
            return;
        }
        this.showMyInfo();
        this.updateLocalStatus();
        this.mBuddyListView.setFilter(this.mEdtSearch.getText().toString());
        this.reloadAllBuddyItems();
        this.updateBuddyInvitationsMessage();
        this.mBuddyListView.refreshContextMenu();
        this.updateBtnClearSearchView();
    }

    private void updateBuddyInvitationsMessage() {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        IMSubscription[] subscriptions = imHelper.getUnhandledSubscriptions();
        if (subscriptions != null && subscriptions.length > 0) {
            this.mTxtInvitationsCount.setVisibility(0);
            if (subscriptions.length < 100) {
                this.mTxtInvitationsCount.setText((CharSequence)String.valueOf(subscriptions.length));
            } else {
                this.mTxtInvitationsCount.setText((CharSequence)"99+");
            }
        } else {
            this.mTxtInvitationsCount.setVisibility(8);
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 9: {
                this.onMyInfoReady();
                break;
            }
            case 12: {
                this.onMyPictureReady();
                break;
            }
            case 0: {
                this.onWebLogin(result);
                break;
            }
            case 22: {
                this.onCallStatusChanged(result);
                break;
            }
            case 21: {
                IMHelper imHelper = PTApp.getInstance().getIMHelper();
                if (imHelper == null) {
                    return;
                }
                this.updateLocalStatus(imHelper.getIMLocalStatus());
                break;
            }
            case 23: {
                this.onCallPlistChanged();
                break;
            }
            case 35: {
                this.updateLocalStatus(5);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
        if (!this.isResumed()) {
            return;
        }
        this.updateLocalStatus(status);
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }
}

