/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.AddrBookSetNumberActivity;
import com.zipow.videobox.AddrBookSettingActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class IMAddrBookSettingFragment
extends ZMFragment
implements View.OnClickListener,
PTUI.IPhoneABListener {
    private final String TAG = IMAddrBookSettingFragment.class.getSimpleName();
    public static final int STATUS_ADDRBOOK_DISABLED = 0;
    public static final int STATUS_ADDRBOOK_ENABLED = 1;
    public static final int STATUS_ADDRBOOK_NUM_VERIFIED = 2;
    private int mStatus = -1;
    private String mCountryCode = null;
    private String mPhoneNumber = null;
    private boolean mShowTitlebar = true;
    private Button mBtnBack;
    private Button mBtnEnable;
    private Button mBtnDone;
    private Button mBtnDisable;
    private TextView mTxtMessage;
    private ImageView mImgIcon;
    private TextView mTxtPhoneNumber;
    private View mPanelPhoneNumber;
    private View mPanelOptions;
    private View mPanelTitleBar;
    private View mContentView;

    public static void showInActivity(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        IMAddrBookSettingFragment f = IMAddrBookSettingFragment.newInstance(true);
        Bundle args = new Bundle();
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, IMAddrBookSettingFragment.class.getName()).commit();
    }

    public static IMAddrBookSettingFragment newInstance(boolean showTitlebar) {
        return IMAddrBookSettingFragment.newInstance(showTitlebar, -1);
    }

    public static IMAddrBookSettingFragment newInstance(boolean showTitlebar, int status) {
        IMAddrBookSettingFragment f = new IMAddrBookSettingFragment();
        f.mShowTitlebar = showTitlebar;
        if (status >= 0) {
            f.mStatus = status;
        }
        return f;
    }

    public static IMAddrBookSettingFragment findFragment(ZMActivity activity) {
        if (activity == null) {
            return null;
        }
        return (IMAddrBookSettingFragment)activity.getSupportFragmentManager().findFragmentByTag(IMAddrBookSettingFragment.class.getName());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        PTUI.getInstance().addPhoneABListener(this);
        SparseArray myState = null;
        if (savedInstanceState != null) {
            myState = savedInstanceState.getSparseParcelableArray(IMAddrBookSettingFragment.class.getName() + ".State");
        }
        this.mContentView = this.getView();
        if (this.mContentView != null && myState != null) {
            this.mContentView.restoreHierarchyState(myState);
        }
        if (this.mContentView == null) {
            this.mContentView = this.onCreateView(this.getLayoutInflater(savedInstanceState), null, savedInstanceState);
            if (this.mContentView != null && myState != null) {
                this.mContentView.restoreHierarchyState(myState);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        SparseArray container = new SparseArray();
        View view = this.getView();
        if (view != null) {
            view.saveHierarchyState(container);
        } else if (this.mContentView != null) {
            this.mContentView.saveHierarchyState(container);
        }
        outState.putSparseParcelableArray(IMAddrBookSettingFragment.class.getName() + ".State", container);
        outState.putInt("addrbookStatus", this.mStatus);
        outState.putString("mCountryCode", this.mCountryCode);
        outState.putString("mPhoneNumber", this.mPhoneNumber);
        outState.putBoolean("mShowTitlebar", this.mShowTitlebar);
        super.onSaveInstanceState(outState);
    }

    public void onDestroy() {
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity.isFinishing() || this.isRemoving()) {
            PTUI.getInstance().removePhoneABListener(this);
        }
        super.onDestroy();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_addrbook_setting, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnEnable = (Button)view.findViewById(R.id.btnEnable);
        this.mBtnDone = (Button)view.findViewById(R.id.btnDone);
        this.mBtnDisable = (Button)view.findViewById(R.id.btnDisable);
        this.mTxtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mImgIcon = (ImageView)view.findViewById(R.id.imgIcon);
        this.mTxtPhoneNumber = (TextView)view.findViewById(R.id.txtPhoneNumber);
        this.mPanelOptions = view.findViewById(R.id.panelOptions);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mPanelPhoneNumber = view.findViewById(R.id.panelPhoneNumber);
        this.mBtnEnable.setOnClickListener((View.OnClickListener)this);
        this.mBtnDone.setOnClickListener((View.OnClickListener)this);
        this.mBtnDisable.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        if (this.mStatus < 0) {
            int n = this.mStatus = this.isPhoneNumberRegistered() ? 1 : 0;
        }
        if (savedInstanceState != null) {
            this.mStatus = savedInstanceState.getInt("addrbookStatus", this.mStatus);
            this.mCountryCode = savedInstanceState.getString("mCountryCode");
            this.mPhoneNumber = savedInstanceState.getString("mPhoneNumber");
            this.mShowTitlebar = savedInstanceState.getBoolean("mShowTitlebar", true);
        }
        this.updateUI();
        return view;
    }

    private String getRegisteredPhoneNumber() {
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper != null) {
            return contactsHelper.getVerifiedPhoneNumber();
        }
        return null;
    }

    private boolean isPhoneNumberRegistered() {
        return !StringUtil.isEmptyOrNull((String)this.getRegisteredPhoneNumber());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnEnable) {
            this.onClickBtnEnable();
        } else if (id2 == R.id.btnDone) {
            this.onClickBtnDone();
        } else if (id2 == R.id.btnDisable) {
            this.onClickBtnDisable();
        }
    }

    private void onClickBtnBack() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((IMAddrBookSettingFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        ABContactsCache.getInstance().registerContentObserver();
        this.enableAddrDone();
    }

    private void onClickBtnDone() {
        if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.READ_CONTACTS") != 0) {
            this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 0);
            AppUtil.saveRequestContactPermissionTime();
            return;
        }
        this.enableAddrDone();
    }

    private void enableAddrDone() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ABContactsHelper.setAddrBookEnabledDone(true);
        if (activity instanceof IMActivity) {
            IMActivity imActivity = (IMActivity)activity;
            imActivity.onAddressBookEnabled(true);
        } else {
            activity.setResult(-1);
            activity.finish();
        }
    }

    private void onClickBtnDisable() {
        DisableAddrBookConfirmDialog.show(this.getChildFragmentManager());
    }

    private void onClickBtnEnable() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            AddrBookSetNumberActivity.show(activity, 100);
        }
    }

    public void onSetPhoneNumberDone(String countryCode, String number) {
        this.mStatus = 2;
        this.mCountryCode = countryCode;
        this.mPhoneNumber = number;
        this.updateUI();
    }

    private void onAddressBookDisabled() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof AddrBookSettingActivity) {
            activity.setResult(-1);
            activity.finish();
        } else {
            this.mStatus = 0;
            this.updateUI();
        }
    }

    private void updateUI() {
        this.mPanelTitleBar.setVisibility(this.mShowTitlebar ? 0 : 8);
        switch (this.mStatus) {
            case 0: {
                this.mBtnEnable.setVisibility(0);
                this.mBtnDone.setVisibility(8);
                this.mBtnDisable.setVisibility(8);
                this.mTxtMessage.setText(R.string.zm_msg_enable_addrbook);
                this.mImgIcon.setImageResource(R.drawable.zm_addrbook_no_match);
                this.mPanelPhoneNumber.setVisibility(8);
                this.mPanelOptions.setVisibility(0);
                break;
            }
            case 2: {
                this.mBtnEnable.setVisibility(8);
                this.mBtnDone.setVisibility(0);
                this.mBtnDisable.setVisibility(8);
                this.mTxtMessage.setText(R.string.zm_msg_addrbook_enabled);
                this.mImgIcon.setImageResource(R.drawable.zm_addrbook_matched);
                this.mPanelPhoneNumber.setVisibility(0);
                this.mPanelOptions.setVisibility(0);
                String number = this.mPhoneNumber;
                if (number == null) {
                    number = this.getRegisteredPhoneNumber();
                    if (number == null) {
                        return;
                    }
                    this.mTxtPhoneNumber.setText((CharSequence)this.getString(R.string.zm_lbl_addrbook_phone_number, new Object[]{number}));
                    break;
                }
                if (!number.startsWith("+") && !StringUtil.isEmptyOrNull((String)this.mCountryCode)) {
                    number = "+" + this.mCountryCode + number;
                }
                this.mTxtPhoneNumber.setText((CharSequence)this.getString(R.string.zm_lbl_addrbook_phone_number, new Object[]{number}));
                break;
            }
            case 1: {
                this.mBtnEnable.setVisibility(8);
                this.mBtnDone.setVisibility(8);
                this.mBtnDisable.setVisibility(0);
                this.mTxtMessage.setText(R.string.zm_msg_addrbook_enabled);
                this.mImgIcon.setImageResource(R.drawable.zm_addrbook_matched);
                this.mPanelPhoneNumber.setVisibility(0);
                this.mPanelOptions.setVisibility(0);
                String number = this.getRegisteredPhoneNumber();
                if (number == null) {
                    return;
                }
                this.mTxtPhoneNumber.setText((CharSequence)this.getString(R.string.zm_lbl_addrbook_phone_number, new Object[]{number}));
            }
        }
    }

    private void disableAddressBook() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_alert_network_disconnected);
            dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
            return;
        }
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return;
        }
        String phoneNumber = contactsHelper.getVerifiedPhoneNumber();
        int ret = contactsHelper.unregisterPhoneNumber(phoneNumber, SystemInfoHelper.getDeviceId());
        if (0 == ret) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting);
            dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        } else {
            this.showErrorDialog(ret);
        }
    }

    @Override
    public void onPhoneABEvent(final int event, final long result, final Object content) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handlePhoneABEvent"){

            public void run(IUIElement ui) {
                ((IMAddrBookSettingFragment)ui).handlePhoneABEvent(event, result, content);
            }
        });
    }

    private void handlePhoneABEvent(int event, long result, Object content) {
        switch (event) {
            case 0: {
                break;
            }
            case 1: {
                this.onPhoneUnregisterComplete(result);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onPhoneUnregisterComplete(long result) {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        if (result == 0L) {
            this.onAddressBookDisabled();
        } else {
            this.showErrorDialog((int)result);
        }
    }

    private void showErrorDialog(int errorCode) {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_unregister_phone_number_failed);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    public static class DisableAddrBookConfirmDialog
    extends ZMDialogFragment {
        public DisableAddrBookConfirmDialog() {
            this.setCancelable(true);
        }

        public static void show(FragmentManager fm) {
            Bundle args = new Bundle();
            DisableAddrBookConfirmDialog f = new DisableAddrBookConfirmDialog();
            f.setArguments(args);
            f.show(fm, DisableAddrBookConfirmDialog.class.getName());
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_msg_warning_disable_address_book_matching_title).setMessage(R.string.zm_msg_warning_disable_address_book_matching_content).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DisableAddrBookConfirmDialog.this.onClickOK();
                }
            }).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }

        private void onClickOK() {
            IMAddrBookSettingFragment parent = (IMAddrBookSettingFragment)this.getParentFragment();
            if (parent != null) {
                parent.disableAddressBook();
            }
        }
    }
}

