/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.AddrBookSetNumberActivity;
import com.zipow.videobox.AddrBookSettingActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.IMSavedSessionsFragment;
import com.zipow.videobox.fragment.IMSearchFragment;
import com.zipow.videobox.fragment.MMAddBuddyFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.fragment.mm.MMPhoneContactsInZoomFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.AutoStreamConflictChecker;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.IMCallbackUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.ZoomPublicRoomSearchUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomPublicRoomSearchData;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMAddrBookListView;
import com.zipow.videobox.view.mm.MMContactSearchFragment;
import com.zipow.videobox.view.mm.MMContactsGroupListView;
import com.zipow.videobox.view.mm.MMContactsRoomsListView;
import com.zipow.videobox.view.mm.MMCreateGroupFragment;
import com.zipow.videobox.view.mm.MMJoinPublicGroupFragment;
import com.zipow.videobox.view.mm.MMZoomXMPPRoom;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMPopupWindow;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class IMAddrBookListFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener,
PTUI.IPhoneABListener,
PTUI.IPTUIListener,
PTUI.IIMListener,
ABContactsCache.IABContactsCacheListener {
    private final String TAG = IMAddrBookListFragment.class.getSimpleName();
    private static final int REQUEST_ENABLE_ADDRBOOK = 100;
    private static final int REQUEST_CREATE_GROUP = 101;
    private static final int REQUEST_JOIN_GROUP = 102;
    private static final int REQUEST_ENABLE_PHONE_MATCH = 103;
    private static final int REQUEST_DIALOG_ENABLE_PHONE_MATCH = 104;
    private static final int PERMISSION_REQUEST_ENABLE_ADDRBOOK = 1000;
    private static final int UI_MODE_CONTACTS = 0;
    private static final int UI_MODE_GROUPS = 1;
    private static final int UI_MODE_ROOMS = 2;
    private static final String EXTRA_UI_MODE = "uiMode";
    private IMAddrBookListView mListView;
    private MMContactsGroupListView mGroupsListView;
    private MMContactsRoomsListView mRoomsListView;
    private EditText mEdtSearch;
    private EditText mForFocus;
    private EditText mEdtGroupSearch;
    private EditText mEdtRoomSearch;
    private EditText mEdtSearchReal;
    private Button mBtnClearSearchView;
    private View mPanelNoItemMsg;
    private TextView mTxtNoContactsMessage;
    private View mBtnInvite;
    private ImageView mImgNoBuddy;
    private View mContentView;
    private View mPanelTitleBar;
    private View mPanelConnectionAlert;
    private TextView mTxtNetworkAlert;
    private View mPanelSearchBar;
    private View mPanelGroupSearchBar;
    private View mPanelTitleRight;
    private View mPanelJoinPublicGroup;
    private FrameLayout mPanelRooms;
    private View mPanelRoomSearchBar;
    private View mPanelSearchBarReal;
    private View mPanelTabContacts;
    private View mPanelTabGroups;
    private View mPanelGroupOperator;
    private View mPanelContacts;
    private View mPanelTabRooms;
    private FrameLayout mPanelGroups;
    private int mUIMode = 0;
    private boolean isKeyboardOpen = false;
    private Drawable mDimmedForground = null;
    private static final int MSG_REFRESH_ALL = 1;
    private Handler mHandler = new MyHandler(this);
    private BroadcastReceiver mNetworkStateReceiver;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onSearchBuddy(String email, int result) {
            IMAddrBookListFragment.this.onZoomMessengerSearchBuddy(true, email, result);
        }

        @Override
        public void onSearchBuddyByKey(String key, int result) {
            IMAddrBookListFragment.this.onZoomMessengerSearchBuddy(false, key, result);
        }

        @Override
        public void onBeginConnect() {
            IMAddrBookListFragment.this.onZoomMessengerBeginConnect();
        }

        @Override
        public void onConnectReturn(int errorCode) {
            IMAddrBookListFragment.this.onZoomMessengerConnectReturn(errorCode);
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            IMAddrBookListFragment.this.onZoomMessengerMUCGroupInfoUpdatedImpl(groupID);
        }

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            IMAddrBookListFragment.this.onZoomMessengerGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            if (IMAddrBookListFragment.this.mGroupsListView != null) {
                IMAddrBookListFragment.this.mGroupsListView.onGroupDestory(groupID);
            }
        }

        @Override
        public void On_DestroyGroup(int result, String actionOwner, String groupID, String groupName, long tm) {
            if (result == 0 && IMAddrBookListFragment.this.mGroupsListView != null) {
                IMAddrBookListFragment.this.mGroupsListView.onGroupDestory(groupID);
            }
        }
    };
    private ZMBuddySyncInstance.ZMBuddyListListener mBuddyListLisener = new ZMBuddySyncInstance.ZMBuddyListListener(){

        @Override
        public void onBuddyListUpdate() {
            IMAddrBookListFragment.this.onBuddyListUpdate();
        }

        @Override
        public void onBuddyInfoUpdate(List<String> presenceChangeJids, List<String> infoChangeJids) {
            IMAddrBookListFragment.this.onBuddyInfoUpdate(presenceChangeJids, infoChangeJids);
        }
    };
    private ZoomPublicRoomSearchUI.IZoomPublicRoomSearchUIListener mZoomPublicRoomSearchUIListener = new ZoomPublicRoomSearchUI.IZoomPublicRoomSearchUIListener(){

        @Override
        public void onSearchResponse(int errCode, int fromIdx, int count) {
        }

        @Override
        public void onJoinRoom(String roomId, int errCode) {
            IMAddrBookListFragment.this.onJoinRoom(roomId, errCode);
        }
    };
    private IMCallbackUI.IIMCallbackUIListener mGroupMemberSynchronizer = new IMCallbackUI.SimpleIMCallbackUIListener(){

        @Override
        public void Notify_AsyncMUCGroupInfoUpdated(String groupid) {
            if (IMAddrBookListFragment.this.mGroupsListView != null) {
                IMAddrBookListFragment.this.mGroupsListView.onGroupMemberInfoUpdate(groupid);
            }
        }
    };
    private HashSet<String> mUpdatedBuddyJids = new HashSet();
    private Runnable mRunnableGroupFilter = new Runnable(){

        @Override
        public void run() {
            String key = IMAddrBookListFragment.this.mEdtSearchReal.getText().toString();
            IMAddrBookListFragment.this.mGroupsListView.filter(key);
            if (key.length() > 0 && IMAddrBookListFragment.this.mGroupsListView.getCount() > 0 || IMAddrBookListFragment.this.mPanelTitleBar.getVisibility() == 0) {
                IMAddrBookListFragment.this.mPanelGroups.setForeground(null);
            } else {
                IMAddrBookListFragment.this.mPanelGroups.setForeground(IMAddrBookListFragment.this.mDimmedForground);
            }
        }
    };
    private Runnable mRunnableRoomFilter = new Runnable(){

        @Override
        public void run() {
            String key = IMAddrBookListFragment.this.mEdtSearchReal.getText().toString();
            IMAddrBookListFragment.this.mRoomsListView.filter(key);
            if (key.length() > 0 && IMAddrBookListFragment.this.mRoomsListView.getCount() > 0 || IMAddrBookListFragment.this.mPanelTitleBar.getVisibility() == 0) {
                IMAddrBookListFragment.this.mPanelRooms.setForeground(null);
            } else {
                IMAddrBookListFragment.this.mPanelRooms.setForeground(IMAddrBookListFragment.this.mDimmedForground);
            }
        }
    };

    private void pushBuddyUpdateEventToQueue(String jid) {
        if (jid != null) {
            this.mUpdatedBuddyJids.add(jid);
        }
    }

    public static IMAddrBookListFragment newInstance(int mode) {
        Bundle args = new Bundle();
        IMAddrBookListFragment fragment = new IMAddrBookListFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        boolean isE2E;
        ZoomMessenger messenger;
        View view = inflater.inflate(R.layout.zm_addrbook_list, container, false);
        this.mListView = (IMAddrBookListView)view.findViewById(R.id.addrBookListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mForFocus = (EditText)view.findViewById(R.id.forFocus);
        this.mPanelSearchBarReal = view.findViewById(R.id.panelSearchBarReal);
        this.mEdtSearchReal = (EditText)view.findViewById(R.id.edtSearchReal);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mTxtNoContactsMessage = (TextView)view.findViewById(R.id.txtNoContactsMessage);
        this.mImgNoBuddy = (ImageView)view.findViewById(R.id.imgNoBuddy);
        this.mBtnInvite = view.findViewById(R.id.btnInvite);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mPanelConnectionAlert = view.findViewById(R.id.panelConnectionAlert);
        this.mTxtNetworkAlert = (TextView)view.findViewById(R.id.txtNetworkAlert);
        this.mPanelTabContacts = view.findViewById(R.id.panelTabContacts);
        this.mPanelTabGroups = view.findViewById(R.id.panelTabGroups);
        this.mPanelGroupOperator = view.findViewById(R.id.panelGroupsOperator);
        this.mPanelContacts = view.findViewById(R.id.panelContacts);
        this.mPanelGroups = (FrameLayout)view.findViewById(R.id.panelGroups);
        this.mGroupsListView = (MMContactsGroupListView)view.findViewById(R.id.groupsListView);
        this.mEdtGroupSearch = (EditText)view.findViewById(R.id.edtGroupSearch);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mPanelGroupSearchBar = view.findViewById(R.id.panelGroupSearchBar);
        this.mPanelTitleRight = view.findViewById(R.id.panelTitleRight);
        this.mPanelJoinPublicGroup = view.findViewById(R.id.panelJoinPublicGroup);
        this.mPanelTabRooms = view.findViewById(R.id.panelTabRooms);
        this.mPanelRooms = (FrameLayout)view.findViewById(R.id.panelRooms);
        this.mRoomsListView = (MMContactsRoomsListView)view.findViewById(R.id.roomsListView);
        this.mPanelRoomSearchBar = view.findViewById(R.id.panelRoomSearchBar);
        this.mEdtRoomSearch = (EditText)view.findViewById(R.id.edtRoomSearch);
        this.mPanelSearchBarReal.setVisibility(4);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mPanelConnectionAlert.setOnClickListener((View.OnClickListener)this);
        this.mPanelTabContacts.setOnClickListener((View.OnClickListener)this);
        this.mPanelTabGroups.setOnClickListener((View.OnClickListener)this);
        this.mGroupsListView.setEmptyView(view.findViewById(R.id.panelGroupsNoItemMsg));
        this.mGroupsListView.setParentFragment(this);
        this.mRoomsListView.setEmptyView(view.findViewById(R.id.panelRoomsNoItemMsg));
        this.mRoomsListView.setParentFragment(this);
        view.findViewById(R.id.panelNewGroup).setOnClickListener((View.OnClickListener)this);
        this.mPanelJoinPublicGroup.setOnClickListener((View.OnClickListener)this);
        this.mPanelTabRooms.setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnSearch).setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEdtSearchReal.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearchReal.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEdtSearchReal.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                if (IMAddrBookListFragment.this.mUIMode == 1) {
                    IMAddrBookListFragment.this.mHandler.removeCallbacks(IMAddrBookListFragment.this.mRunnableGroupFilter);
                    IMAddrBookListFragment.this.mHandler.postDelayed(IMAddrBookListFragment.this.mRunnableGroupFilter, 300L);
                } else if (IMAddrBookListFragment.this.mUIMode == 2) {
                    IMAddrBookListFragment.this.mHandler.removeCallbacks(IMAddrBookListFragment.this.mRunnableRoomFilter);
                    IMAddrBookListFragment.this.mHandler.postDelayed(IMAddrBookListFragment.this.mRunnableRoomFilter, 300L);
                }
                IMAddrBookListFragment.this.updateClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        this.mListView.setParentFragment(this);
        if (this.getActivity() instanceof IMActivity && !((IMActivity)this.getActivity()).isKeyboardOpen()) {
            this.onKeyboardClosed();
        }
        boolean isImDisable = (messenger = PTApp.getInstance().getZoomMessenger()) == null || messenger.imChatGetOption() == 2;
        boolean bl = isE2E = messenger == null || messenger.e2eGetMyOption() == 2;
        if (isImDisable || isE2E) {
            view.findViewById(R.id.btnSearch).setVisibility(8);
        }
        this.mPanelNoItemMsg.setVisibility(8);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        if (savedInstanceState != null) {
            int uiMode = savedInstanceState.getInt(EXTRA_UI_MODE, 0);
            this.updateUIMode(uiMode, true);
        }
        ZoomPublicRoomSearchUI.getInstance().addListener(this.mZoomPublicRoomSearchUIListener);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        ZMBuddySyncInstance.getInsatance().addListener(this.mBuddyListLisener);
        IMCallbackUI.getInstance().addListener(this.mGroupMemberSynchronizer);
        this.compatPCModeForSearch();
        return view;
    }

    private void compatPCModeForSearch() {
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(final View v, boolean hasFocus) {
                if (hasFocus) {
                    IMAddrBookListFragment.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!IMAddrBookListFragment.this.isAdded() || !IMAddrBookListFragment.this.isResumed()) {
                                return;
                            }
                            int id2 = v.getId();
                            if (id2 != R.id.edtRoomSearch && id2 != R.id.edtGroupSearch) {
                                return;
                            }
                            EditText editText = (EditText)v;
                            if (editText.hasFocus()) {
                                IMAddrBookListFragment.this.onKeyboardOpen();
                            }
                        }
                    }, 500L);
                }
            }
        };
        this.mEdtRoomSearch.setOnFocusChangeListener(onFocusChangeListener);
        this.mEdtGroupSearch.setOnFocusChangeListener(onFocusChangeListener);
    }

    public void onSaveInstanceState(Bundle outState) {
        SparseArray container = new SparseArray();
        View view = this.getView();
        if (view != null) {
            view.saveHierarchyState(container);
        } else if (this.mContentView != null) {
            this.mContentView.saveHierarchyState(container);
        }
        outState.putSparseParcelableArray(IMAddrBookListFragment.class.getName() + ".State", container);
        outState.putInt(EXTRA_UI_MODE, this.mUIMode);
        super.onSaveInstanceState(outState);
    }

    public void onJoinRoom(String roomId, final int errCode) {
        this.dismissWaitingMakeGroupDialog();
        if (errCode == 0) {
            this.mGroupsListView.refreshAllData();
            this.mGroupsListView.jump2Group(roomId);
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                IMAddrBookListFragment f = (IMAddrBookListFragment)ui;
                if (f != null) {
                    f.handleJoinGroup(errCode);
                }
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            this.onSetPhoneNumberDone();
        } else if (requestCode == 101 && resultCode == -1) {
            this.createGroup(data);
        } else if (requestCode == 102 && resultCode == -1) {
            this.joinPublicGroup(data);
        } else if (requestCode == 103 && resultCode == -1) {
            if (PTApp.getInstance().isPhoneNumberRegistered()) {
                this.showPhoneContactsInZoom();
            }
        } else if (requestCode == 104 && resultCode == -1) {
            this.showPhoneMatchFragment();
        }
    }

    private void joinPublicGroup(Intent data) {
        if (data == null) {
            return;
        }
        ArrayList groups = (ArrayList)data.getSerializableExtra("selectItems");
        if (groups == null || groups.size() == 0) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        ZoomPublicRoomSearchData searchData = messenger.getPublicRoomSearchData();
        if (searchData == null) {
            return;
        }
        boolean res = false;
        for (MMZoomXMPPRoom group : groups) {
            res |= searchData.joinRoom(group.getJid());
        }
        if (res) {
            this.showWaitingMakeGroupDialog();
        } else {
            this.showMakeGroupFailureMessage(1);
        }
    }

    private void createGroup(Intent data) {
        boolean accessHistory;
        boolean onlyOrganzation;
        if (data == null) {
            return;
        }
        String groupName = data.getStringExtra("groupName");
        ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
        int groupType = data.getIntExtra("groupType", 16);
        if (StringUtil.isEmptyOrNull((String)groupName) || groupType == 16) {
            return;
        }
        if (groupType != 14 && (abItems == null || abItems.size() == 0 || StringUtil.isEmptyOrNull((String)groupName))) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        if (groupType == 12 && !(onlyOrganzation = data.getBooleanExtra("mChkOnlyOrganization", false))) {
            groupType = 8;
        }
        if (accessHistory = data.getBooleanExtra("accessHistory", false)) {
            groupType |= 0x20;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (int i = 0; i < abItems.size(); ++i) {
            IMAddrBookItem item = (IMAddrBookItem)abItems.get(i);
            String jid = item.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) continue;
            buddies.add(jid);
        }
        PTAppProtos.MakeGroupResult res = messenger.makeGroup(buddies, groupName, groupType);
        if (res != null && res.getResult()) {
            this.showWaitingMakeGroupDialog();
        } else {
            this.showMakeGroupFailureMessage(1);
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void updateClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearchReal.getText().length() > 0 ? 0 : 8);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite();
        } else if (id2 == R.id.panelConnectionAlert) {
            this.onClickPanelConnectionAlert();
        } else if (id2 == R.id.edtSearch) {
            this.onClickEdtSearch();
        } else if (id2 == R.id.panelTabContacts) {
            this.onClickPanelTabContacts();
        } else if (id2 == R.id.panelTabGroups) {
            this.onClickPanelTabGroups();
        } else if (id2 == R.id.panelNewGroup) {
            this.onClickPanelNewGroup();
        } else if (id2 == R.id.panelJoinPublicGroup) {
            this.onClickPanelJoinPublicGroup();
        } else if (id2 == R.id.panelTabRooms) {
            this.onClickPanelTabRooms();
        } else if (id2 == R.id.btnSearch) {
            this.onBtnSearch();
        }
    }

    private void onBtnSearch() {
        IMSearchFragment.showAsFragment((Fragment)this, 0);
    }

    private void onClickPanelJoinPublicGroup() {
        MMJoinPublicGroupFragment.showAsActivity((Fragment)this, 102);
    }

    private void onClickPanelNewGroup() {
        MMCreateGroupFragment.showAsActivity((Fragment)this, 101);
    }

    private void onClickPanelTabContacts() {
        this.updateUIMode(0, true);
    }

    private void onClickPanelTabGroups() {
        this.updateUIMode(1, true);
    }

    private void onClickPanelTabRooms() {
        this.updateUIMode(2, true);
    }

    private void onClickEdtSearch() {
        MMContactSearchFragment.showAsFragment(this);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.edtSearch || id2 == R.id.edtGroupSearch || id2 == R.id.edtRoomSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearchReal.setText((CharSequence)"");
        if (!this.isKeyboardOpen) {
            if (this.mUIMode == 2) {
                this.mPanelTitleBar.setVisibility(0);
                this.mPanelSearchBarReal.setVisibility(4);
                this.mPanelRoomSearchBar.setVisibility(0);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        IMAddrBookListFragment.this.mRoomsListView.requestLayout();
                    }
                });
            } else if (this.mUIMode == 1) {
                this.mPanelTitleBar.setVisibility(0);
                this.mPanelSearchBarReal.setVisibility(4);
                this.mPanelGroupSearchBar.setVisibility(0);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        IMAddrBookListFragment.this.mGroupsListView.requestLayout();
                    }
                });
            }
        }
    }

    private void onClickBtnInvite() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.imChatGetOption() == 2) {
            MMAddBuddyFragment.showAsDialog(this.getFragmentManager());
        } else {
            this.showInvitePopWindow();
        }
    }

    private void onClickPanelAddContact() {
        this.mForFocus.requestFocus();
        MMAddBuddyFragment.showAsDialog(this.getFragmentManager());
    }

    private void onClickPanelConnectionAlert() {
        IMActivity activity = (IMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)activity)) {
            Toast.makeText((Context)activity, (int)R.string.zm_alert_network_disconnected, (int)1).show();
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isStreamConflict()) {
            AutoStreamConflictChecker.getInstance().showStreamConflictMessage(this.getActivity());
        } else {
            messenger.trySignon();
        }
    }

    public void showPhoneContactsInZoom() {
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.READ_CONTACTS") == 0) {
                MMPhoneContactsInZoomFragment.showAsActivity((ZMActivity)this.getContext(), 0);
            } else {
                this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 1000);
            }
        } else {
            this.showPhoneMatchFragment();
        }
    }

    private void showPhoneMatchFragment() {
        AddrBookSetNumberActivity.show((Fragment)this, 103);
    }

    private void onContactsPermissionRequestByPhoneMatch() {
        if (this.checkSelfPermission("android.permission.READ_CONTACTS") == 0) {
            this.showPhoneContactsInZoom();
        } else {
            ContactsPermissionFailedDialog.show(this.getFragmentManager());
        }
    }

    public boolean isFocusedOnSearchField() {
        if (this.getView() == null) {
            return false;
        }
        return this.mEdtSearch.hasFocus();
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.isKeyboardOpen) {
            return;
        }
        this.isKeyboardOpen = true;
        if (this.mUIMode == 1 && this.mEdtGroupSearch.hasFocus()) {
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelGroupOperator.setVisibility(8);
            this.mPanelGroups.setForeground(this.mDimmedForground);
            this.mPanelGroupSearchBar.setVisibility(8);
            this.mPanelSearchBarReal.setVisibility(0);
            this.mEdtSearchReal.setHint(this.mEdtGroupSearch.getHint());
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mEdtSearchReal.requestFocus();
        } else if (this.mUIMode == 2 && this.mEdtRoomSearch.hasFocus()) {
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelRooms.setForeground(this.mDimmedForground);
            this.mPanelRoomSearchBar.setVisibility(8);
            this.mPanelSearchBarReal.setVisibility(0);
            this.mEdtSearchReal.setHint(this.mEdtRoomSearch.getHint());
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mEdtSearchReal.requestFocus();
        }
    }

    public void onSessionDelete(String sessionId) {
        this.mGroupsListView.refreshAllData();
    }

    public void onGroupDelete(String groupId) {
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity instanceof IMActivity) {
            ((IMActivity)activity).onMMSessionDeleted(groupId);
        }
    }

    private void showWaitingMakeGroupDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingMakeGroupDialog");
    }

    private boolean dismissWaitingMakeGroupDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return false;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingMakeGroupDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
            return true;
        }
        return false;
    }

    private void showMakeGroupFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 8) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_make_group_failed_too_many_buddies, (int)1).show();
        } else {
            String msg = context.getString(R.string.zm_mm_msg_make_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void handleGroupActionMakeGroup(int result, GroupAction action) {
        this.dismissWaitingMakeGroupDialog();
        if (result == 0) {
            List<String> buddies = action.getNotAllowBuddies();
            if (buddies != null) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < buddies.size(); ++i) {
                    if (StringUtil.isEmptyOrNull((String)buddies.get(i))) continue;
                    buffer.append(buddies.get(i));
                    buffer.append(",");
                }
                if (buffer.length() > 0) {
                    String buddiesName = buffer.substring(0, buffer.length() - 1);
                    Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.zm_mm_msg_add_buddies_not_allowed, new Object[]{buddiesName}), (int)1).show();
                }
            }
        } else {
            this.showMakeGroupFailureMessage(result);
        }
    }

    private void handleJoinGroup(int result) {
        this.dismissWaitingMakeGroupDialog();
        if (result != 0) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            String msg = context.getString(R.string.zm_mm_msg_join_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void showInvitePopWindow() {
        View content = View.inflate((Context)this.getActivity(), (int)R.layout.zm_mm_addrbook_invite_pop, null);
        View panelAddContact = content.findViewById(R.id.panelAddContact);
        View panelNewGroup = content.findViewById(R.id.panelNewGroup);
        View panelJoinPublicGroup = content.findViewById(R.id.panelJoinPublicGroup);
        content.measure(0, 0);
        final ZMPopupWindow popWin = new ZMPopupWindow(content, content.getMeasuredWidth(), content.getMeasuredHeight());
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                int id2 = v.getId();
                if (id2 == R.id.panelAddContact) {
                    IMAddrBookListFragment.this.onClickPanelAddContact();
                } else if (id2 == R.id.panelNewGroup) {
                    IMAddrBookListFragment.this.onClickPanelNewGroup();
                } else if (id2 == R.id.panelJoinPublicGroup) {
                    IMAddrBookListFragment.this.onClickPanelJoinPublicGroup();
                }
                popWin.dismiss();
            }
        };
        panelAddContact.setOnClickListener(listener);
        panelNewGroup.setOnClickListener(listener);
        panelJoinPublicGroup.setOnClickListener(listener);
        popWin.setContentView(content);
        popWin.showAsDropDown(this.mBtnInvite);
    }

    private boolean isPhoneNumberRegistered() {
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper != null) {
            return !StringUtil.isEmptyOrNull((String)contactsHelper.getVerifiedPhoneNumber());
        }
        return false;
    }

    public boolean handleBackPressed() {
        if (this.mPanelSearchBarReal.getVisibility() == 0) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            if (this.mUIMode == 2) {
                this.mPanelRoomSearchBar.setVisibility(0);
            } else if (this.mUIMode == 1) {
                this.mPanelGroupSearchBar.setVisibility(0);
            }
            this.mEdtSearchReal.setText((CharSequence)"");
            this.isKeyboardOpen = false;
            return true;
        }
        return false;
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtGroupSearch == null) {
            return;
        }
        this.isKeyboardOpen = false;
        this.mPanelGroups.setForeground(null);
        this.mPanelRooms.setForeground(null);
        int keyLen = this.mEdtSearchReal.getText().length();
        if (this.mUIMode == 2) {
            if (keyLen == 0 || this.mRoomsListView.getCount() == 0) {
                this.mEdtSearchReal.setText((CharSequence)"");
                this.mPanelTitleBar.setVisibility(0);
                this.mPanelSearchBarReal.setVisibility(4);
                this.mPanelRoomSearchBar.setVisibility(0);
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IMAddrBookListFragment.this.mRoomsListView.requestLayout();
                }
            });
        } else if (this.mUIMode == 1) {
            if (keyLen == 0 || this.mGroupsListView.getCount() == 0) {
                this.mEdtSearchReal.setText((CharSequence)"");
                this.mPanelTitleBar.setVisibility(0);
                this.mPanelSearchBarReal.setVisibility(4);
                this.mPanelGroupSearchBar.setVisibility(0);
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IMAddrBookListFragment.this.mGroupsListView.requestLayout();
                }
            });
        }
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addIMListener(this);
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return;
        }
        boolean reloadDone = true;
        if (cache.needReloadAll() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
            reloadDone = cache.reloadAllContacts();
            if (reloadDone) {
                IMAddrBookListView.clearCaches();
            }
        }
        if (reloadDone && PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
            this.startABMatching();
        } else if (!StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
        }
        this.lazyRefreshAll(true);
        if (this.mListView != null) {
            this.mListView.onResume();
        }
        if (this.mRoomsListView != null) {
            this.mRoomsListView.onResume();
        }
        this.updatePanelConnectionAlert();
        this.updateUIMode(this.mUIMode, true);
        this.startToListenNetworkEvent();
        this.updateUIForIMChatOption();
    }

    private void updateUIForIMChatOption() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || messenger.imChatGetOption() == 2) {
            this.mPanelTabGroups.setVisibility(8);
        }
    }

    private void startToListenNetworkEvent() {
        if (this.mNetworkStateReceiver == null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    IMAddrBookListFragment.this.updatePanelConnectionAlert();
                }
            };
            context.registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopToListenNetworkEvent() {
        if (this.mNetworkStateReceiver != null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            context.unregisterReceiver(this.mNetworkStateReceiver);
            this.mNetworkStateReceiver = null;
        }
    }

    private void updateUIMode(int uiMode, boolean bCloseKeyboard) {
        this.mUIMode = uiMode;
        if (this.mPanelSearchBarReal.getVisibility() == 0) {
            return;
        }
        switch (uiMode) {
            case 0: {
                this.mPanelTabContacts.setSelected(true);
                this.mPanelTabGroups.setSelected(false);
                this.mPanelTabRooms.setSelected(false);
                this.mPanelGroupOperator.setVisibility(8);
                this.mPanelContacts.setVisibility(0);
                this.mPanelGroups.setVisibility(8);
                this.mPanelSearchBar.setVisibility(0);
                this.mPanelGroupSearchBar.setVisibility(8);
                this.mPanelRooms.setVisibility(8);
                this.mPanelRoomSearchBar.setVisibility(8);
                break;
            }
            case 1: {
                this.mPanelTabContacts.setSelected(false);
                this.mPanelTabGroups.setSelected(true);
                this.mPanelTabRooms.setSelected(false);
                this.mPanelGroupOperator.setVisibility(0);
                this.mPanelContacts.setVisibility(8);
                this.mPanelGroups.setVisibility(0);
                this.mPanelSearchBar.setVisibility(8);
                this.mPanelGroupSearchBar.setVisibility(0);
                this.mPanelRooms.setVisibility(8);
                this.mPanelRoomSearchBar.setVisibility(8);
                break;
            }
            case 2: {
                this.mPanelTabContacts.setSelected(false);
                this.mPanelTabGroups.setSelected(false);
                this.mPanelTabRooms.setSelected(true);
                this.mPanelGroupOperator.setVisibility(8);
                this.mPanelContacts.setVisibility(8);
                this.mPanelGroups.setVisibility(8);
                this.mPanelSearchBar.setVisibility(8);
                this.mPanelGroupSearchBar.setVisibility(8);
                this.mPanelRooms.setVisibility(0);
                this.mPanelRoomSearchBar.setVisibility(0);
                break;
            }
        }
        if (bCloseKeyboard) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtGroupSearch);
        }
    }

    private void updatePanelConnectionAlert() {
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelConnectionAlert.setVisibility(8);
            return;
        }
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
                case -1: 
                case 1: 
                case 2: {
                    this.mPanelConnectionAlert.setVisibility(8);
                    break;
                }
                case 0: {
                    this.mPanelConnectionAlert.setVisibility(0);
                    if (this.mTxtNetworkAlert == null) break;
                    this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_stream_conflict);
                }
            }
        } else {
            this.mPanelConnectionAlert.setVisibility(0);
            if (this.mTxtNetworkAlert != null) {
                this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_network_unavailable);
            }
        }
    }

    private void matchNewNumbers() {
        if (!PTApp.getInstance().isWebSignedOn()) {
            return;
        }
        int ret = ContactsMatchHelper.getInstance().matchNewNumbers((Context)this.getActivity());
        if (ret != 0 && ret != -1) {
            this.showErrorDialog(ret);
        }
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeIMListener(this);
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.removeListener(this);
        this.stopToListenNetworkEvent();
    }

    @Override
    public void onContactsCacheUpdated() {
        IMAddrBookListView.clearCaches();
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return;
        }
        if (PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
            this.startABMatching();
        } else if (!StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
        }
        if (this.isResumed()) {
            this.refreshAll(true);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        SparseArray myState = null;
        if (savedInstanceState != null) {
            myState = savedInstanceState.getSparseParcelableArray(IMAddrBookListFragment.class.getName() + ".State");
        }
        this.mContentView = this.getView();
        if (this.mContentView != null && myState != null) {
            this.mContentView.restoreHierarchyState(myState);
        }
        if (this.mContentView == null) {
            this.mContentView = this.onCreateView(this.getLayoutInflater(savedInstanceState), null, savedInstanceState);
            if (this.mContentView != null && myState != null) {
                this.mContentView.restoreHierarchyState(myState);
            }
        }
        PTUI.getInstance().addPhoneABListener(this);
    }

    public void onDestroyView() {
        ZoomPublicRoomSearchUI.getInstance().removeListener(this.mZoomPublicRoomSearchUIListener);
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        ZMBuddySyncInstance.getInsatance().removeListener(this.mBuddyListLisener);
        IMCallbackUI.getInstance().removeListener(this.mGroupMemberSynchronizer);
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity.isFinishing() || this.isRemoving()) {
            PTUI.getInstance().removePhoneABListener(this);
        }
        if (this.isRemoving()) {
            IMAddrBookListView.clearCaches();
        }
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void enableAddrBook() {
        AddrBookSettingActivity.show((Fragment)this, 100);
    }

    public void onSetPhoneNumberDone() {
        this.onAddressBookEnabled();
    }

    public void onSelected() {
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            ABContactsCache cache = ABContactsCache.getInstance();
            if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.READ_CONTACTS") == 0) {
                if (cache.needReloadAll()) {
                    cache.reloadAllContacts();
                }
            } else if (AppUtil.canRequestContactPermission()) {
                this.requestContactPermission();
            }
        }
    }

    public void onAddressBookEnabled() {
        this.mListView.startABMatching();
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity instanceof IMActivity) {
            ((IMActivity)activity).onAddressBookEnabled(true);
        }
    }

    private void refreshAll(boolean force) {
        if (this.getView() == null) {
            return;
        }
        this.mListView.setFilter(this.mEdtSearch.getText().toString().toLowerCase(CompatUtils.getLocalDefault()));
        if (force) {
            IMAddrBookListView.clearCaches();
        }
        this.reloadAllItems();
        this.updateClearSearchView();
        this.mGroupsListView.refreshAllData();
        this.mRoomsListView.refreshAllData();
        this.updateUIMode(this.mUIMode, false);
        this.checkNoRoomMessage();
    }

    public void reloadAllItems() {
        this.reloadAllItems(false);
    }

    public void reloadAllItems(boolean disableLazyLoadAvatar) {
        if (this.getView() == null || this.mListView == null) {
            return;
        }
        this.mListView.reloadAllItems(disableLazyLoadAvatar);
        this.checkShowNoBuddyMessage();
    }

    private void checkNoRoomMessage() {
        boolean hasRoom = this.mRoomsListView.hasRooms();
        this.mPanelTabRooms.setVisibility(hasRoom ? 0 : 8);
    }

    private void checkShowNoBuddyMessage() {
        int count = this.mListView.getContactsItemCount();
        if (count > 0 || this.mEdtSearch.getText().length() > 0) {
            this.mPanelNoItemMsg.setVisibility(8);
        } else {
            PTSettingHelper settingHelper;
            this.mPanelNoItemMsg.setVisibility(0);
            this.mImgNoBuddy.setImageResource(R.drawable.zm_ic_no_zoom_contacts);
            boolean showOfflineBuddies = true;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (!(messenger != null && messenger.isAnyBuddyGroupLarge() || (settingHelper = PTApp.getInstance().getSettingHelper()) == null)) {
                showOfflineBuddies = settingHelper.getShowOfflineBuddies();
            }
            this.mTxtNoContactsMessage.setText(showOfflineBuddies ? R.string.zm_msg_no_zoom_contacts : R.string.zm_msg_no_online_contacts_zoom);
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        if (event == 0) {
            this.onWebLogin(result);
        }
    }

    private void onWebLogin(long result) {
        if (result == 0L) {
            ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
            if (helper == null) {
                return;
            }
            if (PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
                this.startABMatching();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public void onPhoneABEvent(final int event, final long result, final Object content) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handlePhoneABEvent"){

            public void run(IUIElement ui) {
                ((IMAddrBookListFragment)ui).handlePhoneABEvent(event, result, content);
            }
        });
    }

    private void handlePhoneABEvent(int event, long result, Object content) {
        switch (event) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.onPhoneABMatchUpdated(result);
            }
        }
    }

    private void onPhoneABMatchUpdated(long result) {
        this.mListView.onPhoneABMatchUpdated(result);
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        switch ((int)result) {
            case 0: {
                this.refreshAll(true);
                break;
            }
            case 1104: {
                this.onPhoneBindByOther();
            }
        }
    }

    private void onPhoneBindByOther() {
    }

    public boolean startABMatching() {
        int ret = this.mListView.startABMatching();
        if (ret == 0) {
            return true;
        }
        if (ret == -1) {
            this.reloadAllItems();
        } else {
            this.showErrorDialog(ret);
        }
        return false;
    }

    private void showErrorDialog(int errorCode) {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_match_contacts_failed);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
        if (this.mListView != null) {
            this.mListView.updateUnreadMessageCountBubble();
        }
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddySort() {
    }

    @Override
    public void onSubscriptionRequest() {
    }

    @Override
    public void onSubscriptionUpdate() {
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public void showNonZoomUserActions(IMAddrBookItem item) {
        if (item == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        int countNumbers = item.getPhoneNumberCount();
        int countEmails = item.getEmailCount();
        if (countNumbers == 1 && countEmails == 0) {
            IMAddrBookListFragment.inviteBySMS((Context)activity, fm, item.getPhoneNumber(0));
        } else if (countNumbers == 0 && countEmails == 1) {
            IMAddrBookListFragment.inviteByEmail((Context)activity, fm, item.getEmail(0));
        } else {
            ContextMenuFragment.show(fm, item);
        }
    }

    private static void inviteByEmail(Context context, FragmentManager fm, String email) {
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = PTApp.getInstance().getZoomInvitationEmailBody();
        ZMSendMessageFragment.show((Context)context, (FragmentManager)fm, (String[])new String[]{email}, null, (String)topic, (String)content, (String)content, null, null, (int)1);
    }

    private static void inviteBySMS(Context context, FragmentManager fm, String phoneNumber) {
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = context.getString(R.string.zm_msg_sms_invitation_content);
        ZMSendMessageFragment.show((Context)context, (FragmentManager)fm, null, (String[])new String[]{phoneNumber}, (String)topic, (String)content, (String)content, null, null, (int)2);
    }

    private void onZoomMessengerSearchBuddy(boolean b, String email, int result) {
        if (!this.isResumed()) {
            return;
        }
        this.dismissWaitingDialog();
    }

    private void onZoomMessengerBeginConnect() {
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity()) && this.isResumed()) {
            this.updatePanelConnectionAlert();
        }
    }

    private void onZoomMessengerConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && this.isResumed()) {
            this.updatePanelConnectionAlert();
            if (this.mListView != null) {
                this.mListView.onZoomMessengerConnectReturn();
            }
        }
    }

    private void lazyRefreshAll(boolean force) {
        if (this.mListView != null && this.mListView.getContactsItemCount() == 0) {
            this.refreshAll(true);
        } else {
            this.mHandler.removeMessages(1);
            Message msg = this.mHandler.obtainMessage(1, force ? 1 : 0, 0);
            this.mHandler.sendMessageDelayed(msg, 2000L);
        }
    }

    private void onZoomMessengerMUCGroupInfoUpdatedImpl(String groupID) {
        if (!this.isResumed()) {
            return;
        }
        this.mGroupsListView.onZoomMessengerMUCGroupInfoUpdated(groupID);
    }

    public void onZoomMessengerGroupAction(final int result, final GroupAction action, String messageId) {
        if (action.getActionType() == 0) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_ADD_BUDDIES"){

                public void run(IUIElement ui) {
                    IMAddrBookListFragment f = (IMAddrBookListFragment)ui;
                    if (f != null) {
                        f.handleGroupActionMakeGroup(result, action);
                    }
                }
            });
        }
        this.mGroupsListView.onGroupAction(result, action, messageId);
    }

    public void onBuddyListUpdate() {
        this.mListView.onBuddyListUpdate();
        if (!this.isResumed()) {
            return;
        }
        this.mRoomsListView.refreshAllData();
        this.mGroupsListView.refreshAllData();
        this.checkShowNoBuddyMessage();
        this.checkNoRoomMessage();
    }

    public void onBuddyInfoUpdate(List<String> presenceChangeJids, List<String> infoChangeJids) {
        this.mListView.onBuddyInfoUpdate(presenceChangeJids, infoChangeJids);
        if (!this.isResumed()) {
            return;
        }
        this.mRoomsListView.onBuddyInfoUpdate(presenceChangeJids, infoChangeJids);
        this.checkShowNoBuddyMessage();
    }

    public void searchMore(String key) {
        if (StringUtil.isEmptyOrNull((String)key)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.searchBuddyByKey(key)) {
            this.showWaitingDialog();
        }
    }

    public void gotoSavedSessions() {
        IMSavedSessionsFragment.showAsActivity((ZMActivity)this.getActivity(), 0);
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    private void requestContactPermission() {
        this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 0);
        AppUtil.saveRequestContactPermissionTime();
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((IMAddrBookListFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        switch (requestCode) {
            case 1000: {
                this.onContactsPermissionRequestByPhoneMatch();
            }
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_CONTACTS".equals(permissions[i]) || grantResults[i] != 0) continue;
            ABContactsCache cache = ABContactsCache.getInstance();
            cache.registerContentObserver();
            if (!cache.needReloadAll()) continue;
            cache.reloadAllContacts();
        }
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        private String mPhoneNumber;
        private String mEmail;

        public ContextMenuItem(String label, String phoneNumber, String email) {
            super(0, label);
            this.mPhoneNumber = phoneNumber;
            this.mEmail = email;
        }

        public String getPhoneNumber() {
            return this.mPhoneNumber;
        }

        public String getEmail() {
            return this.mEmail;
        }

        public boolean isPhoneNumberItem() {
            return !StringUtil.isEmptyOrNull((String)this.mPhoneNumber);
        }

        public boolean isEmailItem() {
            return !StringUtil.isEmptyOrNull((String)this.mEmail);
        }
    }

    public static class ContextMenuFragment
    extends ZMDialogFragment {
        private static final String ARG_ADDRBOOKITEM = "addrBookItem";
        private ZMMenuAdapter<ContextMenuItem> mAdapter;

        public static void show(@NonNull FragmentManager fm, @NonNull IMAddrBookItem item) {
            Bundle args = new Bundle();
            args.putSerializable(ARG_ADDRBOOKITEM, (Serializable)item);
            ContextMenuFragment f = new ContextMenuFragment();
            f.setArguments(args);
            f.show(fm, ContextMenuFragment.class.getName());
        }

        public ContextMenuFragment() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            IMAddrBookItem item = (IMAddrBookItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            this.mAdapter = this.createUpdateAdapter();
            String title = item.getScreenName();
            title = StringUtil.isEmptyOrNull((String)title) ? this.getString(R.string.zm_title_invite) : this.getString(R.string.zm_title_invite_xxx, new Object[]{title});
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ContextMenuFragment.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMMenuAdapter<ContextMenuItem> createUpdateAdapter() {
            IMAddrBookItem item = (IMAddrBookItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            ContextMenuItem[] items = null;
            if (item != null) {
                int i;
                items = new ContextMenuItem[item.getPhoneNumberCount() + item.getEmailCount()];
                int idx = 0;
                for (i = 0; i < item.getPhoneNumberCount(); ++i) {
                    String number = item.getPhoneNumber(i);
                    items[idx++] = new ContextMenuItem(number, number, null);
                }
                for (i = 0; i < item.getEmailCount(); ++i) {
                    String email = item.getEmail(i);
                    items[idx++] = new ContextMenuItem(email, null, email);
                }
            }
            if (this.mAdapter == null) {
                this.mAdapter = new ZMMenuAdapter((Context)((ZMActivity)this.getActivity()), false);
            } else {
                this.mAdapter.clear();
            }
            if (items != null) {
                this.mAdapter.addAll((IZMMenuItem[])items);
            }
            return this.mAdapter;
        }

        public void refresh() {
            this.createUpdateAdapter().notifyDataSetChanged();
        }

        private void onSelectItem(int which) {
            ContextMenuItem menuItem = (ContextMenuItem)((Object)this.mAdapter.getItem(which));
            if (menuItem == null) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            if (menuItem.isPhoneNumberItem()) {
                IMAddrBookListFragment.inviteBySMS((Context)activity, fm, menuItem.getPhoneNumber());
            } else {
                IMAddrBookListFragment.inviteByEmail((Context)activity, fm, menuItem.getEmail());
            }
        }
    }

    public static class EnablePhoneMatchDialog
    extends ZMDialogFragment {
        public static void show(@NonNull FragmentManager fm, Fragment fragment, int requestCode) {
            Bundle args = new Bundle();
            EnablePhoneMatchDialog f = new EnablePhoneMatchDialog();
            f.setArguments(args);
            f.setTargetFragment(fragment, requestCode);
            f.show(fm, EnablePhoneMatchDialog.class.getName());
        }

        @NonNull
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_title_enable_phone_match_33300).setMessage(R.string.zm_lbl_enable_phone_match_33300).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Fragment fragment = EnablePhoneMatchDialog.this.getTargetFragment();
                    if (fragment != null) {
                        fragment.onActivityResult(EnablePhoneMatchDialog.this.getTargetRequestCode(), -1, null);
                    }
                }
            }).setNegativeButton(R.string.zm_btn_not_allow_33300, null).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }
    }

    public static class ContactsPermissionFailedDialog
    extends ZMDialogFragment {
        public static void show(@NonNull FragmentManager fm) {
            Bundle args = new Bundle();
            ContactsPermissionFailedDialog f = new ContactsPermissionFailedDialog();
            f.setArguments(args);
            f.show(fm, ContactsPermissionFailedDialog.class.getName());
        }

        @NonNull
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_lbl_open_contacts_permission_33300).setPositiveButton(R.string.zm_btn_open_settings_33300, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Uri packageURI = Uri.parse((String)("package:" + ContactsPermissionFailedDialog.this.getActivity().getPackageName()));
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", packageURI);
                    ContactsPermissionFailedDialog.this.startActivity(intent);
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }
    }

    static class MyHandler
    extends Handler {
        static final int MSG_REFRESH_ALL = 1;
        WeakReference<IMAddrBookListFragment> fragmentWeakReference;

        MyHandler(IMAddrBookListFragment fragment) {
            this.fragmentWeakReference = new WeakReference<IMAddrBookListFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            IMAddrBookListFragment fragment = (IMAddrBookListFragment)this.fragmentWeakReference.get();
            if (fragment == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    boolean isForce = msg.arg1 == 1;
                    fragment.refreshAll(isForce);
                }
            }
        }
    }
}

