/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.MeetingInfoActivity;
import com.zipow.videobox.ScheduleActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.IMMyMeetingsFragment;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.ScheduledMeetingItem;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class HostMeetingFragment_v2
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private final String TAG = HostMeetingFragment_v2.class.getSimpleName();
    public static final int REQUEST_SCHEDULE = 100;
    private View mBtnBack;
    private CheckedTextView mChkVideoOn;
    private CheckedTextView mChkUsePMI;
    private TextView mTxtPMI;
    private Button mBtnStartMeeting;
    private View mBtnUpcomingMeetings;
    private View mBtnScheduleMeeting;
    private View mOptionUsePMI;
    private View mOptionVideoOn;
    private PTUI.IMeetingMgrListener mMeetingMgrListener = null;

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, HostMeetingFragment_v2.class.getName(), args, 0, true);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, HostMeetingFragment_v2.class.getName(), args, 0, true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_host_meeting_v2, container, false);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mChkVideoOn = (CheckedTextView)view.findViewById(R.id.chkVideoOn);
        this.mChkUsePMI = (CheckedTextView)view.findViewById(R.id.chkUsePMI);
        this.mTxtPMI = (TextView)view.findViewById(R.id.txtPMI);
        this.mBtnStartMeeting = (Button)view.findViewById(R.id.btnStartMeeting);
        this.mBtnUpcomingMeetings = view.findViewById(R.id.btnUpcomingMeetings);
        this.mBtnScheduleMeeting = view.findViewById(R.id.btnScheduleMeeting);
        this.mOptionUsePMI = view.findViewById(R.id.optionUsePMI);
        this.mOptionVideoOn = view.findViewById(R.id.optionVideoOn);
        if (savedInstanceState == null) {
            MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
            if (meetingHelper != null) {
                this.mChkVideoOn.setChecked(meetingHelper.alwaysMobileVideoOn());
                this.setPmiChecked(meetingHelper.alwaysUsePMI());
            }
        } else {
            boolean videoOn = savedInstanceState.getBoolean("videoOn", true);
            boolean usePMI = savedInstanceState.getBoolean("usePMI", false);
            this.mChkVideoOn.setChecked(videoOn);
            this.setPmiChecked(usePMI);
        }
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnStartMeeting.setOnClickListener((View.OnClickListener)this);
        this.mBtnUpcomingMeetings.setOnClickListener((View.OnClickListener)this);
        this.mBtnScheduleMeeting.setOnClickListener((View.OnClickListener)this);
        this.mOptionVideoOn.setOnClickListener((View.OnClickListener)this);
        this.mOptionUsePMI.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("videoOn", this.mChkVideoOn.isChecked());
        outState.putBoolean("usePMI", this.mChkUsePMI.isChecked());
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeMeetingMgrListener(this.mMeetingMgrListener);
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        if (this.mMeetingMgrListener == null) {
            this.mMeetingMgrListener = new PTUI.SimpleMeetingMgrListener(){

                @Override
                public void onListMeetingResult(int result) {
                    HostMeetingFragment_v2.this.updatePMI();
                }
            };
        }
        PTUI.getInstance().addMeetingMgrListener(this.mMeetingMgrListener);
        this.updatePMI();
        this.updateBtnStartMeeting();
        this.updateBtnSchedule();
    }

    private int getLoginType() {
        PTAppProtos.ZoomAccount account;
        int loginType = PTApp.getInstance().getPTLoginType();
        if (loginType == 100 && (account = PTApp.getInstance().getSavedZoomAccount()) == null) {
            loginType = 102;
        }
        return loginType;
    }

    private void updatePMI() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            this.mTxtPMI.setText((CharSequence)"");
            return;
        }
        MeetingInfo meetingInfo = meetingHelper.getPmiMeetingItem();
        if (meetingInfo == null) {
            this.mTxtPMI.setText((CharSequence)"");
            return;
        }
        long lMeetingNo = meetingInfo.getMeetingNumber();
        String sMeetingNo = String.valueOf(lMeetingNo);
        int iFormat = 0;
        if (sMeetingNo.length() > 10) {
            iFormat = ResourcesUtil.getInteger((Context)this.getActivity(), (int)R.integer.zm_config_long_meeting_id_format_type, (int)iFormat);
        }
        this.mTxtPMI.setText((CharSequence)StringUtil.formatConfNumber((long)lMeetingNo, (int)iFormat));
        boolean usePMI = this.mChkUsePMI.isChecked();
        int loginType = this.getLoginType();
        switch (loginType) {
            case 0: 
            case 2: 
            case 100: 
            case 101: {
                this.mOptionUsePMI.setVisibility(0);
                break;
            }
            default: {
                this.mOptionUsePMI.setVisibility(8);
                return;
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            if (data == null) {
                return;
            }
            ScheduledMeetingItem item = (ScheduledMeetingItem)data.getSerializableExtra("meetingItem");
            this.onScheduleSuccess(item);
        }
    }

    private void onScheduleSuccess(final ScheduledMeetingItem item) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onScheduleSuccess"){

                public void run(IUIElement ui) {
                    MeetingInfoActivity.show((ZMActivity)ui, item, R.string.zm_title_schedule_or_host_a_meeting_21854, true, 104);
                }
            });
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnStartMeeting) {
            this.onClickBtnStartMeeting();
        } else if (id2 == R.id.btnUpcomingMeetings) {
            this.onClickBtnUpcomingMeetings();
        } else if (id2 == R.id.btnScheduleMeeting) {
            this.onClickBtnScheduleMeeting();
        } else if (id2 == R.id.optionVideoOn) {
            this.onClickChkVideoOn();
        } else if (id2 == R.id.optionUsePMI) {
            this.onClickChkUsePMI();
        }
    }

    private void onClickBtnStartMeeting() {
        int callStatus = PTApp.getInstance().getCallStatus();
        switch (callStatus) {
            case 2: {
                this.backToMeeting();
                break;
            }
            case 0: {
                this.startMeeting();
                break;
            }
        }
    }

    private void backToMeeting() {
        if (!PTApp.getInstance().hasActiveCall()) {
            this.updateBtnStartMeeting();
            return;
        }
        ConfActivity.returnToConf((Context)this.getActivity());
    }

    private void startMeeting() {
        int ret;
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        boolean videoOn = this.mChkVideoOn.isChecked();
        boolean usePMI = this.mChkUsePMI.isChecked();
        MeetingHelper mh = PTApp.getInstance().getMeetingHelper();
        if (mh != null) {
            mh.setAlwaysMobileVideoOn(videoOn);
            mh.setAlwaysUsePMI(usePMI);
        }
        if ((ret = ConfActivity.startConference((Context)activity, videoOn ? 3 : 4)) != 0) {
            IMView.StartHangoutFailedDialog.show(activity.getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    private void onClickBtnUpcomingMeetings() {
        IMMyMeetingsFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnScheduleMeeting() {
        ScheduleActivity.show((Fragment)this, 100);
    }

    private void onClickChkVideoOn() {
        this.mChkVideoOn.setChecked(!this.mChkVideoOn.isChecked());
    }

    private void onClickChkUsePMI() {
        this.setPmiChecked(!this.mChkUsePMI.isChecked());
        this.updatePMI();
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onCallStatusChanged(long result) {
        if (!this.isResumed()) {
            return;
        }
        this.updateBtnStartMeetingForCallStatus((int)result);
    }

    private void onWebLogin(long result) {
        if (!this.isResumed()) {
            return;
        }
        this.updateBtnStartMeeting();
        this.updateBtnSchedule();
    }

    private void updateBtnStartMeetingForCallStatus(int status) {
        switch (status) {
            case 1: {
                this.mBtnStartMeeting.setEnabled(false);
                this.mBtnStartMeeting.setText(R.string.zm_btn_start_a_meeting);
                break;
            }
            case 2: {
                this.mBtnStartMeeting.setEnabled(true);
                this.mBtnStartMeeting.setText(R.string.zm_btn_return_to_conf);
                break;
            }
            default: {
                this.mBtnStartMeeting.setEnabled(this.getCanStartMeeting());
                this.mBtnStartMeeting.setText(R.string.zm_btn_start_a_meeting);
            }
        }
    }

    private void updateBtnStartMeeting() {
        int callStatus = PTApp.getInstance().getCallStatus();
        this.updateBtnStartMeetingForCallStatus(callStatus);
    }

    private void updateBtnSchedule() {
        this.mBtnScheduleMeeting.setEnabled(this.getCanScheduleMeeting());
    }

    private boolean getCanStartMeeting() {
        PTApp ptApp = PTApp.getInstance();
        return ptApp.hasPrescheduleMeeting() || ptApp.canAccessZoomWebservice();
    }

    private boolean getCanScheduleMeeting() {
        PTApp ptApp = PTApp.getInstance();
        return ptApp.canAccessZoomWebservice();
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.onCallStatusChanged(result);
                break;
            }
            case 0: {
                this.onWebLogin(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private boolean alwaysUsePMIEnabledOnWebByDefault() {
        PTUserProfile myProfile = PTApp.getInstance().getCurrentUserProfile();
        if (myProfile == null) {
            return false;
        }
        return myProfile.alwaysUsePMIEnabledOnWebByDefault();
    }

    private void setPmiChecked(boolean usePmi) {
        boolean alwaysUsePMIEnabledOnWeb = this.alwaysUsePMIEnabledOnWebByDefault();
        if (alwaysUsePMIEnabledOnWeb) {
            this.mChkUsePMI.setChecked(true);
            this.mChkUsePMI.setEnabled(false);
            this.mOptionUsePMI.setEnabled(false);
        } else {
            this.mChkUsePMI.setChecked(usePmi);
            this.mChkUsePMI.setEnabled(true);
            this.mOptionUsePMI.setEnabled(true);
        }
    }
}

