/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.HostKeyErrorDialog;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class HostKeyEnterDialog
extends ZMDialogFragment
implements TextView.OnEditorActionListener,
TextWatcher {
    public static String ARGS_HOST_NAME = "arg_host_name";
    private EditText mEditHostKey;
    private Button mBtnOK = null;

    public static void show(FragmentManager fragmentMgr, String hostName, String tag) {
        Bundle bundle = new Bundle();
        HostKeyEnterDialog dialog = new HostKeyEnterDialog();
        bundle.putString(ARGS_HOST_NAME, hostName);
        dialog.setArguments(bundle);
        dialog.show(fragmentMgr, tag);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        String hostName = this.getArguments().getString(ARGS_HOST_NAME, "");
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_enter_hostkey, null, false);
        this.mEditHostKey = (EditText)view.findViewById(R.id.txtHostKey);
        if (this.mEditHostKey != null) {
            this.mEditHostKey.setImeOptions(2);
            this.mEditHostKey.setOnEditorActionListener((TextView.OnEditorActionListener)this);
            this.mEditHostKey.addTextChangedListener((TextWatcher)this);
            this.mEditHostKey.requestFocus();
        }
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTitle(R.string.zm_title_enter_hostkey).setView(view).setPositiveButton(R.string.zm_btn_claim, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        return builder.create();
    }

    public void onResume() {
        super.onResume();
        this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
        this.mBtnOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!HostKeyEnterDialog.this.checkInput()) {
                    return;
                }
                HostKeyEnterDialog.this.onClickBtnOK();
            }
        });
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.checkInput()) {
            this.mBtnOK.setEnabled(true);
        } else {
            this.mBtnOK.setEnabled(false);
        }
    }

    private boolean checkInput() {
        if (this.mEditHostKey == null) {
            return false;
        }
        String text = this.mEditHostKey.getText().toString().trim();
        if (StringUtil.isEmptyOrNull((String)text) || text.length() != 6) {
            return false;
        }
        try {
            Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private void onClickBtnOK() {
        String key = this.mEditHostKey.getText().toString();
        if (StringUtil.isEmptyOrNull((String)key)) {
            return;
        }
        this.dismissAllowingStateLoss();
        boolean ret = ConfMgr.getInstance().verifyHostKey(key);
        if (!ret) {
            HostKeyErrorDialog.show(this.getFragmentManager());
            return;
        }
        ConfActivityNormal confActivity = (ConfActivityNormal)this.getActivity();
        if (confActivity != null) {
            confActivity.showVerifyHostKeyDialog();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 2: {
                this.onClickBtnOK();
                return true;
            }
        }
        return false;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.updateButtons();
    }
}

