/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.videomeetings.R;

public class ForgetPasswordFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private Button mBtnBack;
    private Button mBtnSendEmail;
    private EditText mEdtEmail;

    public static void show(ZMActivity activity) {
        ForgetPasswordFragment f = new ForgetPasswordFragment();
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, ForgetPasswordFragment.class.getName()).commit();
    }

    public static ForgetPasswordFragment getForgetPasswordFragment(FragmentManager fm) {
        return (ForgetPasswordFragment)fm.findFragmentByTag(ForgetPasswordFragment.class.getName());
    }

    public ForgetPasswordFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_forgetpwd, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSendEmail = (Button)view.findViewById(R.id.btnSendEmail);
        this.mEdtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSendEmail.setOnClickListener((View.OnClickListener)this);
        TextWatcher inputValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ForgetPasswordFragment.this.updateSendEmailButton();
            }
        };
        this.mEdtEmail.addTextChangedListener(inputValidator);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateSendEmailButton();
        PTUI.getInstance().addPTUIListener(this);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSendEmail) {
            this.onClickSendEmailButton();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickSendEmailButton() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtEmail);
        if (!this.validateInput()) {
            return;
        }
        String email = this.mEdtEmail.getText().toString();
        boolean res = PTApp.getInstance().forgotPassword(email);
        if (res) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_requesting_forgot_pwd);
            dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        } else {
            this.showForgotPwdErrorDialog();
        }
    }

    private void updateSendEmailButton() {
        this.mBtnSendEmail.setEnabled(this.validateInput());
    }

    private boolean validateInput() {
        String email = this.mEdtEmail.getText().toString();
        return StringUtil.isValidEmailAddress((String)email);
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 40: {
                this.onForgotPasswordRet(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onForgotPasswordRet(long result) {
        WaitingDialog waitingDlg = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (waitingDlg != null) {
            waitingDlg.dismiss();
        }
        switch ((int)result) {
            case 0: {
                this.showSendEmailSuccessDialog();
                break;
            }
            case 1001: {
                this.showUserNotExistDialog();
                break;
            }
            default: {
                this.showForgotPwdErrorDialog();
            }
        }
    }

    private void showUserNotExistDialog() {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_account_not_exist);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private void showForgotPwdErrorDialog() {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_resetpwd_failed);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private void showSendEmailSuccessDialog() {
        String email = this.mEdtEmail.getText().toString();
        String msg = this.getString(R.string.zm_msg_resetpwd_email_sent, new Object[]{email});
        String title = this.getString(R.string.zm_msg_resetpwd_email_sent_title);
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(msg, title);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }
}

