/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import com.zipow.videobox.fragment.ScheduleFragment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class EndRepeatFragment
extends ZMDialogFragment {
    private static final String ARG_END_REPEAT = "endRepeat";
    private Date mEndRepeat;
    private DatePicker mDatePicker;
    private Calendar mCalendar;

    public static void showInActivity(ZMActivity activity, Date endRepeat) {
        EndRepeatFragment f = new EndRepeatFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_END_REPEAT, (Serializable)endRepeat);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, EndRepeatFragment.class.getName()).commit();
    }

    public static void showDialog(FragmentManager fm, Date endRepeat) {
        if (EndRepeatFragment.getMeetingInfoFragment(fm) != null) {
            return;
        }
        EndRepeatFragment f = new EndRepeatFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_END_REPEAT, (Serializable)endRepeat);
        f.setArguments(args);
        f.show(fm, EndRepeatFragment.class.getName());
    }

    public static EndRepeatFragment getMeetingInfoFragment(FragmentManager fm) {
        return (EndRepeatFragment)fm.findFragmentByTag(EndRepeatFragment.class.getName());
    }

    public EndRepeatFragment() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    private View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_end_repeat, null);
        this.mDatePicker = (DatePicker)view.findViewById(R.id.datePicker);
        Bundle args = this.getArguments();
        this.mEndRepeat = (Date)args.getSerializable(ARG_END_REPEAT);
        if (savedInstanceState != null) {
            this.mEndRepeat = (Date)savedInstanceState.getSerializable("mEndRepeat");
        }
        if (this.mEndRepeat == null) {
            this.mEndRepeat = new Date();
        }
        this.mCalendar = Calendar.getInstance();
        this.mCalendar.setTime(this.mEndRepeat);
        this.mDatePicker.init(this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5), new DatePicker.OnDateChangedListener(){

            public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                EndRepeatFragment.this.mCalendar.set(1, year);
                EndRepeatFragment.this.mCalendar.set(2, monthOfYear);
                EndRepeatFragment.this.mCalendar.set(5, dayOfMonth);
                EndRepeatFragment.this.mEndRepeat = EndRepeatFragment.this.mCalendar.getTime();
            }
        });
        return view;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View view = this.createView(inflater, null, savedInstanceState);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view).setTitle(R.string.zm_lbl_end_repeat).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                EndRepeatFragment.this.onClickBtnDone();
            }
        }).setNegativeButton(R.string.zm_btn_repeat_forever, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                EndRepeatFragment.this.onClickBtnRepeatForever();
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private void onClickBtnRepeatForever() {
        this.mEndRepeat = new Date(0L);
        this.onClickBtnDone();
    }

    private void onClickBtnDone() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        ScheduleFragment schedule = (ScheduleFragment)this.getParentFragment();
        schedule.onSelectEndRepeat(this.mEndRepeat);
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    private void updateUI() {
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mEndRepeat", (Serializable)this.mEndRepeat);
    }
}

