/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ProgressBar;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ConfCmrFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private WebView mWebView;
    private ProgressBar mLoadingProgress;
    private Button mBtnBack;

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        if (activity == null) {
            return;
        }
        SimpleInMeetingActivity.show(activity, ConfCmrFragment.class.getName(), null, requestCode, false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_conf_crm, null);
        this.mWebView = (WebView)view.findViewById(R.id.webviewPage);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mLoadingProgress = (ProgressBar)view.findViewById(R.id.webLoadingProgress);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mLoadingProgress.setVisibility(8);
        if (!view.isInEditMode()) {
            if (Build.VERSION.SDK_INT > 10) {
                this.mWebView.getSettings().setAllowContentAccess(false);
            }
            this.mWebView.getSettings().setSupportZoom(true);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setLoadsImagesAutomatically(true);
        }
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                ConfCmrFragment.this.showWebUrlLoadingStatus();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                ConfCmrFragment.this.showWebUrlLoadedStatus();
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                ConfCmrFragment.this.displayWebLoadingProgress(view, newProgress);
            }
        });
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            CmmConfContext cmmConfContext = ConfMgr.getInstance().getConfContext();
            if (cmmConfContext == null) {
                return;
            }
            String webServer = cmmConfContext.getRecordingManagementURL();
            if (!StringUtil.isEmptyOrNull((String)webServer)) {
                this.mWebView.loadUrl(webServer);
            }
        }
    }

    private void showWebUrlLoadingStatus() {
        this.mLoadingProgress.setVisibility(0);
        this.mLoadingProgress.setProgress(0);
    }

    private void showWebUrlLoadedStatus() {
        this.mLoadingProgress.setVisibility(8);
    }

    private void displayWebLoadingProgress(WebView view, int progress) {
        if (progress < 100 && progress > 0) {
            this.mLoadingProgress.setProgress(progress);
        } else {
            this.mLoadingProgress.setProgress(0);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBack();
        }
    }

    private void onClickBack() {
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

