/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.ConfChatViewOld;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ConfChatFragmentOld
extends ZMDialogFragment
implements ConfChatViewOld.Listener {
    public static final String ARG_USERID = "userId";
    private ConfChatViewOld mChatView;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void showDialog(FragmentManager fm, long userId) {
        if (ConfChatFragmentOld.getConfChatFragment(fm) != null) {
            return;
        }
        ConfChatFragmentOld f = new ConfChatFragmentOld();
        Bundle args = new Bundle();
        args.putLong(ARG_USERID, userId);
        f.setArguments(args);
        f.show(fm, ConfChatFragmentOld.class.getName());
    }

    public static void showActivity(ZMActivity activity, long userId) {
        ConfChatFragmentOld f = new ConfChatFragmentOld();
        Bundle args = new Bundle();
        args.putLong(ARG_USERID, userId);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, ConfChatFragmentOld.class.getName()).commit();
    }

    public static ConfChatFragmentOld getConfChatFragment(FragmentManager fm) {
        return (ConfChatFragmentOld)fm.findFragmentByTag(ConfChatFragmentOld.class.getName());
    }

    public ConfChatFragmentOld() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public long getUserId() {
        if (this.mChatView == null) {
            return 0L;
        }
        return this.mChatView.getUserId();
    }

    public void onStart() {
        super.onStart();
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserEvent(int eventType, long userId, int flag) {
                    return ConfChatFragmentOld.this.onUserEvent(eventType, userId, flag);
                }

                @Override
                public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
                    return ConfChatFragmentOld.this.onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        Bundle args = this.getArguments();
        if (args != null) {
            long userId = args.getLong(ARG_USERID, 0L);
            this.mChatView.loadData(userId);
        }
        if (this.getActivity() instanceof ConfActivity) {
            ((ConfActivity)this.getActivity()).refreshUnreadChatCount();
        }
        this.mChatView.scrollToBottom(true);
    }

    public void onPause() {
        super.onPause();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mChatView = new ConfChatViewOld((Context)this.getActivity());
        this.mChatView.setListener(this);
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            LinearLayout chatView = (LinearLayout)this.mChatView.findViewById(R.id.chatView);
            int width = UIUtil.dip2px((Context)this.getActivity(), (float)600.0f);
            if (UIUtil.getDisplayWidth((Context)this.getActivity()) < width) {
                width = UIUtil.getDisplayWidth((Context)this.getActivity());
            }
            int height = UIUtil.getDisplayHeight((Context)this.getActivity()) / 2;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
            chatView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return this.mChatView;
    }

    private boolean onUserEvent(int eventType, long userId, int flag) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.mChatView == null) {
                    return true;
                }
                CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
                if (!confStatus.isSameUser(userId, this.mChatView.getUserId())) break;
                this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                    public void run(IUIElement ui) {
                        ((ConfChatFragmentOld)ui).dismiss();
                    }
                });
                break;
            }
            case 2: {
                this.getNonNullEventTaskManagerOrThrowException().push("reloadData", new EventAction(){

                    public void run(IUIElement ui) {
                        ConfChatFragmentOld f = (ConfChatFragmentOld)ui;
                        if (f != null) {
                            f.handleUserUpdate();
                        }
                    }
                });
            }
        }
        return true;
    }

    private void handleUserUpdate() {
        if (this.mChatView != null) {
            this.mChatView.reloadData();
        }
    }

    private boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
        }
        if (this.getActivity() instanceof ConfActivity) {
            ((ConfActivity)this.getActivity()).refreshUnreadChatCount();
        }
        return true;
    }

    @Override
    public void onClickBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }
}

