/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.Toast;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.fragment.PAttendeeListActionDialog;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public abstract class ConfChatAttendeeListFragment
extends ZMDialogFragment
implements AdapterView.OnItemClickListener {
    private String mPromotingJid;
    private String mPromotingName;
    private ConfChatAttendeeItem mAttendeePendingPromote;
    private ConfUI.IConfUIListener mConfUIListener;

    protected void enableAttendeeItemPopMenu(ListView listView) {
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, final long ret) {
                    if (cmd == 99) {
                        ConfChatAttendeeListFragment.this.getNonNullEventTaskManagerOrThrowException().pushLater("onPromotePanelistResult", new EventAction("onPromotePanelistResult"){

                            public void run(IUIElement ui) {
                                ConfChatAttendeeListFragment f = (ConfChatAttendeeListFragment)ui;
                                f.onPromotePanelistResult((int)ret);
                            }
                        });
                    } else if (cmd == 3) {
                        ConfChatAttendeeListFragment.this.getNonNullEventTaskManagerOrThrowException().pushLater("onConfLockStatusChanged", new EventAction("onConfLockStatusChanged"){

                            public void run(IUIElement ui) {
                                ConfChatAttendeeListFragment f = (ConfChatAttendeeListFragment)ui;
                                f.onConfLockStatusChanged();
                            }
                        });
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
    }

    public void onDestroy() {
        if (this.mConfUIListener != null) {
            ConfUI.getInstance().removeListener(this.mConfUIListener);
        }
        super.onDestroy();
    }

    protected abstract void onRemoveItem(String var1);

    private void onPromotePanelistResult(int error) {
        this.dismissWaitingDialog();
        if (error != 0) {
            this.showErrorPromotePanelistMessage(error);
        } else if (this.mPromotingJid != null) {
            this.onRemoveItem(this.mPromotingJid);
            this.showPromoteRejoinMessage(this.mPromotingName);
        }
        this.mPromotingJid = null;
        this.mPromotingName = null;
    }

    private void showErrorPromotePanelistMessage(int error) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String message = null;
        switch (error) {
            case 3035: {
                int limit = 0;
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null) {
                    limit = confContext.getParticipantLimit();
                }
                message = this.getString(R.string.zm_webinar_msg_failed_to_promote_max_panelists, new Object[]{limit});
                break;
            }
            default: {
                message = this.getString(R.string.zm_webinar_msg_failed_to_promote_panelist, new Object[]{error});
            }
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)context).setTitle(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void onConfLockStatusChanged() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && !confStatus.isConfLocked()) {
            this.checkContinuePromoteAttendee();
        }
    }

    private void showPromoteRejoinMessage(String promotingName) {
        if (promotingName == null) {
            return;
        }
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String message = this.getString(R.string.zm_webinar_msg_user_will_rejoin_as_panelist, new Object[]{promotingName});
        Toast.makeText((Context)context, (CharSequence)message, (int)1).show();
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (savedInstanceState != null) {
            this.mPromotingJid = savedInstanceState.getString("mPromotingJid");
            this.mPromotingName = savedInstanceState.getString("mPromotingName");
            this.mAttendeePendingPromote = (ConfChatAttendeeItem)savedInstanceState.getSerializable("mAttendeePendingPromote");
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString("mPromotingJid", this.mPromotingJid);
            outState.putString("mPromotingName", this.mPromotingName);
            outState.putSerializable("mAttendeePendingPromote", (Serializable)this.mAttendeePendingPromote);
        }
    }

    public void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "FreshWaitingDialog");
    }

    public void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("FreshWaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    public void promotePanelist(ConfChatAttendeeItem attendeeItem) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isConfLocked()) {
            this.confirmToUnlockMeetingForPromoteAttendee(attendeeItem);
            return;
        }
        if (ConfMgr.getInstance().promotePanelist(attendeeItem.jid)) {
            this.mPromotingJid = attendeeItem.jid;
            this.mPromotingName = attendeeItem.name;
            this.showWaitingDialog();
        }
    }

    private void confirmToUnlockMeetingForPromoteAttendee(final ConfChatAttendeeItem item) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_webinar_msg_change_role_on_meeting_locked).setPositiveButton(R.string.zm_mi_unlock_meeting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConfChatAttendeeListFragment.this.unlockMeetingToPromoteAttendee(item);
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    private void unlockMeetingToPromoteAttendee(ConfChatAttendeeItem item) {
        this.mAttendeePendingPromote = item;
        ConfMgr.getInstance().handleConfCmd(57);
    }

    private void checkContinuePromoteAttendee() {
        if (this.mAttendeePendingPromote != null) {
            this.promotePanelist(this.mAttendeePendingPromote);
            this.mAttendeePendingPromote = null;
        }
    }

    public abstract ConfChatAttendeeItem getItemAtPosition(int var1);

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        if (!ConfLocalHelper.isNeedShowAttendeeActionList()) {
            return;
        }
        ConfChatAttendeeItem attendeeItem = this.getItemAtPosition(position);
        if (attendeeItem == null) {
            return;
        }
        PAttendeeListActionDialog.show(activity.getSupportFragmentManager(), attendeeItem);
    }
}

