/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ChangeScreenNameDialog
extends ZMDialogFragment
implements TextWatcher,
TextView.OnEditorActionListener {
    private EditText mEdtScreenName = null;
    private Button mBtnOK = null;
    private static final String ARG_USER_ID = "userId";

    public static void showDialog(FragmentManager fm, long userId) {
        if (fm == null) {
            return;
        }
        ChangeScreenNameDialog dialog = new ChangeScreenNameDialog();
        Bundle args = new Bundle();
        args.putLong(ARG_USER_ID, userId);
        dialog.setArguments(args);
        dialog.show(fm, ChangeScreenNameDialog.class.getName());
    }

    public ChangeScreenNameDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_change_screen_name, null, false);
        this.mEdtScreenName = (EditText)view.findViewById(R.id.edtScreenName);
        this.mEdtScreenName.addTextChangedListener((TextWatcher)this);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
        this.mBtnOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ChangeScreenNameDialog.this.checkInput()) {
                    return;
                }
                ChangeScreenNameDialog.this.onClickBtnOK();
            }
        });
        this.updateButtons();
        Bundle args = this.getArguments();
        if (args != null) {
            long userId = args.getLong(ARG_USER_ID, 0L);
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user != null) {
                this.mEdtScreenName.setText((CharSequence)user.getScreenName());
            }
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        UIUtil.closeSoftKeyboardInActivity((ZMActivity)((ZMActivity)this.getActivity()));
    }

    private void onClickBtnOK() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
        String newName = this.mEdtScreenName.getText().toString().trim();
        this.dismissAllowingStateLoss();
        Bundle args = this.getArguments();
        if (args != null) {
            long userId = args.getLong(ARG_USER_ID, 0L);
            ConfMgr.getInstance().changeUserNameByID(newName, userId);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.updateButtons();
    }

    private void updateButtons() {
    }

    private boolean checkInput() {
        return !StringUtil.isEmptyOrNull((String)this.mEdtScreenName.getText().toString());
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 2: {
                this.onClickBtnOK();
                return true;
            }
        }
        return false;
    }
}

