/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.SelectCallInCountryFragment;
import com.zipow.videobox.fragment.ZMErrorMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ChangeCallInCountryFragment
extends SelectCallInCountryFragment {
    private String mRequestID;
    private static String WAITING_DIALOG_TAG = "select_callin_waiting_dialog";
    private PTUI.IProfileListener mListener = new PTUI.SimpleProfileListener(){

        @Override
        public void OnProfileFieldUpdated(String reqID, int result, int type, String param) {
            if (StringUtil.isEmptyOrNull((String)reqID)) {
                return;
            }
            if (!reqID.equals(ChangeCallInCountryFragment.this.mRequestID)) {
                return;
            }
            UIUtil.dismissWaitingDialog((FragmentManager)ChangeCallInCountryFragment.this.getFragmentManager(), (String)WAITING_DIALOG_TAG);
            ChangeCallInCountryFragment.this.handleProfileUpdate(result, type);
        }
    };

    public static void showAsActivity(Fragment fragment, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, ChangeCallInCountryFragment.class.getName(), args, requestCode, false, 1);
    }

    private void handleProfileUpdate(int result, int type) {
        if (result == 0) {
            this.dismiss();
        } else {
            this.showErrorMessage(result);
        }
    }

    @Override
    public void onResume() {
        PTUI.getInstance().addProfileListener(this.mListener);
        super.onResume();
    }

    public void onPause() {
        PTUI.getInstance().removeProfileListener(this.mListener);
        super.onPause();
    }

    @Override
    public void loadAllCountryCodes(Map<String, SelectCallInCountryFragment.CallInNumberItem> countryCodeMap) {
        if (countryCodeMap == null) {
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        PTAppProtos.CountryCodelistProto proto = profile.getCallinCountryCodes();
        if (proto == null) {
            return;
        }
        List<PTAppProtos.CountryCodePT> lists = proto.getCallinCountryCodesList();
        if (lists == null) {
            return;
        }
        for (PTAppProtos.CountryCodePT country : lists) {
            String countryId = country.getId();
            if (countryCodeMap.containsKey(countryId)) continue;
            SelectCallInCountryFragment.CallInNumberItem item = new SelectCallInCountryFragment.CallInNumberItem(country.getName(), country.getCode(), country.getId());
            countryCodeMap.put(countryId, item);
        }
    }

    @Override
    protected void onSelectPhoneNumber(SelectCallInCountryFragment.CallInNumberItem item) {
        if (item == null) {
            return;
        }
        this.mRequestID = PTApp.getInstance().modifyCountryCode(item.countryId);
        if (StringUtil.isEmptyOrNull((String)this.mRequestID)) {
            this.showErrorMessage(5000);
            return;
        }
        UIUtil.showWaitingDialog((FragmentManager)this.getFragmentManager(), (int)R.string.zm_msg_waiting, (String)WAITING_DIALOG_TAG);
    }

    private void showErrorMessage(int result) {
        if (result == 0) {
            return;
        }
        String message = "";
        switch (result) {
            case 5000: 
            case 5003: {
                message = this.getString(R.string.zm_lbl_profile_change_fail_cannot_connect_service);
                break;
            }
            default: {
                message = this.getString(R.string.zm_lbl_callin_country_change_fail);
            }
        }
        String title = this.getString(R.string.zm_title_callin_country_change_fail);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        ZMErrorMessageDialog.show(this.getFragmentManager(), title, messages, "ChangeCallInCountryFragment error dialog");
    }
}

