/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.cmmlib.AppContext;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.ConfSelectCallInCountryFragment;
import com.zipow.videobox.fragment.SelectCallInCountryFragment;
import com.zipow.videobox.ptapp.CountryCode;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.TSPCallInInfo;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZMWebUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMSettingsCategory;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class CallinFragment
extends ZMTipFragment
implements View.OnClickListener {
    public static final int REQUEST_SELECT_CALLIN_NUMBER = 100;
    public static final String ARG_ANCHOR_ID = "anchorId";
    private int mAnchorId = 0;
    private TextView mTxtCountryName;
    private ViewGroup mCallNumberCategory;
    private ViewGroup mPanelTeleConfInfo;
    private String mSelectedCountryId = null;
    private ZMSettingsCategory mPanelMeetingInfo;
    private boolean mSupportDialIn;

    public static void showInActivity(ZMActivity activity) {
        CallinFragment f = new CallinFragment();
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, CallinFragment.class.getName()).commit();
    }

    public static void show(FragmentManager fm, int anchorId) {
        CallinFragment f = CallinFragment.getMeetingRunningInfoFragment(fm);
        if (f == null) {
            f = new CallinFragment();
            Bundle args = new Bundle();
            args.putInt(ARG_ANCHOR_ID, anchorId);
            f.setArguments(args);
            f.show(fm, CallinFragment.class.getName());
        } else {
            f.setTipVisible(true);
        }
    }

    public static CallinFragment getMeetingRunningInfoFragment(FragmentManager fm) {
        return (CallinFragment)fm.findFragmentByTag(CallinFragment.class.getName());
    }

    public static boolean hide(FragmentManager fm) {
        CallinFragment f = CallinFragment.getMeetingRunningInfoFragment(fm);
        if (f != null) {
            if (!f.getShowsTip()) {
                f.dismiss();
                return true;
            }
            if (f.isTipVisible()) {
                f.setTipVisible(false);
                return true;
            }
        }
        return false;
    }

    public static boolean dismiss(FragmentManager fm) {
        CallinFragment f = CallinFragment.getMeetingRunningInfoFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        this.refresh();
    }

    private void createMeetingInfoItemView(Activity activity, String strLabel, String strValue) {
        if (strLabel == null || strValue == null || activity == null || this.mPanelMeetingInfo == null) {
            return;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)activity);
        View view = inflater.inflate(R.layout.zm_tsp_info_item, (ViewGroup)this.mPanelMeetingInfo, false);
        if (view == null) {
            return;
        }
        TextView vLab = (TextView)view.findViewById(R.id.txtLabel);
        TextView vValue = (TextView)view.findViewById(R.id.txtValue);
        vLab.setText((CharSequence)strLabel);
        vValue.setText((CharSequence)strValue);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        this.mPanelMeetingInfo.addView(view, (ViewGroup.LayoutParams)lp);
    }

    public void refresh() {
        ArrayList<TSPCallInInfo> tspInfos;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        this.mPanelMeetingInfo.removeAllViews();
        boolean isTspEnable = confContext.isTspEnabled();
        boolean isNotSupportTelephone = confContext.notSupportTelephony();
        boolean isViewOnly = ConfMgr.getInstance().isViewOnlyMeeting();
        int audioType = 2;
        AudioSessionMgr audoMgr = ConfMgr.getInstance().getAudioObj();
        if (audoMgr != null) {
            audioType = audoMgr.getAudioSessionType();
        }
        long confNumber = confContext.getConfNumber();
        String accessCode = StringUtil.formatConfNumber((long)confNumber, (char)' ');
        long attendeeId = myself.getAttendeeID();
        if (!(isViewOnly || isTspEnable || isNotSupportTelephone || audioType == 0)) {
            this.createMeetingInfoItemView((Activity)activity, this.getString(R.string.zm_lbl_meeting_id2), accessCode);
            this.createMeetingInfoItemView((Activity)activity, this.getString(R.string.zm_lbl_participant_id), String.valueOf(attendeeId));
            String sMeetingPwd = confContext.getMeetingPassword();
            String sPstnPwd = confContext.getH323Password();
            if (confContext.isPSTNPassWordProtectionOn() && !StringUtil.isEmptyOrNull((String)sMeetingPwd) && !StringUtil.isEmptyOrNull((String)sPstnPwd)) {
                this.createMeetingInfoItemView((Activity)activity, this.getString(R.string.zm_lbl_password), sPstnPwd);
            }
        }
        boolean bPSTNNeedConfirm = false;
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        bPSTNNeedConfirm = meetingInfo.getPSTNNeedConfirm1();
        String countryId = "";
        String countryName = "";
        ArrayList<CountryCode> tollFreeNumber = new ArrayList<CountryCode>();
        ArrayList<CountryCode> tollNumber = new ArrayList<CountryCode>();
        if (!StringUtil.isEmptyOrNull((String)this.mSelectedCountryId)) {
            countryId = this.mSelectedCountryId;
        } else {
            countryId = meetingInfo.getDefaultcallInCountry();
            if (StringUtil.isEmptyOrNull((String)countryId)) {
                countryId = "US";
            }
        }
        countryName = new Locale("", countryId).getDisplayCountry();
        ArrayList<CountryCode> numbersList = meetingInfo.getCallinCountryCodesList();
        if (numbersList != null) {
            for (CountryCode number : numbersList) {
                if (number == null || !countryId.equals(number.getId()) || StringUtil.isEmptyOrNull((String)number.getDisplaynumber()) || StringUtil.isEmptyOrNull((String)number.getNumber())) continue;
                if (number.getCalltype() == 1) {
                    tollFreeNumber.add(number);
                    continue;
                }
                tollNumber.add(number);
            }
        }
        this.mTxtCountryName.setText((CharSequence)countryName);
        if (tollNumber.isEmpty() && tollFreeNumber.isEmpty()) {
            this.mPanelTeleConfInfo.setVisibility(8);
        } else {
            this.mPanelTeleConfInfo.setVisibility(0);
            this.mCallNumberCategory.removeAllViews();
            tollNumber.addAll(tollFreeNumber);
            this.createNumbersLinkItems((Activity)activity, this.mCallNumberCategory, tollNumber, confNumber, attendeeId, bPSTNNeedConfirm);
        }
        if (isTspEnable && (tspInfos = meetingInfo.getTspCallinInfoList()) != null && tspInfos.size() > 0) {
            for (int i = 0; i < tspInfos.size(); ++i) {
                TSPCallInInfo info = (TSPCallInInfo)tspInfos.get(i);
                this.createMeetingInfoItemView((Activity)activity, info.getKey(), info.getValue());
            }
        }
    }

    private void createNumbersLinkItems(Activity activity, ViewGroup parent, List<CountryCode> numbers, long confNumber, long attendeeId, boolean bPSTNNeedConfirm) {
        LayoutInflater inflater = LayoutInflater.from((Context)activity);
        int index = 0;
        for (CountryCode number : numbers) {
            String displayNumber;
            String dialNumber = displayNumber = number.getDisplaynumber().trim();
            if (StringUtil.isEmptyOrNull((String)displayNumber) || StringUtil.isEmptyOrNull((String)dialNumber)) continue;
            View view = inflater.inflate(R.layout.zm_call_number_item, parent, false);
            TextView txtCallinNumber = (TextView)view.findViewById(R.id.txtNumber);
            ImageView imgCall = (ImageView)view.findViewById(R.id.imgCall);
            imgCall.setVisibility(this.mSupportDialIn ? 0 : 8);
            if (this.mSupportDialIn) {
                imgCall.setImageResource(index == 0 ? R.drawable.zm_call_highlight : R.drawable.zm_call);
            }
            int callType = number.getCalltype() == 1 ? 1 : 0;
            this.decorateCallinNumberTextView(txtCallinNumber, imgCall, displayNumber, dialNumber, confNumber, attendeeId, bPSTNNeedConfirm, callType);
            parent.addView(view);
            ++index;
        }
    }

    private void decorateCallinNumberTextView(TextView textView, ImageView imgCall, final String displayNumber, String dialNumber, long accessCode, long attendeeId, boolean needConfirm, int callType) {
        final String fullNumberStr = this.buildFullCallInNumberString(dialNumber, accessCode, attendeeId, needConfirm);
        if (callType == 1) {
            textView.setText((CharSequence)this.getString(R.string.zm_lbl_number_desc_18332, new Object[]{displayNumber, this.getString(R.string.zm_lbl_toll_free_number_hint)}));
        } else {
            textView.setText((CharSequence)displayNumber);
        }
        imgCall.setContentDescription((CharSequence)this.getString(callType == 1 ? R.string.zm_content_desc_dial_free_call_18332 : R.string.zm_content_desc_dial_toll_call_18332));
        imgCall.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ZMActivity activity = (ZMActivity)CallinFragment.this.getActivity();
                if (activity == null) {
                    return;
                }
                PhoneCallConfirmDialog.showPhoneCallConfirmDialog(activity, displayNumber, fullNumberStr);
            }
        });
    }

    private String formatNumberForDial(String number) {
        if (number == null) {
            return null;
        }
        number = number.replace("(0)", "");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (c == '+' && builder.length() == 0) {
                builder.append(c);
                continue;
            }
            if (c == ',' || c == ';') break;
        }
        String formattedNumber = builder.toString();
        return formattedNumber;
    }

    private String buildFullCallInNumberString(String number, long accessCode, long attendeeId, boolean needConfirm) {
        String formatedNumber = this.formatNumberForDial(number);
        StringBuilder builder = new StringBuilder();
        builder.append(formatedNumber);
        builder.append(",,,");
        builder.append(accessCode);
        builder.append("#,,,");
        if (needConfirm) {
            builder.append("1,");
        }
        builder.append(attendeeId);
        builder.append("#");
        return builder.toString();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isTipVisible", this.isTipVisible());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_callin_info, null);
        TextView txtDialNumberTitle = (TextView)view.findViewById(R.id.txtDialNumberTitle);
        this.mTxtCountryName = (TextView)view.findViewById(R.id.txtCountryName);
        this.mCallNumberCategory = (ViewGroup)view.findViewById(R.id.dialNumberList);
        this.mPanelTeleConfInfo = (ViewGroup)view.findViewById(R.id.panelTeleConfInfo);
        this.mPanelMeetingInfo = (ZMSettingsCategory)view.findViewById(R.id.panelMeetingInfo);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.llTitle).setOnClickListener((View.OnClickListener)this);
        this.mSelectedCountryId = PreferenceUtil.readStringValue("callin.selected_country_id", null);
        this.mSupportDialIn = !ResourcesUtil.getBoolean((Context)this.getActivity(), (int)R.bool.zm_config_no_auto_dial_in, (boolean)false) && VoiceEngineCompat.isFeatureTelephonySupported((Context)this.getActivity());
        txtDialNumberTitle.setText(this.mSupportDialIn ? R.string.zm_lbl_dial_select_number_18332 : R.string.zm_lbl_dial_pick_number_18332);
        return view;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        SelectCallInCountryFragment.CallInNumberItem number;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null && (number = (SelectCallInCountryFragment.CallInNumberItem)data.getSerializableExtra("phoneNumber")) != null) {
            this.mSelectedCountryId = number.countryId;
            PreferenceUtil.saveStringValue("callin.selected_country_id", this.mSelectedCountryId);
            this.refresh();
        }
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = this.getView();
        if (view == null) {
            return null;
        }
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        Bundle args = this.getArguments();
        this.mAnchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (this.mAnchorId > 0 && (anchor = this.getActivity().findViewById(this.mAnchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode(context) ? 1 : 3);
        }
        if (savedInstanceState != null) {
            boolean visible = savedInstanceState.getBoolean("isTipVisible", true);
            tip.setVisibility(visible ? 0 : 4);
        }
        return tip;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.llTitle) {
            this.onClickPickCountryOrRegion();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    protected void onClickOtherNumbersLink() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        String url = null;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            url = confContext.getTeleConfURL();
        }
        if (StringUtil.isEmptyOrNull(url)) {
            AppContext appContext = new AppContext("config");
            String webServer = appContext.queryWithKey("conf.webserver", AppContext.APP_NAME_CHAT);
            if (StringUtil.isEmptyOrNull((String)webServer)) {
                webServer = ZMWebUtil.getWebDomainWithHttps();
            }
            url = webServer + "/teleconference";
        }
        UIUtil.openURL((Context)activity, (String)url);
    }

    protected void onClickPickCountryOrRegion() {
        ConfSelectCallInCountryFragment.showAsActivity((Fragment)this, 100);
    }

    public void dismiss() {
        if (this.getShowsTip()) {
            super.dismiss();
        } else {
            this.getActivity().finish();
        }
    }

    private boolean isTipVisible() {
        ZMTip tip = this.getTip();
        if (tip != null) {
            return tip.getVisibility() == 0;
        }
        return false;
    }

    private void setTipVisible(boolean visible) {
        ZMTip tip = this.getTip();
        if (tip != null && tip.getVisibility() == 0 != visible) {
            tip.setVisibility(visible ? 0 : 4);
            if (visible) {
                Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.zm_tip_fadein);
                tip.startAnimation(fadeIn);
            }
        }
    }

    public static class PhoneCallConfirmDialog
    extends ZMDialogFragment {
        private static final String TAG = PhoneCallConfirmDialog.class.getSimpleName();
        private static final String ARG_NUMBER = "number";
        private static final String ARG_DIAL_STRING = "dialString";
        private String mDailString;

        public static void showPhoneCallConfirmDialog(ZMActivity activity, @NonNull String number, @NonNull String dialString) {
            PhoneCallConfirmDialog dlg = new PhoneCallConfirmDialog();
            Bundle args = new Bundle();
            args.putString(ARG_NUMBER, number);
            args.putString(ARG_DIAL_STRING, dialString);
            dlg.setArguments(args);
            dlg.show(activity.getSupportFragmentManager(), PhoneCallConfirmDialog.class.getName());
        }

        public PhoneCallConfirmDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            ZMAlertDialog alertDialog;
            Button btn;
            super.onStart();
            Dialog dlg = this.getDialog();
            if (dlg != null && (btn = (alertDialog = (ZMAlertDialog)dlg).getButton(-1)) != null) {
                btn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PhoneCallConfirmDialog.this.doCallNumber(PhoneCallConfirmDialog.this.mDailString);
                    }
                });
            }
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            String dialString;
            Bundle args = this.getArguments();
            String number = args.getString(ARG_NUMBER);
            this.mDailString = dialString = args.getString(ARG_DIAL_STRING);
            String message = this.getString(R.string.zm_alert_dial_into_meeting);
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(number).setMessage(message).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_call, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }

        protected void doCallNumber(String dialString) {
            if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.CALL_PHONE") != 0) {
                this.zm_requestPermissions(new String[]{"android.permission.CALL_PHONE"}, 0);
            } else {
                this.callNumber(dialString);
            }
        }

        public void onRequestPermissionsResult(final int requestCode, final @NonNull String[] permissions, final @NonNull int[] grantResults) {
            this.getNonNullEventTaskManagerOrThrowException().pushLater("CallinPermissionResult", new EventAction("CallinPermissionResult"){

                public void run(IUIElement ui) {
                    if (ui == null) {
                        return;
                    }
                    ((PhoneCallConfirmDialog)ui).handlePermissionResult(requestCode, permissions, grantResults);
                }
            });
        }

        public void handlePermissionResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            if (permissions == null || grantResults == null) {
                return;
            }
            for (int i = 0; i < permissions.length; ++i) {
                if (!"android.permission.CALL_PHONE".equals(permissions[i]) || grantResults[i] != 0) continue;
                this.callNumber(this.mDailString);
            }
        }

        public void callNumber(String dialString) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Uri uri = null;
            if (Build.MANUFACTURER != null && Build.MANUFACTURER.toLowerCase().contains("moto")) {
                dialString = dialString.replaceAll("#", URLEncoder.encode("#").replaceAll(",", URLEncoder.encode(",")));
                uri = Uri.parse((String)("tel:" + dialString));
            } else {
                uri = Uri.parse((String)("tel:" + URLEncoder.encode(dialString)));
            }
            Intent intent = new Intent("android.intent.action.CALL", uri);
            try {
                activity.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dismiss();
        }
    }
}

