/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.fragment.SelectCountryCodeFragment;
import com.zipow.videobox.ptapp.CountryCode;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class CallMeByPhoneFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final int UPDATE_STATUS_DELAY_MILLIS = 1000;
    private static final int REQUEST_SELECT_COUTRY_CODE = 100;
    private Button mBtnCall = null;
    private Button mBtnHangup = null;
    private EditText mEdtNumber = null;
    private View mBtnSelectCountryCode = null;
    private TextView mTxtCountryCode;
    private TextView mTxtMessage = null;
    private SelectCountryCodeFragment.CountryCodeItem mSelectedCountryCode;
    private ConfUI.IConfUIListener mConfUIListener;
    private Handler mHandler = new Handler();
    private ArrayList<SelectCountryCodeFragment.CountryCodeItem> mSupportCountryCodes;
    private boolean mIsInitCallStatus = true;

    public static void showAsActivity(ZMActivity activity, int resquestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, CallMeByPhoneFragment.class.getName(), args, resquestCode, true, 2);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_callme_by_phone, container, false);
        this.mBtnCall = (Button)view.findViewById(R.id.btnCall);
        this.mBtnHangup = (Button)view.findViewById(R.id.btnHangup);
        this.mEdtNumber = (EditText)view.findViewById(R.id.edtNumber);
        this.mBtnSelectCountryCode = view.findViewById(R.id.btnSelectCountryCode);
        this.mTxtCountryCode = (TextView)view.findViewById(R.id.txtCountryCode);
        this.mTxtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mBtnCall.setOnClickListener((View.OnClickListener)this);
        this.mBtnHangup.setOnClickListener((View.OnClickListener)this);
        this.mBtnSelectCountryCode.setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.installNumberChangeListener();
        if (savedInstanceState == null) {
            this.loadDefaultNumber();
        } else {
            this.mSelectedCountryCode = (SelectCountryCodeFragment.CountryCodeItem)savedInstanceState.get("mSelectedCountryCode");
            this.mIsInitCallStatus = savedInstanceState.getBoolean("mIsInitCallStatus");
            this.updateSelectedCountry();
        }
        this.updateCallButton();
        this.mSupportCountryCodes = this.getSupportCountryCodes();
        return view;
    }

    private ArrayList<SelectCountryCodeFragment.CountryCodeItem> getSupportCountryCodes() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return null;
        }
        MeetingInfo meetingItem = confContext.getMeetingItem();
        if (meetingItem == null) {
            return null;
        }
        ArrayList<CountryCode> codes = meetingItem.getCalloutCountryCodesList();
        ArrayList<SelectCountryCodeFragment.CountryCodeItem> calloutCodes = null;
        if (codes != null && codes.size() > 0) {
            calloutCodes = new ArrayList<SelectCountryCodeFragment.CountryCodeItem>();
            for (CountryCode code : codes) {
                String strCode = code.getCode();
                if (strCode.startsWith("+")) {
                    strCode = strCode.substring(1);
                }
                calloutCodes.add(new SelectCountryCodeFragment.CountryCodeItem(strCode, code.getId(), code.getName()));
            }
        }
        return calloutCodes;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mSelectedCountryCode", (Serializable)this.mSelectedCountryCode);
        outState.putBoolean("mIsInitCallStatus", this.mIsInitCallStatus);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        SelectCountryCodeFragment.CountryCodeItem item;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null && (item = (SelectCountryCodeFragment.CountryCodeItem)data.getSerializableExtra("countryCode")) != null) {
            this.mSelectedCountryCode = item;
            this.updateSelectedCountry();
        }
    }

    private void updateSelectedCountry() {
        if (this.mSelectedCountryCode == null) {
            return;
        }
        this.mTxtCountryCode.setText((CharSequence)(this.mSelectedCountryCode.countryName + "(+" + this.mSelectedCountryCode.countryCode + ")"));
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onPause() {
        super.onPause();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    return CallMeByPhoneFragment.this.onConfStatusChanged2(cmd, ret);
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null) {
            this.updateUIForCallOutStatus(confStatus.getCallMeStatus());
        }
        this.updateUIForSupportCalloutType();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void updateCallButton() {
        String countryCode = this.getSelectedCountryCode();
        String number = this.getPhoneNumber();
        boolean enabled = !StringUtil.isEmptyOrNull((String)countryCode) && !StringUtil.isEmptyOrNull((String)number);
        this.mBtnCall.setEnabled(enabled);
    }

    private void installNumberChangeListener() {
        this.mEdtNumber.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                CallMeByPhoneFragment.this.updateCallButton();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
    }

    private void loadDefaultNumber() {
        String phoneNumber;
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mSelectedCountryCode = SelectCountryCodeFragment.CountryCodeItem.readFromPreference("callme.select_country");
        if (this.mSelectedCountryCode == null || StringUtil.isEmptyOrNull((String)this.mSelectedCountryCode.isoCountryCode)) {
            String isoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)activity);
            if (isoCountryCode == null) {
                return;
            }
            String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountryCode);
            Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
            String countryName = locale.getDisplayCountry();
            this.mSelectedCountryCode = new SelectCountryCodeFragment.CountryCodeItem(phoneCountryCode, isoCountryCode, countryName);
        }
        if ((phoneNumber = PreferenceUtil.readStringValue("callme.phone_number", "")) != null) {
            this.mEdtNumber.setText((CharSequence)phoneNumber);
        }
        this.updateSelectedCountry();
    }

    private void onCallOutStatusChanged(int status) {
        this.updateUIForCallOutStatus(status);
    }

    private boolean onConfStatusChanged2(int cmd, long ret) {
        if (cmd == 94) {
            this.onCallOutStatusChanged((int)ret);
        }
        return true;
    }

    private void updateUIForCallOutStatus(int status) {
        if (status != 0) {
            this.mIsInitCallStatus = false;
        }
        switch (status) {
            case 0: {
                if (!this.mIsInitCallStatus) break;
                this.mTxtMessage.setText(R.string.zm_callout_msg_callme_indication);
                break;
            }
            case 1: {
                this.mTxtMessage.setText((CharSequence)this.getString(R.string.zm_callout_msg_calling, new Object[]{this.getCallingNumber()}));
                break;
            }
            case 2: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_ringing);
                break;
            }
            case 3: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_call_accepted);
                break;
            }
            case 4: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_busy);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 5: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_not_available);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 6: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_user_hangup);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 7: 
            case 9: {
                this.mTxtMessage.setText((CharSequence)this.getString(R.string.zm_callout_msg_fail_to_call, new Object[]{this.getCallingNumber()}));
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 8: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_success);
                this.dismissDelayed(1000L);
                break;
            }
            case 10: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_cancel_call);
                break;
            }
            case 12: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_cancel_call_fail);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 11: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_call_canceled);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 14: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_block_no_host);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 15: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_block_high_rate);
                this.updateCallStatusDelayed(1000L);
                break;
            }
            case 16: {
                this.mTxtMessage.setText(R.string.zm_callout_msg_block_too_frequent);
                this.updateCallStatusDelayed(1000L);
            }
        }
        this.updateButtonsForCallOutStatus(status);
    }

    private void updateButtonsForCallOutStatus(int status) {
        switch (status) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                this.mBtnCall.setVisibility(0);
                this.mBtnHangup.setVisibility(8);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                this.mBtnCall.setVisibility(8);
                this.mBtnHangup.setVisibility(0);
                this.mBtnHangup.setEnabled(true);
                break;
            }
            case 10: {
                this.mBtnCall.setVisibility(8);
                this.mBtnHangup.setVisibility(0);
                this.mBtnHangup.setEnabled(false);
            }
        }
    }

    private void updateCallStatusDelayed(long delayMillis) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
                if (confStatus != null) {
                    CallMeByPhoneFragment.this.updateUIForCallOutStatus(confStatus.getCallMeStatus());
                }
            }
        }, delayMillis);
    }

    private void dismissDelayed(long delayMillis) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CallMeByPhoneFragment.this.dismiss();
            }
        }, delayMillis);
    }

    private void updateUIForSupportCalloutType() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        MeetingInfo meetingItem = confContext.getMeetingItem();
        if (meetingItem == null) {
            return;
        }
        int supportCallOutType = meetingItem.getSupportCallOutType();
        if (1 == supportCallOutType) {
            this.mBtnSelectCountryCode.setEnabled(false);
            this.mSelectedCountryCode = new SelectCountryCodeFragment.CountryCodeItem("1", "US", Locale.US.getDisplayCountry());
            this.updateSelectedCountry();
        } else {
            this.mBtnSelectCountryCode.setEnabled(true);
            if (this.mSupportCountryCodes != null && this.mSupportCountryCodes.size() > 0) {
                boolean find = false;
                if (this.mSelectedCountryCode != null && this.mSelectedCountryCode.countryCode != null) {
                    for (SelectCountryCodeFragment.CountryCodeItem item : this.mSupportCountryCodes) {
                        if (!this.mSelectedCountryCode.isoCountryCode.equalsIgnoreCase(item.isoCountryCode)) continue;
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    this.mSelectedCountryCode = SelectCountryCodeFragment.CountryCodeItem.from(this.mSupportCountryCodes.get(0));
                    PreferenceUtil.saveStringValue("callme.select_country", null);
                    PreferenceUtil.saveStringValue("callme.phone_number", null);
                    this.mEdtNumber.setText((CharSequence)"");
                }
            }
            this.updateSelectedCountry();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnCall) {
            this.onClickBtnCall();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSelectCountryCode) {
            this.onClickBtnSelectCountryCode();
        } else if (id2 == R.id.btnHangup) {
            this.onClickBtnHangup();
        }
    }

    private void onClickBtnSelectCountryCode() {
        SelectCountryCodeFragment.showAsActivity((Fragment)this, this.mSupportCountryCodes, true, 100);
    }

    private void onClickBtnCall() {
        String number;
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (StringUtil.isEmptyOrNull((String)(number = this.getFullPhoneNumber()))) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null) {
            confStatus.startCallOut(number);
        }
        this.saveDataAsDefault();
    }

    private void saveDataAsDefault() {
        if (this.mSelectedCountryCode != null) {
            this.mSelectedCountryCode.savePreference("callme.select_country");
        }
        PreferenceUtil.saveStringValue("callme.phone_number", this.getPhoneNumber());
    }

    private void onClickBtnHangup() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null) {
            confStatus.hangUp();
        }
    }

    private String getSelectedCountryCode() {
        if (this.mSelectedCountryCode == null) {
            return null;
        }
        return this.mSelectedCountryCode.countryCode;
    }

    private String getPhoneNumber() {
        String phoneNumber = this.mEdtNumber.getText().toString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (c == '+' && builder.length() == 0) {
                builder.append(c);
                continue;
            }
            if (c == ',' || c == ';') break;
        }
        return builder.toString();
    }

    private String getFullPhoneNumber() {
        return "+" + this.getSelectedCountryCode() + this.getPhoneNumber();
    }

    private String getCallingNumber() {
        return this.getFullPhoneNumber();
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }
}

