/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.File;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class AvatarPreviewFragment
extends ZMDialogFragment
implements View.OnClickListener,
SimpleActivity.ExtListener {
    private static final String ARG_CONTACT = "contact";
    private static final String ARG_AVATAR_BY_CONTACT = "avatarIsFromContact";
    private IMAddrBookItem mContact = null;
    private boolean mAvatarFromContact = false;
    private ImageView mImageView;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;

    public static void showContactAvatar(Fragment fragment, IMAddrBookItem contact) {
        if (fragment == null || contact == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putSerializable(ARG_CONTACT, (Serializable)contact);
        args.putBoolean(ARG_AVATAR_BY_CONTACT, true);
        SimpleActivity.show(fragment, AvatarPreviewFragment.class.getName(), args, 0);
        ZMActivity activity = (ZMActivity)fragment.getActivity();
        if (activity == null) {
            return;
        }
        activity.overridePendingTransition(0, 0);
    }

    public static void showMyAvatar(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putBoolean(ARG_AVATAR_BY_CONTACT, false);
        SimpleActivity.show(fragment, AvatarPreviewFragment.class.getName(), args, 0);
        ZMActivity activity = (ZMActivity)fragment.getActivity();
        if (activity == null) {
            return;
        }
        activity.overridePendingTransition(0, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_avatar_original, container, false);
        if (view == null) {
            return null;
        }
        view.setOnClickListener((View.OnClickListener)this);
        this.mImageView = (ImageView)view.findViewById(R.id.imgAvator);
        if (this.mImageView == null) {
            return null;
        }
        Bundle args = this.getArguments();
        if (args != null) {
            this.mAvatarFromContact = args.getBoolean(ARG_AVATAR_BY_CONTACT);
            if (this.mAvatarFromContact) {
                this.mContact = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
            }
        }
        return view;
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void onIndicateInfoUpdatedWithJID(String jid) {
                    AvatarPreviewFragment.this.onIndicateInfoUpdatedWithJID(jid);
                }

                @Override
                public void onIndicate_BuddyBigPictureDownloaded(String jid, int result) {
                    AvatarPreviewFragment.this.onIndicateBuddyBigPicUpdated(jid);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.updateUI();
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        if (this.mAvatarFromContact && this.mContact != null && StringUtil.isSameString((String)jid, (String)this.mContact.getJid())) {
            this.updateUI();
        }
    }

    private void onIndicateBuddyBigPicUpdated(String jid) {
        if (this.mAvatarFromContact && this.mContact != null && StringUtil.isSameString((String)jid, (String)this.mContact.getJid())) {
            this.updateUI();
        }
    }

    private void updateUI() {
        Bitmap bitmap = null;
        if (this.mAvatarFromContact) {
            bitmap = this.getAvatarBitmapFromContact();
        } else {
            String avatar = null;
            PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
            if (profile != null) {
                avatar = profile.getPictureLocalPath();
            }
            bitmap = ZMBitmapFactory.decodeFile(avatar);
        }
        if (bitmap != null) {
            this.mImageView.setImageBitmap(bitmap);
        }
    }

    private Bitmap getAvatarBitmapFromContact() {
        FragmentActivity context;
        if (this.mContact == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            String avatar = null;
            String jid = this.mContact.getJid();
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy != null) {
                avatar = buddy.getLocalBigPicturePath();
            }
            if (ImageUtil.isValidImageFile(avatar)) {
                Bitmap bitmap = ZMBitmapFactory.decodeFile(avatar);
                if (bitmap != null) {
                    return bitmap;
                }
            } else {
                Bitmap bitmap;
                File file;
                if (!StringUtil.isEmptyOrNull((String)avatar) && (file = new File(avatar)).exists()) {
                    file.delete();
                }
                if (buddy != null) {
                    avatar = buddy.getLocalPicturePath();
                }
                if (ImageUtil.isValidImageFile(avatar) && (bitmap = ZMBitmapFactory.decodeFile(avatar)) != null) {
                    return bitmap;
                }
            }
        }
        if ((context = this.getActivity()) != null) {
            Bitmap bitmap = this.mContact.getAvatarBitmap((Context)context);
            return bitmap;
        }
        return null;
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
    }

    @Override
    public void onKeyboardClosed() {
    }

    @Override
    public boolean onBackPressed() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
            activity.overridePendingTransition(0, 0);
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(false);
    }
}

