/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import java.lang.ref.WeakReference;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.videomeetings.R;

public class AddrBookVerifyNumberFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPhoneABListener {
    private final String TAG = AddrBookVerifyNumberFragment.class.getSimpleName();
    private static final String ARG_COUNTRY_CODE = "countryCode";
    private static final String ARG_PHONE_NUMBER = "phoneNumber";
    private Button mBtnNext = null;
    private Button mBtnBack = null;
    private TextView mTxtNumber = null;
    private EditText mEdtCode = null;
    private Button mBtnResend;
    private String mCountryCode;
    private String mPhoneNumber;
    private MyHandler mHandler = new MyHandler(this);

    public static void showInActivity(ZMActivity activity, String countryCode, String number) {
        AddrBookVerifyNumberFragment f = new AddrBookVerifyNumberFragment();
        Bundle args = new Bundle();
        args.putString(ARG_COUNTRY_CODE, countryCode);
        args.putString(ARG_PHONE_NUMBER, number);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, AddrBookVerifyNumberFragment.class.getName()).commit();
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_addrbook_verify_number, container, false);
        this.mBtnNext = (Button)view.findViewById(R.id.btnNext);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mTxtNumber = (TextView)view.findViewById(R.id.txtNumber);
        this.mEdtCode = (EditText)view.findViewById(R.id.edtCode);
        this.mBtnResend = (Button)view.findViewById(R.id.btnResend);
        this.mBtnNext.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnResend.setOnClickListener((View.OnClickListener)this);
        this.installVerificationCodeChangeListener();
        this.initViewData();
        this.updateNextButton();
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        PTUI.getInstance().addPhoneABListener(this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mCountryCode = args.getString(ARG_COUNTRY_CODE);
            this.mPhoneNumber = args.getString(ARG_PHONE_NUMBER);
        }
    }

    public void onResume() {
        super.onResume();
        this.updateSmsSeconds();
    }

    public void onDestroy() {
        super.onDestroy();
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity.isFinishing() || this.isRemoving()) {
            PTUI.getInstance().removePhoneABListener(this);
        }
    }

    private void initViewData() {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        String countryCode = args.getString(ARG_COUNTRY_CODE);
        String number = args.getString(ARG_PHONE_NUMBER);
        if (countryCode == null || number == null) {
            return;
        }
        if (number.startsWith("+" + countryCode)) {
            number = number.substring(countryCode.length() + 1);
        }
        String textNumber = "+" + countryCode + " " + number;
        this.mTxtNumber.setText((CharSequence)textNumber);
    }

    private void installVerificationCodeChangeListener() {
        this.mEdtCode.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                AddrBookVerifyNumberFragment.this.updateNextButton();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
    }

    private void updateNextButton() {
        String code = this.mEdtCode.getText().toString();
        boolean enabled = code.length() >= 6;
        this.mBtnNext.setEnabled(enabled);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnNext) {
            this.onClickBtnNext();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnResend) {
            this.onClickBtnResend();
        }
    }

    private void onClickBtnResend() {
        String formatedNumber;
        if (ABContactsHelper.getRemainSMSTimeInSecond(this.mPhoneNumber, this.mCountryCode) > 0) {
            return;
        }
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return;
        }
        String phoneNumber = this.mPhoneNumber;
        if (phoneNumber.startsWith("+")) {
            formatedNumber = this.mPhoneNumber;
        } else if (phoneNumber.startsWith("0")) {
            phoneNumber = phoneNumber.substring(1);
            formatedNumber = "+" + this.mCountryCode + phoneNumber;
        } else {
            formatedNumber = "+" + this.mCountryCode + phoneNumber;
        }
        int ret = contactsHelper.registerPhoneNumber(formatedNumber, this.mCountryCode, SystemInfoHelper.getDeviceId());
        if (0 == ret) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting);
            dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        } else {
            this.showErrorDialog(ret);
        }
    }

    private void onClickBtnNext() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)activity, (View)this.getView());
        }
        String countryCode = null;
        String number = null;
        Bundle args = this.getArguments();
        if (args != null) {
            countryCode = args.getString(ARG_COUNTRY_CODE);
            number = args.getString(ARG_PHONE_NUMBER);
        }
        if (StringUtil.isEmptyOrNull(countryCode) || StringUtil.isEmptyOrNull(number)) {
            return;
        }
        number = String.format(CompatUtils.getLocalDefault(), "+%s%s", countryCode, number);
        String verifyCode = this.mEdtCode.getText().toString();
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return;
        }
        int ret = contactsHelper.verifyPhoneNumber(number, SystemInfoHelper.getDeviceId(), verifyCode);
        if (0 == ret) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting);
            dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        } else {
            this.showErrorDialog(ret);
        }
    }

    private void onClickBtnBack() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (this.getShowsDialog()) {
            this.dismiss();
        } else if (activity != null) {
            activity.setResult(0);
            activity.finish();
        }
    }

    @Override
    public void onPhoneABEvent(final int event, final long result, final Object content) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handlePhoneABEvent"){

            public void run(IUIElement ui) {
                ((AddrBookVerifyNumberFragment)ui).handlePhoneABEvent(event, result, content);
            }
        });
    }

    private void handlePhoneABEvent(int event, long result, Object content) {
        switch (event) {
            case 0: {
                this.onPhoneRegisterComplete(result, content);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.onPhoneNumberVerifyComplete(result);
                break;
            }
        }
    }

    private void updateSmsSeconds() {
        this.mHandler.removeMessages(1);
        int seconds = ABContactsHelper.getRemainSMSTimeInSecond(this.mPhoneNumber, this.mCountryCode);
        if (seconds > 0) {
            this.mBtnResend.setText((CharSequence)this.getString(R.string.zm_lbl_seconds_33300, new Object[]{seconds}));
            this.mHandler.sendEmptyMessageDelayed(1, 1000L);
        } else {
            this.mBtnResend.setText(R.string.zm_btn_resend_code_33300);
        }
    }

    private void onPhoneRegisterComplete(long result, Object content) {
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        switch ((int)result) {
            case 0: {
                byte[] protoData = (byte[])content;
                PTAppProtos.PhoneRegisterResponse response = null;
                if (protoData != null) {
                    try {
                        response = PTAppProtos.PhoneRegisterResponse.parseFrom(protoData);
                    }
                    catch (InvalidProtocolBufferException e) {
                        return;
                    }
                }
                if (response == null) {
                    this.showErrorDialog((int)result);
                    break;
                }
                this.updateSmsSeconds();
                break;
            }
            default: {
                this.showErrorDialog((int)result);
            }
        }
    }

    private void onPhoneNumberVerifyComplete(long result) {
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        switch ((int)result) {
            case 0: {
                this.onPhoneNumberVerifyOK();
                break;
            }
            default: {
                this.showErrorDialog((int)result);
            }
        }
    }

    private void onPhoneNumberVerifyOK() {
        FragmentActivity activity = this.getActivity();
        if (this.getShowsDialog()) {
            this.dismiss();
        } else if (activity != null) {
            String countryCode = null;
            String number = null;
            Bundle args = this.getArguments();
            if (args != null) {
                countryCode = args.getString(ARG_COUNTRY_CODE);
                number = args.getString(ARG_PHONE_NUMBER);
            }
            if (StringUtil.isEmptyOrNull(countryCode) || StringUtil.isEmptyOrNull(number)) {
                return;
            }
            number = String.format(CompatUtils.getLocalDefault(), "+%s%s", countryCode, number);
            Intent intent = new Intent();
            intent.putExtra(ARG_COUNTRY_CODE, countryCode);
            intent.putExtra("number", number);
            activity.setResult(-1, intent);
            activity.finish();
        }
    }

    private void showErrorDialog(int errorCode) {
        int msg = R.string.zm_msg_verify_phone_number_failed;
        if (errorCode == 406) {
            msg = R.string.zm_alert_phone_bypass_40122;
        }
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(msg);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    static class MyHandler
    extends Handler {
        static final int MSG_UPDATE_SMS_SECONDS = 1;
        WeakReference<AddrBookVerifyNumberFragment> mWeakReference;

        MyHandler(AddrBookVerifyNumberFragment fragment) {
            this.mWeakReference = new WeakReference<AddrBookVerifyNumberFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AddrBookVerifyNumberFragment fragment;
                    if (this.mWeakReference == null || (fragment = (AddrBookVerifyNumberFragment)this.mWeakReference.get()) == null || !fragment.isAdded()) break;
                    fragment.updateSmsSeconds();
                }
            }
        }
    }
}

