/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.AddFavoriteActivity;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AddFavoriteItem;
import com.zipow.videobox.view.AddFavoriteListView;
import com.zipow.videobox.view.AvatarView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMHorizontalListView;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class AddFavoriteFragment
extends ZMTipFragment
implements View.OnClickListener,
AddFavoriteListView.Listener,
PTUI.IFavoriteListener,
ZMKeyboardDetector.KeyboardListener,
TextView.OnEditorActionListener {
    private static final String TAG = AddFavoriteFragment.class.getSimpleName();
    public static final String ARG_ANCHOR_ID = "anchorId";
    private AddFavoriteListView mListView;
    private EditText mEdtSearch;
    private ZMHorizontalListView mListSelected;
    private SelectedListAdapter mSelectedListAdapter;
    private Button mBtnInvite;
    private Button mBtnClearSearchView;
    private Button mBtnSearch;
    private Button mBtnConfigAccount;
    private View mPanelLoading;
    private View mPanelConfigAccount;
    private View mPanelSearch;
    private View mPanelFailureMsg;
    private int mAnchorId = 0;
    private boolean mIsSearching = false;
    private boolean mIsGettingDomainUser = false;
    private boolean mFailedToGetDomainUser = false;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            AddFavoriteFragment.this.mListView.filter(AddFavoriteFragment.this.mEdtSearch.getText().toString());
        }
    };

    public static void show(FragmentManager fm, int anchorId, long meetingNumber, String meetingId) {
        AddFavoriteFragment f = AddFavoriteFragment.getInviteFragment(fm);
        if (f == null) {
            f = new AddFavoriteFragment();
            Bundle args = new Bundle();
            args.putInt(ARG_ANCHOR_ID, anchorId);
            f.setArguments(args);
            f.show(fm, AddFavoriteFragment.class.getName());
        } else {
            f.setTipVisible(true);
        }
    }

    public static AddFavoriteFragment getInviteFragment(FragmentManager fm) {
        return (AddFavoriteFragment)fm.findFragmentByTag(AddFavoriteFragment.class.getName());
    }

    public static boolean hide(FragmentManager fm) {
        AddFavoriteFragment f = AddFavoriteFragment.getInviteFragment(fm);
        if (f != null) {
            if (!f.getShowsTip()) {
                f.dismiss();
                return true;
            }
            if (f.isTipVisible()) {
                f.setTipVisible(false);
                return true;
            }
        }
        return false;
    }

    public static boolean dismiss(FragmentManager fm) {
        AddFavoriteFragment f = AddFavoriteFragment.getInviteFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onDestroy() {
        this.mHandler.removeCallbacks(this.mRunnableFilter);
        super.onDestroy();
    }

    public void onResume() {
        super.onResume();
        this.mListView.setFilter(this.mEdtSearch.getText().toString());
        this.updateBtnClearSearchView();
        PTUI.getInstance().addFavoriteListener(this);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeFavoriteListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isTipVisible", this.isTipVisible());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = null;
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            view = inflater.inflate(R.layout.zm_add_favorite, null);
        } else {
            view = inflater.inflate(R.layout.zm_add_favorite_main_screen, null);
            ZMKeyboardDetector keyboardDetector = (ZMKeyboardDetector)view.findViewById(R.id.keyboardDetector);
            keyboardDetector.setKeyboardListener((ZMKeyboardDetector.KeyboardListener)this);
        }
        this.mListView = (AddFavoriteListView)view.findViewById(R.id.buddyListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mListSelected = (ZMHorizontalListView)view.findViewById(R.id.listSelected);
        this.mBtnInvite = (Button)view.findViewById(R.id.btnInvite);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mBtnSearch = (Button)view.findViewById(R.id.btnSearch);
        this.mBtnConfigAccount = (Button)view.findViewById(R.id.btnConfigAccount);
        this.mPanelLoading = view.findViewById(R.id.panelLoading);
        this.mPanelConfigAccount = view.findViewById(R.id.panelConfigAccount);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        this.mPanelFailureMsg = view.findViewById(R.id.panelFailureMsg);
        Button btnBack = (Button)view.findViewById(R.id.btnBack);
        this.mSelectedListAdapter = new SelectedListAdapter((Context)this.getActivity());
        this.mListSelected.setAdapter((ListAdapter)this.mSelectedListAdapter);
        this.mListSelected.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                AddFavoriteItem item = (AddFavoriteItem)AddFavoriteFragment.this.mSelectedListAdapter.getItem(position);
                AddFavoriteFragment.this.mListView.unselectBuddy(item);
            }
        });
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mBtnSearch.setOnClickListener((View.OnClickListener)this);
        this.mBtnConfigAccount.setOnClickListener((View.OnClickListener)this);
        btnBack.setOnClickListener((View.OnClickListener)this);
        this.mListView.setListener(this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                AddFavoriteFragment.this.mHandler.removeCallbacks(AddFavoriteFragment.this.mRunnableFilter);
                AddFavoriteFragment.this.mHandler.postDelayed(AddFavoriteFragment.this.mRunnableFilter, 300L);
                AddFavoriteFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        PTUI.getInstance().addFavoriteListener(this);
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
            if (favMgr != null) {
                favMgr.getAllDomainUser();
                this.mIsGettingDomainUser = true;
            }
        } else {
            this.mListView.reloadAllBuddyItems();
        }
        int cntSelected = this.updateSelectedList();
        this.updateButtonInvite(cntSelected);
        this.updateSearchField();
        this.updateLoadingPanel();
        this.updateConfigAccountPanel();
        this.updateFailureMsgPanel();
        return view;
    }

    private void updateLoadingPanel() {
        if (this.mFailedToGetDomainUser) {
            this.mPanelLoading.setVisibility(8);
            return;
        }
        this.mPanelLoading.setVisibility(this.mIsSearching || this.mIsGettingDomainUser ? 0 : 8);
    }

    private void updateConfigAccountPanel() {
        if (this.mFailedToGetDomainUser) {
            this.mPanelConfigAccount.setVisibility(8);
            this.mPanelSearch.setVisibility(8);
            this.mBtnInvite.setVisibility(4);
            return;
        }
        FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
        if (favMgr == null) {
            return;
        }
        int count = favMgr.getDomainUserCount();
        if (count == 1 && !this.mIsGettingDomainUser) {
            this.mPanelConfigAccount.setVisibility(0);
            this.mPanelSearch.setVisibility(8);
            this.mBtnInvite.setVisibility(4);
        } else {
            this.mPanelConfigAccount.setVisibility(8);
            if (!this.mIsGettingDomainUser) {
                this.mPanelSearch.setVisibility(0);
                this.mBtnInvite.setVisibility(0);
            } else {
                this.mPanelSearch.setVisibility(8);
                this.mBtnInvite.setVisibility(4);
            }
        }
    }

    private void updateFailureMsgPanel() {
        this.mPanelFailureMsg.setVisibility(this.mFailedToGetDomainUser ? 0 : 8);
    }

    private void updateSearchField() {
        if (this.needSearchDomain()) {
            this.mEdtSearch.setHint(R.string.zm_hint_add_favorite_email_address);
            this.mEdtSearch.setImeOptions(3);
            this.mBtnSearch.setVisibility(8);
        } else {
            this.mEdtSearch.setHint(R.string.zm_hint_search);
            this.mEdtSearch.setImeOptions(6);
            this.mBtnSearch.setVisibility(8);
        }
    }

    private boolean needSearchDomain() {
        FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
        if (favMgr != null) {
            int domainUserCount = favMgr.getDomainUserCount();
            return domainUserCount > 200;
        }
        return false;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = this.getView();
        if (view == null) {
            return null;
        }
        int width = UIUtil.dip2px((Context)context, (float)400.0f);
        if (UIUtil.getDisplayWidth((Context)context) < width) {
            width = UIUtil.getDisplayWidth((Context)context);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        ZMTip tip = new ZMTip(context);
        tip.setArrowSize(UIUtil.dip2px((Context)context, (float)30.0f), UIUtil.dip2px((Context)context, (float)11.0f));
        tip.setCornerArcSize(0);
        tip.addView(view);
        Bundle args = this.getArguments();
        this.mAnchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (this.mAnchorId > 0 && (anchor = this.getActivity().findViewById(this.mAnchorId)) != null) {
            tip.setAnchor(anchor, 1);
        }
        if (savedInstanceState != null) {
            boolean visible = savedInstanceState.getBoolean("isTipVisible", true);
            tip.setVisibility(visible ? 0 : 4);
        }
        return tip;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnSearch) {
            this.onClickBtnSearch();
        } else if (id2 == R.id.btnConfigAccount) {
            this.onClickBtnConfigAccount();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            if (actionId == 3) {
                this.onClickBtnSearch();
            } else {
                UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnSearch);
            }
            return true;
        }
        return false;
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        if (this.getShowsTip()) {
            this.setTipVisible(false);
        } else {
            this.dismiss();
        }
    }

    private void onClickBtnInvite() {
        List<AddFavoriteItem> items = this.mListView.getSelectedBuddies();
        if (items == null || items.size() == 0) {
            this.onClickBtnBack();
            return;
        }
        FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
        if (favMgr == null) {
            return;
        }
        ArrayList<ZoomContact> contacts = new ArrayList<ZoomContact>();
        for (AddFavoriteItem item : items) {
            contacts.add(item.getZoomContact());
        }
        boolean ret = favMgr.addFavorite(contacts);
        if (!ret) {
            this.onSentInvitationFailed();
        } else {
            this.onSentInvitationDone(items);
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickBtnSearch() {
        if (this.needSearchDomain()) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            this.startSearchDomain();
        }
    }

    private void onClickBtnConfigAccount() {
        PTApp.getInstance().navWebWithDefaultBrowser(8, null);
    }

    private void startSearchDomain() {
        String keyword = this.mEdtSearch.getText().toString();
        if (StringUtil.isEmptyOrNull((String)keyword)) {
            return;
        }
        FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
        if (favMgr == null) {
            return;
        }
        if (!favMgr.searchDomainUser(keyword)) {
            return;
        }
        this.mBtnSearch.setEnabled(false);
        this.mIsSearching = true;
        this.updateLoadingPanel();
    }

    private void endSearchDomain() {
        this.mBtnSearch.setEnabled(true);
        this.mIsSearching = false;
        this.updateLoadingPanel();
    }

    private void onSentInvitationFailed() {
        new InviteFailedDialog().show(this.getFragmentManager(), InviteFailedDialog.class.getName());
    }

    private void onSentInvitationDone(List<AddFavoriteItem> items) {
        if (this.getShowsTip()) {
            this.setTipVisible(false);
        } else {
            ((AddFavoriteActivity)this.getActivity()).onSentInvitationDone(items.size());
        }
    }

    private void clearSelection() {
        this.mListView.clearSelection();
    }

    @Override
    public void onSelectionChanged() {
        int cntSelected = this.updateSelectedList();
        this.updateButtonInvite(cntSelected);
    }

    private void updateButtonInvite(int cntSelected) {
        if (cntSelected <= 0) {
            this.mBtnInvite.setText((CharSequence)this.getResources().getString(R.string.zm_btn_done));
            this.mBtnInvite.setEnabled(false);
        } else {
            this.mBtnInvite.setText((CharSequence)(this.getResources().getString(R.string.zm_btn_done) + "(" + cntSelected + ")"));
            this.mBtnInvite.setEnabled(true);
        }
    }

    private int updateSelectedList() {
        List<AddFavoriteItem> items = this.mListView.getSelectedBuddies();
        this.mListSelected.setVisibility(items.size() > 0 ? 0 : 8);
        this.mSelectedListAdapter.update(items);
        return items.size();
    }

    public void onKeyboardOpen() {
        this.mEdtSearch.setCursorVisible(true);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
    }

    public void onKeyboardClosed() {
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
    }

    @Override
    public void onFavoriteEvent(int event, long result) {
        switch (event) {
            case 0: {
                this.mListView.reloadAllBuddyItems();
                this.mIsGettingDomainUser = false;
                this.mFailedToGetDomainUser = result != 0L;
            }
        }
        this.updateLoadingPanel();
        this.updateConfigAccountPanel();
        this.updateSearchField();
        this.updateFailureMsgPanel();
    }

    @Override
    public void onFavAvatarReady(String userId) {
        this.mListView.updateZoomContact(userId);
    }

    @Override
    public void onFinishSearchDomainUser(String requestID, int result, int contactCount, List<ZoomContact> contacts) {
        this.mListView.loadZoomContactsFromList(contacts);
        this.endSearchDomain();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        if (this.getShowsTip()) {
            super.dismiss();
        } else {
            this.getActivity().finish();
        }
    }

    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    private boolean isTipVisible() {
        ZMTip tip = this.getTip();
        if (tip != null) {
            return tip.getVisibility() == 0;
        }
        return false;
    }

    private void setTipVisible(boolean visible) {
        ZMTip tip = this.getTip();
        if (tip != null && tip.getVisibility() == 0 != visible) {
            tip.setVisibility(visible ? 0 : 4);
            if (visible) {
                this.clearSelection();
                Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.zm_tip_fadein);
                tip.startAnimation(fadeIn);
            }
        }
    }

    public static class InviteFailedDialog
    extends ZMDialogFragment {
        public InviteFailedDialog() {
            this.setCancelable(true);
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_invite_failed).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }

        public void onStart() {
            super.onStart();
        }
    }

    public class SelectedListAdapter
    extends BaseAdapter {
        private Context mContext;
        private List<AddFavoriteItem> mItems;

        public SelectedListAdapter(Context c) {
            this.mContext = c;
        }

        public void update(List<AddFavoriteItem> items) {
            this.mItems = items;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.mItems == null) {
                return 0;
            }
            return this.mItems.size();
        }

        public Object getItem(int position) {
            if (this.mItems == null) {
                return null;
            }
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            AddFavoriteItem item = (AddFavoriteItem)this.getItem(position);
            return item.getUserID().hashCode();
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            AvatarView avatarView;
            AddFavoriteItem item = (AddFavoriteItem)this.getItem(position);
            View itemView = convertView;
            if (itemView == null) {
                itemView = View.inflate((Context)this.mContext, (int)R.layout.zm_invite_selected_listview_item, null);
            }
            if ((avatarView = (AvatarView)itemView.findViewById(R.id.avatarView)) == null) {
                itemView = View.inflate((Context)this.mContext, (int)R.layout.zm_invite_selected_listview_item, null);
                avatarView = (AvatarView)itemView.findViewById(R.id.avatarView);
            }
            if (item == null) {
                return avatarView;
            }
            avatarView.setAvatar(item.getAvatar());
            int w = UIUtil.dip2px((Context)this.mContext, (float)45.0f);
            int h = UIUtil.dip2px((Context)this.mContext, (float)50.0f);
            itemView.setLayoutParams(new ViewGroup.LayoutParams(w, h));
            return itemView;
        }
    }
}

