/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.mm.AddCompanyContactsItem;
import com.zipow.videobox.view.mm.AddCompanyContactsListView;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMHorizontalListView;
import us.zoom.videomeetings.R;

public class AddCompanyContactsFragment
extends ZMDialogFragment
implements View.OnClickListener,
AddCompanyContactsListView.Listener,
SimpleActivity.ExtListener,
TextView.OnEditorActionListener {
    private static final String TAG = AddCompanyContactsFragment.class.getSimpleName();
    public static final String ARG_ANCHOR_ID = "anchorId";
    private AddCompanyContactsListView mListView;
    private EditText mEdtSearch;
    private ZMHorizontalListView mListSelected;
    private SelectedListAdapter mSelectedListAdapter;
    private Button mBtnInvite;
    private Button mBtnClearSearchView;
    private Button mBtnSearch;
    private View mPanelLoading;
    private View mTxtInstructions;
    private TextView mTxtSelectionCount;
    private View mPanelSelected;
    private boolean mIsSearching = false;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, AddCompanyContactsFragment.class.getName(), args, 0, false, true);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, AddCompanyContactsFragment.class.getName(), args, 0, false, true);
    }

    public void onDestroy() {
        super.onDestroy();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onResume() {
        super.onResume();
        this.updateBtnClearSearchView();
    }

    public void onPause() {
        super.onPause();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_add_company_contacts, null);
        this.mListView = (AddCompanyContactsListView)view.findViewById(R.id.buddyListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mListSelected = (ZMHorizontalListView)view.findViewById(R.id.listSelected);
        this.mBtnInvite = (Button)view.findViewById(R.id.btnInvite);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mBtnSearch = (Button)view.findViewById(R.id.btnSearch);
        this.mPanelLoading = view.findViewById(R.id.panelLoading);
        Button btnBack = (Button)view.findViewById(R.id.btnBack);
        this.mTxtInstructions = view.findViewById(R.id.txtInstructions);
        this.mPanelSelected = view.findViewById(R.id.panelSelected);
        this.mTxtSelectionCount = (TextView)view.findViewById(R.id.txtSelectionCount);
        this.mSelectedListAdapter = new SelectedListAdapter((Context)this.getActivity());
        this.mListSelected.setAdapter((ListAdapter)this.mSelectedListAdapter);
        this.mListSelected.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                AddCompanyContactsItem item = (AddCompanyContactsItem)AddCompanyContactsFragment.this.mSelectedListAdapter.getItem(position);
                AddCompanyContactsFragment.this.mListView.unselectBuddy(item);
            }
        });
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mBtnSearch.setOnClickListener((View.OnClickListener)this);
        btnBack.setOnClickListener((View.OnClickListener)this);
        this.mListView.setListener(this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                AddCompanyContactsFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

            @Override
            public void onSearchBuddy(String email, int result) {
                AddCompanyContactsFragment.this.onSearchBuddy(true, email, result);
            }

            @Override
            public void onSearchBuddyByKey(String key, int result) {
                AddCompanyContactsFragment.this.onSearchBuddy(false, key, result);
            }

            @Override
            public void onSearchBuddyPicDownloaded(String jid) {
                AddCompanyContactsFragment.this.onSearchBuddyPicDownloaded(jid);
            }
        };
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.mListView.reloadAllBuddyItems();
        int cntSelected = this.updateSelectedList();
        this.updateButtonInvite(cntSelected);
        this.updateSearchField();
        this.updateLoadingPanel();
        return view;
    }

    private void updateLoadingPanel() {
        this.mPanelLoading.setVisibility(this.mIsSearching ? 0 : 8);
    }

    private void updateSearchField() {
        this.mEdtSearch.setImeOptions(3);
        this.mBtnSearch.setVisibility(0);
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnSearch) {
            this.onClickBtnSearch();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            if (actionId == 3) {
                this.onClickBtnSearch();
            } else {
                UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnSearch);
            }
            return true;
        }
        return false;
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.finishFragment(true);
    }

    private void onClickBtnInvite() {
        List<AddCompanyContactsItem> items = this.mListView.getSelectedBuddies();
        if (items == null || items.size() == 0) {
            this.onClickBtnBack();
            return;
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickBtnSearch() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.startSearch();
    }

    private void startSearch() {
        String keyword = this.mEdtSearch.getText().toString();
        if (StringUtil.isEmptyOrNull((String)keyword)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.searchBuddyByKey(keyword)) {
            this.mBtnSearch.setEnabled(false);
            this.mIsSearching = true;
            this.updateLoadingPanel();
        }
    }

    private void endSearch() {
        this.mBtnSearch.setEnabled(true);
        this.mIsSearching = false;
        this.updateLoadingPanel();
    }

    private void onSentInvitationFailed() {
        new InviteFailedDialog().show(this.getFragmentManager(), InviteFailedDialog.class.getName());
    }

    private void onSentInvitationDone(List<AddCompanyContactsItem> items) {
        this.dismiss();
    }

    @Override
    public void onSelectionChanged() {
        int cntSelected = this.updateSelectedList();
        this.updateButtonInvite(cntSelected);
    }

    private void updateButtonInvite(int cntSelected) {
        if (cntSelected <= 0) {
            this.mBtnInvite.setText((CharSequence)this.getResources().getString(R.string.zm_btn_done));
            this.mBtnInvite.setEnabled(false);
        } else {
            this.mBtnInvite.setText((CharSequence)(this.getResources().getString(R.string.zm_btn_done) + "(" + cntSelected + ")"));
            this.mBtnInvite.setEnabled(true);
        }
    }

    private int updateSelectedList() {
        List<AddCompanyContactsItem> items = this.mListView.getSelectedBuddies();
        this.mSelectedListAdapter.update(items);
        int cnt = items.size();
        if (cnt <= 0) {
            this.mPanelSelected.setVisibility(8);
            this.mTxtInstructions.setVisibility(0);
        } else {
            this.mPanelSelected.setVisibility(0);
            this.mTxtInstructions.setVisibility(8);
            this.mTxtSelectionCount.setText((CharSequence)String.valueOf(cnt));
        }
        return cnt;
    }

    @Override
    public void onKeyboardOpen() {
        this.mEdtSearch.setCursorVisible(true);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
    }

    @Override
    public void onKeyboardClosed() {
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private void onSearchBuddy(final boolean isByEmail, final String key, final int result) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onSearchResurn"){

            public void run(IUIElement ui) {
                ((AddCompanyContactsFragment)ui).handleOnSearchBuddy(isByEmail, key, result);
            }
        });
    }

    private void handleOnSearchBuddy(boolean isByEmail, String key, int result) {
        this.endSearch();
        if (result == 0) {
            this.mListView.reloadAllBuddyItems();
        }
        this.updateLoadingPanel();
        this.updateSearchField();
    }

    private void onSearchBuddyPicDownloaded(final String jid) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onSearchResurn"){

            public void run(IUIElement ui) {
                ((AddCompanyContactsFragment)ui).handleOnSearchBuddyPicDownloaded(jid);
            }
        });
    }

    private void handleOnSearchBuddyPicDownloaded(String jid) {
        this.mListView.updateBuddy(jid);
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public static class InviteFailedDialog
    extends ZMDialogFragment {
        public InviteFailedDialog() {
            this.setCancelable(true);
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_invite_failed).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }

        public void onStart() {
            super.onStart();
        }
    }

    public class SelectedListAdapter
    extends BaseAdapter {
        private Context mContext;
        private List<AddCompanyContactsItem> mItems;

        public SelectedListAdapter(Context c) {
            this.mContext = c;
        }

        public void update(List<AddCompanyContactsItem> items) {
            this.mItems = items;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.mItems == null) {
                return 0;
            }
            return this.mItems.size();
        }

        public Object getItem(int position) {
            if (this.mItems == null) {
                return null;
            }
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            AddCompanyContactsItem item = (AddCompanyContactsItem)this.getItem(position);
            return item.getJid().hashCode();
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            AvatarView avatarView;
            AddCompanyContactsItem item = (AddCompanyContactsItem)this.getItem(position);
            View itemView = convertView;
            if (itemView == null) {
                itemView = View.inflate((Context)this.mContext, (int)R.layout.zm_invite_selected_listview_item, null);
            }
            if ((avatarView = (AvatarView)itemView.findViewById(R.id.avatarView)) == null) {
                itemView = View.inflate((Context)this.mContext, (int)R.layout.zm_invite_selected_listview_item, null);
                avatarView = (AvatarView)itemView.findViewById(R.id.avatarView);
            }
            if (item == null) {
                return avatarView;
            }
            avatarView.setAvatar(item.getAvatar());
            int w = UIUtil.dip2px((Context)this.mContext, (float)45.0f);
            int h = UIUtil.dip2px((Context)this.mContext, (float)50.0f);
            itemView.setLayoutParams(new ViewGroup.LayoutParams(w, h));
            return itemView;
        }
    }
}

