/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dropbox;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.OkHttp3Requestor;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.dropbox.DropboxFileListEntry;
import com.zipow.videobox.dropbox.DropboxResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ZMDropboxClient {
    private static final String TAG = ZMDropboxClient.class.getSimpleName();
    private ArrayList<AsyncLoadDir> mDirAsyncLoader = new ArrayList();
    private ArrayList<AsyncFileDownload> mAsyncFileDownloads = new ArrayList();
    private DropboxListener mListener = null;
    private static DbxClientV2 mDbxClient;
    private static String mAccessToken;

    public ZMDropboxClient(String accessToken) {
        mAccessToken = accessToken;
        OkHttpClient httpClient = OkHttp3Requestor.defaultOkHttpClient();
        DbxRequestConfig requestConfig = DbxRequestConfig.newBuilder((String)"DropboxV2Client").withHttpRequestor((HttpRequestor)new OkHttp3Requestor(httpClient)).build();
        mDbxClient = new DbxClientV2(requestConfig, accessToken);
    }

    public void setListener(DropboxListener l) {
        this.mListener = l;
    }

    public String getToken() {
        return mAccessToken;
    }

    public boolean loadDir(String dir) {
        if (StringUtil.isEmptyOrNull((String)dir)) {
            return false;
        }
        this.asyncLoadDir(dir);
        return true;
    }

    public boolean cancel() {
        if (this.mDirAsyncLoader.size() > 0) {
            for (AsyncLoadDir dirLoader : this.mDirAsyncLoader) {
                dirLoader.cancel(true);
            }
            this.mDirAsyncLoader.clear();
        }
        if (this.mAsyncFileDownloads.size() > 0) {
            for (AsyncFileDownload fileDownload : this.mAsyncFileDownloads) {
                fileDownload.cancel(true);
            }
            this.mAsyncFileDownloads.clear();
        }
        return true;
    }

    public boolean loadFile(DropboxFileListEntry file, String outDir) {
        String outPath = AppUtil.getShareCachePathByExtension(outDir, file.getPath());
        if (StringUtil.isEmptyOrNull((String)outPath)) {
            return false;
        }
        Metadata meta = file.getMetadata();
        if (meta instanceof FileMetadata) {
            AsyncFileDownload download = new AsyncFileDownload((FileMetadata)meta, outPath);
            this.mAsyncFileDownloads.add(download);
            download.execute(new Void[0]);
            return true;
        }
        return false;
    }

    private void asyncLoadDir(String dir) {
        AsyncLoadDir load = new AsyncLoadDir(dir);
        this.mDirAsyncLoader.add(load);
        load.execute(new Void[0]);
    }

    protected String checkDir(String dir) {
        if (dir == null || dir.equals("")) {
            dir = File.separator;
        }
        return dir;
    }

    private DropboxResult parseDropboxException(Exception e) {
        DropboxResult result = DropboxResult.INTERNAL_ERR;
        if (e instanceof FileNotFoundException) {
            result = DropboxResult.NOT_FOUND;
        } else if (e instanceof IOException) {
            result = DropboxResult.IO_EXCEPTION;
        } else if (e instanceof DownloadErrorException) {
            result = DropboxResult.INTERNAL_ERR;
        } else if (e instanceof DbxException) {
            result = DropboxResult.INTERNAL_ERR;
        }
        return result;
    }

    private class AsyncFileDownload
    extends ZMAsyncTask<Void, Long, DropboxResult> {
        private boolean mCanceled = false;
        private String mOutPath;
        private String mFileName;
        private FileMetadata mFile;

        public AsyncFileDownload(FileMetadata file, String outPath) {
            this.mOutPath = outPath;
            this.mFile = file;
            this.mFileName = file.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DropboxResult doInBackground(Void ... params) {
            if (this.mFile == null) {
                return DropboxResult.INTERNAL_ERR;
            }
            String filePath = this.mFile.getPathLower();
            if (mDbxClient == null || StringUtil.isEmptyOrNull((String)this.mOutPath) || StringUtil.isEmptyOrNull((String)filePath)) {
                return DropboxResult.INTERNAL_ERR;
            }
            if (this.mCanceled) {
                return DropboxResult.CANCELED;
            }
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(this.mOutPath);
                mDbxClient.files().download(filePath, this.mFile.getRev()).download((OutputStream)outputStream);
            }
            catch (Exception e) {
                DropboxResult dropboxResult = ZMDropboxClient.this.parseDropboxException(e);
                return dropboxResult;
            }
            finally {
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.mCanceled) {
                return DropboxResult.CANCELED;
            }
            return DropboxResult.OK;
        }

        protected void onCancelled() {
            this.mCanceled = true;
        }

        protected void onPostExecute(DropboxResult result) {
            if (ZMDropboxClient.this.mListener != null) {
                ZMDropboxClient.this.mListener.onLoadFile(result, this.mFileName, this.mOutPath);
            }
            if (ZMDropboxClient.this.mAsyncFileDownloads.contains((Object)this)) {
                ZMDropboxClient.this.mAsyncFileDownloads.remove((Object)this);
            }
        }
    }

    private class AsyncLoadDir
    extends ZMAsyncTask<Void, Long, DropboxResult> {
        private boolean mCanceled = false;
        private ArrayList<Metadata> mFileEntries = new ArrayList();
        private String mDir;

        public AsyncLoadDir(String dir) {
            this.mDir = ZMDropboxClient.this.checkDir(dir);
        }

        protected void onCancelled() {
            this.mCanceled = true;
        }

        protected DropboxResult doInBackground(Void ... params) {
            if (this.mCanceled) {
                return DropboxResult.CANCELED;
            }
            if (mDbxClient == null) {
                return DropboxResult.INTERNAL_ERR;
            }
            this.mFileEntries.clear();
            try {
                ListFolderResult result = File.separator.equals(this.mDir) ? mDbxClient.files().listFolder("") : mDbxClient.files().listFolder(this.mDir);
                while (true) {
                    if (!result.getEntries().isEmpty()) {
                        this.mFileEntries.addAll(result.getEntries());
                    }
                    if (result.getHasMore()) {
                        result = mDbxClient.files().listFolderContinue(result.getCursor());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                return ZMDropboxClient.this.parseDropboxException(e);
            }
            if (this.mCanceled) {
                return DropboxResult.CANCELED;
            }
            return DropboxResult.OK;
        }

        protected void onPostExecute(DropboxResult result) {
            if (ZMDropboxClient.this.mListener != null) {
                ZMDropboxClient.this.mListener.onLoadDir(result, this.mDir, this.mFileEntries);
            }
            if (ZMDropboxClient.this.mDirAsyncLoader.contains((Object)this)) {
                ZMDropboxClient.this.mDirAsyncLoader.remove((Object)this);
            }
        }
    }

    public static interface DropboxListener {
        public void onLoadDir(DropboxResult var1, String var2, List<Metadata> var3);

        public void onLoadFile(DropboxResult var1, String var2, String var3);
    }
}

