/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dropbox;

import android.content.Context;
import android.content.DialogInterface;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.dropbox.DropboxFileListEntry;
import com.zipow.videobox.dropbox.DropboxResult;
import com.zipow.videobox.dropbox.ZMDropbox;
import com.zipow.videobox.dropbox.ZMDropboxClient;
import java.io.File;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListBaseAdapter;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class DropboxFileListAdapter
extends ZMFileListBaseAdapter
implements ZMDropboxClient.DropboxListener {
    private ZMDropbox mDropbox;
    private ZMFileListListener mListener;
    private String mCurrentDir = null;
    private String mCachedDir;
    private DialogInterface.OnCancelListener mWaitingDialogCancelListener = new DialogInterface.OnCancelListener(){

        public void onCancel(DialogInterface dialog) {
            if (DropboxFileListAdapter.this.mDropbox.hasLogin()) {
                DropboxFileListAdapter.this.mDropbox.getClient().cancel();
            }
        }
    };

    public void init(ZMActivity activity, ZMFileListListener l) {
        super.init(activity, l);
        this.mActivity = activity;
        this.mDropbox = ZMDropbox.getInstance();
        this.mListener = l;
        this.mCachedDir = AppUtil.getCachePath();
        if (this.mDropbox.hasLogin()) {
            this.mDropbox.setListener(this);
        }
    }

    public void login() {
        if (!this.mDropbox.hasLogin()) {
            this.mDropbox.login((Context)this.mActivity);
            if (this.mListener != null) {
                this.mListener.onStarting();
            }
        } else {
            this.mDropbox.setListener(this);
            if (this.mListener != null) {
                this.mListener.onStarted(true, null);
            }
        }
    }

    public void logout() {
        if (this.mDropbox.hasLogin()) {
            DropboxFileListAdapter dropboxFileListAdapter = this;
            dropboxFileListAdapter.mDropbox.release();
        }
    }

    public void onResume() {
        this.mDropbox.onResume((Context)this.mActivity);
        if (this.mDropbox.hasLogin()) {
            this.mDropbox.setListener(this);
            if (this.mListener != null) {
                this.mListener.onStarted(true, null);
            }
        } else if (this.mListener != null) {
            this.mListener.onStarted(false, this.mActivity.getResources().getString(R.string.zm_alert_auth_token_failed_msg));
        }
    }

    public boolean openDir(String dir) {
        if (!this.mDropbox.hasLogin()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)dir)) {
            if (this.mCurrentDir == null) {
                dir = File.separator;
            } else {
                if (this.mFileList.size() > 0) {
                    return true;
                }
                dir = this.mCurrentDir;
            }
        } else if (dir.equals(this.mCurrentDir) && this.mFileList.size() > 0) {
            return true;
        }
        return this.loadDir(dir);
    }

    public boolean isRootDir() {
        return this.mCurrentDir == null || this.mCurrentDir.equals(File.separator);
    }

    public String getCurrentDirName() {
        if (StringUtil.isEmptyOrNull((String)this.mCurrentDir)) {
            return "";
        }
        String DirName = AndroidAppUtil.getPathLastName((String)this.mCurrentDir);
        return DirName;
    }

    public String getCurrentDirPath() {
        if (StringUtil.isEmptyOrNull((String)this.mCurrentDir)) {
            return "";
        }
        return this.mCurrentDir;
    }

    protected void gotoParentDir() {
        int last;
        if (!this.mDropbox.hasLogin()) {
            return;
        }
        if (this.isRootDir()) {
            return;
        }
        StringBuilder builder = new StringBuilder(this.getCurrentDirPath());
        String dir = builder.toString();
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.lastIndexOf(File.separator));
        }
        if ((dir = dir.substring(0, (last = dir.lastIndexOf(File.separator)) + 1)).equals(this.getCurrentDirName())) {
            return;
        }
        this.loadDir(dir);
    }

    public void onPause() {
        this.mDropbox.setListener(null);
        this.cancel();
    }

    public boolean onBackPressed() {
        this.cancel();
        return super.onBackPressed();
    }

    private void cancel() {
        this.dismissWaitingDialog();
        if (this.mDropbox.hasLogin()) {
            this.mDropbox.getClient().cancel();
        }
    }

    private boolean dropboxLoadDir(String dir) {
        if (StringUtil.isEmptyOrNull((String)dir) || !this.mDropbox.hasLogin()) {
            return false;
        }
        boolean ret = this.mDropbox.getClient().loadDir(dir);
        if (ret) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
        return ret;
    }

    private boolean loadDir(String dir) {
        if (StringUtil.isEmptyOrNull((String)dir)) {
            return false;
        }
        return this.dropboxLoadDir(dir);
    }

    protected void openDir(ZMFileListEntry dir) {
        if (dir == null || !dir.isDir()) {
            return;
        }
        this.loadDir(dir.getPath());
    }

    protected void openFile(ZMFileListEntry file) {
        if (file == null || !this.mDropbox.hasLogin()) {
            return;
        }
        String filePath = file.getPath();
        if (StringUtil.isEmptyOrNull((String)filePath) || file.isDir()) {
            return;
        }
        if (!AppUtil.hasEnoughDiskSpace(this.mCachedDir, file.getBytes())) {
            this.alertMemoryNotEnough(this.mActivity.getString(R.string.zm_title_error), this.mActivity.getString(R.string.zm_msg_memory_size_insufficient));
            return;
        }
        if (file instanceof DropboxFileListEntry) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
            this.mDropbox.getClient().loadFile((DropboxFileListEntry)file, this.mCachedDir);
        }
    }

    @Override
    public void onLoadDir(DropboxResult result, String dir, List<Metadata> entries) {
        if (StringUtil.isEmptyOrNull((String)dir)) {
            return;
        }
        this.dismissWaitingDialog();
        if (result == DropboxResult.CANCELED) {
            if (this.isRootDir() && this.mListener != null) {
                this.mListener.onSelectedFile(null, null);
            }
            return;
        }
        if (result == DropboxResult.OK) {
            this.mCurrentDir = dir;
            this.mFileList.clear();
            this.addAllEntry(entries);
            this.notifyDataSetChanged();
            if (this.mListener != null) {
                this.mListener.onRefresh();
            }
        } else if (result == DropboxResult.SERVICE_UNAVAILABLE || result == DropboxResult.SSL_EXCEPTION || result == DropboxResult.UNAUTHORIZED || result == DropboxResult.UNLINKED) {
            if (this.mListener != null) {
                this.mListener.onReLogin();
            }
        } else {
            this.alertError(this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{dir}));
        }
    }

    @Override
    public void onLoadFile(DropboxResult result, String fileName, String outPath) {
        if (result == DropboxResult.CANCELED) {
            return;
        }
        this.dismissWaitingDialog();
        if (result == DropboxResult.OK) {
            if (this.mListener != null) {
                this.mListener.onSelectedFile(outPath, fileName);
            }
        } else if (result == DropboxResult.SERVICE_UNAVAILABLE || result == DropboxResult.SSL_EXCEPTION || result == DropboxResult.UNAUTHORIZED || result == DropboxResult.UNLINKED) {
            if (this.mListener != null) {
                this.mListener.onReLogin();
            }
        } else {
            this.alertError(this.mActivity.getString(R.string.zm_msg_load_file_fail, new Object[]{fileName}));
        }
    }

    private void alertError(String message) {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.mActivity).setTitle(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (DropboxFileListAdapter.this.mListener != null) {
                    DropboxFileListAdapter.this.mListener.onSelectedFile(null, null);
                }
            }
        }).create();
        dialog.show();
    }

    private void addAllEntry(List<Metadata> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (Metadata metadata : entries) {
            DropboxFileListEntry item;
            String path = metadata.getPathLower();
            if (metadata instanceof FileMetadata) {
                if (!this.acceptFileType(path)) continue;
                FileMetadata fileMeta = (FileMetadata)metadata;
                item = new DropboxFileListEntry(metadata);
                item.setBytes(fileMeta.getSize());
                item.setDate(fileMeta.getClientModified());
                item.setDir(false);
                item.setDisplayName(fileMeta.getName());
                item.setPath(fileMeta.getPathLower());
                this.mFileList.add(item);
                continue;
            }
            if (!(metadata instanceof FolderMetadata)) continue;
            FolderMetadata folderMeta = (FolderMetadata)metadata;
            item = new DropboxFileListEntry(metadata);
            item.setBytes(0L);
            item.setDir(true);
            item.setDisplayName(folderMeta.getName());
            item.setPath(folderMeta.getPathLower());
            this.mFileList.add(item);
        }
        this.sortFileList();
    }

    public boolean isNeedAuth() {
        return true;
    }

    public boolean hasAuthorized() {
        return this.mDropbox.hasLogin();
    }
}

