/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.confapp.meeting.confhelper.ShareComponent;
import java.io.File;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class SharePermissionAlertDialog
extends ZMDialogFragment {
    private static final String ARG_SHARE_ALERT_TYPE = "share_alert_msg";
    private static final String ARG_SHARE_ALERT_IS_VIEW_AUDIO = "share_alert_view_audio";
    public static final int SHARE_ALERT_TYPE_LOCK_SHARE = 1;
    public static final int SHARE_ALERT_TYPE_OTHER_SHARING = 2;
    public static final int SHARE_ALERT_TYPE_GRAB_OTHER_SHARE = 3;
    private static final String ARG_SHARE_TYPE = "share_type";
    private static final String ARG_SHARE_PATH = "share_path";
    private static final String ARG_SHARE_LOCAL_FILE = "share_local_file";
    private static final String ARG_SHARE_INTENT = "share_intent";
    private static final int SHARE_TYPE_NONE = 0;
    public static final int SHARE_TYPE_IMAGE = 1;
    public static final int SHARE_TYPE_BY_PATH = 2;
    public static final int SHARE_TYPE_WEBVIEW = 3;
    public static final int SHARE_TYPE_SCREEN = 4;
    private int alertType = 1;
    private int shareType = 0;
    private String shareData = null;
    private boolean localFile = true;
    private Intent shareIntent;
    private boolean mIsViewPureAduio = false;

    public static SharePermissionAlertDialog createAlertDialog(int shareAlertType, boolean isViewPureAudio) {
        SharePermissionAlertDialog dlg = new SharePermissionAlertDialog();
        Bundle args = new Bundle();
        args.putInt(ARG_SHARE_ALERT_TYPE, shareAlertType);
        args.putBoolean(ARG_SHARE_ALERT_IS_VIEW_AUDIO, isViewPureAudio);
        dlg.setArguments(args);
        return dlg;
    }

    public SharePermissionAlertDialog() {
        this.setCancelable(true);
    }

    public void setShareInfo(int type, String path, boolean local) {
        Bundle args = this.getArguments();
        args.putInt(ARG_SHARE_TYPE, type);
        args.putString(ARG_SHARE_PATH, path);
        args.putBoolean(ARG_SHARE_LOCAL_FILE, local);
    }

    public void setShareInfo(int type, Intent intent) {
        Bundle args = this.getArguments();
        args.putInt(ARG_SHARE_TYPE, type);
        args.putParcelable(ARG_SHARE_INTENT, (Parcelable)intent);
    }

    public void show(FragmentManager fragmentMgr) {
        this.show(fragmentMgr, SharePermissionAlertDialog.class.getName());
    }

    private void onPositiveClick() {
        if (this.alertType == 3) {
            ConfActivityNormal confActivity = (ConfActivityNormal)this.getActivity();
            if (confActivity == null) {
                return;
            }
            switch (this.shareType) {
                case 0: {
                    ShareComponent shareComponent = confActivity.getmShareComponent();
                    if (shareComponent != null) {
                        shareComponent.mbMarkedAsGrabShare = true;
                    }
                    confActivity.showShareTip();
                    break;
                }
                case 1: {
                    Uri image;
                    if (this.localFile) {
                        File imageFile = new File(this.shareData);
                        image = Uri.fromFile((File)imageFile);
                    } else {
                        image = Uri.parse((String)this.shareData);
                    }
                    confActivity.startShareImage(image, this.localFile);
                    break;
                }
                case 2: {
                    confActivity.shareByPathExtension(this.shareData);
                    break;
                }
                case 3: {
                    confActivity.startShareWebview(this.shareData);
                    break;
                }
                case 4: {
                    confActivity.startShareScreen(this.shareIntent);
                }
            }
        }
    }

    private void onNegativeClick() {
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.alertType = args.getInt(ARG_SHARE_ALERT_TYPE);
        this.mIsViewPureAduio = args.getBoolean(ARG_SHARE_ALERT_IS_VIEW_AUDIO);
        this.shareType = args.getInt(ARG_SHARE_TYPE);
        this.shareData = args.getString(ARG_SHARE_PATH);
        this.localFile = args.getBoolean(ARG_SHARE_LOCAL_FILE);
        this.shareIntent = (Intent)args.getParcelable(ARG_SHARE_INTENT);
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true);
        int positiveBtn = R.string.zm_btn_ok;
        if (this.alertType == 1) {
            builder.setTitle(R.string.zm_alert_host_lock_share);
        } else if (this.alertType == 2) {
            builder.setTitle(R.string.zm_alert_other_is_sharing);
        } else if (this.alertType == 3) {
            if (this.mIsViewPureAduio) {
                positiveBtn = R.string.zm_btn_continue;
                builder.setMessage(R.string.zm_alert_grab_pure_audio_share_41468);
            } else {
                builder.setMessage(R.string.zm_alert_grab_otherSharing);
            }
            builder.setTitle(R.string.zm_title_start_share);
            builder.setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SharePermissionAlertDialog.this.onNegativeClick();
                }
            });
        }
        builder.setPositiveButton(positiveBtn, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SharePermissionAlertDialog.this.onPositiveClick();
            }
        });
        return builder.create();
    }
}

