/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.PreferenceUtil;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class LeaveAlertDialog
extends ZMDialogFragment {
    private static final String TAG = LeaveAlertDialog.class.getName();

    public LeaveAlertDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material_Transparent).setView(this.createContent());
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private View createContent() {
        CmmAudioStatus audioStatus;
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_conf_leave_menu, null);
        View end = view.findViewById(R.id.panelEndMeeting);
        View leave = view.findViewById(R.id.panelLeaveMeeting);
        View leaveWithCall = view.findViewById(R.id.panelLeaveWithCall);
        TextView txtPrompt = (TextView)view.findViewById(R.id.txtLeavePromt);
        end.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfActivity confActivity = (ConfActivity)LeaveAlertDialog.this.getActivity();
                if (confActivity != null) {
                    ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(1), true);
                    ConfLocalHelper.endCall(confActivity);
                }
            }
        });
        leave.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfActivity confActivity = (ConfActivity)LeaveAlertDialog.this.getActivity();
                if (confActivity != null) {
                    int confStatus = ConfMgr.getInstance().getConfStatus();
                    if (confStatus == 8 || confStatus == 9) {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(8), true);
                    } else {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(1), true);
                    }
                    ConfLocalHelper.leaveCall(confActivity);
                }
            }
        });
        leaveWithCall.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfActivity confActivity = (ConfActivity)LeaveAlertDialog.this.getActivity();
                if (confActivity != null) {
                    int confStatus = ConfMgr.getInstance().getConfStatus();
                    if (confStatus == 8 || confStatus == 9) {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(8), true);
                    } else {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(1), true);
                    }
                    ConfMgr.getInstance().handleConfCmd(50);
                }
            }
        });
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && myself.isHost()) {
            if (PreferenceUtil.readBooleanValue("no_leave_meeting_button_for_host", false)) {
                txtPrompt.setText(R.string.zm_alert_confirm_end_conf);
                leave.setVisibility(8);
            } else {
                txtPrompt.setText(R.string.zm_alert_end_conf);
            }
        } else {
            txtPrompt.setText(R.string.zm_alert_leave_conf);
            end.setVisibility(8);
        }
        long audioType = 0L;
        if (myself != null && (audioStatus = myself.getAudioStatusObj()) != null) {
            audioType = audioStatus.getAudiotype();
        }
        if (audioType != 1L) {
            leaveWithCall.setVisibility(8);
        }
        return view;
    }
}

