/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.util.DialogUtils;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.FingerprintUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class FingerprintAuthenticationDialog
extends ZMDialogFragment {
    private static final String TAG = FingerprintAuthenticationDialog.class.getName();
    private FingerprintUtil mFingerprintUtil;
    private FingerprintAuthCallBack mFingerprintAuthCallBack;
    private TextView mTxtDesc;
    private TextView mTxtTitle;
    private TextView mBtnEnterPasswd;
    private View mBtnCancel;
    private LinearLayout mLinealayoutButton;
    private LinearLayout.LayoutParams mLayoutParams;

    public FingerprintAuthenticationDialog() {
        this.setCancelable(true);
    }

    public static void show(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        FingerprintAuthenticationDialog fingerprintAuthenticationDialog = new FingerprintAuthenticationDialog();
        fingerprintAuthenticationDialog.show(activity.getSupportFragmentManager(), TAG);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mFingerprintAuthCallBack = (FingerprintAuthCallBack)context;
        this.mFingerprintUtil = new FingerprintUtil((ZMActivity)context);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mFingerprintUtil.onDestroy();
    }

    public void onPause() {
        super.onPause();
        this.mFingerprintUtil.cancelAuthenticate();
    }

    public void onResume() {
        super.onResume();
        if (!this.mFingerprintUtil.isSupportFingerprint()) {
            this.dismiss();
            return;
        }
        this.mFingerprintUtil.callFingerPrintVerify(new FingerprintUtil.IFingerprintResultListener(){
            boolean isAlreadyFailed;

            public void onNoHardwareDetected() {
            }

            public void onInSecurity() {
            }

            public void onNoEnroll() {
            }

            public void onSupport() {
            }

            public void onAuthenticateStart() {
            }

            public void onAuthenticateError(int errMsgId, CharSequence errString) {
                if (FingerprintAuthenticationDialog.this.isResumed()) {
                    FingerprintAuthenticationDialog.this.dismissAllowingStateLoss();
                    if (!this.isAlreadyFailed) {
                        return;
                    }
                    ZMActivity activity = (ZMActivity)FingerprintAuthenticationDialog.this.getActivity();
                    DialogUtils.showAlertDialog(activity, errString.toString(), R.string.zm_btn_ok);
                }
            }

            public void onAuthenticateFailed() {
                this.isAlreadyFailed = true;
                FingerprintAuthenticationDialog.this.mTxtTitle.setVisibility(8);
                FingerprintAuthenticationDialog.this.mBtnEnterPasswd.setVisibility(0);
                ((FingerprintAuthenticationDialog)FingerprintAuthenticationDialog.this).mLayoutParams.gravity = 5;
                ((FingerprintAuthenticationDialog)FingerprintAuthenticationDialog.this).mLayoutParams.width = -2;
                FingerprintAuthenticationDialog.this.mLinealayoutButton.setLayoutParams((ViewGroup.LayoutParams)FingerprintAuthenticationDialog.this.mLayoutParams);
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)FingerprintAuthenticationDialog.this.mBtnCancel.getLayoutParams();
                layoutParams.width = -2;
                FingerprintAuthenticationDialog.this.mBtnCancel.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FingerprintAuthenticationDialog.this.mTxtDesc.setText(R.string.zm_alert_fingerprint_mismatch_22438);
                FingerprintAuthenticationDialog.this.mTxtDesc.setTextColor(-65536);
                FingerprintAuthenticationDialog.this.mTxtDesc.clearAnimation();
                Animation shake = AnimationUtils.loadAnimation((Context)FingerprintAuthenticationDialog.this.getContext(), (int)R.anim.zm_shake);
                FingerprintAuthenticationDialog.this.mTxtDesc.startAnimation(shake);
            }

            public void onAuthenticateHelp(int helpMsgId, CharSequence helpString) {
                FingerprintAuthenticationDialog.this.mTxtTitle.setVisibility(0);
                FingerprintAuthenticationDialog.this.mBtnEnterPasswd.setVisibility(8);
                ((FingerprintAuthenticationDialog)FingerprintAuthenticationDialog.this).mLayoutParams.gravity = 1;
                ((FingerprintAuthenticationDialog)FingerprintAuthenticationDialog.this).mLayoutParams.width = -1;
                FingerprintAuthenticationDialog.this.mLinealayoutButton.setLayoutParams((ViewGroup.LayoutParams)FingerprintAuthenticationDialog.this.mLayoutParams);
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)FingerprintAuthenticationDialog.this.mBtnCancel.getLayoutParams();
                layoutParams.width = -1;
                FingerprintAuthenticationDialog.this.mBtnCancel.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FingerprintAuthenticationDialog.this.mTxtDesc.setText(helpString);
                FingerprintAuthenticationDialog.this.mTxtDesc.setTextColor(R.color.zm_setting_option);
                FingerprintAuthenticationDialog.this.mTxtDesc.clearAnimation();
                Animation shake = AnimationUtils.loadAnimation((Context)FingerprintAuthenticationDialog.this.getContext(), (int)R.anim.zm_shake);
                FingerprintAuthenticationDialog.this.mTxtDesc.startAnimation(shake);
            }

            public void onAuthenticateSucceeded(FingerprintManager.AuthenticationResult result) {
                FingerprintAuthenticationDialog.this.dismissAllowingStateLoss();
                FingerprintAuthenticationDialog.this.mFingerprintAuthCallBack.onAuthenticateSucceeded(result);
            }
        });
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTheme(R.style.ZMDialog_Material_RoundRect).setCancelable(true).setView(this.createContent());
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private View createContent() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material_RoundRect);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_fingerprint_authentication_dialog, null);
        this.mLinealayoutButton = (LinearLayout)view.findViewById(R.id.ll_button);
        this.mLayoutParams = (LinearLayout.LayoutParams)this.mLinealayoutButton.getLayoutParams();
        this.mTxtDesc = (TextView)view.findViewById(R.id.txtDesc);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnEnterPasswd = (TextView)view.findViewById(R.id.btn_enter_passwd);
        this.mBtnCancel = view.findViewById(R.id.btn_cancel);
        this.mBtnEnterPasswd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FingerprintAuthenticationDialog.this.dismiss();
                if (FingerprintAuthenticationDialog.this.mFingerprintAuthCallBack != null) {
                    FingerprintAuthenticationDialog.this.mFingerprintAuthCallBack.onEnterPasswd();
                }
            }
        });
        this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FingerprintAuthenticationDialog.this.dismiss();
            }
        });
        return view;
    }

    public static interface FingerprintAuthCallBack {
        public void onAuthenticateSucceeded(FingerprintManager.AuthenticationResult var1);

        public void onEnterPasswd();
    }
}

