/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.config;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.zipow.cmmlib.AppContext;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.config.ConfigReader;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;

public class ConfigWriter
extends BroadcastReceiver {
    private static final String TAG = ConfigWriter.class.getSimpleName();
    public static final String ACTION_CHANGE_CONFIG = "us.zoom.videomeetings.intent.action.CHANGE_CONFIG";
    public static final String ACTION_RESET_CONFIG = "us.zoom.videomeetings.intent.action.RESET_CONFIG";

    public void onReceive(Context context, Intent intent) {
        if (VideoBoxApplication.getInstance() == null) {
            Context appContext = context.getApplicationContext();
            VideoBoxApplication.initialize(appContext, false, 0, null);
        }
        if (ACTION_CHANGE_CONFIG.equals(intent.getAction())) {
            this.changeConfig(context, intent);
        } else if (ACTION_RESET_CONFIG.equals(intent.getAction())) {
            this.resetConfig(context, intent);
        }
    }

    private void changeConfig(Context context, Intent intent) {
        String enableAddrBook;
        AppContext appContext = new AppContext("config");
        appContext.beginTransaction();
        boolean enableLog = "true".equals(appContext.queryWithKey("enableLog", AppContext.APP_NAME_CHAT));
        boolean enableMZMLog = "true".equals(appContext.queryWithKey("enableMzmLog", AppContext.APP_NAME_CHAT));
        boolean disableUtilLog = "true".equals(appContext.queryWithKey("DisableUtilLog", AppContext.APP_NAME_CHAT));
        String oldWebServer = appContext.queryWithKey("conf.webserver", AppContext.APP_NAME_CHAT);
        String oldUiMode = PreferenceUtil.readStringValue("UIMode", null);
        String oldEnableAddrBook = PreferenceUtil.readStringValue("AddressBookEnabled", null);
        boolean bForceDisableGCM = PreferenceUtil.readBooleanValue("forceDisableGCM", false);
        String oldAudioAPIType = PreferenceUtil.readStringValue("audioAPIType", null);
        boolean bAlwaysGCM = PreferenceUtil.readBooleanValue("gcmAlways", false);
        boolean db = PreferenceUtil.readBooleanValue("dbSDK", false);
        String webServer = intent.getStringExtra("conf.webserver");
        String confServerRingcentralAPI = intent.getStringExtra("conf.server.ringcentralapi");
        String logLevel = intent.getStringExtra("logLevel");
        enableLog = intent.getBooleanExtra("enableLog", enableLog);
        enableMZMLog = intent.getBooleanExtra("enableMzmLog", enableMZMLog);
        disableUtilLog = intent.getBooleanExtra("DisableUtilLog", disableUtilLog);
        String disableDeadlockDetect = intent.getStringExtra("com.zoom.test.disable_deadlock_detect");
        String crashDumpUserInfo = intent.getStringExtra("Crash.DumpUserInfor");
        bAlwaysGCM = intent.getBooleanExtra("gcmAlways", bAlwaysGCM);
        db = intent.getBooleanExtra("dbSDK", db);
        String uiMode = intent.getStringExtra("UIMode");
        if (uiMode == null) {
            uiMode = oldUiMode;
        }
        if ((enableAddrBook = intent.getStringExtra("AddressBookEnabled")) == null) {
            enableAddrBook = oldEnableAddrBook;
        }
        bForceDisableGCM = intent.getBooleanExtra("forceDisableGCM", bForceDisableGCM);
        String audioAPIType = intent.getStringExtra("audioAPIType");
        if (audioAPIType == null) {
            audioAPIType = oldAudioAPIType;
        }
        if (webServer != null && webServer.length() > 0 && !webServer.equals(oldWebServer)) {
            if (webServer.indexOf("www.zoom.us") > 0) {
                webServer = webServer.replace("www.zoom.us", "zoom.us");
            }
            appContext.setKeyValue("conf.webserver", webServer, AppContext.APP_NAME_CHAT);
            File file = new File(AppUtil.getDataPath() + "/ZMPreSchedule");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(AppUtil.getDataPath() + "/ZMMeetingTrash")).exists()) {
                file.delete();
            }
        } else if (StringUtil.isEmptyOrNull((String)webServer)) {
            appContext.setKeyValue("conf.webserver", null, AppContext.APP_NAME_CHAT);
        }
        appContext.setKeyValue("conf.server.ringcentralapi", confServerRingcentralAPI, AppContext.APP_NAME_CHAT);
        if (logLevel != null && (logLevel.equals("info") || logLevel.equals("warning"))) {
            appContext.setKeyValue("logLevel", logLevel, AppContext.APP_NAME_CHAT);
        }
        if (disableDeadlockDetect != null && disableDeadlockDetect.length() > 0) {
            appContext.setKeyValue("com.zoom.test.disable_deadlock_detect", disableDeadlockDetect, AppContext.APP_NAME_CHAT);
        }
        if (crashDumpUserInfo != null && crashDumpUserInfo.length() > 0) {
            appContext.setKeyValue("Crash.DumpUserInfor", crashDumpUserInfo, AppContext.APP_NAME_CHAT);
        }
        appContext.setKeyValue("enableLog", String.valueOf(enableLog), AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("enableMzmLog", String.valueOf(enableMZMLog), AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("DisableUtilLog", String.valueOf(disableUtilLog), AppContext.APP_NAME_CHAT);
        if (uiMode != null && (uiMode.equals("auto") || uiMode.equals("large") || uiMode.equals("normal"))) {
            PreferenceUtil.saveStringValue("UIMode", uiMode);
        }
        if (enableAddrBook != null && (enableAddrBook.equals("auto") || enableAddrBook.equals("yes") || enableAddrBook.equals("no"))) {
            PreferenceUtil.saveStringValue("AddressBookEnabled", enableAddrBook);
        }
        PreferenceUtil.saveBooleanValue("forceDisableGCM", bForceDisableGCM);
        if (bForceDisableGCM) {
            PreferenceUtil.saveStringValue("gcm_registration_id", null);
            PreferenceUtil.saveLongValue("gcm_registration_id_timestamp", 0L);
        }
        PreferenceUtil.saveBooleanValue("gcmAlways", bAlwaysGCM);
        PreferenceUtil.saveBooleanValue("dbSDK", db);
        if (audioAPIType != null && (audioAPIType.equals("auto") || audioAPIType.equals("java") || audioAPIType.equals("OpenSLES"))) {
            PreferenceUtil.saveStringValue("audioAPIType", audioAPIType);
        }
        appContext.endTransaction();
        this.applyNewConfig(context);
    }

    private void resetConfig(Context context, Intent intent) {
        AppContext appContext = new AppContext("config");
        appContext.beginTransaction();
        appContext.setKeyValue("conf.webserver", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("logLevel", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("enableLog", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("enableMzmLog", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("DisableUtilLog", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("com.zoom.test.disable_deadlock_detect", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("Crash.DumpUserInfor", null, AppContext.APP_NAME_CHAT);
        appContext.setKeyValue("conf.server.ringcentralapi", null, AppContext.APP_NAME_CHAT);
        appContext.endTransaction();
        PreferenceUtil.saveStringValue("UIMode", "auto");
        PreferenceUtil.saveStringValue("AddressBookEnabled", "auto");
        PreferenceUtil.saveBooleanValue("forceDisableGCM", false);
        PreferenceUtil.saveStringValue("audioAPIType", "auto");
        PreferenceUtil.saveBooleanValue("gcmAlways", false);
        PreferenceUtil.saveBooleanValue("dbSDK", false);
        this.applyNewConfig(context);
    }

    private void applyNewConfig(Context context) {
        ConfigReader.broadcastConfigInfo(context);
        VideoBoxApplication.getInstance().restart();
    }
}

